/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.ReduceTaskStatus;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TestTaskAttemptListenerImpl;
import org.apache.hadoop.mapred.WrappedJvmID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptCompletionEventStatus;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptStatusUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
@RunWith(value=MockitoJUnitRunner.class)
public class TestTaskAttemptListenerImpl {
    private static final String ATTEMPT1_ID = "attempt_123456789012_0001_m_000001_0";
    private static final String ATTEMPT2_ID = "attempt_123456789012_0001_m_000002_0";
    private static final TaskAttemptId TASKATTEMPTID1 = TypeConverter.toYarn((TaskAttemptID)TaskAttemptID.forName((String)"attempt_123456789012_0001_m_000001_0"));
    private static final TaskAttemptId TASKATTEMPTID2 = TypeConverter.toYarn((TaskAttemptID)TaskAttemptID.forName((String)"attempt_123456789012_0001_m_000002_0"));
    @Mock
    private AppContext appCtx;
    @Mock
    private JobTokenSecretManager secret;
    @Mock
    private RMHeartbeatHandler rmHeartbeatHandler;
    @Mock
    private TaskHeartbeatHandler hbHandler;
    @Mock
    private Dispatcher dispatcher;
    @Mock
    private Task task;
    @Mock
    private EventHandler<Event> ea;
    @Captor
    private ArgumentCaptor<Event> eventCaptor;
    private JVMId id;
    private WrappedJvmID wid;
    private TaskAttemptID attemptID;
    private TaskAttemptId attemptId;
    private ReduceTaskStatus firstReduceStatus;
    private ReduceTaskStatus secondReduceStatus;
    private ReduceTaskStatus thirdReduceStatus;
    private MockTaskAttemptListenerImpl listener;

    @After
    public void after() throws IOException {
        if (this.listener != null) {
            this.listener.close();
            this.listener = null;
        }
    }

    @Test(timeout=5000L)
    public void testGetTask() throws IOException {
        this.configureMocks();
        this.startListener(false);
        JvmContext context = new JvmContext();
        context.jvmId = this.id;
        JvmTask result = this.listener.getTask(context);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.shouldDie);
        this.listener.registerPendingTask(this.task, this.wid);
        result = this.listener.getTask(context);
        Assert.assertNull((Object)result);
        this.listener.unregister(this.attemptId, this.wid);
        this.listener.registerPendingTask(this.task, this.wid);
        this.listener.registerLaunchedTask(this.attemptId, this.wid);
        ((TaskHeartbeatHandler)Mockito.verify((Object)this.hbHandler)).register(this.attemptId);
        result = this.listener.getTask(context);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.shouldDie);
        result = this.listener.getTask(context);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.shouldDie);
        this.listener.unregister(this.attemptId, this.wid);
        result = this.listener.getTask(context);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.shouldDie);
        JVMId jvmid = JVMId.forName((String)"jvm_001_002_m_004");
        Assert.assertNotNull((Object)jvmid);
        try {
            JVMId.forName((String)"jvm_001_002_m_004_006");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"TaskId string : jvm_001_002_m_004_006 is not properly formed");
        }
    }

    @Test(timeout=5000L)
    public void testJVMId() {
        JVMId jvmid = new JVMId("test", 1, true, 2L);
        JVMId jvmid1 = JVMId.forName((String)"jvm_test_0001_m_000002");
        Assert.assertEquals((long)0L, (long)jvmid.compareTo(jvmid1));
    }

    @Test(timeout=10000L)
    public void testGetMapCompletionEvents() throws IOException {
        TaskAttemptCompletionEvent[] empty = new TaskAttemptCompletionEvent[]{};
        TaskAttemptCompletionEvent[] taskEvents = new TaskAttemptCompletionEvent[]{TestTaskAttemptListenerImpl.createTce((int)0, (boolean)true, (TaskAttemptCompletionEventStatus)TaskAttemptCompletionEventStatus.OBSOLETE), TestTaskAttemptListenerImpl.createTce((int)1, (boolean)false, (TaskAttemptCompletionEventStatus)TaskAttemptCompletionEventStatus.FAILED), TestTaskAttemptListenerImpl.createTce((int)2, (boolean)true, (TaskAttemptCompletionEventStatus)TaskAttemptCompletionEventStatus.SUCCEEDED), TestTaskAttemptListenerImpl.createTce((int)3, (boolean)false, (TaskAttemptCompletionEventStatus)TaskAttemptCompletionEventStatus.FAILED)};
        TaskAttemptCompletionEvent[] mapEvents = new TaskAttemptCompletionEvent[]{taskEvents[0], taskEvents[2]};
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getTaskAttemptCompletionEvents(0, 100)).thenReturn((Object)taskEvents);
        Mockito.when((Object)mockJob.getTaskAttemptCompletionEvents(0, 2)).thenReturn((Object)Arrays.copyOfRange(taskEvents, 0, 2));
        Mockito.when((Object)mockJob.getTaskAttemptCompletionEvents(2, 100)).thenReturn((Object)Arrays.copyOfRange(taskEvents, 2, 4));
        Mockito.when((Object)mockJob.getMapAttemptCompletionEvents(0, 100)).thenReturn((Object)TypeConverter.fromYarn((TaskAttemptCompletionEvent[])mapEvents));
        Mockito.when((Object)mockJob.getMapAttemptCompletionEvents(0, 2)).thenReturn((Object)TypeConverter.fromYarn((TaskAttemptCompletionEvent[])mapEvents));
        Mockito.when((Object)mockJob.getMapAttemptCompletionEvents(2, 100)).thenReturn((Object)TypeConverter.fromYarn((TaskAttemptCompletionEvent[])empty));
        this.configureMocks();
        Mockito.when((Object)this.appCtx.getJob((JobId)Matchers.any(JobId.class))).thenReturn((Object)mockJob);
        this.listener = new /* Unavailable Anonymous Inner Class!! */;
        Configuration conf = new Configuration();
        this.listener.init(conf);
        this.listener.start();
        JobID jid = new JobID("12345", 1);
        TaskAttemptID tid = new TaskAttemptID("12345", 1, TaskType.REDUCE, 1, 0);
        MapTaskCompletionEventsUpdate update = this.listener.getMapCompletionEvents(jid, 0, 100, tid);
        Assert.assertEquals((long)2L, (long)update.events.length);
        update = this.listener.getMapCompletionEvents(jid, 0, 2, tid);
        Assert.assertEquals((long)2L, (long)update.events.length);
        update = this.listener.getMapCompletionEvents(jid, 2, 100, tid);
        Assert.assertEquals((long)0L, (long)update.events.length);
    }

    private static TaskAttemptCompletionEvent createTce(int eventId, boolean isMap, TaskAttemptCompletionEventStatus status) {
        JobId jid = MRBuilderUtils.newJobId((long)12345L, (int)1, (int)1);
        TaskId tid = MRBuilderUtils.newTaskId((JobId)jid, (int)0, (org.apache.hadoop.mapreduce.v2.api.records.TaskType)(isMap ? org.apache.hadoop.mapreduce.v2.api.records.TaskType.MAP : org.apache.hadoop.mapreduce.v2.api.records.TaskType.REDUCE));
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)tid, (int)0);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        TaskAttemptCompletionEvent tce = (TaskAttemptCompletionEvent)recordFactory.newRecordInstance(TaskAttemptCompletionEvent.class);
        tce.setEventId(eventId);
        tce.setAttemptId(attemptId);
        tce.setStatus(status);
        return tce;
    }

    @Test(timeout=10000L)
    public void testCommitWindow() throws IOException {
        SystemClock clock = SystemClock.getInstance();
        this.configureMocks();
        org.apache.hadoop.mapreduce.v2.app.job.Task mockTask = (org.apache.hadoop.mapreduce.v2.app.job.Task)Mockito.mock(org.apache.hadoop.mapreduce.v2.app.job.Task.class);
        Mockito.when((Object)mockTask.canCommit((TaskAttemptId)Matchers.any(TaskAttemptId.class))).thenReturn((Object)true);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getTask((TaskId)Matchers.any(TaskId.class))).thenReturn((Object)mockTask);
        Mockito.when((Object)this.appCtx.getJob((JobId)Matchers.any(JobId.class))).thenReturn((Object)mockJob);
        Mockito.when((Object)this.appCtx.getClock()).thenReturn((Object)clock);
        this.listener = new /* Unavailable Anonymous Inner Class!! */;
        Configuration conf = new Configuration();
        this.listener.init(conf);
        this.listener.start();
        TaskAttemptID tid = new TaskAttemptID("12345", 1, TaskType.REDUCE, 1, 0);
        boolean canCommit = this.listener.canCommit(tid);
        Assert.assertFalse((boolean)canCommit);
        ((org.apache.hadoop.mapreduce.v2.app.job.Task)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.never())).canCommit((TaskAttemptId)Matchers.any(TaskAttemptId.class));
        Mockito.when((Object)this.rmHeartbeatHandler.getLastHeartbeatTime()).thenReturn((Object)clock.getTime());
        canCommit = this.listener.canCommit(tid);
        Assert.assertTrue((boolean)canCommit);
        ((org.apache.hadoop.mapreduce.v2.app.job.Task)Mockito.verify((Object)mockTask, (VerificationMode)Mockito.times((int)1))).canCommit((TaskAttemptId)Matchers.any(TaskAttemptId.class));
    }

    @Test
    public void testSingleStatusUpdate() throws IOException, InterruptedException {
        this.configureMocks();
        this.startListener(true);
        this.listener.statusUpdate(this.attemptID, (TaskStatus)this.firstReduceStatus);
        ((EventHandler)Mockito.verify((Object)this.ea)).handle((Event)this.eventCaptor.capture());
        TaskAttemptStatusUpdateEvent updateEvent = (TaskAttemptStatusUpdateEvent)this.eventCaptor.getValue();
        TaskAttemptStatusUpdateEvent.TaskAttemptStatus status = (TaskAttemptStatusUpdateEvent.TaskAttemptStatus)updateEvent.getTaskAttemptStatusRef().get();
        Assert.assertTrue((boolean)status.fetchFailedMaps.contains(TASKATTEMPTID1));
        Assert.assertEquals((long)1L, (long)status.fetchFailedMaps.size());
        Assert.assertEquals((Object)Phase.SHUFFLE, (Object)status.phase);
    }

    @Test
    public void testStatusUpdateEventCoalescing() throws IOException, InterruptedException {
        this.configureMocks();
        this.startListener(true);
        this.listener.statusUpdate(this.attemptID, (TaskStatus)this.firstReduceStatus);
        this.listener.statusUpdate(this.attemptID, (TaskStatus)this.secondReduceStatus);
        ((EventHandler)Mockito.verify((Object)this.ea)).handle((Event)Matchers.any(Event.class));
        ConcurrentMap attemptIdToStatus = this.listener.getAttemptIdToStatus();
        TaskAttemptStatusUpdateEvent.TaskAttemptStatus status = (TaskAttemptStatusUpdateEvent.TaskAttemptStatus)((AtomicReference)attemptIdToStatus.get(this.attemptId)).get();
        Assert.assertTrue((boolean)status.fetchFailedMaps.contains(TASKATTEMPTID1));
        Assert.assertTrue((boolean)status.fetchFailedMaps.contains(TASKATTEMPTID2));
        Assert.assertEquals((long)2L, (long)status.fetchFailedMaps.size());
        Assert.assertEquals((Object)Phase.SORT, (Object)status.phase);
    }

    @Test
    public void testCoalescedStatusUpdatesCleared() throws IOException, InterruptedException {
        this.configureMocks();
        this.startListener(true);
        this.listener.statusUpdate(this.attemptID, (TaskStatus)this.firstReduceStatus);
        this.listener.statusUpdate(this.attemptID, (TaskStatus)this.secondReduceStatus);
        ConcurrentMap attemptIdToStatus = this.listener.getAttemptIdToStatus();
        ((AtomicReference)attemptIdToStatus.get(this.attemptId)).set(null);
        this.listener.statusUpdate(this.attemptID, (TaskStatus)this.thirdReduceStatus);
        ((EventHandler)Mockito.verify((Object)this.ea, (VerificationMode)Mockito.times((int)2))).handle((Event)this.eventCaptor.capture());
        TaskAttemptStatusUpdateEvent updateEvent = (TaskAttemptStatusUpdateEvent)this.eventCaptor.getValue();
        TaskAttemptStatusUpdateEvent.TaskAttemptStatus status = (TaskAttemptStatusUpdateEvent.TaskAttemptStatus)updateEvent.getTaskAttemptStatusRef().get();
        Assert.assertNull((Object)status.fetchFailedMaps);
        Assert.assertEquals((Object)Phase.REDUCE, (Object)status.phase);
    }

    @Test
    public void testStatusUpdateFromUnregisteredTask() throws Exception {
        this.configureMocks();
        ControlledClock clock = new ControlledClock();
        clock.setTime(0L);
        ((AppContext)Mockito.doReturn((Object)clock).when((Object)this.appCtx)).getClock();
        3 tal = new /* Unavailable Anonymous Inner Class!! */;
        Configuration conf = new Configuration();
        conf.setLong("mapreduce.task.timeout.check-interval-ms", 1L);
        conf.setDouble("mapreduce.task.log.progress.delta.threshold", 0.01);
        conf.setDouble("mapreduce.task.log.progress.wait.interval-seconds", 1.0);
        tal.init(conf);
        tal.start();
        Assert.assertFalse((boolean)tal.statusUpdate(this.attemptID, (TaskStatus)this.firstReduceStatus));
        tal.registerPendingTask(this.task, this.wid);
        tal.registerLaunchedTask(this.attemptId, this.wid);
        Assert.assertTrue((boolean)tal.statusUpdate(this.attemptID, (TaskStatus)this.firstReduceStatus));
        tal.unregister(this.attemptId, this.wid);
        Assert.assertTrue((boolean)tal.statusUpdate(this.attemptID, (TaskStatus)this.firstReduceStatus));
        long unregisterTimeout = conf.getLong("mapreduce.task.exit.timeout", 60000L);
        clock.setTime(unregisterTimeout + 1L);
        GenericTestUtils.waitFor((Supplier)new /* Unavailable Anonymous Inner Class!! */, (int)10, (int)10000);
    }

    private void configureMocks() {
        this.firstReduceStatus = new ReduceTaskStatus(this.attemptID, 0.0f, 1, TaskStatus.State.RUNNING, "", "RUNNING", "", TaskStatus.Phase.SHUFFLE, new Counters());
        this.firstReduceStatus.addFetchFailedMap(TaskAttemptID.forName((String)"attempt_123456789012_0001_m_000001_0"));
        this.secondReduceStatus = new ReduceTaskStatus(this.attemptID, 0.0f, 1, TaskStatus.State.RUNNING, "", "RUNNING", "", TaskStatus.Phase.SORT, new Counters());
        this.secondReduceStatus.addFetchFailedMap(TaskAttemptID.forName((String)"attempt_123456789012_0001_m_000002_0"));
        this.thirdReduceStatus = new ReduceTaskStatus(this.attemptID, 0.0f, 1, TaskStatus.State.RUNNING, "", "RUNNING", "", TaskStatus.Phase.REDUCE, new Counters());
        Mockito.when((Object)this.dispatcher.getEventHandler()).thenReturn((Object)this.ea);
        Mockito.when((Object)this.appCtx.getEventHandler()).thenReturn((Object)this.ea);
        this.listener = new MockTaskAttemptListenerImpl(this.appCtx, this.secret, this.rmHeartbeatHandler, this.hbHandler);
        this.id = new JVMId("foo", 1, true, 1L);
        this.wid = new WrappedJvmID(this.id.getJobId(), this.id.isMap, this.id.getId());
        this.attemptID = new TaskAttemptID("1", 1, TaskType.MAP, 1, 1);
        this.attemptId = TypeConverter.toYarn((TaskAttemptID)this.attemptID);
    }

    private void startListener(boolean registerTask) {
        Configuration conf = new Configuration();
        this.listener.init(conf);
        this.listener.start();
        if (registerTask) {
            this.listener.registerPendingTask(this.task, this.wid);
            this.listener.registerLaunchedTask(this.attemptId, this.wid);
        }
    }

    static /* synthetic */ TaskHeartbeatHandler access$000(TestTaskAttemptListenerImpl x0) {
        return x0.hbHandler;
    }

    static /* synthetic */ TaskAttemptID access$100(TestTaskAttemptListenerImpl x0) {
        return x0.attemptID;
    }

    static /* synthetic */ ReduceTaskStatus access$200(TestTaskAttemptListenerImpl x0) {
        return x0.firstReduceStatus;
    }
}

