/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.ClientHandlerException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.AMStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEventHandler;
import org.apache.hadoop.mapreduce.jobhistory.JobInfoChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInitedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobPriorityChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobQueueChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobStatusChangedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSubmittedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSummary;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.MapAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.NormalizedResourceEvent;
import org.apache.hadoop.mapreduce.jobhistory.ReduceAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskUpdatedEvent;
import org.apache.hadoop.mapreduce.util.JobHistoryEventUtils;
import org.apache.hadoop.mapreduce.util.MRJobConfUtil;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.jobhistory.FileNameIndexUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobIndexInfo;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationEntity;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.client.api.TimelineV2Client;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.TimelineServiceHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class JobHistoryEventHandler
extends AbstractService
implements EventHandler<JobHistoryEvent> {
    private final AppContext context;
    private final int startCount;
    private int eventCounter;
    private FileSystem stagingDirFS;
    private FileSystem doneDirFS;
    private Path stagingDirPath = null;
    private Path doneDirPrefixPath = null;
    private int maxUnflushedCompletionEvents;
    private int postJobCompletionMultiplier;
    private long flushTimeout;
    private int minQueueSizeForBatchingFlushes;
    private int numUnflushedCompletionEvents = 0;
    private boolean isTimerActive;
    private EventWriter.WriteMode jhistMode = EventWriter.WriteMode.JSON;
    protected BlockingQueue<JobHistoryEvent> eventQueue = new LinkedBlockingQueue();
    protected boolean handleTimelineEvent = false;
    protected AsyncDispatcher atsEventDispatcher = null;
    protected Thread eventHandlingThread;
    private volatile boolean stopped;
    private final Object lock = new Object();
    private static final Log LOG = LogFactory.getLog(JobHistoryEventHandler.class);
    protected static final Map<JobId, MetaInfo> fileMap = Collections.synchronizedMap(new HashMap());
    protected volatile boolean forceJobCompletion = false;
    @VisibleForTesting
    protected TimelineClient timelineClient;
    @VisibleForTesting
    protected TimelineV2Client timelineV2Client;
    private static String MAPREDUCE_JOB_ENTITY_TYPE = "MAPREDUCE_JOB";
    private static String MAPREDUCE_TASK_ENTITY_TYPE = "MAPREDUCE_TASK";
    private static final String MAPREDUCE_TASK_ATTEMPT_ENTITY_TYPE = "MAPREDUCE_TASK_ATTEMPT";

    public JobHistoryEventHandler(AppContext context, int startCount) {
        super("JobHistoryEventHandler");
        this.context = context;
        this.startCount = startCount;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        String userDoneDirStr;
        block20: {
            String jobId = TypeConverter.fromYarn((ApplicationId)this.context.getApplicationID()).toString();
            String stagingDirStr = null;
            String doneDirStr = null;
            userDoneDirStr = null;
            try {
                stagingDirStr = JobHistoryUtils.getConfiguredHistoryStagingDirPrefix((Configuration)conf, (String)jobId);
                doneDirStr = JobHistoryUtils.getConfiguredHistoryIntermediateDoneDirPrefix((Configuration)conf);
                userDoneDirStr = JobHistoryUtils.getHistoryIntermediateDoneDirForUser((Configuration)conf);
            }
            catch (IOException e) {
                LOG.error((Object)"Failed while getting the configured log directories", (Throwable)e);
                throw new YarnRuntimeException((Throwable)e);
            }
            try {
                this.stagingDirPath = FileContext.getFileContext((Configuration)conf).makeQualified(new Path(stagingDirStr));
                this.stagingDirFS = FileSystem.get((URI)this.stagingDirPath.toUri(), (Configuration)conf);
                this.mkdir(this.stagingDirFS, this.stagingDirPath, new FsPermission(JobHistoryUtils.HISTORY_STAGING_DIR_PERMISSIONS));
            }
            catch (IOException e) {
                LOG.error((Object)("Failed while checking for/creating  history staging path: [" + this.stagingDirPath + "]"), (Throwable)e);
                throw new YarnRuntimeException((Throwable)e);
            }
            Path doneDirPath = null;
            try {
                doneDirPath = FileContext.getFileContext((Configuration)conf).makeQualified(new Path(doneDirStr));
                this.doneDirFS = FileSystem.get((URI)doneDirPath.toUri(), (Configuration)conf);
                if (this.doneDirFS.exists(doneDirPath)) break block20;
                if (JobHistoryUtils.shouldCreateNonUserDirectory((Configuration)conf)) {
                    LOG.info((Object)("Creating intermediate history logDir: [" + doneDirPath + "] + based on conf. Should ideally be created by the JobHistoryServer: " + "yarn.app.mapreduce.am.create-intermediate-jh-base-dir"));
                    this.mkdir(this.doneDirFS, doneDirPath, new FsPermission(JobHistoryUtils.HISTORY_INTERMEDIATE_DONE_DIR_PERMISSIONS.toShort()));
                    break block20;
                }
                String message = "Not creating intermediate history logDir: [" + doneDirPath + "] based on conf: " + "yarn.app.mapreduce.am.create-intermediate-jh-base-dir" + ". Either set to true or pre-create this directory with" + " appropriate permissions";
                LOG.error((Object)message);
                throw new YarnRuntimeException(message);
            }
            catch (IOException e) {
                LOG.error((Object)("Failed checking for the existance of history intermediate done directory: [" + doneDirPath + "]"));
                throw new YarnRuntimeException((Throwable)e);
            }
        }
        try {
            this.doneDirPrefixPath = FileContext.getFileContext((Configuration)conf).makeQualified(new Path(userDoneDirStr));
            this.mkdir(this.doneDirFS, this.doneDirPrefixPath, new FsPermission(JobHistoryUtils.HISTORY_INTERMEDIATE_USER_DIR_PERMISSIONS));
        }
        catch (IOException e) {
            LOG.error((Object)("Error creating user intermediate history done directory: [ " + this.doneDirPrefixPath + "]"), (Throwable)e);
            throw new YarnRuntimeException((Throwable)e);
        }
        this.maxUnflushedCompletionEvents = conf.getInt("yarn.app.mapreduce.am.history.max-unflushed-events", 200);
        this.postJobCompletionMultiplier = conf.getInt("yarn.app.mapreduce.am.history.job-complete-unflushed-multiplier", 30);
        this.flushTimeout = conf.getLong("yarn.app.mapreduce.am.history.complete-event-flush-timeout", 30000L);
        this.minQueueSizeForBatchingFlushes = conf.getInt("yarn.app.mapreduce.am.history.use-batched-flush.queue-size.threshold", 50);
        if (conf.getBoolean("mapreduce.job.emit-timeline-data", false)) {
            LOG.info((Object)"Emitting job history data to the timeline service is enabled");
            if (YarnConfiguration.timelineServiceEnabled((Configuration)conf)) {
                boolean timelineServiceV2Enabled = YarnConfiguration.timelineServiceV2Enabled((Configuration)conf);
                if (timelineServiceV2Enabled) {
                    this.timelineV2Client = ((MRAppMaster.RunningAppContext)this.context).getTimelineV2Client();
                    this.timelineV2Client.init(conf);
                } else {
                    this.timelineClient = ((MRAppMaster.RunningAppContext)this.context).getTimelineClient();
                    this.timelineClient.init(conf);
                }
                this.handleTimelineEvent = true;
                LOG.info((Object)("Timeline service is enabled; version: " + YarnConfiguration.getTimelineServiceVersion((Configuration)conf)));
            } else {
                LOG.info((Object)"Timeline service is not enabled");
            }
        } else {
            LOG.info((Object)"Emitting job history data to the timeline server is not enabled");
        }
        String jhistFormat = conf.get("mapreduce.jobhistory.jhist.format", "json");
        if (jhistFormat.equals("json")) {
            this.jhistMode = EventWriter.WriteMode.JSON;
        } else if (jhistFormat.equals("binary")) {
            this.jhistMode = EventWriter.WriteMode.BINARY;
        } else {
            LOG.warn((Object)("Unrecognized value '" + jhistFormat + "' for property " + "mapreduce.jobhistory.jhist.format" + ".  Valid values are " + "'json' or 'binary'.  Falling back to default value '" + "json" + "'."));
        }
        if (this.handleTimelineEvent) {
            this.atsEventDispatcher = this.createDispatcher();
            ForwardingEventHandler timelineEventHandler = new ForwardingEventHandler(this, null);
            this.atsEventDispatcher.register(EventType.class, (EventHandler)timelineEventHandler);
            this.atsEventDispatcher.setDrainEventsOnStop();
            this.atsEventDispatcher.init(conf);
        }
        super.serviceInit(conf);
    }

    protected AsyncDispatcher createDispatcher() {
        return new AsyncDispatcher("Job ATS Event Dispatcher");
    }

    private void mkdir(FileSystem fs, Path path, FsPermission fsp) throws IOException {
        if (!fs.exists(path)) {
            try {
                fs.mkdirs(path, fsp);
                FileStatus fsStatus = fs.getFileStatus(path);
                LOG.info((Object)("Perms after creating " + fsStatus.getPermission().toShort() + ", Expected: " + fsp.toShort()));
                if (fsStatus.getPermission().toShort() != fsp.toShort()) {
                    LOG.info((Object)("Explicitly setting permissions to : " + fsp.toShort() + ", " + fsp));
                    fs.setPermission(path, fsp);
                }
            }
            catch (FileAlreadyExistsException e) {
                LOG.info((Object)("Directory: [" + path + "] already exists."));
            }
        }
    }

    protected void serviceStart() throws Exception {
        if (this.timelineClient != null) {
            this.timelineClient.start();
        } else if (this.timelineV2Client != null) {
            this.timelineV2Client.start();
        }
        this.eventHandlingThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */, "eventHandlingThread");
        this.eventHandlingThread.start();
        if (this.handleTimelineEvent) {
            this.atsEventDispatcher.start();
        }
        super.serviceStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceStop() throws Exception {
        LOG.info((Object)("Stopping JobHistoryEventHandler. Size of the outstanding queue size is " + this.eventQueue.size()));
        this.stopped = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.eventHandlingThread != null) {
                LOG.debug((Object)"Interrupting Event Handling thread");
                this.eventHandlingThread.interrupt();
            } else {
                LOG.debug((Object)"Null event handling thread");
            }
        }
        try {
            if (this.eventHandlingThread != null) {
                LOG.debug((Object)"Waiting for Event Handling thread to complete");
                this.eventHandlingThread.join();
            }
        }
        catch (InterruptedException ie) {
            LOG.info((Object)"Interrupted Exception while stopping", (Throwable)ie);
        }
        for (MetaInfo mi : fileMap.values()) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Shutting down timer for " + mi));
                }
                mi.shutDownTimer();
            }
            catch (IOException e) {
                LOG.info((Object)("Exception while canceling delayed flush timer. Likely caused by a failed flush " + e.getMessage()));
            }
        }
        for (JobHistoryEvent ev : this.eventQueue) {
            LOG.info((Object)("In stop, writing event " + ev.getType()));
            this.handleEvent(ev);
        }
        if (this.forceJobCompletion) {
            for (Map.Entry jobIt : fileMap.entrySet()) {
                JobId toClose = (JobId)jobIt.getKey();
                MetaInfo mi = (MetaInfo)jobIt.getValue();
                if (mi == null || !mi.isWriterActive()) continue;
                LOG.warn((Object)("Found jobId " + toClose + " to have not been closed. Will close"));
                Job job = this.context.getJob(toClose);
                JobUnsuccessfulCompletionEvent jucEvent = new JobUnsuccessfulCompletionEvent((JobID)TypeConverter.fromYarn((JobId)toClose), System.currentTimeMillis(), job.getCompletedMaps(), job.getCompletedReduces(), this.createJobStateForJobUnsuccessfulCompletionEvent(mi.getForcedJobStateOnShutDown()), (Iterable)job.getDiagnostics());
                JobHistoryEvent jfEvent = new JobHistoryEvent(toClose, (HistoryEvent)jucEvent);
                this.handleEvent(jfEvent);
            }
        }
        for (MetaInfo mi : fileMap.values()) {
            try {
                mi.closeWriter();
            }
            catch (IOException e) {
                LOG.info((Object)("Exception while closing file " + e.getMessage()));
            }
        }
        if (this.handleTimelineEvent && this.atsEventDispatcher != null) {
            this.atsEventDispatcher.stop();
        }
        if (this.timelineClient != null) {
            this.timelineClient.stop();
        } else if (this.timelineV2Client != null) {
            this.timelineV2Client.stop();
        }
        LOG.info((Object)"Stopped JobHistoryEventHandler. super.stop()");
        super.serviceStop();
    }

    protected EventWriter createEventWriter(Path historyFilePath) throws IOException {
        FSDataOutputStream out = this.stagingDirFS.create(historyFilePath, true);
        return new EventWriter(out, this.jhistMode);
    }

    protected void setupEventWriter(JobId jobId, AMStartedEvent amStartedEvent) throws IOException {
        if (this.stagingDirPath == null) {
            LOG.error((Object)"Log Directory is null, returning");
            throw new IOException("Missing Log Directory for History");
        }
        MetaInfo oldFi = (MetaInfo)fileMap.get(jobId);
        Configuration conf = this.getConfig();
        Path historyFile = JobHistoryUtils.getStagingJobHistoryFile((Path)this.stagingDirPath, (JobId)jobId, (int)this.startCount);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        if (user == null) {
            throw new IOException("User is null while setting up jobhistory eventwriter");
        }
        String jobName = this.context.getJob(jobId).getName();
        EventWriter writer = oldFi == null ? null : MetaInfo.access$500((MetaInfo)oldFi);
        Path logDirConfPath = JobHistoryUtils.getStagingConfFile((Path)this.stagingDirPath, (JobId)jobId, (int)this.startCount);
        if (writer == null) {
            try {
                writer = this.createEventWriter(historyFile);
                LOG.info((Object)("Event Writer setup for JobId: " + jobId + ", File: " + historyFile));
            }
            catch (IOException ioe) {
                LOG.info((Object)("Could not create log file: [" + historyFile + "] + for job " + "[" + jobName + "]"));
                throw ioe;
            }
            if (conf != null && logDirConfPath != null) {
                Configuration redactedConf = new Configuration(conf);
                MRJobConfUtil.redact((Configuration)redactedConf);
                try (FSDataOutputStream jobFileOut = this.stagingDirFS.create(logDirConfPath, true);){
                    redactedConf.writeXml((OutputStream)jobFileOut);
                }
                catch (IOException e) {
                    LOG.info((Object)"Failed to write the job configuration file", (Throwable)e);
                    throw e;
                }
            }
        }
        String queueName = "default";
        if (conf != null) {
            queueName = conf.get("mapreduce.job.queuename", "default");
        }
        MetaInfo fi = new MetaInfo(this, historyFile, logDirConfPath, writer, user, jobName, jobId, amStartedEvent.getForcedJobStateOnShutDown(), queueName);
        fi.getJobSummary().setJobId(jobId);
        fi.getJobSummary().setJobLaunchTime(amStartedEvent.getStartTime());
        fi.getJobSummary().setJobSubmitTime(amStartedEvent.getSubmitTime());
        fi.getJobIndexInfo().setJobStartTime(amStartedEvent.getStartTime());
        fi.getJobIndexInfo().setSubmitTime(amStartedEvent.getSubmitTime());
        fileMap.put(jobId, fi);
    }

    public void closeWriter(JobId id) throws IOException {
        try {
            MetaInfo mi = (MetaInfo)fileMap.get(id);
            if (mi != null) {
                mi.closeWriter();
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Error closing writer for JobID: " + id));
            throw e;
        }
    }

    public void handle(JobHistoryEvent event) {
        try {
            if (this.isJobCompletionEvent(event.getHistoryEvent())) {
                this.maxUnflushedCompletionEvents *= this.postJobCompletionMultiplier;
            }
            this.eventQueue.put(event);
            if (this.handleTimelineEvent) {
                this.atsEventDispatcher.getEventHandler().handle((Event)event);
            }
        }
        catch (InterruptedException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    private boolean isJobCompletionEvent(HistoryEvent historyEvent) {
        return EnumSet.of(EventType.JOB_FINISHED, EventType.JOB_FAILED, EventType.JOB_KILLED).contains(historyEvent.getEventType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public void handleEvent(JobHistoryEvent event) {
        Object object = this.lock;
        synchronized (object) {
            JobUnsuccessfulCompletionEvent jucEvent;
            if (event.getHistoryEvent().getEventType() == EventType.AM_STARTED) {
                try {
                    AMStartedEvent amStartedEvent = (AMStartedEvent)event.getHistoryEvent();
                    this.setupEventWriter(event.getJobID(), amStartedEvent);
                }
                catch (IOException ioe) {
                    LOG.error((Object)("Error JobHistoryEventHandler in handleEvent: " + event), (Throwable)ioe);
                    throw new YarnRuntimeException((Throwable)ioe);
                }
            }
            MetaInfo mi = (MetaInfo)fileMap.get(event.getJobID());
            try {
                HistoryEvent historyEvent = event.getHistoryEvent();
                if (!(historyEvent instanceof NormalizedResourceEvent)) {
                    mi.writeEvent(historyEvent);
                }
                this.processEventForJobSummary(event.getHistoryEvent(), mi.getJobSummary(), event.getJobID());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("In HistoryEventHandler " + event.getHistoryEvent().getEventType()));
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Error writing History Event: " + event.getHistoryEvent()), (Throwable)e);
                throw new YarnRuntimeException((Throwable)e);
            }
            if (event.getHistoryEvent().getEventType() == EventType.JOB_SUBMITTED) {
                JobSubmittedEvent jobSubmittedEvent = (JobSubmittedEvent)event.getHistoryEvent();
                mi.getJobIndexInfo().setSubmitTime(jobSubmittedEvent.getSubmitTime());
                mi.getJobIndexInfo().setQueueName(jobSubmittedEvent.getJobQueueName());
            }
            if (event.getHistoryEvent().getEventType() == EventType.JOB_INITED) {
                JobInitedEvent jie = (JobInitedEvent)event.getHistoryEvent();
                mi.getJobIndexInfo().setJobStartTime(jie.getLaunchTime());
            }
            if (event.getHistoryEvent().getEventType() == EventType.JOB_QUEUE_CHANGED) {
                JobQueueChangeEvent jQueueEvent = (JobQueueChangeEvent)event.getHistoryEvent();
                mi.getJobIndexInfo().setQueueName(jQueueEvent.getJobQueueName());
            }
            if (event.getHistoryEvent().getEventType() == EventType.JOB_FINISHED) {
                try {
                    JobFinishedEvent jFinishedEvent = (JobFinishedEvent)event.getHistoryEvent();
                    mi.getJobIndexInfo().setFinishTime(jFinishedEvent.getFinishTime());
                    mi.getJobIndexInfo().setNumMaps(jFinishedEvent.getFinishedMaps());
                    mi.getJobIndexInfo().setNumReduces(jFinishedEvent.getFinishedReduces());
                    mi.getJobIndexInfo().setJobStatus(JobState.SUCCEEDED.toString());
                    this.closeEventWriter(event.getJobID());
                    this.processDoneFiles(event.getJobID());
                }
                catch (IOException e) {
                    throw new YarnRuntimeException((Throwable)e);
                }
            }
            if (event.getHistoryEvent().getEventType() == EventType.JOB_ERROR) {
                try {
                    jucEvent = (JobUnsuccessfulCompletionEvent)event.getHistoryEvent();
                    mi.getJobIndexInfo().setFinishTime(jucEvent.getFinishTime());
                    mi.getJobIndexInfo().setNumMaps(jucEvent.getFinishedMaps());
                    mi.getJobIndexInfo().setNumReduces(jucEvent.getFinishedReduces());
                    mi.getJobIndexInfo().setJobStatus(jucEvent.getStatus());
                    this.closeEventWriter(event.getJobID());
                    if (this.context.isLastAMRetry()) {
                        this.processDoneFiles(event.getJobID());
                    }
                }
                catch (IOException e) {
                    throw new YarnRuntimeException((Throwable)e);
                }
            }
            if (event.getHistoryEvent().getEventType() == EventType.JOB_FAILED || event.getHistoryEvent().getEventType() == EventType.JOB_KILLED) {
                try {
                    jucEvent = (JobUnsuccessfulCompletionEvent)event.getHistoryEvent();
                    mi.getJobIndexInfo().setFinishTime(jucEvent.getFinishTime());
                    mi.getJobIndexInfo().setNumMaps(jucEvent.getFinishedMaps());
                    mi.getJobIndexInfo().setNumReduces(jucEvent.getFinishedReduces());
                    mi.getJobIndexInfo().setJobStatus(jucEvent.getStatus());
                    this.closeEventWriter(event.getJobID());
                    this.processDoneFiles(event.getJobID());
                }
                catch (IOException e) {
                    throw new YarnRuntimeException((Throwable)e);
                }
            }
        }
    }

    private void handleTimelineEvent(JobHistoryEvent event) {
        HistoryEvent historyEvent = event.getHistoryEvent();
        if (this.handleTimelineEvent) {
            if (this.timelineV2Client != null) {
                this.processEventForNewTimelineService(historyEvent, event.getJobID(), event.getTimestamp());
            } else if (this.timelineClient != null) {
                this.processEventForTimelineServer(historyEvent, event.getJobID(), event.getTimestamp());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("In HistoryEventHandler, handle timelineEvent:" + event.getHistoryEvent().getEventType()));
        }
    }

    public void processEventForJobSummary(HistoryEvent event, JobSummary summary, JobId jobId) {
        switch (2.$SwitchMap$org$apache$hadoop$mapreduce$jobhistory$EventType[event.getEventType().ordinal()]) {
            case 1: {
                JobSubmittedEvent jse = (JobSubmittedEvent)event;
                summary.setUser(jse.getUserName());
                summary.setQueue(jse.getJobQueueName());
                summary.setJobSubmitTime(jse.getSubmitTime());
                summary.setJobName(jse.getJobName());
                break;
            }
            case 2: {
                NormalizedResourceEvent normalizedResourceEvent = (NormalizedResourceEvent)event;
                if (normalizedResourceEvent.getTaskType() == TaskType.MAP) {
                    summary.setResourcesPerMap((int)normalizedResourceEvent.getMemory());
                    break;
                }
                if (normalizedResourceEvent.getTaskType() != TaskType.REDUCE) break;
                summary.setResourcesPerReduce((int)normalizedResourceEvent.getMemory());
                break;
            }
            case 3: {
                JobInitedEvent jie = (JobInitedEvent)event;
                summary.setJobLaunchTime(jie.getLaunchTime());
                break;
            }
            case 4: {
                TaskAttemptStartedEvent mtase = (TaskAttemptStartedEvent)event;
                if (summary.getFirstMapTaskLaunchTime() != 0L) break;
                summary.setFirstMapTaskLaunchTime(mtase.getStartTime());
                break;
            }
            case 5: {
                TaskAttemptStartedEvent rtase = (TaskAttemptStartedEvent)event;
                if (summary.getFirstReduceTaskLaunchTime() != 0L) break;
                summary.setFirstReduceTaskLaunchTime(rtase.getStartTime());
                break;
            }
            case 6: {
                JobFinishedEvent jfe = (JobFinishedEvent)event;
                summary.setJobFinishTime(jfe.getFinishTime());
                summary.setNumFinishedMaps(jfe.getFinishedMaps());
                summary.setNumFailedMaps(jfe.getFailedMaps());
                summary.setNumFinishedReduces(jfe.getFinishedReduces());
                summary.setNumFailedReduces(jfe.getFailedReduces());
                if (summary.getJobStatus() == null) {
                    summary.setJobStatus(JobStatus.State.SUCCEEDED.toString());
                }
                this.setSummarySlotSeconds(summary, jfe.getTotalCounters());
                break;
            }
            case 7: 
            case 8: {
                JobUnsuccessfulCompletionEvent juce = (JobUnsuccessfulCompletionEvent)event;
                summary.setJobStatus(juce.getStatus());
                summary.setNumFinishedMaps(this.context.getJob(jobId).getTotalMaps());
                summary.setNumFinishedReduces(this.context.getJob(jobId).getTotalReduces());
                summary.setJobFinishTime(juce.getFinishTime());
                this.setSummarySlotSeconds(summary, this.context.getJob(jobId).getAllCounters());
                break;
            }
        }
    }

    private void processEventForTimelineServer(HistoryEvent event, JobId jobId, long timestamp) {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType(StringUtils.toUpperCase((String)event.getEventType().name()));
        tEvent.setTimestamp(timestamp);
        TimelineEntity tEntity = new TimelineEntity();
        switch (2.$SwitchMap$org$apache$hadoop$mapreduce$jobhistory$EventType[event.getEventType().ordinal()]) {
            case 1: {
                JobSubmittedEvent jse = (JobSubmittedEvent)event;
                tEvent.addEventInfo("SUBMIT_TIME", (Object)jse.getSubmitTime());
                tEvent.addEventInfo("QUEUE_NAME", (Object)jse.getJobQueueName());
                tEvent.addEventInfo("JOB_NAME", (Object)jse.getJobName());
                tEvent.addEventInfo("USER_NAME", (Object)jse.getUserName());
                tEvent.addEventInfo("JOB_CONF_PATH", (Object)jse.getJobConfPath());
                tEvent.addEventInfo("ACLS", (Object)jse.getJobAcls());
                tEvent.addEventInfo("JOB_QUEUE_NAME", (Object)jse.getJobQueueName());
                tEvent.addEventInfo("WORKFLOW_ID", (Object)jse.getWorkflowId());
                tEvent.addEventInfo("WORKLFOW_ID", (Object)jse.getWorkflowId());
                tEvent.addEventInfo("WORKFLOW_NAME", (Object)jse.getWorkflowName());
                tEvent.addEventInfo("WORKFLOW_NAME_NAME", (Object)jse.getWorkflowNodeName());
                tEvent.addEventInfo("WORKFLOW_ADJACENCIES", (Object)jse.getWorkflowAdjacencies());
                tEvent.addEventInfo("WORKFLOW_TAGS", (Object)jse.getWorkflowTags());
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(jobId.toString());
                tEntity.setEntityType(MAPREDUCE_JOB_ENTITY_TYPE);
                break;
            }
            case 9: {
                JobStatusChangedEvent jsce = (JobStatusChangedEvent)event;
                tEvent.addEventInfo("STATUS", (Object)jsce.getStatus());
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(jobId.toString());
                tEntity.setEntityType(MAPREDUCE_JOB_ENTITY_TYPE);
                break;
            }
            case 10: {
                JobInfoChangeEvent jice = (JobInfoChangeEvent)event;
                tEvent.addEventInfo("SUBMIT_TIME", (Object)jice.getSubmitTime());
                tEvent.addEventInfo("LAUNCH_TIME", (Object)jice.getLaunchTime());
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(jobId.toString());
                tEntity.setEntityType(MAPREDUCE_JOB_ENTITY_TYPE);
                break;
            }
            case 3: {
                JobInitedEvent jie = (JobInitedEvent)event;
                tEvent.addEventInfo("START_TIME", (Object)jie.getLaunchTime());
                tEvent.addEventInfo("STATUS", (Object)jie.getStatus());
                tEvent.addEventInfo("TOTAL_MAPS", (Object)jie.getTotalMaps());
                tEvent.addEventInfo("TOTAL_REDUCES", (Object)jie.getTotalReduces());
                tEvent.addEventInfo("UBERIZED", (Object)jie.getUberized());
                tEntity.setStartTime(Long.valueOf(jie.getLaunchTime()));
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(jobId.toString());
                tEntity.setEntityType(MAPREDUCE_JOB_ENTITY_TYPE);
                break;
            }
            case 11: {
                JobPriorityChangeEvent jpce = (JobPriorityChangeEvent)event;
                tEvent.addEventInfo("PRIORITY", (Object)jpce.getPriority().toString());
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(jobId.toString());
                tEntity.setEntityType(MAPREDUCE_JOB_ENTITY_TYPE);
                break;
            }
            case 12: {
                JobQueueChangeEvent jqe = (JobQueueChangeEvent)event;
                tEvent.addEventInfo("QUEUE_NAMES", (Object)jqe.getJobQueueName());
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(jobId.toString());
                tEntity.setEntityType(MAPREDUCE_JOB_ENTITY_TYPE);
                break;
            }
            case 7: 
            case 8: 
            case 13: {
                JobUnsuccessfulCompletionEvent juce = (JobUnsuccessfulCompletionEvent)event;
                tEvent.addEventInfo("FINISH_TIME", (Object)juce.getFinishTime());
                tEvent.addEventInfo("NUM_MAPS", (Object)juce.getFinishedMaps());
                tEvent.addEventInfo("NUM_REDUCES", (Object)juce.getFinishedReduces());
                tEvent.addEventInfo("JOB_STATUS", (Object)juce.getStatus());
                tEvent.addEventInfo("DIAGNOSTICS", (Object)juce.getDiagnostics());
                tEvent.addEventInfo("FINISHED_MAPS", (Object)juce.getFinishedMaps());
                tEvent.addEventInfo("FINISHED_REDUCES", (Object)juce.getFinishedReduces());
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(jobId.toString());
                tEntity.setEntityType(MAPREDUCE_JOB_ENTITY_TYPE);
                break;
            }
            case 6: {
                JobFinishedEvent jfe = (JobFinishedEvent)event;
                tEvent.addEventInfo("FINISH_TIME", (Object)jfe.getFinishTime());
                tEvent.addEventInfo("NUM_MAPS", (Object)jfe.getFinishedMaps());
                tEvent.addEventInfo("NUM_REDUCES", (Object)jfe.getFinishedReduces());
                tEvent.addEventInfo("FAILED_MAPS", (Object)jfe.getFailedMaps());
                tEvent.addEventInfo("FAILED_REDUCES", (Object)jfe.getFailedReduces());
                tEvent.addEventInfo("FINISHED_MAPS", (Object)jfe.getFinishedMaps());
                tEvent.addEventInfo("FINISHED_REDUCES", (Object)jfe.getFinishedReduces());
                tEvent.addEventInfo("MAP_COUNTERS_GROUPS", (Object)JobHistoryEventUtils.countersToJSON((Counters)jfe.getMapCounters()));
                tEvent.addEventInfo("REDUCE_COUNTERS_GROUPS", (Object)JobHistoryEventUtils.countersToJSON((Counters)jfe.getReduceCounters()));
                tEvent.addEventInfo("TOTAL_COUNTERS_GROUPS", (Object)JobHistoryEventUtils.countersToJSON((Counters)jfe.getTotalCounters()));
                tEvent.addEventInfo("JOB_STATUS", (Object)JobState.SUCCEEDED.toString());
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(jobId.toString());
                tEntity.setEntityType(MAPREDUCE_JOB_ENTITY_TYPE);
                break;
            }
            case 14: {
                TaskStartedEvent tse = (TaskStartedEvent)event;
                tEvent.addEventInfo("TASK_TYPE", (Object)tse.getTaskType().toString());
                tEvent.addEventInfo("START_TIME", (Object)tse.getStartTime());
                tEvent.addEventInfo("SPLIT_LOCATIONS", (Object)tse.getSplitLocations());
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(tse.getTaskId().toString());
                tEntity.setEntityType(MAPREDUCE_TASK_ENTITY_TYPE);
                tEntity.addRelatedEntity(MAPREDUCE_JOB_ENTITY_TYPE, jobId.toString());
                break;
            }
            case 15: {
                TaskFailedEvent tfe = (TaskFailedEvent)event;
                tEvent.addEventInfo("TASK_TYPE", (Object)tfe.getTaskType().toString());
                tEvent.addEventInfo("STATUS", (Object)TaskStatus.State.FAILED.toString());
                tEvent.addEventInfo("FINISH_TIME", (Object)tfe.getFinishTime());
                tEvent.addEventInfo("ERROR", (Object)tfe.getError());
                tEvent.addEventInfo("FAILED_ATTEMPT_ID", (Object)(tfe.getFailedAttemptID() == null ? "" : tfe.getFailedAttemptID().toString()));
                tEvent.addEventInfo("COUNTERS_GROUPS", (Object)JobHistoryEventUtils.countersToJSON((Counters)tfe.getCounters()));
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(tfe.getTaskId().toString());
                tEntity.setEntityType(MAPREDUCE_TASK_ENTITY_TYPE);
                tEntity.addRelatedEntity(MAPREDUCE_JOB_ENTITY_TYPE, jobId.toString());
                break;
            }
            case 16: {
                TaskUpdatedEvent tue = (TaskUpdatedEvent)event;
                tEvent.addEventInfo("FINISH_TIME", (Object)tue.getFinishTime());
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(tue.getTaskId().toString());
                tEntity.setEntityType(MAPREDUCE_TASK_ENTITY_TYPE);
                tEntity.addRelatedEntity(MAPREDUCE_JOB_ENTITY_TYPE, jobId.toString());
                break;
            }
            case 17: {
                TaskFinishedEvent tfe2 = (TaskFinishedEvent)event;
                tEvent.addEventInfo("TASK_TYPE", (Object)tfe2.getTaskType().toString());
                tEvent.addEventInfo("COUNTERS_GROUPS", (Object)JobHistoryEventUtils.countersToJSON((Counters)tfe2.getCounters()));
                tEvent.addEventInfo("FINISH_TIME", (Object)tfe2.getFinishTime());
                tEvent.addEventInfo("STATUS", (Object)TaskStatus.State.SUCCEEDED.toString());
                tEvent.addEventInfo("SUCCESSFUL_TASK_ATTEMPT_ID", (Object)(tfe2.getSuccessfulTaskAttemptId() == null ? "" : tfe2.getSuccessfulTaskAttemptId().toString()));
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(tfe2.getTaskId().toString());
                tEntity.setEntityType(MAPREDUCE_TASK_ENTITY_TYPE);
                tEntity.addRelatedEntity(MAPREDUCE_JOB_ENTITY_TYPE, jobId.toString());
                break;
            }
            case 4: 
            case 5: 
            case 18: 
            case 19: {
                TaskAttemptStartedEvent tase = (TaskAttemptStartedEvent)event;
                tEvent.addEventInfo("TASK_TYPE", (Object)tase.getTaskType().toString());
                tEvent.addEventInfo("TASK_ATTEMPT_ID", (Object)tase.getTaskAttemptId().toString());
                tEvent.addEventInfo("START_TIME", (Object)tase.getStartTime());
                tEvent.addEventInfo("HTTP_PORT", (Object)tase.getHttpPort());
                tEvent.addEventInfo("TRACKER_NAME", (Object)tase.getTrackerName());
                tEvent.addEventInfo("SHUFFLE_PORT", (Object)tase.getShufflePort());
                tEvent.addEventInfo("CONTAINER_ID", (Object)(tase.getContainerId() == null ? "" : tase.getContainerId().toString()));
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(tase.getTaskId().toString());
                tEntity.setEntityType(MAPREDUCE_TASK_ENTITY_TYPE);
                tEntity.addRelatedEntity(MAPREDUCE_JOB_ENTITY_TYPE, jobId.toString());
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                TaskAttemptUnsuccessfulCompletionEvent tauce = (TaskAttemptUnsuccessfulCompletionEvent)event;
                tEvent.addEventInfo("TASK_TYPE", (Object)tauce.getTaskType().toString());
                tEvent.addEventInfo("TASK_ATTEMPT_ID", (Object)(tauce.getTaskAttemptId() == null ? "" : tauce.getTaskAttemptId().toString()));
                tEvent.addEventInfo("FINISH_TIME", (Object)tauce.getFinishTime());
                tEvent.addEventInfo("ERROR", (Object)tauce.getError());
                tEvent.addEventInfo("STATUS", (Object)tauce.getTaskStatus());
                tEvent.addEventInfo("HOSTNAME", (Object)tauce.getHostname());
                tEvent.addEventInfo("PORT", (Object)tauce.getPort());
                tEvent.addEventInfo("RACK_NAME", (Object)tauce.getRackName());
                tEvent.addEventInfo("SHUFFLE_FINISH_TIME", (Object)tauce.getFinishTime());
                tEvent.addEventInfo("SORT_FINISH_TIME", (Object)tauce.getFinishTime());
                tEvent.addEventInfo("MAP_FINISH_TIME", (Object)tauce.getFinishTime());
                tEvent.addEventInfo("COUNTERS_GROUPS", (Object)JobHistoryEventUtils.countersToJSON((Counters)tauce.getCounters()));
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(tauce.getTaskId().toString());
                tEntity.setEntityType(MAPREDUCE_TASK_ENTITY_TYPE);
                tEntity.addRelatedEntity(MAPREDUCE_JOB_ENTITY_TYPE, jobId.toString());
                break;
            }
            case 28: {
                MapAttemptFinishedEvent mafe = (MapAttemptFinishedEvent)event;
                tEvent.addEventInfo("TASK_TYPE", (Object)mafe.getTaskType().toString());
                tEvent.addEventInfo("FINISH_TIME", (Object)mafe.getFinishTime());
                tEvent.addEventInfo("STATUS", (Object)mafe.getTaskStatus());
                tEvent.addEventInfo("STATE", (Object)mafe.getState());
                tEvent.addEventInfo("MAP_FINISH_TIME", (Object)mafe.getMapFinishTime());
                tEvent.addEventInfo("COUNTERS_GROUPS", (Object)JobHistoryEventUtils.countersToJSON((Counters)mafe.getCounters()));
                tEvent.addEventInfo("HOSTNAME", (Object)mafe.getHostname());
                tEvent.addEventInfo("PORT", (Object)mafe.getPort());
                tEvent.addEventInfo("RACK_NAME", (Object)mafe.getRackName());
                tEvent.addEventInfo("ATTEMPT_ID", (Object)(mafe.getAttemptId() == null ? "" : mafe.getAttemptId().toString()));
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(mafe.getTaskId().toString());
                tEntity.setEntityType(MAPREDUCE_TASK_ENTITY_TYPE);
                tEntity.addRelatedEntity(MAPREDUCE_JOB_ENTITY_TYPE, jobId.toString());
                break;
            }
            case 29: {
                ReduceAttemptFinishedEvent rafe = (ReduceAttemptFinishedEvent)event;
                tEvent.addEventInfo("TASK_TYPE", (Object)rafe.getTaskType().toString());
                tEvent.addEventInfo("ATTEMPT_ID", (Object)(rafe.getAttemptId() == null ? "" : rafe.getAttemptId().toString()));
                tEvent.addEventInfo("FINISH_TIME", (Object)rafe.getFinishTime());
                tEvent.addEventInfo("STATUS", (Object)rafe.getTaskStatus());
                tEvent.addEventInfo("STATE", (Object)rafe.getState());
                tEvent.addEventInfo("SHUFFLE_FINISH_TIME", (Object)rafe.getShuffleFinishTime());
                tEvent.addEventInfo("SORT_FINISH_TIME", (Object)rafe.getSortFinishTime());
                tEvent.addEventInfo("COUNTERS_GROUPS", (Object)JobHistoryEventUtils.countersToJSON((Counters)rafe.getCounters()));
                tEvent.addEventInfo("HOSTNAME", (Object)rafe.getHostname());
                tEvent.addEventInfo("PORT", (Object)rafe.getPort());
                tEvent.addEventInfo("RACK_NAME", (Object)rafe.getRackName());
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(rafe.getTaskId().toString());
                tEntity.setEntityType(MAPREDUCE_TASK_ENTITY_TYPE);
                tEntity.addRelatedEntity(MAPREDUCE_JOB_ENTITY_TYPE, jobId.toString());
                break;
            }
            case 30: 
            case 31: {
                TaskAttemptFinishedEvent tafe = (TaskAttemptFinishedEvent)event;
                tEvent.addEventInfo("TASK_TYPE", (Object)tafe.getTaskType().toString());
                tEvent.addEventInfo("ATTEMPT_ID", (Object)(tafe.getAttemptId() == null ? "" : tafe.getAttemptId().toString()));
                tEvent.addEventInfo("FINISH_TIME", (Object)tafe.getFinishTime());
                tEvent.addEventInfo("STATUS", (Object)tafe.getTaskStatus());
                tEvent.addEventInfo("STATE", (Object)tafe.getState());
                tEvent.addEventInfo("COUNTERS_GROUPS", (Object)JobHistoryEventUtils.countersToJSON((Counters)tafe.getCounters()));
                tEvent.addEventInfo("HOSTNAME", (Object)tafe.getHostname());
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(tafe.getTaskId().toString());
                tEntity.setEntityType(MAPREDUCE_TASK_ENTITY_TYPE);
                tEntity.addRelatedEntity(MAPREDUCE_JOB_ENTITY_TYPE, jobId.toString());
                break;
            }
            case 32: {
                AMStartedEvent ase = (AMStartedEvent)event;
                tEvent.addEventInfo("APPLICATION_ATTEMPT_ID", (Object)(ase.getAppAttemptId() == null ? "" : ase.getAppAttemptId().toString()));
                tEvent.addEventInfo("CONTAINER_ID", (Object)(ase.getContainerId() == null ? "" : ase.getContainerId().toString()));
                tEvent.addEventInfo("NODE_MANAGER_HOST", (Object)ase.getNodeManagerHost());
                tEvent.addEventInfo("NODE_MANAGER_PORT", (Object)ase.getNodeManagerPort());
                tEvent.addEventInfo("NODE_MANAGER_HTTP_PORT", (Object)ase.getNodeManagerHttpPort());
                tEvent.addEventInfo("START_TIME", (Object)ase.getStartTime());
                tEvent.addEventInfo("SUBMIT_TIME", (Object)ase.getSubmitTime());
                tEntity.addEvent(tEvent);
                tEntity.setEntityId(jobId.toString());
                tEntity.setEntityType(MAPREDUCE_JOB_ENTITY_TYPE);
                break;
            }
        }
        try {
            TimelinePutResponse response = this.timelineClient.putEntities(new TimelineEntity[]{tEntity});
            List errors = response.getErrors();
            if (errors.size() == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Timeline entities are successfully put in event " + event.getEventType()));
                }
            } else {
                for (TimelinePutResponse.TimelinePutError error : errors) {
                    LOG.error((Object)("Error when publishing entity [" + error.getEntityType() + "," + error.getEntityId() + "], server side error code: " + error.getErrorCode()));
                }
            }
        }
        catch (ClientHandlerException | IOException | YarnException ex) {
            LOG.error((Object)("Error putting entity " + tEntity.getEntityId() + " to Timeline" + "Server"), ex);
        }
    }

    private org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity createJobEntity(HistoryEvent event, long timestamp, JobId jobId, String entityType, boolean setCreatedTime) {
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity entity = this.createBaseEntity(event, timestamp, entityType, setCreatedTime);
        entity.setId(jobId.toString());
        return entity;
    }

    private org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity createJobEntity(JobId jobId) {
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity entity = new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity();
        entity.setId(jobId.toString());
        entity.setType(MAPREDUCE_JOB_ENTITY_TYPE);
        return entity;
    }

    private org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity createAppEntityWithJobMetrics(HistoryEvent event, JobId jobId) {
        ApplicationEntity entity = new ApplicationEntity();
        entity.setId(jobId.getAppId().toString());
        entity.setMetrics(event.getTimelineMetrics());
        return entity;
    }

    private org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity createBaseEntity(HistoryEvent event, long timestamp, String entityType, boolean setCreatedTime) {
        Set timelineMetrics;
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent tEvent = event.toTimelineEvent();
        tEvent.setTimestamp(timestamp);
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity entity = new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity();
        entity.addEvent(tEvent);
        entity.setType(entityType);
        if (setCreatedTime) {
            entity.setCreatedTime(Long.valueOf(timestamp));
        }
        if ((timelineMetrics = event.getTimelineMetrics()) != null) {
            entity.setMetrics(timelineMetrics);
        }
        return entity;
    }

    private org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity createTaskEntity(HistoryEvent event, long timestamp, String taskId, String entityType, String relatedJobEntity, JobId jobId, boolean setCreatedTime, long taskIdPrefix) {
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity entity = this.createBaseEntity(event, timestamp, entityType, setCreatedTime);
        entity.setId(taskId);
        if (event.getEventType() == EventType.TASK_STARTED) {
            entity.addInfo("TASK_TYPE", (Object)((TaskStartedEvent)event).getTaskType().toString());
        }
        entity.addIsRelatedToEntity(relatedJobEntity, jobId.toString());
        entity.setIdPrefix(taskIdPrefix);
        return entity;
    }

    private org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity createTaskAttemptEntity(HistoryEvent event, long timestamp, String taskAttemptId, String entityType, String relatedTaskEntity, String taskId, boolean setCreatedTime, long taskAttemptIdPrefix) {
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity entity = this.createBaseEntity(event, timestamp, entityType, setCreatedTime);
        entity.setId(taskAttemptId);
        entity.addIsRelatedToEntity(relatedTaskEntity, taskId);
        entity.setIdPrefix(taskAttemptIdPrefix);
        return entity;
    }

    private void publishConfigsOnJobSubmittedEvent(JobSubmittedEvent event, JobId jobId) {
        if (event.getJobConf() == null) {
            return;
        }
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity jobEntityForConfigs = this.createJobEntity(jobId);
        ApplicationEntity appEntityForConfigs = new ApplicationEntity();
        String appId = jobId.getAppId().toString();
        appEntityForConfigs.setId(appId);
        try {
            int configSize = 0;
            for (Map.Entry entry : event.getJobConf()) {
                int size = ((String)entry.getKey()).length() + ((String)entry.getValue()).length();
                if ((configSize += size) > 10240) {
                    if (jobEntityForConfigs.getConfigs().size() > 0) {
                        this.timelineV2Client.putEntities(new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity[]{jobEntityForConfigs});
                        this.timelineV2Client.putEntities(new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity[]{appEntityForConfigs});
                        jobEntityForConfigs = this.createJobEntity(jobId);
                        appEntityForConfigs = new ApplicationEntity();
                        appEntityForConfigs.setId(appId);
                    }
                    configSize = size;
                }
                jobEntityForConfigs.addConfig((String)entry.getKey(), (String)entry.getValue());
                appEntityForConfigs.addConfig((String)entry.getKey(), (String)entry.getValue());
            }
            if (configSize > 0) {
                this.timelineV2Client.putEntities(new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity[]{jobEntityForConfigs});
                this.timelineV2Client.putEntities(new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity[]{appEntityForConfigs});
            }
        }
        catch (IOException | YarnException e) {
            LOG.error((Object)("Exception while publishing configs on JOB_SUBMITTED Event  for the job : " + jobId), e);
        }
    }

    private void processEventForNewTimelineService(HistoryEvent event, JobId jobId, long timestamp) {
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity tEntity = null;
        String taskId = null;
        String taskAttemptId = null;
        boolean setCreatedTime = false;
        long taskIdPrefix = 0L;
        long taskAttemptIdPrefix = 0L;
        switch (2.$SwitchMap$org$apache$hadoop$mapreduce$jobhistory$EventType[event.getEventType().ordinal()]) {
            case 1: {
                setCreatedTime = true;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 32: {
                break;
            }
            case 14: {
                setCreatedTime = true;
                taskId = ((TaskStartedEvent)event).getTaskId().toString();
                taskIdPrefix = TimelineServiceHelper.invertLong((long)((TaskStartedEvent)event).getStartTime());
                break;
            }
            case 15: {
                taskId = ((TaskFailedEvent)event).getTaskId().toString();
                taskIdPrefix = TimelineServiceHelper.invertLong((long)((TaskFailedEvent)event).getStartTime());
                break;
            }
            case 16: {
                taskId = ((TaskUpdatedEvent)event).getTaskId().toString();
                break;
            }
            case 17: {
                taskId = ((TaskFinishedEvent)event).getTaskId().toString();
                taskIdPrefix = TimelineServiceHelper.invertLong((long)((TaskFinishedEvent)event).getStartTime());
                break;
            }
            case 4: 
            case 5: {
                setCreatedTime = true;
                taskId = ((TaskAttemptStartedEvent)event).getTaskId().toString();
                taskAttemptId = ((TaskAttemptStartedEvent)event).getTaskAttemptId().toString();
                taskAttemptIdPrefix = TimelineServiceHelper.invertLong((long)((TaskAttemptStartedEvent)event).getStartTime());
                break;
            }
            case 18: 
            case 19: {
                taskId = ((TaskAttemptStartedEvent)event).getTaskId().toString();
                taskAttemptId = ((TaskAttemptStartedEvent)event).getTaskAttemptId().toString();
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                taskId = ((TaskAttemptUnsuccessfulCompletionEvent)event).getTaskId().toString();
                taskAttemptId = ((TaskAttemptUnsuccessfulCompletionEvent)event).getTaskAttemptId().toString();
                taskAttemptIdPrefix = TimelineServiceHelper.invertLong((long)((TaskAttemptUnsuccessfulCompletionEvent)event).getStartTime());
                break;
            }
            case 28: {
                taskId = ((MapAttemptFinishedEvent)event).getTaskId().toString();
                taskAttemptId = ((MapAttemptFinishedEvent)event).getAttemptId().toString();
                taskAttemptIdPrefix = TimelineServiceHelper.invertLong((long)((MapAttemptFinishedEvent)event).getStartTime());
                break;
            }
            case 29: {
                taskId = ((ReduceAttemptFinishedEvent)event).getTaskId().toString();
                taskAttemptId = ((ReduceAttemptFinishedEvent)event).getAttemptId().toString();
                taskAttemptIdPrefix = TimelineServiceHelper.invertLong((long)((ReduceAttemptFinishedEvent)event).getStartTime());
                break;
            }
            case 30: 
            case 31: {
                taskId = ((TaskAttemptFinishedEvent)event).getTaskId().toString();
                taskAttemptId = ((TaskAttemptFinishedEvent)event).getAttemptId().toString();
                break;
            }
            default: {
                LOG.warn((Object)("EventType: " + event.getEventType() + " cannot be recognized" + " and handled by timeline service."));
                return;
            }
        }
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity appEntityWithJobMetrics = null;
        if (taskId == null) {
            tEntity = this.createJobEntity(event, timestamp, jobId, MAPREDUCE_JOB_ENTITY_TYPE, setCreatedTime);
            if (event.getEventType() == EventType.JOB_FINISHED && event.getTimelineMetrics() != null) {
                appEntityWithJobMetrics = this.createAppEntityWithJobMetrics(event, jobId);
            }
        } else {
            tEntity = taskAttemptId == null ? this.createTaskEntity(event, timestamp, taskId, MAPREDUCE_TASK_ENTITY_TYPE, MAPREDUCE_JOB_ENTITY_TYPE, jobId, setCreatedTime, taskIdPrefix) : this.createTaskAttemptEntity(event, timestamp, taskAttemptId, "MAPREDUCE_TASK_ATTEMPT", MAPREDUCE_TASK_ENTITY_TYPE, taskId, setCreatedTime, taskAttemptIdPrefix);
        }
        try {
            if (appEntityWithJobMetrics == null) {
                this.timelineV2Client.putEntitiesAsync(new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity[]{tEntity});
            } else {
                this.timelineV2Client.putEntities(new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity[]{tEntity, appEntityWithJobMetrics});
            }
        }
        catch (IOException | YarnException e) {
            LOG.error((Object)("Failed to process Event " + event.getEventType() + " for the job : " + jobId), e);
            return;
        }
        if (event.getEventType() == EventType.JOB_SUBMITTED) {
            this.publishConfigsOnJobSubmittedEvent((JobSubmittedEvent)event, jobId);
        }
    }

    private void setSummarySlotSeconds(JobSummary summary, Counters allCounters) {
        Counter slotMillisReduceCounter;
        Counter slotMillisMapCounter = allCounters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS);
        if (slotMillisMapCounter != null) {
            summary.setMapSlotSeconds(slotMillisMapCounter.getValue() / 1000L);
        }
        if ((slotMillisReduceCounter = allCounters.findCounter((Enum)JobCounter.SLOTS_MILLIS_REDUCES)) != null) {
            summary.setReduceSlotSeconds(slotMillisReduceCounter.getValue() / 1000L);
        }
    }

    protected void closeEventWriter(JobId jobId) throws IOException {
        MetaInfo mi = (MetaInfo)fileMap.get(jobId);
        if (mi == null) {
            throw new IOException("No MetaInfo found for JobId: [" + jobId + "]");
        }
        if (!mi.isWriterActive()) {
            throw new IOException("Inactive Writer: Likely received multiple JobFinished / JobUnsuccessful events for JobId: [" + jobId + "]");
        }
        try {
            mi.closeWriter();
        }
        catch (IOException e) {
            LOG.error((Object)("Error closing writer for JobID: " + jobId));
            throw e;
        }
    }

    protected void processDoneFiles(JobId jobId) throws IOException {
        MetaInfo mi = (MetaInfo)fileMap.get(jobId);
        if (mi == null) {
            throw new IOException("No MetaInfo found for JobId: [" + jobId + "]");
        }
        if (mi.getHistoryFile() == null) {
            LOG.warn((Object)("No file for job-history with " + jobId + " found in cache!"));
        }
        if (mi.getConfFile() == null) {
            LOG.warn((Object)("No file for jobconf with " + jobId + " found in cache!"));
        }
        Path qualifiedSummaryDoneFile = null;
        FSDataOutputStream summaryFileOut = null;
        try {
            String doneSummaryFileName = this.getTempFileName(JobHistoryUtils.getIntermediateSummaryFileName((JobId)jobId));
            qualifiedSummaryDoneFile = this.doneDirFS.makeQualified(new Path(this.doneDirPrefixPath, doneSummaryFileName));
            summaryFileOut = this.doneDirFS.create(qualifiedSummaryDoneFile, true);
            summaryFileOut.writeUTF(mi.getJobSummary().getJobSummaryString());
            summaryFileOut.close();
            this.doneDirFS.setPermission(qualifiedSummaryDoneFile, new FsPermission(JobHistoryUtils.HISTORY_INTERMEDIATE_FILE_PERMISSIONS));
        }
        catch (IOException e) {
            LOG.info((Object)("Unable to write out JobSummaryInfo to [" + qualifiedSummaryDoneFile + "]"), (Throwable)e);
            throw e;
        }
        try {
            Path qualifiedDoneFile = null;
            if (mi.getHistoryFile() != null) {
                Path historyFile = mi.getHistoryFile();
                Path qualifiedLogFile = this.stagingDirFS.makeQualified(historyFile);
                int jobNameLimit = this.getConfig().getInt("mapreduce.jobhistory.jobname.limit", 50);
                String doneJobHistoryFileName = this.getTempFileName(FileNameIndexUtils.getDoneFileName((JobIndexInfo)mi.getJobIndexInfo(), (int)jobNameLimit));
                qualifiedDoneFile = this.doneDirFS.makeQualified(new Path(this.doneDirPrefixPath, doneJobHistoryFileName));
                if (this.moveToDoneNow(qualifiedLogFile, qualifiedDoneFile)) {
                    String historyUrl = MRWebAppUtil.getApplicationWebURLOnJHSWithScheme((Configuration)this.getConfig(), (ApplicationId)this.context.getApplicationID());
                    this.context.setHistoryUrl(historyUrl);
                    LOG.info((Object)("Set historyUrl to " + historyUrl));
                }
            }
            Path qualifiedConfDoneFile = null;
            if (mi.getConfFile() != null) {
                Path confFile = mi.getConfFile();
                Path qualifiedConfFile = this.stagingDirFS.makeQualified(confFile);
                String doneConfFileName = this.getTempFileName(JobHistoryUtils.getIntermediateConfFileName((JobId)jobId));
                qualifiedConfDoneFile = this.doneDirFS.makeQualified(new Path(this.doneDirPrefixPath, doneConfFileName));
                this.moveToDoneNow(qualifiedConfFile, qualifiedConfDoneFile);
            }
            this.moveTmpToDone(qualifiedSummaryDoneFile);
            this.moveTmpToDone(qualifiedConfDoneFile);
            this.moveTmpToDone(qualifiedDoneFile);
        }
        catch (IOException e) {
            LOG.error((Object)("Error closing writer for JobID: " + jobId));
            throw e;
        }
    }

    protected void moveTmpToDone(Path tmpPath) throws IOException {
        if (tmpPath != null) {
            String tmpFileName = tmpPath.getName();
            String fileName = this.getFileNameFromTmpFN(tmpFileName);
            Path path = new Path(tmpPath.getParent(), fileName);
            this.doneDirFS.rename(tmpPath, path);
            LOG.info((Object)("Moved tmp to done: " + tmpPath + " to " + path));
        }
    }

    protected boolean moveToDoneNow(Path fromPath, Path toPath) throws IOException {
        boolean success = false;
        if (this.stagingDirFS.exists(fromPath)) {
            LOG.info((Object)("Copying " + fromPath.toString() + " to " + toPath.toString()));
            this.doneDirFS.delete(toPath, true);
            boolean copied = FileUtil.copy((FileSystem)this.stagingDirFS, (Path)fromPath, (FileSystem)this.doneDirFS, (Path)toPath, (boolean)false, (Configuration)this.getConfig());
            this.doneDirFS.setPermission(toPath, new FsPermission(JobHistoryUtils.HISTORY_INTERMEDIATE_FILE_PERMISSIONS));
            if (copied) {
                LOG.info((Object)("Copied from: " + fromPath.toString() + " to done location: " + toPath.toString()));
                success = true;
            } else {
                LOG.info((Object)("Copy failed from: " + fromPath.toString() + " to done location: " + toPath.toString()));
            }
        }
        return success;
    }

    private String getTempFileName(String srcFile) {
        return srcFile + "_tmp";
    }

    private String getFileNameFromTmpFN(String tmpFileName) {
        return tmpFileName.substring(0, tmpFileName.length() - 4);
    }

    public void setForcejobCompletion(boolean forceJobCompletion) {
        this.forceJobCompletion = forceJobCompletion;
        LOG.info((Object)("JobHistoryEventHandler notified that forceJobCompletion is " + forceJobCompletion));
    }

    private String createJobStateForJobUnsuccessfulCompletionEvent(String forcedJobStateOnShutDown) {
        if (forcedJobStateOnShutDown == null || forcedJobStateOnShutDown.isEmpty()) {
            return JobState.KILLED.toString();
        }
        if (forcedJobStateOnShutDown.equals(JobStateInternal.ERROR.toString()) || forcedJobStateOnShutDown.equals(JobStateInternal.FAILED.toString())) {
            return JobState.FAILED.toString();
        }
        if (forcedJobStateOnShutDown.equals(JobStateInternal.SUCCEEDED.toString())) {
            return JobState.SUCCEEDED.toString();
        }
        return JobState.KILLED.toString();
    }

    @VisibleForTesting
    boolean getFlushTimerStatus() {
        return this.isTimerActive;
    }

    static /* synthetic */ boolean access$100(JobHistoryEventHandler x0) {
        return x0.stopped;
    }

    static /* synthetic */ int access$200(JobHistoryEventHandler x0) {
        return x0.eventCounter;
    }

    static /* synthetic */ int access$202(JobHistoryEventHandler x0, int x1) {
        x0.eventCounter = x1;
        return x0.eventCounter;
    }

    static /* synthetic */ Log access$300() {
        return LOG;
    }

    static /* synthetic */ int access$208(JobHistoryEventHandler x0) {
        return x0.eventCounter++;
    }

    static /* synthetic */ Object access$400(JobHistoryEventHandler x0) {
        return x0.lock;
    }

    static /* synthetic */ int access$608(JobHistoryEventHandler x0) {
        return x0.numUnflushedCompletionEvents++;
    }

    static /* synthetic */ boolean access$700(JobHistoryEventHandler x0) {
        return x0.isTimerActive;
    }

    static /* synthetic */ long access$800(JobHistoryEventHandler x0) {
        return x0.flushTimeout;
    }

    static /* synthetic */ boolean access$702(JobHistoryEventHandler x0, boolean x1) {
        x0.isTimerActive = x1;
        return x0.isTimerActive;
    }

    static /* synthetic */ int access$900(JobHistoryEventHandler x0) {
        return x0.minQueueSizeForBatchingFlushes;
    }

    static /* synthetic */ int access$600(JobHistoryEventHandler x0) {
        return x0.numUnflushedCompletionEvents;
    }

    static /* synthetic */ int access$1000(JobHistoryEventHandler x0) {
        return x0.maxUnflushedCompletionEvents;
    }

    static /* synthetic */ boolean access$1100(JobHistoryEventHandler x0, HistoryEvent x1) {
        return x0.isJobCompletionEvent(x1);
    }

    static /* synthetic */ int access$602(JobHistoryEventHandler x0, int x1) {
        x0.numUnflushedCompletionEvents = x1;
        return x0.numUnflushedCompletionEvents;
    }

    static /* synthetic */ void access$1200(JobHistoryEventHandler x0, JobHistoryEvent x1) {
        x0.handleTimelineEvent(x1);
    }
}

