/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.api.records;

import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.TaskAttemptReportPBImpl;
import org.apache.hadoop.mapreduce.v2.app.MockJobs;
import org.apache.hadoop.mapreduce.v2.proto.MRProtos;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskAttemptReport {
    @Test
    public void testSetRawCounters() {
        TaskAttemptReport report = (TaskAttemptReport)Records.newRecord(TaskAttemptReport.class);
        Counters rCounters = MockJobs.newCounters();
        report.setRawCounters(rCounters);
        org.apache.hadoop.mapreduce.v2.api.records.Counters counters = report.getCounters();
        Assert.assertNotEquals(null, (Object)counters);
    }

    @Test
    public void testBuildImplicitRawCounters() {
        TaskAttemptReportPBImpl report = new TaskAttemptReportPBImpl();
        Counters rCounters = MockJobs.newCounters();
        report.setRawCounters(rCounters);
        MRProtos.TaskAttemptReportProto protoVal = report.getProto();
        org.apache.hadoop.mapreduce.v2.api.records.Counters counters = report.getCounters();
        Assert.assertTrue((boolean)protoVal.hasCounters());
    }

    @Test
    public void testCountersOverRawCounters() {
        TaskAttemptReport report = (TaskAttemptReport)Records.newRecord(TaskAttemptReport.class);
        Counters rCounters = MockJobs.newCounters();
        org.apache.hadoop.mapreduce.v2.api.records.Counters altCounters = TypeConverter.toYarn((Counters)rCounters);
        report.setRawCounters(rCounters);
        report.setCounters(altCounters);
        org.apache.hadoop.mapreduce.v2.api.records.Counters counters = report.getCounters();
        Assert.assertNotEquals(null, (Object)counters);
        Assert.assertNotEquals((Object)rCounters, (Object)altCounters);
        Assert.assertEquals((Object)counters, (Object)altCounters);
    }

    @Test
    public void testUninitializedCounters() {
        TaskAttemptReport report = (TaskAttemptReport)Records.newRecord(TaskAttemptReport.class);
        Assert.assertEquals(null, (Object)report.getCounters());
        Assert.assertEquals(null, (Object)report.getRawCounters());
    }

    @Test
    public void testSetRawCountersToNull() {
        TaskAttemptReport report = (TaskAttemptReport)Records.newRecord(TaskAttemptReport.class);
        report.setRawCounters(null);
        Assert.assertEquals(null, (Object)report.getCounters());
        Assert.assertEquals(null, (Object)report.getRawCounters());
    }

    @Test
    public void testSetCountersToNull() {
        TaskAttemptReport report = (TaskAttemptReport)Records.newRecord(TaskAttemptReport.class);
        report.setCounters(null);
        Assert.assertEquals(null, (Object)report.getCounters());
        Assert.assertEquals(null, (Object)report.getRawCounters());
    }

    @Test
    public void testSetNonNullCountersToNull() {
        TaskAttemptReport report = (TaskAttemptReport)Records.newRecord(TaskAttemptReport.class);
        Counters rCounters = MockJobs.newCounters();
        report.setRawCounters(rCounters);
        org.apache.hadoop.mapreduce.v2.api.records.Counters counters = report.getCounters();
        Assert.assertNotEquals(null, (Object)counters);
        report.setCounters(null);
        Assert.assertEquals(null, (Object)report.getCounters());
        Assert.assertEquals(null, (Object)report.getRawCounters());
    }

    @Test
    public void testSetNonNullRawCountersToNull() {
        TaskAttemptReport report = (TaskAttemptReport)Records.newRecord(TaskAttemptReport.class);
        Counters rCounters = MockJobs.newCounters();
        report.setRawCounters(rCounters);
        org.apache.hadoop.mapreduce.v2.api.records.Counters counters = report.getCounters();
        Assert.assertNotEquals(null, (Object)counters);
        report.setRawCounters(null);
        Assert.assertEquals(null, (Object)report.getCounters());
        Assert.assertEquals(null, (Object)report.getRawCounters());
    }
}

