/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapTaskAttemptImpl;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.WrappedJvmID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TestShuffleProvider;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestShuffleProvider {
    @Test
    public void testShuffleProviders() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)1);
        TaskId taskId = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.MAP);
        Path jobFile = (Path)Mockito.mock(Path.class);
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        TaskAttemptListener taListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        Mockito.when((Object)taListener.getAddress()).thenReturn((Object)new InetSocketAddress("localhost", 0));
        JobConf jobConf = new JobConf();
        jobConf.setClass("fs.file.impl", StubbedFS.class, FileSystem.class);
        jobConf.setBoolean("fs.file.impl.disable.cache", true);
        jobConf.set("mapreduce.map.env", "");
        jobConf.set("yarn.nodemanager.aux-services", "test_shuffle1,test_shuffle2");
        String serviceName = "test_shuffle1";
        String serviceStr = String.format("yarn.nodemanager.aux-services.%s.class", serviceName);
        jobConf.set(serviceStr, TestShuffleHandler1.class.getName());
        serviceName = "test_shuffle2";
        serviceStr = String.format("yarn.nodemanager.aux-services.%s.class", serviceName);
        jobConf.set(serviceStr, TestShuffleHandler2.class.getName());
        jobConf.set("mapreduce.job.shuffle.provider.services", "test_shuffle1,test_shuffle2");
        Credentials credentials = new Credentials();
        Token jobToken = new Token("tokenid".getBytes(), "tokenpw".getBytes(), new Text("tokenkind"), new Text("tokenservice"));
        MapTaskAttemptImpl taImpl = new MapTaskAttemptImpl(taskId, 1, eventHandler, jobFile, 1, (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class), jobConf, taListener, jobToken, credentials, (Clock)SystemClock.getInstance(), null);
        jobConf.set("mapreduce.job.application.attempt.id", taImpl.getID().toString());
        ContainerLaunchContext launchCtx = TaskAttemptImpl.createContainerLaunchContext(null, (Configuration)jobConf, (Token)jobToken, (Task)taImpl.createRemoteTask(), (JobID)TypeConverter.fromYarn((JobId)jobId), (WrappedJvmID)((WrappedJvmID)Mockito.mock(WrappedJvmID.class)), (TaskAttemptListener)taListener, (Credentials)credentials);
        Map serviceDataMap = launchCtx.getServiceData();
        Assert.assertNotNull((String)"TestShuffleHandler1 is missing", serviceDataMap.get("test_shuffle1"));
        Assert.assertNotNull((String)"TestShuffleHandler2 is missing", serviceDataMap.get("test_shuffle2"));
        Assert.assertTrue((String)"mismatch number of services in map", (serviceDataMap.size() == 3 ? 1 : 0) != 0);
    }
}

