/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MockAppContext;
import org.apache.hadoop.mapreduce.v2.app.MockJobs;
import org.apache.hadoop.mapreduce.v2.app.client.MRClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebApp;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppController;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppView;
import org.apache.hadoop.mapreduce.v2.app.webapp.CountersPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.JobConfPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.JobPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.SingleCounterPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.TaskPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.TasksPage;
import org.apache.hadoop.mapreduce.v2.app.webapp.TestAMWebApp;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.webproxy.ProxyUriUtils;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestAMWebApp {
    static String webProxyBase = null;

    @Test
    public void testAppControllerIndex() {
        MockAppContext ctx = new MockAppContext(0, 1, 1, 1);
        Injector injector = WebAppTests.createMockInjector(AppContext.class, (Object)ctx, (Module[])new Module[0]);
        AppController controller = (AppController)injector.getInstance(AppController.class);
        controller.index();
        Assert.assertEquals((Object)ctx.getApplicationID().toString(), (Object)controller.get("app.id", ""));
    }

    @Test
    public void testAppView() {
        WebAppTests.testPage(AppView.class, AppContext.class, (Object)new MockAppContext(0, 1, 1, 1), (Module[])new Module[0]);
    }

    @Test
    public void testJobView() {
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map params = TestAMWebApp.getJobParams((AppContext)appContext);
        WebAppTests.testPage(JobPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testTasksView() {
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map params = TestAMWebApp.getTaskParams((AppContext)appContext);
        WebAppTests.testPage(TasksPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testTaskView() {
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map params = TestAMWebApp.getTaskParams((AppContext)appContext);
        App app = new App((AppContext)appContext);
        app.setJob((Job)appContext.getAllJobs().values().iterator().next());
        app.setTask((Task)app.getJob().getTasks().values().iterator().next());
        WebAppTests.testPage(TaskPage.class, App.class, (Object)app, (Map)params, (Module[])new Module[0]);
    }

    public static Map<String, String> getJobParams(AppContext appContext) {
        JobId jobId = (JobId)appContext.getAllJobs().entrySet().iterator().next().getKey();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("job.id", MRApps.toString((JobId)jobId));
        return params;
    }

    public static Map<String, String> getTaskParams(AppContext appContext) {
        JobId jobId = (JobId)appContext.getAllJobs().entrySet().iterator().next().getKey();
        Map.Entry e = appContext.getJob(jobId).getTasks().entrySet().iterator().next();
        ((Task)e.getValue()).getType();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("job.id", MRApps.toString((JobId)jobId));
        params.put("task.id", MRApps.toString((TaskId)((TaskId)e.getKey())));
        params.put("task.type", MRApps.taskSymbol((TaskType)((Task)e.getValue()).getType()));
        return params;
    }

    @Test
    public void testConfView() {
        WebAppTests.testPage(JobConfPage.class, AppContext.class, (Object)new MockAppContext(0, 1, 1, 1), (Module[])new Module[0]);
    }

    @Test
    public void testCountersView() {
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map params = TestAMWebApp.getJobParams((AppContext)appContext);
        WebAppTests.testPage(CountersPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testSingleCounterView() {
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Job job = (Job)appContext.getAllJobs().values().iterator().next();
        Task failedTask = MockJobs.newTask((JobId)job.getID(), (int)2, (int)1, (boolean)true);
        Map tasks = job.getTasks();
        tasks.put(failedTask.getID(), failedTask);
        Map params = TestAMWebApp.getJobParams((AppContext)appContext);
        params.put("counter.group", "org.apache.hadoop.mapreduce.FileSystemCounter");
        params.put("counter.name", "HDFS_WRITE_OPS");
        WebAppTests.testPage(SingleCounterPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testTaskCountersView() {
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map params = TestAMWebApp.getTaskParams((AppContext)appContext);
        WebAppTests.testPage(CountersPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testSingleTaskCounterView() {
        MockAppContext appContext = new MockAppContext(0, 1, 1, 2);
        Map params = TestAMWebApp.getTaskParams((AppContext)appContext);
        params.put("counter.group", "org.apache.hadoop.mapreduce.FileSystemCounter");
        params.put("counter.name", "HDFS_WRITE_OPS");
        TaskId taskID = MRApps.toTaskID((String)((String)params.get("task.id")));
        Job job = appContext.getJob(taskID.getJobId());
        Task task = job.getTask(taskID);
        TaskAttempt attempt = (TaskAttempt)task.getAttempts().values().iterator().next();
        attempt.getReport().setCounters(null);
        WebAppTests.testPage(SingleCounterPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testMRWebAppSSLDisabled() throws Exception {
        1 app = new /* Unavailable Anonymous Inner Class!! */;
        Configuration conf = new Configuration();
        conf.set("yarn.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        Job job = app.submit(conf);
        String hostPort = NetUtils.getHostPortString((InetSocketAddress)((MRClientService)app.getClientService()).getWebApp().getListenerAddress());
        URL httpUrl = new URL("http://" + hostPort);
        HttpURLConnection conn = (HttpURLConnection)httpUrl.openConnection();
        InputStream in = conn.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)1024);
        Assert.assertTrue((boolean)out.toString().contains("MapReduce Application"));
        URL httpsUrl = new URL("https://" + hostPort);
        try {
            HttpURLConnection httpsConn = (HttpURLConnection)httpsUrl.openConnection();
            httpsConn.getInputStream();
            Assert.fail((String)"https:// is not accessible, expected to fail");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof SSLException));
        }
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
    }

    @Test
    public void testMRWebAppRedirection() throws Exception {
        String[] schemePrefix;
        for (String scheme : schemePrefix = new String[]{"http://", "https://"}) {
            2 app = new /* Unavailable Anonymous Inner Class!! */;
            Configuration conf = new Configuration();
            conf.set("yarn.web-proxy.address", "9.9.9.9");
            conf.set("yarn.http.policy", scheme.equals("https://") ? HttpConfig.Policy.HTTPS_ONLY.name() : HttpConfig.Policy.HTTP_ONLY.name());
            webProxyBase = "/proxy/" + app.getAppID();
            conf.set("hadoop.http.filter.initializers", TestAMFilterInitializer.class.getName());
            Job job = app.submit(conf);
            String hostPort = NetUtils.getHostPortString((InetSocketAddress)((MRClientService)app.getClientService()).getWebApp().getListenerAddress());
            URL httpUrl = new URL("http://" + hostPort + "/mapreduce");
            HttpURLConnection conn = (HttpURLConnection)httpUrl.openConnection();
            conn.setInstanceFollowRedirects(false);
            conn.connect();
            String expectedURL = scheme + conf.get("yarn.web-proxy.address") + ProxyUriUtils.getPath((ApplicationId)app.getAppID(), (String)"/mapreduce", (boolean)true);
            Assert.assertEquals((Object)expectedURL, (Object)conn.getHeaderField("Location"));
            Assert.assertEquals((long)302L, (long)conn.getResponseCode());
            app.waitForState(job, JobState.SUCCEEDED);
            app.verifyCompleted();
        }
    }

    public static void main(String[] args) {
        WebApps.$for((String)"yarn", AppContext.class, (Object)new MockAppContext(0, 8, 88, 4)).at(58888).inDevMode().start((WebApp)new AMWebApp()).joinThread();
    }
}

