/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.launcher;

import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.event.AbstractEvent;

public class ContainerLauncherEvent
extends AbstractEvent<ContainerLauncher.EventType> {
    private TaskAttemptId taskAttemptID;
    private ContainerId containerID;
    private String containerMgrAddress;
    private Token containerToken;

    public ContainerLauncherEvent(TaskAttemptId taskAttemptID, ContainerId containerID, String containerMgrAddress, Token containerToken, ContainerLauncher.EventType type) {
        super((Enum)type);
        this.taskAttemptID = taskAttemptID;
        this.containerID = containerID;
        this.containerMgrAddress = containerMgrAddress;
        this.containerToken = containerToken;
    }

    public TaskAttemptId getTaskAttemptID() {
        return this.taskAttemptID;
    }

    public ContainerId getContainerID() {
        return this.containerID;
    }

    public String getContainerMgrAddress() {
        return this.containerMgrAddress;
    }

    public Token getContainerToken() {
        return this.containerToken;
    }

    public String toString() {
        return super.toString() + " for container " + this.containerID + " taskAttempt " + this.taskAttemptID;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.containerID == null ? 0 : this.containerID.hashCode());
        result = 31 * result + (this.containerMgrAddress == null ? 0 : this.containerMgrAddress.hashCode());
        result = 31 * result + (this.containerToken == null ? 0 : this.containerToken.hashCode());
        result = 31 * result + (this.taskAttemptID == null ? 0 : this.taskAttemptID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerLauncherEvent other = (ContainerLauncherEvent)obj;
        if (this.containerID == null ? other.containerID != null : !this.containerID.equals((Object)other.containerID)) {
            return false;
        }
        if (this.containerMgrAddress == null ? other.containerMgrAddress != null : !this.containerMgrAddress.equals(other.containerMgrAddress)) {
            return false;
        }
        if (this.containerToken == null ? other.containerToken != null : !this.containerToken.equals(other.containerToken)) {
            return false;
        }
        return !(this.taskAttemptID == null ? other.taskAttemptID != null : !this.taskAttemptID.equals((Object)other.taskAttemptID));
    }
}

