/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.jobhistory.JobSummary;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestJobSummary {
    private static final Log LOG = LogFactory.getLog(TestJobSummary.class);
    private JobSummary summary = new JobSummary();

    @Before
    public void before() {
        JobId mockJobId = (JobId)Mockito.mock(JobId.class);
        Mockito.when((Object)mockJobId.toString()).thenReturn((Object)"testJobId");
        this.summary.setJobId(mockJobId);
        this.summary.setJobSubmitTime(2L);
        this.summary.setJobLaunchTime(3L);
        this.summary.setFirstMapTaskLaunchTime(4L);
        this.summary.setFirstReduceTaskLaunchTime(5L);
        this.summary.setJobFinishTime(6L);
        this.summary.setNumFinishedMaps(1);
        this.summary.setNumFailedMaps(0);
        this.summary.setNumFinishedReduces(1);
        this.summary.setNumFailedReduces(0);
        this.summary.setUser("testUser");
        this.summary.setQueue("testQueue");
        this.summary.setJobStatus("testJobStatus");
        this.summary.setMapSlotSeconds(7L);
        this.summary.setReduceSlotSeconds(8L);
        this.summary.setJobName("testName");
    }

    @Test
    public void testEscapeJobSummary() {
        this.summary.setJobName("aa\rbb\ncc\r\ndd");
        String out = this.summary.getJobSummaryString();
        LOG.info((Object)("summary: " + out));
        Assert.assertFalse((boolean)out.contains("\r"));
        Assert.assertFalse((boolean)out.contains("\n"));
        Assert.assertTrue((boolean)out.contains("aa\\rbb\\ncc\\r\\ndd"));
    }
}

