/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.ClusterInfo;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEvent;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEventHandler;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttemptStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.TaskStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobFinishEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskImpl;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class MRApp
extends MRAppMaster {
    private static final Log LOG = LogFactory.getLog(MRApp.class);
    int maps;
    int reduces;
    private File testWorkDir;
    private Path testAbsPath;
    private ClusterInfo clusterInfo;
    private String assignedQueue;
    public static String NM_HOST = "localhost";
    public static int NM_PORT = 1234;
    public static int NM_HTTP_PORT = 8042;
    protected boolean autoComplete = false;
    static ApplicationId applicationId = ApplicationId.newInstance((long)0L, (int)0);

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, Clock clock) {
        this(maps, reduces, autoComplete, testName, cleanOnStart, 1, clock, null);
    }

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, Clock clock, boolean unregistered) {
        this(maps, reduces, autoComplete, testName, cleanOnStart, 1, clock, unregistered);
    }

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart) {
        this(maps, reduces, autoComplete, testName, cleanOnStart, 1);
    }

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, String assignedQueue) {
        this(maps, reduces, autoComplete, testName, cleanOnStart, 1, (Clock)new SystemClock(), assignedQueue);
    }

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, boolean unregistered) {
        this(maps, reduces, autoComplete, testName, cleanOnStart, 1, unregistered);
    }

    protected void initJobCredentialsAndUGI(Configuration conf) {
        String shuffleSecret = "fake-shuffle-secret";
        TokenCache.setShuffleSecretKey((byte[])shuffleSecret.getBytes(), (Credentials)this.getCredentials());
    }

    private static ApplicationAttemptId getApplicationAttemptId(ApplicationId applicationId, int startCount) {
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)startCount);
        return applicationAttemptId;
    }

    private static ContainerId getContainerId(ApplicationId applicationId, int startCount) {
        ApplicationAttemptId appAttemptId = MRApp.getApplicationAttemptId((ApplicationId)applicationId, (int)startCount);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)startCount);
        return containerId;
    }

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, int startCount) {
        this(maps, reduces, autoComplete, testName, cleanOnStart, startCount, (Clock)new SystemClock(), null);
    }

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, int startCount, boolean unregistered) {
        this(maps, reduces, autoComplete, testName, cleanOnStart, startCount, (Clock)new SystemClock(), unregistered);
    }

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, int startCount, Clock clock, boolean unregistered) {
        this(MRApp.getApplicationAttemptId((ApplicationId)applicationId, (int)startCount), MRApp.getContainerId((ApplicationId)applicationId, (int)startCount), maps, reduces, autoComplete, testName, cleanOnStart, startCount, clock, unregistered, null);
    }

    public MRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, int startCount, Clock clock, String assignedQueue) {
        this(MRApp.getApplicationAttemptId((ApplicationId)applicationId, (int)startCount), MRApp.getContainerId((ApplicationId)applicationId, (int)startCount), maps, reduces, autoComplete, testName, cleanOnStart, startCount, clock, true, assignedQueue);
    }

    public MRApp(ApplicationAttemptId appAttemptId, ContainerId amContainerId, int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, int startCount, boolean unregistered) {
        this(appAttemptId, amContainerId, maps, reduces, autoComplete, testName, cleanOnStart, startCount, (Clock)new SystemClock(), unregistered, null);
    }

    public MRApp(ApplicationAttemptId appAttemptId, ContainerId amContainerId, int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, int startCount) {
        this(appAttemptId, amContainerId, maps, reduces, autoComplete, testName, cleanOnStart, startCount, (Clock)new SystemClock(), true, null);
    }

    public MRApp(ApplicationAttemptId appAttemptId, ContainerId amContainerId, int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart, int startCount, Clock clock, boolean unregistered, String assignedQueue) {
        super(appAttemptId, amContainerId, NM_HOST, NM_PORT, NM_HTTP_PORT, clock, System.currentTimeMillis());
        this.testWorkDir = new File("target", testName);
        this.testAbsPath = new Path(this.testWorkDir.getAbsolutePath());
        LOG.info((Object)("PathUsed: " + this.testAbsPath));
        if (cleanOnStart) {
            this.testAbsPath = new Path(this.testWorkDir.getAbsolutePath());
            try {
                FileContext.getLocalFSFileContext().delete(this.testAbsPath, true);
            }
            catch (Exception e) {
                LOG.warn((Object)("COULD NOT CLEANUP: " + this.testAbsPath), (Throwable)e);
                throw new YarnRuntimeException("could not cleanup test dir", (Throwable)e);
            }
        }
        this.maps = maps;
        this.reduces = reduces;
        this.autoComplete = autoComplete;
        this.successfullyUnregistered.set(unregistered);
        this.assignedQueue = assignedQueue;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        try {
            String user = UserGroupInformation.getCurrentUser().getShortUserName();
            Path stagingDir = MRApps.getStagingAreaDir((Configuration)conf, (String)user);
            FileSystem fs = this.getFileSystem(conf);
            fs.mkdirs(stagingDir);
        }
        catch (Exception e) {
            throw new YarnRuntimeException("Error creating staging dir", (Throwable)e);
        }
        super.serviceInit(conf);
        if (this.clusterInfo != null) {
            this.getContext().getClusterInfo().setMaxContainerCapability(this.clusterInfo.getMaxContainerCapability());
        } else {
            this.getContext().getClusterInfo().setMaxContainerCapability(Resource.newInstance((int)10240, (int)1));
        }
    }

    public Job submit(Configuration conf) throws Exception {
        return this.submit(conf, false, false);
    }

    public Job submit(Configuration conf, boolean mapSpeculative, boolean reduceSpeculative) throws Exception {
        String user = conf.get("mapreduce.job.user.name", UserGroupInformation.getCurrentUser().getShortUserName());
        conf.set("mapreduce.job.user.name", user);
        conf.set("yarn.app.mapreduce.am.staging-dir", this.testAbsPath.toString());
        conf.setBoolean("yarn.app.mapreduce.am.create-intermediate-jh-base-dir", true);
        conf.setBoolean("mapreduce.map.speculative", mapSpeculative);
        conf.setBoolean("mapreduce.reduce.speculative", reduceSpeculative);
        this.init(conf);
        this.start();
        DefaultMetricsSystem.shutdown();
        Job job = (Job)this.getContext().getAllJobs().values().iterator().next();
        if (this.assignedQueue != null) {
            job.setQueueName(this.assignedQueue);
        }
        String jobFile = MRApps.getJobFile((Configuration)conf, (String)user, (JobID)TypeConverter.fromYarn((JobId)job.getID()));
        LOG.info((Object)("Writing job conf to " + jobFile));
        new File(jobFile).getParentFile().mkdirs();
        conf.writeXml((OutputStream)new FileOutputStream(jobFile));
        return job;
    }

    public void waitForInternalState(JobImpl job, JobStateInternal finalState) throws Exception {
        int timeoutSecs = 0;
        JobStateInternal iState = job.getInternalState();
        while (!finalState.equals((Object)iState) && timeoutSecs++ < 20) {
            System.out.println("Job Internal State is : " + iState + " Waiting for Internal state : " + finalState);
            Thread.sleep(500L);
            iState = job.getInternalState();
        }
        System.out.println("Task Internal State is : " + iState);
        Assert.assertEquals((String)"Task Internal state is not correct (timedout)", (Object)finalState, (Object)iState);
    }

    public void waitForInternalState(TaskImpl task, TaskStateInternal finalState) throws Exception {
        int timeoutSecs = 0;
        TaskReport report = task.getReport();
        TaskStateInternal iState = task.getInternalState();
        while (!finalState.equals((Object)iState) && timeoutSecs++ < 20) {
            System.out.println("Task Internal State is : " + iState + " Waiting for Internal state : " + finalState + "   progress : " + report.getProgress());
            Thread.sleep(500L);
            report = task.getReport();
            iState = task.getInternalState();
        }
        System.out.println("Task Internal State is : " + iState);
        Assert.assertEquals((String)"Task Internal state is not correct (timedout)", (Object)finalState, (Object)iState);
    }

    public void waitForInternalState(TaskAttemptImpl attempt, TaskAttemptStateInternal finalState) throws Exception {
        int timeoutSecs = 0;
        TaskAttemptReport report = attempt.getReport();
        TaskAttemptStateInternal iState = attempt.getInternalState();
        while (!finalState.equals((Object)iState) && timeoutSecs++ < 20) {
            System.out.println("TaskAttempt Internal State is : " + iState + " Waiting for Internal state : " + finalState + "   progress : " + report.getProgress());
            Thread.sleep(500L);
            report = attempt.getReport();
            iState = attempt.getInternalState();
        }
        System.out.println("TaskAttempt Internal State is : " + iState);
        Assert.assertEquals((String)"TaskAttempt Internal state is not correct (timedout)", (Object)finalState, (Object)iState);
    }

    public void waitForState(TaskAttempt attempt, TaskAttemptState finalState) throws Exception {
        int timeoutSecs = 0;
        TaskAttemptReport report = attempt.getReport();
        while (!finalState.equals((Object)report.getTaskAttemptState()) && timeoutSecs++ < 20) {
            System.out.println("TaskAttempt State is : " + report.getTaskAttemptState() + " Waiting for state : " + finalState + "   progress : " + report.getProgress());
            report = attempt.getReport();
            Thread.sleep(500L);
        }
        System.out.println("TaskAttempt State is : " + report.getTaskAttemptState());
        Assert.assertEquals((String)"TaskAttempt state is not correct (timedout)", (Object)finalState, (Object)report.getTaskAttemptState());
    }

    public void waitForState(Task task, TaskState finalState) throws Exception {
        int timeoutSecs = 0;
        TaskReport report = task.getReport();
        while (!finalState.equals((Object)report.getTaskState()) && timeoutSecs++ < 20) {
            System.out.println("Task State for " + task.getID() + " is : " + report.getTaskState() + " Waiting for state : " + finalState + "   progress : " + report.getProgress());
            report = task.getReport();
            Thread.sleep(500L);
        }
        System.out.println("Task State is : " + report.getTaskState());
        Assert.assertEquals((String)"Task state is not correct (timedout)", (Object)finalState, (Object)report.getTaskState());
    }

    public void waitForState(Job job, JobState finalState) throws Exception {
        int timeoutSecs = 0;
        JobReport report = job.getReport();
        while (!finalState.equals((Object)report.getJobState()) && timeoutSecs++ < 20) {
            System.out.println("Job State is : " + report.getJobState() + " Waiting for state : " + finalState + "   map progress : " + report.getMapProgress() + "   reduce progress : " + report.getReduceProgress());
            report = job.getReport();
            Thread.sleep(500L);
        }
        System.out.println("Job State is : " + report.getJobState());
        Assert.assertEquals((String)"Job state is not correct (timedout)", (Object)finalState, (Object)job.getState());
    }

    public void waitForState(Service.STATE finalState) throws Exception {
        if (finalState == Service.STATE.STOPPED) {
            Assert.assertTrue((String)"Timeout while waiting for MRApp to stop", (boolean)this.waitForServiceToStop(20000L));
        } else {
            int timeoutSecs = 0;
            while (!finalState.equals((Object)this.getServiceState()) && timeoutSecs++ < 20) {
                System.out.println("MRApp State is : " + this.getServiceState() + " Waiting for state : " + finalState);
                Thread.sleep(500L);
            }
            System.out.println("MRApp State is : " + this.getServiceState());
            Assert.assertEquals((String)"MRApp state is not correct (timedout)", (Object)finalState, (Object)this.getServiceState());
        }
    }

    public void verifyCompleted() {
        for (Job job : this.getContext().getAllJobs().values()) {
            JobReport jobReport = job.getReport();
            System.out.println("Job start time :" + jobReport.getStartTime());
            System.out.println("Job finish time :" + jobReport.getFinishTime());
            Assert.assertTrue((String)"Job start time is not less than finish time", (jobReport.getStartTime() <= jobReport.getFinishTime() ? 1 : 0) != 0);
            Assert.assertTrue((String)"Job finish time is in future", (jobReport.getFinishTime() <= System.currentTimeMillis() ? 1 : 0) != 0);
            for (Task task : job.getTasks().values()) {
                TaskReport taskReport = task.getReport();
                System.out.println("Task start time : " + taskReport.getStartTime());
                System.out.println("Task finish time : " + taskReport.getFinishTime());
                Assert.assertTrue((String)"Task start time is not less than finish time", (taskReport.getStartTime() <= taskReport.getFinishTime() ? 1 : 0) != 0);
                for (TaskAttempt attempt : task.getAttempts().values()) {
                    TaskAttemptReport attemptReport = attempt.getReport();
                    Assert.assertTrue((String)"Attempt start time is not less than finish time", (attemptReport.getStartTime() <= attemptReport.getFinishTime() ? 1 : 0) != 0);
                }
            }
        }
    }

    protected Job createJob(Configuration conf, JobStateInternal forcedState, String diagnostic) {
        UserGroupInformation currentUser = null;
        try {
            currentUser = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        TestJob newJob = new TestJob(this, this.getJobId(), this.getAttemptID(), conf, this.getDispatcher().getEventHandler(), this.getTaskAttemptListener(), this.getContext().getClock(), this.getCommitter(), this.isNewApiCommitter(), currentUser.getUserName(), this.getContext(), forcedState, diagnostic);
        this.getContext().getAllJobs().put(newJob.getID(), newJob);
        this.getDispatcher().register(JobFinishEvent.Type.class, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        return newJob;
    }

    protected TaskAttemptListener createTaskAttemptListener(AppContext context) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected EventHandler<JobHistoryEvent> createJobHistoryHandler(AppContext context) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected ContainerLauncher createContainerLauncher(AppContext context) {
        return new MockContainerLauncher(this);
    }

    protected void attemptLaunched(TaskAttemptId attemptID) {
        if (this.autoComplete) {
            this.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(attemptID, TaskAttemptEventType.TA_DONE));
        }
    }

    protected ContainerAllocator createContainerAllocator(ClientService clientService, AppContext context) {
        return new MRAppContainerAllocator(this);
    }

    protected EventHandler<CommitterEvent> createCommitterEventHandler(AppContext context, OutputCommitter committer) {
        4 stubbedCommitter = new /* Unavailable Anonymous Inner Class!! */;
        return new CommitterEventHandler(context, (OutputCommitter)stubbedCommitter, this.getRMHeartbeatHandler());
    }

    protected ClientService createClientService(AppContext context) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setClusterInfo(ClusterInfo clusterInfo) {
        if (this.getServiceState() != Service.STATE.NOTINITED && this.getServiceState() != Service.STATE.INITED) {
            throw new IllegalStateException("ClusterInfo can only be set before the App is STARTED");
        }
        this.clusterInfo = clusterInfo;
    }

    public static org.apache.hadoop.yarn.api.records.Token newContainerToken(NodeId nodeId, byte[] password, ContainerTokenIdentifier tokenIdentifier) {
        InetSocketAddress addr = NetUtils.createSocketAddrForHost((String)nodeId.getHost(), (int)nodeId.getPort());
        org.apache.hadoop.yarn.api.records.Token containerToken = org.apache.hadoop.yarn.api.records.Token.newInstance((byte[])tokenIdentifier.getBytes(), (String)ContainerTokenIdentifier.KIND.toString(), (byte[])password, (String)SecurityUtil.buildTokenService((InetSocketAddress)addr).toString());
        return containerToken;
    }

    public static ContainerId newContainerId(int appId, int appAttemptId, long timestamp, int containerId) {
        ApplicationId applicationId = ApplicationId.newInstance((long)timestamp, (int)appId);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)appAttemptId);
        return ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptId, (long)containerId);
    }

    public static ContainerTokenIdentifier newContainerTokenIdentifier(org.apache.hadoop.yarn.api.records.Token containerToken) throws IOException {
        Token token = new Token(containerToken.getIdentifier().array(), containerToken.getPassword().array(), new Text(containerToken.getKind()), new Text(containerToken.getService()));
        return (ContainerTokenIdentifier)token.decodeIdentifier();
    }

    static /* synthetic */ ApplicationAttemptId access$000(ApplicationId x0, int x1) {
        return MRApp.getApplicationAttemptId((ApplicationId)x0, (int)x1);
    }
}

