/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEventHandler;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEvent;
import org.apache.hadoop.mapreduce.v2.app.commit.CommitterEventHandler;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.EventHandler;
import org.junit.Assert;
import org.mockito.Mockito;

class MRAppMasterTest
extends MRAppMaster {
    Path stagingDirPath;
    private Configuration conf;
    private boolean overrideInit;
    private boolean overrideStart;
    ContainerAllocator mockContainerAllocator;
    CommitterEventHandler mockCommitterEventHandler;
    RMHeartbeatHandler mockRMHeartbeatHandler;
    JobHistoryEventHandler spyHistoryService;

    public MRAppMasterTest(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String host, int port, int httpPort, long submitTime) {
        this(applicationAttemptId, containerId, host, port, httpPort, submitTime, true, true);
    }

    public MRAppMasterTest(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String host, int port, int httpPort, long submitTime, boolean overrideInit, boolean overrideStart) {
        super(applicationAttemptId, containerId, host, port, httpPort, submitTime);
        this.overrideInit = overrideInit;
        this.overrideStart = overrideStart;
        this.mockContainerAllocator = (ContainerAllocator)Mockito.mock(ContainerAllocator.class);
        this.mockCommitterEventHandler = (CommitterEventHandler)Mockito.mock(CommitterEventHandler.class);
        this.mockRMHeartbeatHandler = (RMHeartbeatHandler)Mockito.mock(RMHeartbeatHandler.class);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (!this.overrideInit) {
            super.serviceInit(conf);
        }
        this.conf = conf;
    }

    protected ContainerAllocator createContainerAllocator(ClientService clientService, AppContext context) {
        return this.mockContainerAllocator;
    }

    protected EventHandler<CommitterEvent> createCommitterEventHandler(AppContext context, OutputCommitter committer) {
        return this.mockCommitterEventHandler;
    }

    protected RMHeartbeatHandler getRMHeartbeatHandler() {
        return this.mockRMHeartbeatHandler;
    }

    protected void serviceStart() throws Exception {
        if (this.overrideStart) {
            try {
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                String user = ugi.getShortUserName();
                this.stagingDirPath = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        } else {
            super.serviceStart();
        }
    }

    public Credentials getCredentials() {
        return super.getCredentials();
    }

    public UserGroupInformation getUgi() {
        return this.currentUser;
    }

    protected EventHandler<JobHistoryEvent> createJobHistoryHandler(AppContext context) {
        this.spyHistoryService = (JobHistoryEventHandler)Mockito.spy((Object)((JobHistoryEventHandler)super.createJobHistoryHandler(context)));
        this.spyHistoryService.setForcejobCompletion(this.isLastAMRetry);
        return this.spyHistoryService;
    }
}

