/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerRemoteLaunchEvent;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.junit.Assert;
import org.junit.Test;

public class TestMapReduceChildJVM {
    private static final Log LOG = LogFactory.getLog(TestMapReduceChildJVM.class);

    @Test(timeout=30000L)
    public void testCommandLine() throws Exception {
        MyMRApp app = new MyMRApp(1, 0, true, this.getClass().getName(), true);
        Configuration conf = new Configuration();
        conf.setBoolean("mapreduce.app-submission.cross-platform", true);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assert.assertEquals((Object)("[" + MRApps.crossPlatformify((String)"JAVA_HOME") + "/bin/java" + " -Djava.net.preferIPv4Stack=true" + " -Dhadoop.metrics.log.level=WARN" + "  -Xmx200m -Djava.io.tmpdir=" + MRApps.crossPlatformify((String)"PWD") + "/tmp" + " -Dlog4j.configuration=container-log4j.properties" + " -Dyarn.app.container.log.dir=<LOG_DIR>" + " -Dyarn.app.container.log.filesize=0" + " -Dhadoop.root.logger=INFO,CLA" + " org.apache.hadoop.mapred.YarnChild 127.0.0.1" + " 54321" + " attempt_0_0000_m_000000_0" + " 0" + " 1><LOG_DIR>/stdout" + " 2><LOG_DIR>/stderr ]"), (Object)app.myCommandLine);
        Assert.assertTrue((String)"HADOOP_ROOT_LOGGER not set for job", (boolean)app.cmdEnvironment.containsKey("HADOOP_ROOT_LOGGER"));
        Assert.assertEquals((Object)"INFO,console", app.cmdEnvironment.get("HADOOP_ROOT_LOGGER"));
        Assert.assertTrue((String)"HADOOP_CLIENT_OPTS not set for job", (boolean)app.cmdEnvironment.containsKey("HADOOP_CLIENT_OPTS"));
        Assert.assertEquals((Object)"", app.cmdEnvironment.get("HADOOP_CLIENT_OPTS"));
    }

    @Test(timeout=30000L)
    public void testCommandLineWithLog4JConifg() throws Exception {
        MyMRApp app = new MyMRApp(1, 0, true, this.getClass().getName(), true);
        Configuration conf = new Configuration();
        conf.setBoolean("mapreduce.app-submission.cross-platform", true);
        String testLogPropertieFile = "test-log4j.properties";
        String testLogPropertiePath = "../test-log4j.properties";
        conf.set("mapreduce.job.log4j-properties-file", testLogPropertiePath);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assert.assertEquals((Object)("[" + MRApps.crossPlatformify((String)"JAVA_HOME") + "/bin/java" + " -Djava.net.preferIPv4Stack=true" + " -Dhadoop.metrics.log.level=WARN" + "  -Xmx200m -Djava.io.tmpdir=" + MRApps.crossPlatformify((String)"PWD") + "/tmp" + " -Dlog4j.configuration=" + testLogPropertieFile + " -Dyarn.app.container.log.dir=<LOG_DIR>" + " -Dyarn.app.container.log.filesize=0" + " -Dhadoop.root.logger=INFO,CLA" + " org.apache.hadoop.mapred.YarnChild 127.0.0.1" + " 54321" + " attempt_0_0000_m_000000_0" + " 0" + " 1><LOG_DIR>/stdout" + " 2><LOG_DIR>/stderr ]"), (Object)app.myCommandLine);
    }

    @Test
    public void testEnvironmentVariables() throws Exception {
        MyMRApp app = new MyMRApp(1, 0, true, this.getClass().getName(), true);
        Configuration conf = new Configuration();
        conf.set("mapreduce.map.env", "HADOOP_CLIENT_OPTS=test");
        conf.setStrings("mapreduce.map.log.level", new String[]{"WARN"});
        conf.setBoolean("mapreduce.app-submission.cross-platform", false);
        Job job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assert.assertTrue((String)"HADOOP_ROOT_LOGGER not set for job", (boolean)app.cmdEnvironment.containsKey("HADOOP_ROOT_LOGGER"));
        Assert.assertEquals((Object)"WARN,console", app.cmdEnvironment.get("HADOOP_ROOT_LOGGER"));
        Assert.assertTrue((String)"HADOOP_CLIENT_OPTS not set for job", (boolean)app.cmdEnvironment.containsKey("HADOOP_CLIENT_OPTS"));
        Assert.assertEquals((Object)"test", app.cmdEnvironment.get("HADOOP_CLIENT_OPTS"));
        app = new MyMRApp(1, 0, true, this.getClass().getName(), true);
        conf = new Configuration();
        conf.set("mapreduce.map.env", "HADOOP_ROOT_LOGGER=trace");
        job = app.submit(conf);
        app.waitForState(job, JobState.SUCCEEDED);
        app.verifyCompleted();
        Assert.assertTrue((String)"HADOOP_ROOT_LOGGER not set for job", (boolean)app.cmdEnvironment.containsKey("HADOOP_ROOT_LOGGER"));
        Assert.assertEquals((Object)"trace", app.cmdEnvironment.get("HADOOP_ROOT_LOGGER"));
    }

    private static final class MyMRApp
    extends MRApp {
        private String myCommandLine;
        private Map<String, String> cmdEnvironment;

        public MyMRApp(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart) {
            super(maps, reduces, autoComplete, testName, cleanOnStart);
        }

        @Override
        protected ContainerLauncher createContainerLauncher(AppContext context) {
            return new MRApp.MockContainerLauncher(){

                @Override
                public void handle(ContainerLauncherEvent event) {
                    if (event.getType() == ContainerLauncher.EventType.CONTAINER_REMOTE_LAUNCH) {
                        ContainerRemoteLaunchEvent launchEvent = (ContainerRemoteLaunchEvent)event;
                        ContainerLaunchContext launchContext = launchEvent.getContainerLaunchContext();
                        String cmdString = launchContext.getCommands().toString();
                        LOG.info((Object)("launchContext " + cmdString));
                        MyMRApp.this.myCommandLine = cmdString;
                        MyMRApp.this.cmdEnvironment = launchContext.getEnvironment();
                    }
                    super.handle(event);
                }
            };
        }
    }
}

