/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp.dao;

import java.util.ArrayList;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.CounterGroupInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobCounterInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;

@XmlRootElement(name="jobCounters")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JobCounterInfo {
    @XmlTransient
    protected Counters total = null;
    @XmlTransient
    protected Counters map = null;
    @XmlTransient
    protected Counters reduce = null;
    protected String id;
    protected ArrayList<CounterGroupInfo> counterGroup;

    public JobCounterInfo() {
    }

    public JobCounterInfo(AppContext ctx, Job job) {
        this.getCounters(ctx, job);
        this.counterGroup = new ArrayList();
        this.id = MRApps.toString((JobId)job.getID());
        if (this.total != null) {
            for (CounterGroup g : this.total) {
                if (g == null) continue;
                CounterGroup mg = this.map == null ? null : (CounterGroup)this.map.getGroup(g.getName());
                CounterGroup rg = this.reduce == null ? null : (CounterGroup)this.reduce.getGroup(g.getName());
                CounterGroupInfo cginfo = new CounterGroupInfo(g.getName(), g, mg, rg);
                this.counterGroup.add(cginfo);
            }
        }
    }

    private void getCounters(AppContext ctx, Job job) {
        if (job == null) {
            return;
        }
        this.total = job.getAllCounters();
        boolean needTotalCounters = false;
        if (this.total == null) {
            this.total = new Counters();
            needTotalCounters = true;
        }
        this.map = new Counters();
        this.reduce = new Counters();
        Map tasks = job.getTasks();
        for (Task t : tasks.values()) {
            Counters counters = t.getCounters();
            if (counters == null) continue;
            switch (1.$SwitchMap$org$apache$hadoop$mapreduce$v2$api$records$TaskType[t.getType().ordinal()]) {
                case 1: {
                    this.map.incrAllCounters((AbstractCounters)counters);
                    break;
                }
                case 2: {
                    this.reduce.incrAllCounters((AbstractCounters)counters);
                }
            }
            if (!needTotalCounters) continue;
            this.total.incrAllCounters((AbstractCounters)counters);
        }
    }
}

