/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.LocalContainerLauncher;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncher;
import org.apache.hadoop.mapreduce.v2.app.launcher.ContainerLauncherEvent;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

public class LocalContainerLauncher
extends AbstractService
implements ContainerLauncher {
    private static final File curDir = new File(".");
    private static final Log LOG = LogFactory.getLog(LocalContainerLauncher.class);
    private FileContext curFC = null;
    private final HashSet<File> localizedFiles;
    private final AppContext context;
    private final TaskUmbilicalProtocol umbilical;
    private ExecutorService taskRunner;
    private Thread eventHandler;
    private byte[] encryptedSpillKey = new byte[]{0};
    private BlockingQueue<ContainerLauncherEvent> eventQueue = new LinkedBlockingQueue();

    public LocalContainerLauncher(AppContext context, TaskUmbilicalProtocol umbilical) {
        super(LocalContainerLauncher.class.getName());
        this.context = context;
        this.umbilical = umbilical;
        try {
            this.curFC = FileContext.getFileContext((URI)curDir.toURI());
        }
        catch (UnsupportedFileSystemException ufse) {
            LOG.error((Object)("Local filesystem " + curDir.toURI().toString() + " is unsupported?? (should never happen)"));
        }
        File[] curLocalFiles = curDir.listFiles();
        this.localizedFiles = new HashSet(curLocalFiles.length);
        for (int j = 0; j < curLocalFiles.length; ++j) {
            this.localizedFiles.add(curLocalFiles[j]);
        }
    }

    public void serviceStart() throws Exception {
        this.taskRunner = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("uber-SubtaskRunner").build());
        this.eventHandler = new Thread((Runnable)new EventHandler(this), "uber-EventHandler");
        this.eventHandler.start();
        super.serviceStart();
    }

    public void serviceStop() throws Exception {
        if (this.eventHandler != null) {
            this.eventHandler.interrupt();
        }
        if (this.taskRunner != null) {
            this.taskRunner.shutdownNow();
        }
        super.serviceStop();
    }

    public void handle(ContainerLauncherEvent event) {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    public void setEncryptedSpillKey(byte[] encryptedSpillKey) {
        if (encryptedSpillKey != null) {
            this.encryptedSpillKey = encryptedSpillKey;
        }
    }

    @VisibleForTesting
    protected static MapOutputFile renameMapOutputForReduce(JobConf conf, TaskAttemptId mapId, MapOutputFile subMapOutputFile) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path mapOut = subMapOutputFile.getOutputFile();
        FileStatus mStatus = localFs.getFileStatus(mapOut);
        Path reduceIn = subMapOutputFile.getInputFileForWrite((TaskID)TypeConverter.fromYarn((TaskAttemptId)mapId).getTaskID(), mStatus.getLen());
        Path mapOutIndex = subMapOutputFile.getOutputIndexFile();
        Path reduceInIndex = new Path(reduceIn.toString() + ".index");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renaming map output file for task attempt " + mapId.toString() + " from original location " + mapOut.toString() + " to destination " + reduceIn.toString()));
        }
        if (!localFs.mkdirs(reduceIn.getParent())) {
            throw new IOException("Mkdirs failed to create " + reduceIn.getParent().toString());
        }
        if (!localFs.rename(mapOut, reduceIn)) {
            throw new IOException("Couldn't rename " + mapOut);
        }
        if (!localFs.rename(mapOutIndex, reduceInIndex)) {
            throw new IOException("Couldn't rename " + mapOutIndex);
        }
        return new RenamedMapOutputFile(reduceIn);
    }

    static /* synthetic */ BlockingQueue access$000(LocalContainerLauncher x0) {
        return x0.eventQueue;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }

    static /* synthetic */ ExecutorService access$300(LocalContainerLauncher x0) {
        return x0.taskRunner;
    }

    static /* synthetic */ AppContext access$400(LocalContainerLauncher x0) {
        return x0.context;
    }

    static /* synthetic */ byte[] access$500(LocalContainerLauncher x0) {
        return x0.encryptedSpillKey;
    }

    static /* synthetic */ TaskUmbilicalProtocol access$600(LocalContainerLauncher x0) {
        return x0.umbilical;
    }

    static /* synthetic */ File access$700() {
        return curDir;
    }

    static /* synthetic */ HashSet access$800(LocalContainerLauncher x0) {
        return x0.localizedFiles;
    }

    static /* synthetic */ FileContext access$900(LocalContainerLauncher x0) {
        return x0.curFC;
    }
}

