/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.TaskHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestTaskHeartbeatHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeout() throws InterruptedException {
        EventHandler mockHandler = (EventHandler)Mockito.mock(EventHandler.class);
        SystemClock clock = new SystemClock();
        TaskHeartbeatHandler hb = new TaskHeartbeatHandler(mockHandler, (Clock)clock, 1);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.task.timeout", 10);
        conf.setInt("mapreduce.task.timeout.check-interval-ms", 10);
        hb.init(conf);
        hb.start();
        try {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)5);
            JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)4);
            TaskId tid = MRBuilderUtils.newTaskId((JobId)jobId, (int)3, (TaskType)TaskType.MAP);
            TaskAttemptId taid = MRBuilderUtils.newTaskAttemptId((TaskId)tid, (int)2);
            hb.register(taid);
            Thread.sleep(100L);
            ((EventHandler)Mockito.verify((Object)mockHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)Matchers.any(Event.class));
        }
        finally {
            hb.stop();
        }
    }
}

