/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobCounterUpdateEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.preemption.AMPreemptionPolicy;
import org.apache.hadoop.mapreduce.v2.app.rm.preemption.KillAMPreemptionPolicy;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.PreemptionContainer;
import org.apache.hadoop.yarn.api.records.PreemptionContract;
import org.apache.hadoop.yarn.api.records.PreemptionMessage;
import org.apache.hadoop.yarn.api.records.StrictPreemptionContract;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestKillAMPreemptionPolicy {
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @Test
    public void testKillAMPreemptPolicy() {
        ApplicationId appId = ApplicationId.newInstance((long)123456789L, (int)1);
        ContainerId container = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), (long)1L);
        AMPreemptionPolicy.Context mPctxt = (AMPreemptionPolicy.Context)Mockito.mock(AMPreemptionPolicy.Context.class);
        Mockito.when((Object)mPctxt.getTaskAttempt((ContainerId)Matchers.any(ContainerId.class))).thenReturn((Object)MRBuilderUtils.newTaskAttemptId((TaskId)MRBuilderUtils.newTaskId((JobId)MRBuilderUtils.newJobId((ApplicationId)appId, (int)1), (int)1, (TaskType)TaskType.MAP), (int)0));
        ArrayList<Container> p = new ArrayList<Container>();
        p.add(Container.newInstance((ContainerId)container, null, null, null, null, null));
        Mockito.when((Object)mPctxt.getContainers((TaskType)Matchers.any(TaskType.class))).thenReturn(p);
        KillAMPreemptionPolicy policy = new KillAMPreemptionPolicy();
        MRAppMaster.RunningAppContext mActxt = this.getRunningAppContext();
        policy.init((AppContext)mActxt);
        PreemptionMessage pM = this.getPreemptionMessage(false, false, container);
        policy.preempt(mPctxt, pM);
        ((EventHandler)Mockito.verify((Object)mActxt.getEventHandler(), (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.any(TaskAttemptEvent.class));
        ((EventHandler)Mockito.verify((Object)mActxt.getEventHandler(), (VerificationMode)Mockito.times((int)0))).handle((Event)Matchers.any(JobCounterUpdateEvent.class));
        mActxt = this.getRunningAppContext();
        policy.init((AppContext)mActxt);
        pM = this.getPreemptionMessage(true, false, container);
        policy.preempt(mPctxt, pM);
        ((EventHandler)Mockito.verify((Object)mActxt.getEventHandler(), (VerificationMode)Mockito.times((int)2))).handle((Event)Matchers.any(TaskAttemptEvent.class));
        ((EventHandler)Mockito.verify((Object)mActxt.getEventHandler(), (VerificationMode)Mockito.times((int)2))).handle((Event)Matchers.any(JobCounterUpdateEvent.class));
        mActxt = this.getRunningAppContext();
        policy.init((AppContext)mActxt);
        pM = this.getPreemptionMessage(false, true, container);
        policy.preempt(mPctxt, pM);
        ((EventHandler)Mockito.verify((Object)mActxt.getEventHandler(), (VerificationMode)Mockito.times((int)2))).handle((Event)Matchers.any(TaskAttemptEvent.class));
        ((EventHandler)Mockito.verify((Object)mActxt.getEventHandler(), (VerificationMode)Mockito.times((int)2))).handle((Event)Matchers.any(JobCounterUpdateEvent.class));
        mActxt = this.getRunningAppContext();
        policy.init((AppContext)mActxt);
        pM = this.getPreemptionMessage(true, true, container);
        policy.preempt(mPctxt, pM);
        ((EventHandler)Mockito.verify((Object)mActxt.getEventHandler(), (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.any(TaskAttemptEvent.class));
        ((EventHandler)Mockito.verify((Object)mActxt.getEventHandler(), (VerificationMode)Mockito.times((int)4))).handle((Event)Matchers.any(JobCounterUpdateEvent.class));
    }

    private MRAppMaster.RunningAppContext getRunningAppContext() {
        MRAppMaster.RunningAppContext mActxt = (MRAppMaster.RunningAppContext)Mockito.mock(MRAppMaster.RunningAppContext.class);
        EventHandler eventHandler = (EventHandler)Mockito.mock(EventHandler.class);
        Mockito.when((Object)mActxt.getEventHandler()).thenReturn((Object)eventHandler);
        return mActxt;
    }

    private PreemptionMessage getPreemptionMessage(boolean strictContract, boolean contract, ContainerId container) {
        PreemptionMessage preemptionMessage = (PreemptionMessage)this.recordFactory.newRecordInstance(PreemptionMessage.class);
        HashSet<PreemptionContainer> cntrs = new HashSet<PreemptionContainer>();
        PreemptionContainer preemptContainer = (PreemptionContainer)this.recordFactory.newRecordInstance(PreemptionContainer.class);
        preemptContainer.setId(container);
        cntrs.add(preemptContainer);
        if (strictContract) {
            StrictPreemptionContract set = (StrictPreemptionContract)this.recordFactory.newRecordInstance(StrictPreemptionContract.class);
            set.setContainers(cntrs);
            preemptionMessage.setStrictContract(set);
        }
        if (contract) {
            PreemptionContract preemptContract = (PreemptionContract)this.recordFactory.newRecordInstance(PreemptionContract.class);
            preemptContract.setContainers(cntrs);
            preemptionMessage.setContract(preemptContract);
        }
        return preemptionMessage;
    }
}

