/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.TaskHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestTaskHeartbeatHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskTimeout() throws InterruptedException {
        EventHandler mockHandler = (EventHandler)Mockito.mock(EventHandler.class);
        SystemClock clock = SystemClock.getInstance();
        TaskHeartbeatHandler hb = new TaskHeartbeatHandler(mockHandler, (Clock)clock, 1);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.task.timeout", 10);
        conf.setLong("mapreduce.task.progress-report.interval", 5L);
        conf.setInt("mapreduce.task.timeout.check-interval-ms", 10);
        conf.setDouble("mapreduce.task.log.progress.delta.threshold", 0.01);
        hb.init(conf);
        hb.start();
        try {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)5);
            JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)4);
            TaskId tid = MRBuilderUtils.newTaskId((JobId)jobId, (int)3, (TaskType)TaskType.MAP);
            TaskAttemptId taid = MRBuilderUtils.newTaskAttemptId((TaskId)tid, (int)2);
            hb.register(taid);
            hb.progressing(taid);
            Thread.sleep(100L);
            ((EventHandler)Mockito.verify((Object)mockHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)ArgumentMatchers.any(Event.class));
        }
        finally {
            hb.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskTimeoutDisable() throws InterruptedException {
        EventHandler mockHandler = (EventHandler)Mockito.mock(EventHandler.class);
        SystemClock clock = SystemClock.getInstance();
        TaskHeartbeatHandler hb = new TaskHeartbeatHandler(mockHandler, (Clock)clock, 1);
        Configuration conf = new Configuration();
        conf.setLong("mapreduce.task.stuck.timeout-ms", 0L);
        conf.setInt("mapreduce.task.timeout", 0);
        conf.setLong("mapreduce.task.progress-report.interval", 0L);
        conf.setInt("mapreduce.task.timeout.check-interval-ms", 10);
        hb.init(conf);
        hb.start();
        try {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)5);
            JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)4);
            TaskId tid = MRBuilderUtils.newTaskId((JobId)jobId, (int)3, (TaskType)TaskType.MAP);
            TaskAttemptId taid = MRBuilderUtils.newTaskAttemptId((TaskId)tid, (int)2);
            hb.register(taid);
            ConcurrentMap runningAttempts = hb.getRunningAttempts();
            for (Map.Entry entry : runningAttempts.entrySet()) {
                Assert.assertFalse((boolean)((TaskHeartbeatHandler.ReportTime)entry.getValue()).isReported());
            }
            Thread.sleep(100L);
            ((EventHandler)Mockito.verify((Object)mockHandler, (VerificationMode)Mockito.never())).handle((Event)ArgumentMatchers.any(Event.class));
        }
        finally {
            hb.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskStuck() throws InterruptedException {
        EventHandler mockHandler = (EventHandler)Mockito.mock(EventHandler.class);
        SystemClock clock = SystemClock.getInstance();
        TaskHeartbeatHandler hb = new TaskHeartbeatHandler(mockHandler, (Clock)clock, 1);
        Configuration conf = new Configuration();
        conf.setLong("mapreduce.task.stuck.timeout-ms", 10L);
        conf.setInt("mapreduce.task.timeout", 1000);
        conf.setLong("mapreduce.task.progress-report.interval", 5L);
        conf.setInt("mapreduce.task.timeout.check-interval-ms", 10);
        hb.init(conf);
        hb.start();
        try {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)5);
            JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)4);
            TaskId tid = MRBuilderUtils.newTaskId((JobId)jobId, (int)3, (TaskType)TaskType.MAP);
            TaskAttemptId taid = MRBuilderUtils.newTaskAttemptId((TaskId)tid, (int)2);
            hb.register(taid);
            ConcurrentMap runningAttempts = hb.getRunningAttempts();
            for (Map.Entry entry : runningAttempts.entrySet()) {
                Assert.assertFalse((boolean)((TaskHeartbeatHandler.ReportTime)entry.getValue()).isReported());
            }
            Thread.sleep(100L);
            ((EventHandler)Mockito.verify((Object)mockHandler, (VerificationMode)Mockito.times((int)2))).handle((Event)ArgumentMatchers.any(Event.class));
        }
        finally {
            hb.stop();
        }
    }

    @Test
    public void testTaskTimeoutConfigSmallerThanTaskProgressReportInterval() {
        TestTaskHeartbeatHandler.testTaskTimeoutWrtProgressReportInterval(1000L, 5000L);
    }

    @Test
    public void testTaskTimeoutConfigBiggerThanTaskProgressReportInterval() {
        TestTaskHeartbeatHandler.testTaskTimeoutWrtProgressReportInterval(5000L, 1000L);
    }

    @Test
    public void testTaskTimeoutConfigWithoutTaskProgressReportInterval() {
        long taskTimeoutConfiged = 2000L;
        Configuration conf = new Configuration();
        conf.setLong("mapreduce.task.timeout", 2000L);
        long expectedTimeout = 2000L;
        TestTaskHeartbeatHandler.verifyTaskTimeoutConfig(conf, 2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskUnregistered() throws Exception {
        EventHandler mockHandler = (EventHandler)Mockito.mock(EventHandler.class);
        ControlledClock clock = new ControlledClock();
        clock.setTime(0L);
        final TaskHeartbeatHandler hb = new TaskHeartbeatHandler(mockHandler, (Clock)clock, 1);
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.task.timeout.check-interval-ms", 1);
        conf.setDouble("mapreduce.task.log.progress.delta.threshold", 0.01);
        hb.init(conf);
        hb.start();
        try {
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)5);
            JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appId, (int)4);
            TaskId tid = MRBuilderUtils.newTaskId((JobId)jobId, (int)3, (TaskType)TaskType.MAP);
            final TaskAttemptId taid = MRBuilderUtils.newTaskAttemptId((TaskId)tid, (int)2);
            Assert.assertFalse((boolean)hb.hasRecentlyUnregistered(taid));
            hb.register(taid);
            Assert.assertFalse((boolean)hb.hasRecentlyUnregistered(taid));
            hb.unregister(taid);
            Assert.assertTrue((boolean)hb.hasRecentlyUnregistered(taid));
            long unregisterTimeout = conf.getLong("mapreduce.task.exit.timeout", 60000L);
            clock.setTime(unregisterTimeout + 1L);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return !hb.hasRecentlyUnregistered(taid);
                }
            }, (long)10L, (long)10000L);
        }
        finally {
            hb.stop();
        }
    }

    private static void testTaskTimeoutWrtProgressReportInterval(long timeoutConfig, long taskreportInterval) {
        Configuration conf = new Configuration();
        conf.setLong("mapreduce.task.timeout", timeoutConfig);
        conf.setLong("mapreduce.task.progress-report.interval", taskreportInterval);
        long expectedTimeout = Math.max(timeoutConfig, taskreportInterval * 2L);
        TestTaskHeartbeatHandler.verifyTaskTimeoutConfig(conf, expectedTimeout);
    }

    private static void verifyTaskTimeoutConfig(Configuration conf, long expectedTimeout) {
        TaskHeartbeatHandler hb = new TaskHeartbeatHandler(null, (Clock)SystemClock.getInstance(), 1);
        hb.init(conf);
        Assert.assertTrue((String)"The value of the task timeout is incorrect.", (hb.getTaskTimeOut() == expectedTimeout ? 1 : 0) != 0);
    }
}

