/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.AMStartedEvent;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JHEvenHandlerForTest;
import org.apache.hadoop.mapreduce.jobhistory.JHEventHandlerForSigtermTest;
import org.apache.hadoop.mapreduce.jobhistory.JobFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryEventHandler;
import org.apache.hadoop.mapreduce.jobhistory.JobQueueChangeEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobStatusChangedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSubmittedEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFinishedEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskStartedEvent;
import org.apache.hadoop.mapreduce.util.JobHistoryEventUtils;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.client.api.TimelineV2Client;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.MiniYARNCluster;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestJobHistoryEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TestJobHistoryEventHandler.class);
    private static MiniDFSCluster dfsCluster = null;
    private static String coreSitePath;

    @BeforeClass
    public static void setUpClass() throws Exception {
        coreSitePath = "." + File.separator + "target" + File.separator + "test-classes" + File.separator + "core-site.xml";
        HdfsConfiguration conf = new HdfsConfiguration();
        dfsCluster = new MiniDFSCluster.Builder((Configuration)conf).build();
    }

    @AfterClass
    public static void cleanUpClass() throws Exception {
        dfsCluster.shutdown();
    }

    @After
    public void cleanTest() throws Exception {
        new File(coreSitePath).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testFirstFlushOnCompletionEvent() throws Exception {
        TestParams t = new TestParams();
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", t.workDir);
        conf.setLong("yarn.app.mapreduce.am.history.complete-event-flush-timeout", 60000L);
        conf.setInt("yarn.app.mapreduce.am.history.job-complete-unflushed-multiplier", 10);
        conf.setInt("yarn.app.mapreduce.am.history.max-unflushed-events", 10);
        conf.setInt("yarn.app.mapreduce.am.history.use-batched-flush.queue-size.threshold", 200);
        JHEvenHandlerForTest realJheh = new JHEvenHandlerForTest(t.mockAppContext, 0);
        JHEvenHandlerForTest jheh = (JHEvenHandlerForTest)((Object)Mockito.spy((Object)((Object)realJheh)));
        jheh.init(conf);
        EventWriter mockWriter = null;
        try {
            jheh.start();
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new AMStartedEvent(t.appAttemptId, 200L, t.containerId, "nmhost", 3000, 4000, -1L)));
            mockWriter = jheh.getEventWriter();
            ((EventWriter)Mockito.verify((Object)mockWriter)).write((HistoryEvent)ArgumentMatchers.any(HistoryEvent.class));
            for (int i = 0; i < 100; ++i) {
                this.queueEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new TaskStartedEvent(t.taskID, 0L, TaskType.MAP, "")));
            }
            this.handleNextNEvents(jheh, 100);
            ((EventWriter)Mockito.verify((Object)mockWriter, (VerificationMode)Mockito.times((int)0))).flush();
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new TaskFinishedEvent(t.taskID, t.taskAttemptID, 0L, TaskType.MAP, "", null, 0L)));
            ((EventWriter)Mockito.verify((Object)mockWriter)).flush();
        }
        catch (Throwable throwable) {
            jheh.stop();
            ((EventWriter)Mockito.verify(mockWriter)).close();
            throw throwable;
        }
        jheh.stop();
        ((EventWriter)Mockito.verify((Object)mockWriter)).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testMaxUnflushedCompletionEvents() throws Exception {
        TestParams t = new TestParams();
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", t.workDir);
        conf.setLong("yarn.app.mapreduce.am.history.complete-event-flush-timeout", 60000L);
        conf.setInt("yarn.app.mapreduce.am.history.job-complete-unflushed-multiplier", 10);
        conf.setInt("yarn.app.mapreduce.am.history.max-unflushed-events", 10);
        conf.setInt("yarn.app.mapreduce.am.history.use-batched-flush.queue-size.threshold", 5);
        JHEvenHandlerForTest realJheh = new JHEvenHandlerForTest(t.mockAppContext, 0);
        JHEvenHandlerForTest jheh = (JHEvenHandlerForTest)((Object)Mockito.spy((Object)((Object)realJheh)));
        jheh.init(conf);
        EventWriter mockWriter = null;
        try {
            jheh.start();
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new AMStartedEvent(t.appAttemptId, 200L, t.containerId, "nmhost", 3000, 4000, -1L)));
            mockWriter = jheh.getEventWriter();
            ((EventWriter)Mockito.verify((Object)mockWriter)).write((HistoryEvent)ArgumentMatchers.any(HistoryEvent.class));
            for (int i = 0; i < 100; ++i) {
                this.queueEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new TaskFinishedEvent(t.taskID, t.taskAttemptID, 0L, TaskType.MAP, "", null, 0L)));
            }
            this.handleNextNEvents(jheh, 9);
            ((EventWriter)Mockito.verify((Object)mockWriter, (VerificationMode)Mockito.times((int)0))).flush();
            this.handleNextNEvents(jheh, 1);
            ((EventWriter)Mockito.verify((Object)mockWriter)).flush();
            this.handleNextNEvents(jheh, 50);
            ((EventWriter)Mockito.verify((Object)mockWriter, (VerificationMode)Mockito.times((int)6))).flush();
        }
        catch (Throwable throwable) {
            jheh.stop();
            ((EventWriter)Mockito.verify(mockWriter)).close();
            throw throwable;
        }
        jheh.stop();
        ((EventWriter)Mockito.verify((Object)mockWriter)).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testUnflushedTimer() throws Exception {
        TestParams t = new TestParams();
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", t.workDir);
        conf.setLong("yarn.app.mapreduce.am.history.complete-event-flush-timeout", 2000L);
        conf.setInt("yarn.app.mapreduce.am.history.job-complete-unflushed-multiplier", 10);
        conf.setInt("yarn.app.mapreduce.am.history.max-unflushed-events", 100);
        conf.setInt("yarn.app.mapreduce.am.history.use-batched-flush.queue-size.threshold", 5);
        JHEvenHandlerForTest realJheh = new JHEvenHandlerForTest(t.mockAppContext, 0);
        JHEvenHandlerForTest jheh = (JHEvenHandlerForTest)((Object)Mockito.spy((Object)((Object)realJheh)));
        jheh.init(conf);
        EventWriter mockWriter = null;
        try {
            jheh.start();
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new AMStartedEvent(t.appAttemptId, 200L, t.containerId, "nmhost", 3000, 4000, -1L)));
            mockWriter = jheh.getEventWriter();
            ((EventWriter)Mockito.verify((Object)mockWriter)).write((HistoryEvent)ArgumentMatchers.any(HistoryEvent.class));
            for (int i = 0; i < 100; ++i) {
                this.queueEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new TaskFinishedEvent(t.taskID, t.taskAttemptID, 0L, TaskType.MAP, "", null, 0L)));
            }
            this.handleNextNEvents(jheh, 9);
            Assert.assertTrue((boolean)jheh.getFlushTimerStatus());
            ((EventWriter)Mockito.verify((Object)mockWriter, (VerificationMode)Mockito.times((int)0))).flush();
            Thread.sleep(8000L);
            ((EventWriter)Mockito.verify((Object)mockWriter)).flush();
            Assert.assertFalse((boolean)jheh.getFlushTimerStatus());
        }
        catch (Throwable throwable) {
            jheh.stop();
            ((EventWriter)Mockito.verify(mockWriter)).close();
            throw throwable;
        }
        jheh.stop();
        ((EventWriter)Mockito.verify((Object)mockWriter)).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testBatchedFlushJobEndMultiplier() throws Exception {
        TestParams t = new TestParams();
        Configuration conf = new Configuration();
        conf.set("yarn.app.mapreduce.am.staging-dir", t.workDir);
        conf.setLong("yarn.app.mapreduce.am.history.complete-event-flush-timeout", 60000L);
        conf.setInt("yarn.app.mapreduce.am.history.job-complete-unflushed-multiplier", 3);
        conf.setInt("yarn.app.mapreduce.am.history.max-unflushed-events", 10);
        conf.setInt("yarn.app.mapreduce.am.history.use-batched-flush.queue-size.threshold", 0);
        JHEvenHandlerForTest realJheh = new JHEvenHandlerForTest(t.mockAppContext, 0);
        JHEvenHandlerForTest jheh = (JHEvenHandlerForTest)((Object)Mockito.spy((Object)((Object)realJheh)));
        jheh.init(conf);
        EventWriter mockWriter = null;
        try {
            jheh.start();
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new AMStartedEvent(t.appAttemptId, 200L, t.containerId, "nmhost", 3000, 4000, -1L)));
            mockWriter = jheh.getEventWriter();
            ((EventWriter)Mockito.verify((Object)mockWriter)).write((HistoryEvent)ArgumentMatchers.any(HistoryEvent.class));
            for (int i = 0; i < 100; ++i) {
                this.queueEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new TaskFinishedEvent(t.taskID, t.taskAttemptID, 0L, TaskType.MAP, "", null, 0L)));
            }
            this.queueEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobFinishedEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 10, 10, 0, 0, 0, 0, null, null, new Counters())));
            this.handleNextNEvents(jheh, 29);
            ((EventWriter)Mockito.verify((Object)mockWriter, (VerificationMode)Mockito.times((int)0))).flush();
            this.handleNextNEvents(jheh, 72);
            ((EventWriter)Mockito.verify((Object)mockWriter, (VerificationMode)Mockito.times((int)4))).flush();
        }
        catch (Throwable throwable) {
            jheh.stop();
            ((EventWriter)Mockito.verify(mockWriter)).close();
            throw throwable;
        }
        jheh.stop();
        ((EventWriter)Mockito.verify((Object)mockWriter)).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testProcessDoneFilesOnLastAMRetry() throws Exception {
        TestParams t = new TestParams(true);
        Configuration conf = new Configuration();
        JHEvenHandlerForTest realJheh = new JHEvenHandlerForTest(t.mockAppContext, 0);
        JHEvenHandlerForTest jheh = (JHEvenHandlerForTest)((Object)Mockito.spy((Object)((Object)realJheh)));
        jheh.init(conf);
        EventWriter mockWriter = null;
        try {
            jheh.start();
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new AMStartedEvent(t.appAttemptId, 200L, t.containerId, "nmhost", 3000, 4000, -1L)));
            ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)0)))).processDoneFiles((JobId)ArgumentMatchers.any(JobId.class));
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobUnsuccessfulCompletionEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 0, 0, 0, 0, 0, 0, JobStateInternal.ERROR.toString())));
            ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)1)))).processDoneFiles((JobId)ArgumentMatchers.any(JobId.class));
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobFinishedEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 0, 0, 0, 0, 0, 0, new Counters(), new Counters(), new Counters())));
            ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)2)))).processDoneFiles((JobId)ArgumentMatchers.any(JobId.class));
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobUnsuccessfulCompletionEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 0, 0, 0, 0, 0, 0, JobStateInternal.FAILED.toString())));
            ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)3)))).processDoneFiles((JobId)ArgumentMatchers.any(JobId.class));
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobUnsuccessfulCompletionEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 0, 0, 0, 0, 0, 0, JobStateInternal.KILLED.toString())));
            ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)4)))).processDoneFiles((JobId)ArgumentMatchers.any(JobId.class));
            mockWriter = jheh.getEventWriter();
            ((EventWriter)Mockito.verify((Object)mockWriter, (VerificationMode)Mockito.times((int)5))).write((HistoryEvent)ArgumentMatchers.any(HistoryEvent.class));
        }
        catch (Throwable throwable) {
            jheh.stop();
            ((EventWriter)Mockito.verify(mockWriter)).close();
            throw throwable;
        }
        jheh.stop();
        ((EventWriter)Mockito.verify((Object)mockWriter)).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testProcessDoneFilesNotLastAMRetry() throws Exception {
        TestParams t = new TestParams(false);
        Configuration conf = new Configuration();
        JHEvenHandlerForTest realJheh = new JHEvenHandlerForTest(t.mockAppContext, 0);
        JHEvenHandlerForTest jheh = (JHEvenHandlerForTest)((Object)Mockito.spy((Object)((Object)realJheh)));
        jheh.init(conf);
        EventWriter mockWriter = null;
        try {
            jheh.start();
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new AMStartedEvent(t.appAttemptId, 200L, t.containerId, "nmhost", 3000, 4000, -1L)));
            ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)0)))).processDoneFiles(t.jobId);
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobUnsuccessfulCompletionEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 0, 0, 0, 0, 0, 0, JobStateInternal.ERROR.toString())));
            ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)0)))).processDoneFiles(t.jobId);
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobFinishedEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 0, 0, 0, 0, 0, 0, new Counters(), new Counters(), new Counters())));
            ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)1)))).processDoneFiles(t.jobId);
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobUnsuccessfulCompletionEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 0, 0, 0, 0, 0, 0, JobStateInternal.FAILED.toString())));
            ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)2)))).processDoneFiles(t.jobId);
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobUnsuccessfulCompletionEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 0, 0, 0, 0, 0, 0, JobStateInternal.KILLED.toString())));
            ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)3)))).processDoneFiles(t.jobId);
            mockWriter = jheh.getEventWriter();
            ((EventWriter)Mockito.verify((Object)mockWriter, (VerificationMode)Mockito.times((int)5))).write((HistoryEvent)ArgumentMatchers.any(HistoryEvent.class));
        }
        catch (Throwable throwable) {
            jheh.stop();
            ((EventWriter)Mockito.verify(mockWriter)).close();
            throw throwable;
        }
        jheh.stop();
        ((EventWriter)Mockito.verify((Object)mockWriter)).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPropertyRedactionForJHS() throws Exception {
        Configuration conf = new Configuration();
        String sensitivePropertyName = "aws.fake.credentials.name";
        String sensitivePropertyValue = "aws.fake.credentials.val";
        conf.set(sensitivePropertyName, sensitivePropertyValue);
        conf.set("mapreduce.job.redacted-properties", sensitivePropertyName);
        conf.set("fs.defaultFS", dfsCluster.getURI().toString());
        TestParams params = new TestParams();
        conf.set("yarn.app.mapreduce.am.staging-dir", params.dfsWorkDir);
        JHEvenHandlerForTest jheh = new JHEvenHandlerForTest(params.mockAppContext, 0, false);
        try {
            jheh.init(conf);
            jheh.start();
            this.handleEvent(jheh, new JobHistoryEvent(params.jobId, (HistoryEvent)new AMStartedEvent(params.appAttemptId, 200L, params.containerId, "nmhost", 3000, 4000, -1L)));
            this.handleEvent(jheh, new JobHistoryEvent(params.jobId, (HistoryEvent)new JobUnsuccessfulCompletionEvent((JobID)TypeConverter.fromYarn((JobId)params.jobId), 0L, 0, 0, 0, 0, 0, 0, JobStateInternal.FAILED.toString())));
            ((AbstractStringAssert)Assertions.assertThat((String)conf.get(sensitivePropertyName)).isEqualTo((Object)sensitivePropertyValue)).withFailMessage(sensitivePropertyName + " is modified.", new Object[0]);
            Path jhsJobConfFile = TestJobHistoryEventHandler.getJobConfInIntermediateDoneDir(conf, params.jobId);
            Assert.assertTrue((String)"The job_conf.xml file is not in the JHS directory", (boolean)FileContext.getFileContext((Configuration)conf).util().exists(jhsJobConfFile));
            Configuration jhsJobConf = new Configuration();
            try (FSDataInputStream input = FileSystem.get((Configuration)conf).open(jhsJobConfFile);){
                jhsJobConf.addResource((InputStream)input);
                Assert.assertEquals((String)(sensitivePropertyName + " is not redacted in HDFS."), (Object)"*********(redacted)", (Object)jhsJobConf.get(sensitivePropertyName));
            }
        }
        finally {
            jheh.stop();
            this.purgeHdfsHistoryIntermediateDoneDirectory(conf);
        }
    }

    private static Path getJobConfInIntermediateDoneDir(Configuration conf, JobId jobId) throws IOException {
        Path userDoneDir = new Path(JobHistoryUtils.getHistoryIntermediateDoneDirForUser((Configuration)conf));
        Path doneDirPrefix = FileContext.getFileContext((Configuration)conf).makeQualified(userDoneDir);
        return new Path(doneDirPrefix, JobHistoryUtils.getIntermediateConfFileName((JobId)jobId));
    }

    private void purgeHdfsHistoryIntermediateDoneDirectory(Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)dfsCluster.getConfiguration(0));
        String intermDoneDirPrefix = JobHistoryUtils.getConfiguredHistoryIntermediateDoneDirPrefix((Configuration)conf);
        fs.delete(new Path(intermDoneDirPrefix), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testDefaultFsIsUsedForHistory() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", dfsCluster.getURI().toString());
        FileOutputStream os = new FileOutputStream(coreSitePath);
        conf.writeXml((OutputStream)os);
        os.close();
        conf.set("fs.defaultFS", "file:///");
        TestParams t = new TestParams();
        conf.set("yarn.app.mapreduce.am.staging-dir", t.dfsWorkDir);
        JHEvenHandlerForTest realJheh = new JHEvenHandlerForTest(t.mockAppContext, 0, false);
        JHEvenHandlerForTest jheh = (JHEvenHandlerForTest)((Object)Mockito.spy((Object)((Object)realJheh)));
        jheh.init(conf);
        try {
            jheh.start();
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new AMStartedEvent(t.appAttemptId, 200L, t.containerId, "nmhost", 3000, 4000, -1L)));
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobFinishedEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 0, 0, 0, 0, 0, 0, new Counters(), new Counters(), new Counters())));
            DistributedFileSystem dfsFileSystem = dfsCluster.getFileSystem();
            Assert.assertTrue((String)"Minicluster contains some history files", (dfsFileSystem.globStatus(new Path(t.dfsWorkDir + "/*")).length != 0 ? 1 : 0) != 0);
            FileSystem localFileSystem = LocalFileSystem.get((Configuration)conf);
            Assert.assertFalse((String)"No history directory on non-default file system", (boolean)localFileSystem.exists(new Path(t.dfsWorkDir)));
        }
        finally {
            jheh.stop();
            this.purgeHdfsHistoryIntermediateDoneDirectory(conf);
        }
    }

    @Test
    public void testGetHistoryIntermediateDoneDirForUser() throws IOException {
        Configuration conf = new Configuration();
        conf.set("mapreduce.jobhistory.intermediate-done-dir", "/mapred/history/done_intermediate");
        conf.set("mapreduce.job.user.name", System.getProperty("user.name"));
        String pathStr = JobHistoryUtils.getHistoryIntermediateDoneDirForUser((Configuration)conf);
        Assert.assertEquals((Object)("/mapred/history/done_intermediate/" + System.getProperty("user.name")), (Object)pathStr);
        conf.set("fs.defaultFS", dfsCluster.getURI().toString());
        FileOutputStream os = new FileOutputStream(coreSitePath);
        conf.writeXml((OutputStream)os);
        os.close();
        conf.set("fs.defaultFS", "file:///");
        pathStr = JobHistoryUtils.getHistoryIntermediateDoneDirForUser((Configuration)conf);
        Assert.assertEquals((Object)(dfsCluster.getURI().toString() + "/mapred/history/done_intermediate/" + System.getProperty("user.name")), (Object)pathStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testAMStartedEvent() throws Exception {
        TestParams t = new TestParams();
        Configuration conf = new Configuration();
        JHEvenHandlerForTest realJheh = new JHEvenHandlerForTest(t.mockAppContext, 0);
        JHEvenHandlerForTest jheh = (JHEvenHandlerForTest)((Object)Mockito.spy((Object)((Object)realJheh)));
        jheh.init(conf);
        EventWriter mockWriter = null;
        try {
            jheh.start();
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new AMStartedEvent(t.appAttemptId, 200L, t.containerId, "nmhost", 3000, 4000, 100L)));
            JobHistoryEventHandler.MetaInfo mi = (JobHistoryEventHandler.MetaInfo)JobHistoryEventHandler.fileMap.get(t.jobId);
            Assertions.assertThat((long)mi.getJobIndexInfo().getSubmitTime()).isEqualTo(100L);
            Assertions.assertThat((long)mi.getJobIndexInfo().getJobStartTime()).isEqualTo(200L);
            Assertions.assertThat((long)mi.getJobSummary().getJobSubmitTime()).isEqualTo(100L);
            Assertions.assertThat((long)mi.getJobSummary().getJobLaunchTime()).isEqualTo(200L);
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobUnsuccessfulCompletionEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 0, 0, 0, 0, 0, 0, JobStateInternal.FAILED.toString())));
            Assertions.assertThat((long)mi.getJobIndexInfo().getSubmitTime()).isEqualTo(100L);
            Assertions.assertThat((long)mi.getJobIndexInfo().getJobStartTime()).isEqualTo(200L);
            Assertions.assertThat((long)mi.getJobSummary().getJobSubmitTime()).isEqualTo(100L);
            Assertions.assertThat((long)mi.getJobSummary().getJobLaunchTime()).isEqualTo(200L);
            ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)1)))).processDoneFiles(t.jobId);
            mockWriter = jheh.getEventWriter();
            ((EventWriter)Mockito.verify((Object)mockWriter, (VerificationMode)Mockito.times((int)2))).write((HistoryEvent)ArgumentMatchers.any(HistoryEvent.class));
        }
        finally {
            jheh.stop();
        }
    }

    @Test(timeout=50000L)
    public void testTimelineEventHandling() throws Exception {
        TestParams t = new TestParams(MRAppMaster.RunningAppContext.class, false);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.timeline-service.enabled", true);
        long currentTime = System.currentTimeMillis();
        try (MiniYARNCluster yarnCluster = new MiniYARNCluster(TestJobHistoryEventHandler.class.getSimpleName(), 1, 1, 1, 1);){
            yarnCluster.init((Configuration)conf);
            yarnCluster.start();
            YarnConfiguration confJHEH = new YarnConfiguration((Configuration)conf);
            confJHEH.setBoolean("mapreduce.job.emit-timeline-data", true);
            confJHEH.set("yarn.timeline-service.webapp.address", MiniYARNCluster.getHostname() + ":" + yarnCluster.getApplicationHistoryServer().getPort());
            JHEvenHandlerForTest jheh = new JHEvenHandlerForTest(t.mockAppContext, 0);
            jheh.init((Configuration)confJHEH);
            jheh.start();
            TimelineStore ts = yarnCluster.getApplicationHistoryServer().getTimelineStore();
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new AMStartedEvent(t.appAttemptId, 200L, t.containerId, "nmhost", 3000, 4000, -1L), currentTime - 10L));
            jheh.getDispatcher().await();
            TimelineEntities entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null, null);
            Assert.assertEquals((long)1L, (long)entities.getEntities().size());
            TimelineEntity tEntity = (TimelineEntity)entities.getEntities().get(0);
            Assert.assertEquals((Object)t.jobId.toString(), (Object)tEntity.getEntityId());
            Assert.assertEquals((long)1L, (long)tEntity.getEvents().size());
            Assert.assertEquals((Object)EventType.AM_STARTED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(0)).getEventType());
            Assert.assertEquals((long)(currentTime - 10L), (long)((TimelineEvent)tEntity.getEvents().get(0)).getTimestamp());
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobSubmittedEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), "name", "user", 200L, "/foo/job.xml", new HashMap(), "default"), currentTime + 10L));
            jheh.getDispatcher().await();
            entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null, null);
            Assert.assertEquals((long)1L, (long)entities.getEntities().size());
            tEntity = (TimelineEntity)entities.getEntities().get(0);
            Assert.assertEquals((Object)t.jobId.toString(), (Object)tEntity.getEntityId());
            Assert.assertEquals((long)2L, (long)tEntity.getEvents().size());
            Assert.assertEquals((Object)EventType.JOB_SUBMITTED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(0)).getEventType());
            Assert.assertEquals((Object)EventType.AM_STARTED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(1)).getEventType());
            Assert.assertEquals((long)(currentTime + 10L), (long)((TimelineEvent)tEntity.getEvents().get(0)).getTimestamp());
            Assert.assertEquals((long)(currentTime - 10L), (long)((TimelineEvent)tEntity.getEvents().get(1)).getTimestamp());
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobQueueChangeEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), "q2"), currentTime - 20L));
            jheh.getDispatcher().await();
            entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null, null);
            Assert.assertEquals((long)1L, (long)entities.getEntities().size());
            tEntity = (TimelineEntity)entities.getEntities().get(0);
            Assert.assertEquals((Object)t.jobId.toString(), (Object)tEntity.getEntityId());
            Assert.assertEquals((long)3L, (long)tEntity.getEvents().size());
            Assert.assertEquals((Object)EventType.JOB_SUBMITTED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(0)).getEventType());
            Assert.assertEquals((Object)EventType.AM_STARTED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(1)).getEventType());
            Assert.assertEquals((Object)EventType.JOB_QUEUE_CHANGED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(2)).getEventType());
            Assert.assertEquals((long)(currentTime + 10L), (long)((TimelineEvent)tEntity.getEvents().get(0)).getTimestamp());
            Assert.assertEquals((long)(currentTime - 10L), (long)((TimelineEvent)tEntity.getEvents().get(1)).getTimestamp());
            Assert.assertEquals((long)(currentTime - 20L), (long)((TimelineEvent)tEntity.getEvents().get(2)).getTimestamp());
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobFinishedEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 0, 0, 0, 0, 0, 0, new Counters(), new Counters(), new Counters()), currentTime));
            jheh.getDispatcher().await();
            entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null, null);
            Assert.assertEquals((long)1L, (long)entities.getEntities().size());
            tEntity = (TimelineEntity)entities.getEntities().get(0);
            Assert.assertEquals((Object)t.jobId.toString(), (Object)tEntity.getEntityId());
            Assert.assertEquals((long)4L, (long)tEntity.getEvents().size());
            Assert.assertEquals((Object)EventType.JOB_SUBMITTED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(0)).getEventType());
            Assert.assertEquals((Object)EventType.JOB_FINISHED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(1)).getEventType());
            Assert.assertEquals((Object)EventType.AM_STARTED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(2)).getEventType());
            Assert.assertEquals((Object)EventType.JOB_QUEUE_CHANGED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(3)).getEventType());
            Assert.assertEquals((long)(currentTime + 10L), (long)((TimelineEvent)tEntity.getEvents().get(0)).getTimestamp());
            Assert.assertEquals((long)currentTime, (long)((TimelineEvent)tEntity.getEvents().get(1)).getTimestamp());
            Assert.assertEquals((long)(currentTime - 10L), (long)((TimelineEvent)tEntity.getEvents().get(2)).getTimestamp());
            Assert.assertEquals((long)(currentTime - 20L), (long)((TimelineEvent)tEntity.getEvents().get(3)).getTimestamp());
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobUnsuccessfulCompletionEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 0, 0, 0, 0, 0, 0, JobStateInternal.KILLED.toString()), currentTime + 20L));
            jheh.getDispatcher().await();
            entities = ts.getEntities("MAPREDUCE_JOB", null, null, null, null, null, null, null, null, null);
            Assert.assertEquals((long)1L, (long)entities.getEntities().size());
            tEntity = (TimelineEntity)entities.getEntities().get(0);
            Assert.assertEquals((Object)t.jobId.toString(), (Object)tEntity.getEntityId());
            Assert.assertEquals((long)5L, (long)tEntity.getEvents().size());
            Assert.assertEquals((Object)EventType.JOB_KILLED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(0)).getEventType());
            Assert.assertEquals((Object)EventType.JOB_SUBMITTED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(1)).getEventType());
            Assert.assertEquals((Object)EventType.JOB_FINISHED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(2)).getEventType());
            Assert.assertEquals((Object)EventType.AM_STARTED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(3)).getEventType());
            Assert.assertEquals((Object)EventType.JOB_QUEUE_CHANGED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(4)).getEventType());
            Assert.assertEquals((long)(currentTime + 20L), (long)((TimelineEvent)tEntity.getEvents().get(0)).getTimestamp());
            Assert.assertEquals((long)(currentTime + 10L), (long)((TimelineEvent)tEntity.getEvents().get(1)).getTimestamp());
            Assert.assertEquals((long)currentTime, (long)((TimelineEvent)tEntity.getEvents().get(2)).getTimestamp());
            Assert.assertEquals((long)(currentTime - 10L), (long)((TimelineEvent)tEntity.getEvents().get(3)).getTimestamp());
            Assert.assertEquals((long)(currentTime - 20L), (long)((TimelineEvent)tEntity.getEvents().get(4)).getTimestamp());
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new TaskStartedEvent(t.taskID, 0L, TaskType.MAP, "")));
            jheh.getDispatcher().await();
            entities = ts.getEntities("MAPREDUCE_TASK", null, null, null, null, null, null, null, null, null);
            Assert.assertEquals((long)1L, (long)entities.getEntities().size());
            tEntity = (TimelineEntity)entities.getEntities().get(0);
            Assert.assertEquals((Object)t.taskID.toString(), (Object)tEntity.getEntityId());
            Assert.assertEquals((long)1L, (long)tEntity.getEvents().size());
            Assert.assertEquals((Object)EventType.TASK_STARTED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(0)).getEventType());
            Assert.assertEquals((Object)TaskType.MAP.toString(), ((TimelineEvent)tEntity.getEvents().get(0)).getEventInfo().get("TASK_TYPE"));
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new TaskStartedEvent(t.taskID, 0L, TaskType.REDUCE, "")));
            jheh.getDispatcher().await();
            entities = ts.getEntities("MAPREDUCE_TASK", null, null, null, null, null, null, null, null, null);
            Assert.assertEquals((long)1L, (long)entities.getEntities().size());
            tEntity = (TimelineEntity)entities.getEntities().get(0);
            Assert.assertEquals((Object)t.taskID.toString(), (Object)tEntity.getEntityId());
            Assert.assertEquals((long)2L, (long)tEntity.getEvents().size());
            Assert.assertEquals((Object)EventType.TASK_STARTED.toString(), (Object)((TimelineEvent)tEntity.getEvents().get(1)).getEventType());
            Assert.assertEquals((Object)TaskType.REDUCE.toString(), ((TimelineEvent)tEntity.getEvents().get(0)).getEventInfo().get("TASK_TYPE"));
            Assert.assertEquals((Object)TaskType.MAP.toString(), ((TimelineEvent)tEntity.getEvents().get(1)).getEventInfo().get("TASK_TYPE"));
        }
    }

    @Test(timeout=50000L)
    public void testCountersToJSON() throws Exception {
        JobHistoryEventHandler jheh = new JobHistoryEventHandler(null, 0);
        Counters counters = new Counters();
        CounterGroup group1 = (CounterGroup)counters.addGroup("DOCTORS", "Incarnations of the Doctor");
        group1.addCounter("PETER_CAPALDI", "Peter Capaldi", 12L);
        group1.addCounter("MATT_SMITH", "Matt Smith", 11L);
        group1.addCounter("DAVID_TENNANT", "David Tennant", 10L);
        CounterGroup group2 = (CounterGroup)counters.addGroup("COMPANIONS", "Companions of the Doctor");
        group2.addCounter("CLARA_OSWALD", "Clara Oswald", 6L);
        group2.addCounter("RORY_WILLIAMS", "Rory Williams", 5L);
        group2.addCounter("AMY_POND", "Amy Pond", 4L);
        group2.addCounter("MARTHA_JONES", "Martha Jones", 3L);
        group2.addCounter("DONNA_NOBLE", "Donna Noble", 2L);
        group2.addCounter("ROSE_TYLER", "Rose Tyler", 1L);
        JsonNode jsonNode = JobHistoryEventUtils.countersToJSON((Counters)counters);
        String jsonStr = new ObjectMapper().writeValueAsString((Object)jsonNode);
        String expected = "[{\"NAME\":\"COMPANIONS\",\"DISPLAY_NAME\":\"Companions of the Doctor\",\"COUNTERS\":[{\"NAME\":\"AMY_POND\",\"DISPLAY_NAME\":\"Amy Pond\",\"VALUE\":4},{\"NAME\":\"CLARA_OSWALD\",\"DISPLAY_NAME\":\"Clara Oswald\",\"VALUE\":6},{\"NAME\":\"DONNA_NOBLE\",\"DISPLAY_NAME\":\"Donna Noble\",\"VALUE\":2},{\"NAME\":\"MARTHA_JONES\",\"DISPLAY_NAME\":\"Martha Jones\",\"VALUE\":3},{\"NAME\":\"RORY_WILLIAMS\",\"DISPLAY_NAME\":\"Rory Williams\",\"VALUE\":5},{\"NAME\":\"ROSE_TYLER\",\"DISPLAY_NAME\":\"Rose Tyler\",\"VALUE\":1}]},{\"NAME\":\"DOCTORS\",\"DISPLAY_NAME\":\"Incarnations of the Doctor\",\"COUNTERS\":[{\"NAME\":\"DAVID_TENNANT\",\"DISPLAY_NAME\":\"David Tennant\",\"VALUE\":10},{\"NAME\":\"MATT_SMITH\",\"DISPLAY_NAME\":\"Matt Smith\",\"VALUE\":11},{\"NAME\":\"PETER_CAPALDI\",\"DISPLAY_NAME\":\"Peter Capaldi\",\"VALUE\":12}]}]";
        Assert.assertEquals((Object)expected, (Object)jsonStr);
    }

    @Test(timeout=50000L)
    public void testCountersToJSONEmpty() throws Exception {
        JobHistoryEventHandler jheh = new JobHistoryEventHandler(null, 0);
        Counters counters = null;
        JsonNode jsonNode = JobHistoryEventUtils.countersToJSON(counters);
        String jsonStr = new ObjectMapper().writeValueAsString((Object)jsonNode);
        String expected = "[]";
        Assert.assertEquals((Object)expected, (Object)jsonStr);
        counters = new Counters();
        jsonNode = JobHistoryEventUtils.countersToJSON((Counters)counters);
        jsonStr = new ObjectMapper().writeValueAsString((Object)jsonNode);
        expected = "[]";
        Assert.assertEquals((Object)expected, (Object)jsonStr);
        counters.addGroup("DOCTORS", "Incarnations of the Doctor");
        jsonNode = JobHistoryEventUtils.countersToJSON((Counters)counters);
        jsonStr = new ObjectMapper().writeValueAsString((Object)jsonNode);
        expected = "[{\"NAME\":\"DOCTORS\",\"DISPLAY_NAME\":\"Incarnations of the Doctor\",\"COUNTERS\":[]}]";
        Assert.assertEquals((Object)expected, (Object)jsonStr);
    }

    private void queueEvent(JHEvenHandlerForTest jheh, JobHistoryEvent event) {
        jheh.handle(event);
    }

    private void handleEvent(JHEvenHandlerForTest jheh, JobHistoryEvent event) throws InterruptedException {
        jheh.handle(event);
        jheh.handleEvent((JobHistoryEvent)jheh.eventQueue.take());
    }

    private void handleNextNEvents(JHEvenHandlerForTest jheh, int numEvents) throws InterruptedException {
        for (int i = 0; i < numEvents; ++i) {
            jheh.handleEvent((JobHistoryEvent)jheh.eventQueue.take());
        }
    }

    private String setupTestWorkDir() {
        File testWorkDir = new File("target", this.getClass().getCanonicalName());
        try {
            FileContext.getLocalFSFileContext().delete(new Path(testWorkDir.getAbsolutePath()), true);
            return testWorkDir.getAbsolutePath();
        }
        catch (Exception e) {
            LOG.warn("Could not cleanup", (Throwable)e);
            throw new YarnRuntimeException("could not cleanup test dir", (Throwable)e);
        }
    }

    private Job mockJob() {
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getAllCounters()).thenReturn((Object)new Counters());
        Mockito.when((Object)mockJob.getTotalMaps()).thenReturn((Object)10);
        Mockito.when((Object)mockJob.getTotalReduces()).thenReturn((Object)10);
        Mockito.when((Object)mockJob.getName()).thenReturn((Object)"mockjob");
        return mockJob;
    }

    private AppContext mockAppContext(Class<? extends AppContext> contextClass, ApplicationId appId, boolean isLastAMRetry) {
        JobId jobId = TypeConverter.toYarn((JobID)TypeConverter.fromYarn((ApplicationId)appId));
        AppContext mockContext = (AppContext)Mockito.mock(contextClass);
        Job mockJob = this.mockJob();
        Mockito.when((Object)mockContext.getJob(jobId)).thenReturn((Object)mockJob);
        Mockito.when((Object)mockContext.getApplicationID()).thenReturn((Object)appId);
        Mockito.when((Object)mockContext.isLastAMRetry()).thenReturn((Object)isLastAMRetry);
        if (mockContext instanceof MRAppMaster.RunningAppContext) {
            Mockito.when((Object)((MRAppMaster.RunningAppContext)mockContext).getTimelineClient()).thenReturn((Object)TimelineClient.createTimelineClient());
            Mockito.when((Object)((MRAppMaster.RunningAppContext)mockContext).getTimelineV2Client()).thenReturn((Object)TimelineV2Client.createTimelineClient((ApplicationId)ApplicationId.newInstance((long)0L, (int)1)));
        }
        return mockContext;
    }

    private JobHistoryEvent getEventToEnqueue(JobId jobId) {
        JobStatusChangedEvent toReturn = new JobStatusChangedEvent(new JobID(Integer.toString(jobId.getId()), jobId.getId()), "change status");
        return new JobHistoryEvent(jobId, (HistoryEvent)toReturn);
    }

    @Test
    public void testSigTermedFunctionality() throws IOException {
        AppContext mockedContext = (AppContext)Mockito.mock(AppContext.class);
        JHEventHandlerForSigtermTest jheh = new JHEventHandlerForSigtermTest(mockedContext, 0);
        JobId jobId = (JobId)Mockito.mock(JobId.class);
        jheh.addToFileMap(jobId);
        int numEvents = 4;
        JobHistoryEvent[] events = new JobHistoryEvent[4];
        for (int i = 0; i < 4; ++i) {
            events[i] = this.getEventToEnqueue(jobId);
            jheh.handle(events[i]);
        }
        jheh.stop();
        Assert.assertTrue((String)("handleEvent should've been called only 4 times but was " + jheh.eventsHandled), (jheh.eventsHandled == 4 ? 1 : 0) != 0);
        jheh = new JHEventHandlerForSigtermTest(mockedContext, 0);
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockedContext.getJob(jobId)).thenReturn((Object)job);
        ApplicationId mockAppId = (ApplicationId)Mockito.mock(ApplicationId.class);
        Mockito.when((Object)mockAppId.getClusterTimestamp()).thenReturn((Object)1000L);
        Mockito.when((Object)jobId.getAppId()).thenReturn((Object)mockAppId);
        jheh.addToFileMap(jobId);
        jheh.setForcejobCompletion(true);
        for (int i = 0; i < 4; ++i) {
            events[i] = this.getEventToEnqueue(jobId);
            jheh.handle(events[i]);
        }
        jheh.stop();
        Assert.assertTrue((String)("handleEvent should've been called only 5 times but was " + jheh.eventsHandled), (jheh.eventsHandled == 5 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Last event handled wasn't JobUnsuccessfulCompletionEvent", (boolean)(jheh.lastEventHandled.getHistoryEvent() instanceof JobUnsuccessfulCompletionEvent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testSetTrackingURLAfterHistoryIsWritten() throws Exception {
        TestParams t = new TestParams(true);
        Configuration conf = new Configuration();
        JHEvenHandlerForTest realJheh = new JHEvenHandlerForTest(t.mockAppContext, 0, false);
        JHEvenHandlerForTest jheh = (JHEvenHandlerForTest)((Object)Mockito.spy((Object)((Object)realJheh)));
        jheh.init(conf);
        try {
            jheh.start();
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new AMStartedEvent(t.appAttemptId, 200L, t.containerId, "nmhost", 3000, 4000, -1L)));
            ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)0)))).processDoneFiles((JobId)ArgumentMatchers.any(JobId.class));
            ((AppContext)Mockito.verify((Object)t.mockAppContext, (VerificationMode)Mockito.times((int)0))).setHistoryUrl((String)ArgumentMatchers.any(String.class));
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobFinishedEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 0, 0, 0, 0, 0, 0, new Counters(), new Counters(), new Counters())));
            ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)1)))).processDoneFiles((JobId)ArgumentMatchers.any(JobId.class));
            String historyUrl = MRWebAppUtil.getApplicationWebURLOnJHSWithScheme((Configuration)conf, (ApplicationId)t.mockAppContext.getApplicationID());
            ((AppContext)Mockito.verify((Object)t.mockAppContext, (VerificationMode)Mockito.times((int)1))).setHistoryUrl(historyUrl);
        }
        finally {
            jheh.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testDontSetTrackingURLIfHistoryWriteFailed() throws Exception {
        TestParams t = new TestParams(true);
        Configuration conf = new Configuration();
        JHEvenHandlerForTest realJheh = new JHEvenHandlerForTest(t.mockAppContext, 0, false);
        JHEvenHandlerForTest jheh = (JHEvenHandlerForTest)((Object)Mockito.spy((Object)((Object)realJheh)));
        jheh.init(conf);
        try {
            jheh.start();
            ((JHEvenHandlerForTest)((Object)Mockito.doReturn((Object)false).when((Object)jheh))).moveToDoneNow((Path)ArgumentMatchers.any(Path.class), (Path)ArgumentMatchers.any(Path.class));
            ((JHEvenHandlerForTest)((Object)Mockito.doNothing().when((Object)jheh))).moveTmpToDone((Path)ArgumentMatchers.any(Path.class));
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new AMStartedEvent(t.appAttemptId, 200L, t.containerId, "nmhost", 3000, 4000, -1L)));
            ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)0)))).processDoneFiles((JobId)ArgumentMatchers.any(JobId.class));
            ((AppContext)Mockito.verify((Object)t.mockAppContext, (VerificationMode)Mockito.times((int)0))).setHistoryUrl((String)ArgumentMatchers.any(String.class));
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobFinishedEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 0, 0, 0, 0, 0, 0, new Counters(), new Counters(), new Counters())));
            ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)1)))).processDoneFiles((JobId)ArgumentMatchers.any(JobId.class));
            ((AppContext)Mockito.verify((Object)t.mockAppContext, (VerificationMode)Mockito.times((int)0))).setHistoryUrl((String)ArgumentMatchers.any(String.class));
        }
        finally {
            jheh.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testDontSetTrackingURLIfHistoryWriteThrows() throws Exception {
        TestParams t = new TestParams(true);
        Configuration conf = new Configuration();
        JHEvenHandlerForTest realJheh = new JHEvenHandlerForTest(t.mockAppContext, 0, false);
        JHEvenHandlerForTest jheh = (JHEvenHandlerForTest)((Object)Mockito.spy((Object)((Object)realJheh)));
        jheh.init(conf);
        try {
            jheh.start();
            ((JHEvenHandlerForTest)((Object)Mockito.doThrow((Throwable[])new Throwable[]{new YarnRuntimeException((Throwable)new IOException())}).when((Object)jheh))).processDoneFiles((JobId)ArgumentMatchers.any(JobId.class));
            this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new AMStartedEvent(t.appAttemptId, 200L, t.containerId, "nmhost", 3000, 4000, -1L)));
            ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)0)))).processDoneFiles((JobId)ArgumentMatchers.any(JobId.class));
            ((AppContext)Mockito.verify((Object)t.mockAppContext, (VerificationMode)Mockito.times((int)0))).setHistoryUrl((String)ArgumentMatchers.any(String.class));
            try {
                this.handleEvent(jheh, new JobHistoryEvent(t.jobId, (HistoryEvent)new JobFinishedEvent((JobID)TypeConverter.fromYarn((JobId)t.jobId), 0L, 0, 0, 0, 0, 0, 0, new Counters(), new Counters(), new Counters())));
                throw new RuntimeException("processDoneFiles didn't throw, but should have");
            }
            catch (YarnRuntimeException yarnRuntimeException) {
                ((JHEvenHandlerForTest)((Object)Mockito.verify((Object)((Object)jheh), (VerificationMode)Mockito.times((int)1)))).processDoneFiles((JobId)ArgumentMatchers.any(JobId.class));
                ((AppContext)Mockito.verify((Object)t.mockAppContext, (VerificationMode)Mockito.times((int)0))).setHistoryUrl((String)ArgumentMatchers.any(String.class));
                jheh.stop();
            }
        }
        catch (Throwable throwable) {
            jheh.stop();
            throw throwable;
        }
    }

    private class TestParams {
        boolean isLastAMRetry;
        String workDir;
        String dfsWorkDir;
        ApplicationId appId;
        ApplicationAttemptId appAttemptId;
        ContainerId containerId;
        TaskID taskID;
        TaskAttemptID taskAttemptID;
        JobId jobId;
        AppContext mockAppContext;

        public TestParams() {
            this(AppContext.class, false);
        }

        public TestParams(boolean isLastAMRetry) {
            this(AppContext.class, isLastAMRetry);
        }

        public TestParams(Class<? extends AppContext> contextClass, boolean isLastAMRetry) {
            this.workDir = TestJobHistoryEventHandler.this.setupTestWorkDir();
            this.dfsWorkDir = "/" + this.getClass().getCanonicalName();
            this.appId = ApplicationId.newInstance((long)200L, (int)1);
            this.appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.appId, (int)1);
            this.containerId = ContainerId.newContainerId((ApplicationAttemptId)this.appAttemptId, (long)1L);
            this.taskID = TaskID.forName((String)"task_200707121733_0003_m_000005");
            this.taskAttemptID = new TaskAttemptID(this.taskID, 0);
            this.jobId = MRBuilderUtils.newJobId((ApplicationId)this.appId, (int)1);
            this.isLastAMRetry = isLastAMRetry;
            this.mockAppContext = TestJobHistoryEventHandler.this.mockAppContext(contextClass, this.appId, this.isLastAMRetry);
        }
    }
}

