/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.StringReader;
import java.util.Set;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MockAppContext;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebServices;
import org.apache.hadoop.mapreduce.v2.app.webapp.JAXBContextResolver;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.hadoop.util.XMLUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.GuiceServletConfig;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestAMWebServices
extends JerseyTestBase {
    private static Configuration conf = new Configuration();
    private static MockAppContext appContext;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    public TestAMWebServices() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.mapreduce.v2.app.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testAM() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testAMSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testAMDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce/").get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testAMXML() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/xml; charset=utf-8", (Object)response.getType().toString());
        String xml = (String)response.getEntity(String.class);
        this.verifyAMInfoXML(xml, appContext);
    }

    @Test
    public void testInfo() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("info").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testInfoSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("info/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testInfoDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("info/").get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyAMInfo(json.getJSONObject("info"), appContext);
    }

    @Test
    public void testInfoXML() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("info/").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/xml; charset=utf-8", (Object)response.getType().toString());
        String xml = (String)response.getEntity(String.class);
        this.verifyAMInfoXML(xml, appContext);
    }

    @Test
    public void testInvalidUri() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("mapreduce").path("bogus").accept(new String[]{"application/json"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testInvalidUri2() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("invalid").accept(new String[]{"application/json"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.NOT_FOUND, (Response.StatusType)response.getStatusInfo());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testInvalidAccept() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("mapreduce").accept(new String[]{"text/plain"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            WebServicesTestUtils.assertResponseStatusCode((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR, (Response.StatusType)response.getStatusInfo());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testBlacklistedNodes() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("blacklistednodes").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/json; charset=utf-8", (Object)response.getType().toString());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyBlacklistedNodesInfo(json, appContext);
    }

    @Test
    public void testBlacklistedNodesXML() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("mapreduce").path("blacklistednodes").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)"application/xml; charset=utf-8", (Object)response.getType().toString());
        String xml = (String)response.getEntity(String.class);
        this.verifyBlacklistedNodesInfoXML(xml, appContext);
    }

    public void verifyAMInfo(JSONObject info, AppContext ctx) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)5L, (long)info.length());
        this.verifyAMInfoGeneric(ctx, info.getString("appId"), info.getString("user"), info.getString("name"), info.getLong("startedOn"), info.getLong("elapsedTime"));
    }

    public void verifyAMInfoXML(String xml, AppContext ctx) throws JSONException, Exception {
        DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("info");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyAMInfoGeneric(ctx, WebServicesTestUtils.getXmlString((Element)element, (String)"appId"), WebServicesTestUtils.getXmlString((Element)element, (String)"user"), WebServicesTestUtils.getXmlString((Element)element, (String)"name"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startedOn"), WebServicesTestUtils.getXmlLong((Element)element, (String)"elapsedTime"));
        }
    }

    public void verifyAMInfoGeneric(AppContext ctx, String id, String user, String name, long startedOn, long elapsedTime) {
        WebServicesTestUtils.checkStringMatch((String)"id", (String)ctx.getApplicationID().toString(), (String)id);
        WebServicesTestUtils.checkStringMatch((String)"user", (String)ctx.getUser().toString(), (String)user);
        WebServicesTestUtils.checkStringMatch((String)"name", (String)ctx.getApplicationName(), (String)name);
        Assert.assertEquals((String)"startedOn incorrect", (long)ctx.getStartTime(), (long)startedOn);
        Assert.assertTrue((String)"elapsedTime not greater then 0", (elapsedTime > 0L ? 1 : 0) != 0);
    }

    public void verifyBlacklistedNodesInfo(JSONObject blacklist, AppContext ctx) throws JSONException, Exception {
        JSONArray array = blacklist.getJSONArray("blacklistedNodes");
        Assert.assertEquals((long)array.length(), (long)ctx.getBlacklistedNodes().size());
        for (int i = 0; i < array.length(); ++i) {
            Assert.assertTrue((boolean)ctx.getBlacklistedNodes().contains(array.getString(i)));
        }
    }

    public void verifyBlacklistedNodesInfoXML(String xml, AppContext ctx) throws JSONException, Exception {
        DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList infonodes = dom.getElementsByTagName("blacklistednodesinfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)infonodes.getLength());
        NodeList nodes = dom.getElementsByTagName("blacklistedNodes");
        Set blacklistedNodes = ctx.getBlacklistedNodes();
        Assert.assertEquals((String)"incorrect number of elements", (long)blacklistedNodes.size(), (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            Assert.assertTrue((boolean)blacklistedNodes.contains(element.getFirstChild().getNodeValue()));
        }
    }

    static {
        GuiceServletConfig.setInjector((Injector)Guice.createInjector((Module[])new Module[]{new WebServletModule()}));
    }

    private static class WebServletModule
    extends ServletModule {
        private WebServletModule() {
        }

        protected void configureServlets() {
            appContext = new MockAppContext(0, 1, 1, 1);
            appContext.setBlacklistedNodes(Sets.newHashSet((Object[])new String[]{"badnode1", "badnode2"}));
            this.bind(JAXBContextResolver.class);
            this.bind(AMWebServices.class);
            this.bind(GenericExceptionHandler.class);
            this.bind(AppContext.class).toInstance((Object)appContext);
            this.bind(Configuration.class).toInstance((Object)conf);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
        }
    }
}

