/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.TaskAttemptListenerImpl;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptFinishingMonitor;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.app.rm.preemption.AMPreemptionPolicy;
import org.apache.hadoop.mapreduce.v2.app.rm.preemption.CheckpointAMPreemptionPolicy;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTaskAttemptFinishingMonitor {
    @Test
    public void testFinshingAttemptTimeout() throws IOException, InterruptedException {
        SystemClock clock = SystemClock.getInstance();
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.task.exit.timeout", 100);
        conf.setInt("mapreduce.task.exit.timeout.check-interval-ms", 10);
        conf.setDouble("mapreduce.task.log.progress.delta.threshold", 0.01);
        AppContext appCtx = (AppContext)Mockito.mock(AppContext.class);
        JobTokenSecretManager secret = (JobTokenSecretManager)Mockito.mock(JobTokenSecretManager.class);
        RMHeartbeatHandler rmHeartbeatHandler = (RMHeartbeatHandler)Mockito.mock(RMHeartbeatHandler.class);
        MockEventHandler eventHandler = new MockEventHandler();
        TaskAttemptFinishingMonitor taskAttemptFinishingMonitor = new TaskAttemptFinishingMonitor((EventHandler)eventHandler);
        taskAttemptFinishingMonitor.init(conf);
        taskAttemptFinishingMonitor.start();
        Mockito.when((Object)appCtx.getEventHandler()).thenReturn((Object)eventHandler);
        Mockito.when((Object)appCtx.getNMHostname()).thenReturn((Object)"0.0.0.0");
        Mockito.when((Object)appCtx.getTaskAttemptFinishingMonitor()).thenReturn((Object)taskAttemptFinishingMonitor);
        Mockito.when((Object)appCtx.getClock()).thenReturn((Object)clock);
        CheckpointAMPreemptionPolicy policy = new CheckpointAMPreemptionPolicy();
        policy.init(appCtx);
        TaskAttemptListenerImpl listener = new TaskAttemptListenerImpl(appCtx, secret, rmHeartbeatHandler, (AMPreemptionPolicy)policy);
        listener.init(conf);
        listener.start();
        JobId jid = MRBuilderUtils.newJobId((long)12345L, (int)1, (int)1);
        TaskId tid = MRBuilderUtils.newTaskId((JobId)jid, (int)0, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)tid, (int)0);
        appCtx.getTaskAttemptFinishingMonitor().register((Object)attemptId);
        int check = 0;
        while (!eventHandler.timedOut && check++ < 10) {
            Thread.sleep(100L);
        }
        taskAttemptFinishingMonitor.stop();
        Assert.assertTrue((String)"Finishing attempt didn't time out.", (boolean)eventHandler.timedOut);
    }

    public static class MockEventHandler
    implements EventHandler<Event> {
        public boolean timedOut = false;

        public void handle(Event event) {
            TaskAttemptEvent attemptEvent;
            if (event instanceof TaskAttemptEvent && TaskAttemptEventType.TA_TIMED_OUT == (attemptEvent = (TaskAttemptEvent)event).getType()) {
                this.timedOut = true;
            }
        }
    }
}

