/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.rm;

import java.util.EnumSet;
import org.apache.hadoop.mapreduce.v2.app.rm.ResourceCalculatorUtils;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.junit.Assert;
import org.junit.Test;

public class TestResourceCalculatorUtils {
    @Test
    public void testComputeAvailableContainers() throws Exception {
        Resource clusterAvailableResources = Resource.newInstance((int)81920, (int)40);
        Resource nonZeroResource = Resource.newInstance((int)1024, (int)2);
        int expectedNumberOfContainersForMemory = 80;
        int expectedNumberOfContainersForCPU = 20;
        this.verifyDifferentResourceTypes(clusterAvailableResources, nonZeroResource, expectedNumberOfContainersForMemory, expectedNumberOfContainersForCPU);
        Resource zeroMemoryResource = Resource.newInstance((int)0, (int)nonZeroResource.getVirtualCores());
        this.verifyDifferentResourceTypes(clusterAvailableResources, zeroMemoryResource, Integer.MAX_VALUE, expectedNumberOfContainersForCPU);
        Resource zeroCpuResource = Resource.newInstance((long)nonZeroResource.getMemorySize(), (int)0);
        this.verifyDifferentResourceTypes(clusterAvailableResources, zeroCpuResource, expectedNumberOfContainersForMemory, expectedNumberOfContainersForMemory);
    }

    private void verifyDifferentResourceTypes(Resource clusterAvailableResources, Resource nonZeroResource, int expectedNumberOfContainersForMemoryOnly, int expectedNumberOfContainersOverall) {
        Assert.assertEquals((String)"Incorrect number of available containers for Memory", (long)expectedNumberOfContainersForMemoryOnly, (long)ResourceCalculatorUtils.computeAvailableContainers((Resource)clusterAvailableResources, (Resource)nonZeroResource, EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY)));
        Assert.assertEquals((String)"Incorrect number of available containers overall", (long)expectedNumberOfContainersOverall, (long)ResourceCalculatorUtils.computeAvailableContainers((Resource)clusterAvailableResources, (Resource)nonZeroResource, EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.CPU, YarnServiceProtos.SchedulerResourceTypes.MEMORY)));
    }
}

