/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.LocalJobRunner;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.protocol.ClientProtocolProvider;

@InterfaceAudience.Private
public class LocalClientProtocolProvider
extends ClientProtocolProvider {
    public ClientProtocol create(Configuration conf) throws IOException {
        String framework = conf.get("mapreduce.framework.name", "local");
        if (!"local".equals(framework)) {
            return null;
        }
        String tracker = conf.get("mapreduce.jobtracker.address", "local");
        if ("local".equals(tracker)) {
            conf.setInt("mapreduce.job.maps", 1);
            return new LocalJobRunner(conf);
        }
        throw new IOException("Invalid \"mapreduce.jobtracker.address\" configuration value for LocalJobRunner : \"" + tracker + "\"");
    }

    public ClientProtocol create(InetSocketAddress addr, Configuration conf) {
        return null;
    }

    public void close(ClientProtocol clientProtocol) {
    }
}

