/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.LocalDistributedCacheManager;
import org.apache.hadoop.mapred.LocalJobRunnerMetrics;
import org.apache.hadoop.mapred.MROutputFiles;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.mapreduce.v2.LogParams;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LocalJobRunner
implements ClientProtocol {
    public static final Log LOG = LogFactory.getLog(LocalJobRunner.class);
    public static final String LOCAL_MAX_MAPS = "mapreduce.local.map.tasks.maximum";
    private FileSystem fs;
    private HashMap<JobID, Job> jobs = new HashMap();
    private JobConf conf;
    private AtomicInteger map_tasks = new AtomicInteger(0);
    private int reduce_tasks = 0;
    final Random rand = new Random();
    private LocalJobRunnerMetrics myMetrics = null;
    private static final String jobDir = "localRunner/";
    private static final org.apache.hadoop.mapred.Counters EMPTY_COUNTERS = new org.apache.hadoop.mapred.Counters();
    private static int jobid = 0;
    private int randid;
    static final String TASK_CLEANUP_SUFFIX = ".cleanup";
    static final String SUBDIR = "localRunner/";
    static final String JOBCACHE = "jobcache";

    public long getProtocolVersion(String protocol, long clientVersion) {
        return 37L;
    }

    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        return ProtocolSignature.getProtocolSignature((VersionedProtocol)this, (String)protocol, (long)clientVersion, (int)clientMethodsHash);
    }

    public LocalJobRunner(Configuration conf) throws IOException {
        this(new JobConf(conf));
    }

    @Deprecated
    public LocalJobRunner(JobConf conf) throws IOException {
        this.fs = FileSystem.getLocal((Configuration)conf);
        this.conf = conf;
        this.myMetrics = new LocalJobRunnerMetrics(new JobConf((Configuration)conf));
    }

    public synchronized org.apache.hadoop.mapreduce.JobID getNewJobID() {
        return new org.apache.hadoop.mapreduce.JobID("local" + this.randid, ++jobid);
    }

    public JobStatus submitJob(org.apache.hadoop.mapreduce.JobID jobid, String jobSubmitDir, Credentials credentials) throws IOException {
        Job job = new Job(JobID.downgrade((org.apache.hadoop.mapreduce.JobID)jobid), jobSubmitDir);
        job.job.setCredentials(credentials);
        return job.status;
    }

    public void killJob(org.apache.hadoop.mapreduce.JobID id) {
        this.jobs.get((Object)JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id)).killed = true;
        this.jobs.get(JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id)).interrupt();
    }

    public void setJobPriority(org.apache.hadoop.mapreduce.JobID id, String jp) throws IOException {
        throw new UnsupportedOperationException("Changing job priority in LocalJobRunner is not supported.");
    }

    public boolean killTask(TaskAttemptID taskId, boolean shouldFail) throws IOException {
        throw new UnsupportedOperationException("Killing tasks in LocalJobRunner is not supported");
    }

    public TaskReport[] getTaskReports(org.apache.hadoop.mapreduce.JobID id, TaskType type) {
        return new TaskReport[0];
    }

    public JobStatus getJobStatus(org.apache.hadoop.mapreduce.JobID id) {
        Job job = this.jobs.get(JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id));
        if (job != null) {
            return job.status;
        }
        return null;
    }

    public Counters getJobCounters(org.apache.hadoop.mapreduce.JobID id) {
        Job job = this.jobs.get(JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id));
        return new Counters((AbstractCounters)job.getCurrentCounters());
    }

    public String getFilesystemName() throws IOException {
        return this.fs.getUri().toString();
    }

    public ClusterMetrics getClusterMetrics() {
        int numMapTasks = this.map_tasks.get();
        return new ClusterMetrics(numMapTasks, this.reduce_tasks, numMapTasks, this.reduce_tasks, 0, 0, 1, 1, this.jobs.size(), 1, 0, 0);
    }

    public Cluster.JobTrackerStatus getJobTrackerStatus() {
        return Cluster.JobTrackerStatus.RUNNING;
    }

    public long getTaskTrackerExpiryInterval() throws IOException, InterruptedException {
        return 0L;
    }

    public TaskTrackerInfo[] getActiveTrackers() throws IOException, InterruptedException {
        return new TaskTrackerInfo[0];
    }

    public TaskTrackerInfo[] getBlacklistedTrackers() throws IOException, InterruptedException {
        return new TaskTrackerInfo[0];
    }

    public org.apache.hadoop.mapreduce.TaskCompletionEvent[] getTaskCompletionEvents(org.apache.hadoop.mapreduce.JobID jobid, int fromEventId, int maxEvents) throws IOException {
        return org.apache.hadoop.mapreduce.TaskCompletionEvent.EMPTY_ARRAY;
    }

    public JobStatus[] getAllJobs() {
        return null;
    }

    public String[] getTaskDiagnostics(TaskAttemptID taskid) throws IOException {
        return new String[0];
    }

    public String getSystemDir() {
        Path sysDir = new Path(this.conf.get("mapreduce.jobtracker.system.dir", "/tmp/hadoop/mapred/system"));
        return this.fs.makeQualified(sysDir).toString();
    }

    public AccessControlList getQueueAdmins(String queueName) throws IOException {
        return new AccessControlList(" ");
    }

    public String getStagingAreaDir() throws IOException {
        Path stagingRootDir = new Path(this.conf.get("mapreduce.jobtracker.staging.root.dir", "/tmp/hadoop/mapred/staging"));
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        this.randid = this.rand.nextInt(Integer.MAX_VALUE);
        String user = ugi != null ? ugi.getShortUserName() + this.randid : "dummy" + this.randid;
        return this.fs.makeQualified(new Path(stagingRootDir, user + "/.staging")).toString();
    }

    public String getJobHistoryDir() {
        return null;
    }

    public QueueInfo[] getChildQueues(String queueName) throws IOException {
        return null;
    }

    public QueueInfo[] getRootQueues() throws IOException {
        return null;
    }

    public QueueInfo[] getQueues() throws IOException {
        return null;
    }

    public QueueInfo getQueue(String queue) throws IOException {
        return null;
    }

    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException {
        return null;
    }

    public static void setLocalMaxRunningMaps(JobContext job, int maxMaps) {
        job.getConfiguration().setInt(LOCAL_MAX_MAPS, maxMaps);
    }

    public static int getLocalMaxRunningMaps(JobContext job) {
        return job.getConfiguration().getInt(LOCAL_MAX_MAPS, 1);
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        return null;
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        return 0L;
    }

    public LogParams getLogFileParams(org.apache.hadoop.mapreduce.JobID jobID, TaskAttemptID taskAttemptID) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("Not supported");
    }

    static void setupChildMapredLocalDirs(Task t, JobConf conf) {
        String[] localDirs = conf.getTrimmedStrings("mapreduce.cluster.local.dir");
        String jobId = t.getJobID().toString();
        String taskId = t.getTaskID().toString();
        boolean isCleanup = t.isTaskCleanupTask();
        String user = t.getUser();
        StringBuffer childMapredLocalDir = new StringBuffer(localDirs[0] + "/" + LocalJobRunner.getLocalTaskDir(user, jobId, taskId, isCleanup));
        for (int i = 1; i < localDirs.length; ++i) {
            childMapredLocalDir.append("," + localDirs[i] + "/" + LocalJobRunner.getLocalTaskDir(user, jobId, taskId, isCleanup));
        }
        LOG.debug((Object)("mapreduce.cluster.local.dir for child : " + childMapredLocalDir));
        conf.set("mapreduce.cluster.local.dir", childMapredLocalDir.toString());
    }

    static String getLocalTaskDir(String user, String jobid, String taskid, boolean isCleanupAttempt) {
        String taskDir = "localRunner//" + user + "/" + JOBCACHE + "/" + jobid + "/" + taskid;
        if (isCleanupAttempt) {
            taskDir = taskDir + TASK_CLEANUP_SUFFIX;
        }
        return taskDir;
    }

    private class Job
    extends Thread
    implements TaskUmbilicalProtocol {
        private Path systemJobDir;
        private Path systemJobFile;
        private Path localJobDir;
        private Path localJobFile;
        private JobID id;
        private JobConf job;
        private int numMapTasks;
        private float[] partialMapProgress;
        private org.apache.hadoop.mapred.Counters[] mapCounters;
        private org.apache.hadoop.mapred.Counters reduceCounters;
        private org.apache.hadoop.mapred.JobStatus status;
        private List<org.apache.hadoop.mapred.TaskAttemptID> mapIds = Collections.synchronizedList(new ArrayList());
        private JobProfile profile;
        private FileSystem localFs;
        boolean killed = false;
        private LocalDistributedCacheManager localDistributedCacheManager;

        public long getProtocolVersion(String protocol, long clientVersion) {
            return 19L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
            return ProtocolSignature.getProtocolSignature((VersionedProtocol)this, (String)protocol, (long)clientVersion, (int)clientMethodsHash);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Job(JobID jobid, String jobSubmitDir) throws IOException {
            this.systemJobDir = new Path(jobSubmitDir);
            this.systemJobFile = new Path(this.systemJobDir, "job.xml");
            this.id = jobid;
            JobConf conf = new JobConf(this.systemJobFile);
            this.localFs = FileSystem.getLocal((Configuration)conf);
            this.localJobDir = this.localFs.makeQualified(conf.getLocalPath("localRunner/"));
            this.localJobFile = new Path(this.localJobDir, this.id + ".xml");
            this.localDistributedCacheManager = new LocalDistributedCacheManager();
            this.localDistributedCacheManager.setup(conf);
            FSDataOutputStream out = this.localFs.create(this.localJobFile);
            try {
                conf.writeXml((OutputStream)out);
            }
            finally {
                out.close();
            }
            this.job = new JobConf(this.localJobFile);
            if (this.localDistributedCacheManager.hasLocalClasspaths()) {
                this.setContextClassLoader(this.localDistributedCacheManager.makeClassLoader(this.getContextClassLoader()));
            }
            this.profile = new JobProfile(this.job.getUser(), (org.apache.hadoop.mapreduce.JobID)this.id, this.systemJobFile.toString(), "http://localhost:8080/", this.job.getJobName());
            this.status = new org.apache.hadoop.mapred.JobStatus(this.id, 0.0f, 0.0f, org.apache.hadoop.mapred.JobStatus.RUNNING, this.profile.getUser(), this.profile.getJobName(), this.profile.getJobFile(), this.profile.getURL().toString());
            LocalJobRunner.this.jobs.put(this.id, this);
            this.start();
        }

        protected List<MapTaskRunnable> getMapTaskRunnables(JobSplit.TaskSplitMetaInfo[] taskInfo, JobID jobId, Map<org.apache.hadoop.mapred.TaskAttemptID, MapOutputFile> mapOutputFiles) {
            int numTasks = 0;
            ArrayList<MapTaskRunnable> list = new ArrayList<MapTaskRunnable>();
            for (JobSplit.TaskSplitMetaInfo task : taskInfo) {
                list.add(new MapTaskRunnable(task, numTasks++, jobId, mapOutputFiles));
            }
            return list;
        }

        private synchronized void initCounters(int numMaps) {
            this.partialMapProgress = new float[numMaps];
            this.mapCounters = new org.apache.hadoop.mapred.Counters[numMaps];
            for (int i = 0; i < numMaps; ++i) {
                this.mapCounters[i] = EMPTY_COUNTERS;
            }
            this.reduceCounters = EMPTY_COUNTERS;
        }

        protected ExecutorService createMapExecutor(int numMapTasks) {
            int maxMapThreads = this.job.getInt(LocalJobRunner.LOCAL_MAX_MAPS, 1);
            if (maxMapThreads < 1) {
                throw new IllegalArgumentException("Configured mapreduce.local.map.tasks.maximum must be >= 1");
            }
            this.numMapTasks = numMapTasks;
            maxMapThreads = Math.min(maxMapThreads, this.numMapTasks);
            maxMapThreads = Math.max(maxMapThreads, 1);
            this.initCounters(this.numMapTasks);
            LOG.debug((Object)"Starting thread pool executor.");
            LOG.debug((Object)("Max local threads: " + maxMapThreads));
            LOG.debug((Object)("Map tasks to process: " + this.numMapTasks));
            ThreadFactory tf = new ThreadFactoryBuilder().setNameFormat("LocalJobRunner Map Task Executor #%d").build();
            ExecutorService executor = Executors.newFixedThreadPool(maxMapThreads, tf);
            return executor;
        }

        private OutputCommitter createOutputCommitter(boolean newApiCommitter, JobID jobId, Configuration conf) throws Exception {
            OutputCommitter committer = null;
            LOG.info((Object)("OutputCommitter set in config " + conf.get("mapred.output.committer.class")));
            if (newApiCommitter) {
                org.apache.hadoop.mapreduce.TaskID taskId = new org.apache.hadoop.mapreduce.TaskID((org.apache.hadoop.mapreduce.JobID)jobId, TaskType.MAP, 0);
                TaskAttemptID taskAttemptID = new TaskAttemptID(taskId, 0);
                TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl(conf, taskAttemptID);
                OutputFormat outputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)taskContext.getOutputFormatClass(), (Configuration)conf);
                committer = outputFormat.getOutputCommitter((TaskAttemptContext)taskContext);
            } else {
                committer = (OutputCommitter)ReflectionUtils.newInstance((Class)conf.getClass("mapred.output.committer.class", FileOutputCommitter.class, org.apache.hadoop.mapred.OutputCommitter.class), (Configuration)conf);
            }
            LOG.info((Object)("OutputCommitter is " + committer.getClass().getName()));
            return committer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JobID jobId = this.profile.getJobID();
            JobContextImpl jContext = new JobContextImpl(this.job, (org.apache.hadoop.mapreduce.JobID)jobId);
            OutputCommitter outputCommitter = null;
            try {
                outputCommitter = this.createOutputCommitter(LocalJobRunner.this.conf.getUseNewMapper(), jobId, (Configuration)LocalJobRunner.this.conf);
            }
            catch (Exception e) {
                LOG.info((Object)"Failed to createOutputCommitter", (Throwable)e);
                return;
            }
            try {
                block32: {
                    JobSplit.TaskSplitMetaInfo[] taskSplitMetaInfos = SplitMetaInfoReader.readSplitMetaInfo((org.apache.hadoop.mapreduce.JobID)jobId, (FileSystem)this.localFs, (Configuration)LocalJobRunner.this.conf, (Path)this.systemJobDir);
                    int numReduceTasks = this.job.getNumReduceTasks();
                    if (numReduceTasks > 1 || numReduceTasks < 0) {
                        numReduceTasks = 1;
                        this.job.setNumReduceTasks(1);
                    }
                    outputCommitter.setupJob((JobContext)jContext);
                    this.status.setSetupProgress(1.0f);
                    Map<org.apache.hadoop.mapred.TaskAttemptID, MapOutputFile> mapOutputFiles = Collections.synchronizedMap(new HashMap());
                    List<MapTaskRunnable> taskRunnables = this.getMapTaskRunnables(taskSplitMetaInfos, jobId, mapOutputFiles);
                    ExecutorService mapService = this.createMapExecutor(taskRunnables.size());
                    for (Runnable runnable : taskRunnables) {
                        mapService.submit(runnable);
                    }
                    try {
                        mapService.shutdown();
                        LOG.info((Object)"Waiting for map tasks");
                        mapService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                    }
                    catch (InterruptedException ie) {
                        mapService.shutdownNow();
                        throw ie;
                    }
                    LOG.info((Object)"Map task executor complete.");
                    for (MapTaskRunnable mapTaskRunnable : taskRunnables) {
                        if (mapTaskRunnable.storedException == null) continue;
                        throw new Exception(mapTaskRunnable.storedException);
                    }
                    org.apache.hadoop.mapred.TaskAttemptID reduceId = new org.apache.hadoop.mapred.TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, TaskType.REDUCE, 0), 0);
                    try {
                        if (numReduceTasks <= 0) break block32;
                        ReduceTask reduceTask = new ReduceTask(this.systemJobFile.toString(), reduceId, 0, this.mapIds.size(), 1);
                        reduceTask.setUser(UserGroupInformation.getCurrentUser().getShortUserName());
                        JobConf localConf = new JobConf((Configuration)this.job);
                        localConf.set("mapreduce.jobtracker.address", "local");
                        LocalJobRunner.setupChildMapredLocalDirs((Task)reduceTask, localConf);
                        for (int i = 0; i < this.mapIds.size(); ++i) {
                            if (!this.isInterrupted()) {
                                org.apache.hadoop.mapred.TaskAttemptID mapId = this.mapIds.get(i);
                                Path mapOut = mapOutputFiles.get(mapId).getOutputFile();
                                MROutputFiles localOutputFile = new MROutputFiles();
                                localOutputFile.setConf((Configuration)localConf);
                                Path reduceIn = localOutputFile.getInputFileForWrite((org.apache.hadoop.mapreduce.TaskID)mapId.getTaskID(), this.localFs.getFileStatus(mapOut).getLen());
                                if (!this.localFs.mkdirs(reduceIn.getParent())) {
                                    throw new IOException("Mkdirs failed to create " + reduceIn.getParent().toString());
                                }
                                if (this.localFs.rename(mapOut, reduceIn)) continue;
                                throw new IOException("Couldn't rename " + mapOut);
                            }
                            throw new InterruptedException();
                        }
                        if (!this.isInterrupted()) {
                            reduceTask.setJobFile(this.localJobFile.toString());
                            localConf.setUser(reduceTask.getUser());
                            reduceTask.localizeConfiguration(localConf);
                            reduceTask.setConf((Configuration)localConf);
                            LocalJobRunner.this.reduce_tasks += 1;
                            LocalJobRunner.this.myMetrics.launchReduce(reduceTask.getTaskID());
                            reduceTask.run(localConf, (TaskUmbilicalProtocol)this);
                            LocalJobRunner.this.myMetrics.completeReduce(reduceTask.getTaskID());
                            LocalJobRunner.this.reduce_tasks -= 1;
                            break block32;
                        }
                        throw new InterruptedException();
                    }
                    finally {
                        for (MapOutputFile output : mapOutputFiles.values()) {
                            output.removeAll();
                        }
                    }
                }
                outputCommitter.commitJob((JobContext)jContext);
                this.status.setCleanupProgress(1.0f);
                if (this.killed) {
                    this.status.setRunState(org.apache.hadoop.mapred.JobStatus.KILLED);
                } else {
                    this.status.setRunState(org.apache.hadoop.mapred.JobStatus.SUCCEEDED);
                }
                JobEndNotifier.localRunnerNotification((JobConf)this.job, (org.apache.hadoop.mapred.JobStatus)this.status);
            }
            catch (Throwable t) {
                try {
                    outputCommitter.abortJob((JobContext)jContext, JobStatus.State.FAILED);
                }
                catch (IOException ioe) {
                    LOG.info((Object)("Error cleaning up job:" + this.id));
                }
                this.status.setCleanupProgress(1.0f);
                if (this.killed) {
                    this.status.setRunState(org.apache.hadoop.mapred.JobStatus.KILLED);
                } else {
                    this.status.setRunState(org.apache.hadoop.mapred.JobStatus.FAILED);
                }
                LOG.warn((Object)this.id, t);
                JobEndNotifier.localRunnerNotification((JobConf)this.job, (org.apache.hadoop.mapred.JobStatus)this.status);
            }
            finally {
                try {
                    LocalJobRunner.this.fs.delete(this.systemJobFile.getParent(), true);
                    this.localFs.delete(this.localJobFile, true);
                    this.localDistributedCacheManager.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Error cleaning up " + this.id + ": " + e));
                }
            }
        }

        public JvmTask getTask(JvmContext context) {
            return null;
        }

        public synchronized boolean statusUpdate(org.apache.hadoop.mapred.TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            LOG.info((Object)taskStatus.getStateString());
            int taskIndex = this.mapIds.indexOf(taskId);
            if (taskIndex >= 0) {
                float numTasks = this.numMapTasks;
                this.partialMapProgress[taskIndex] = taskStatus.getProgress();
                this.mapCounters[taskIndex] = taskStatus.getCounters();
                float partialProgress = 0.0f;
                for (float f : this.partialMapProgress) {
                    partialProgress += f;
                }
                this.status.setMapProgress(partialProgress / numTasks);
            } else {
                this.reduceCounters = taskStatus.getCounters();
                this.status.setReduceProgress(taskStatus.getProgress());
            }
            return true;
        }

        public synchronized org.apache.hadoop.mapred.Counters getCurrentCounters() {
            if (null == this.mapCounters) {
                return EMPTY_COUNTERS;
            }
            org.apache.hadoop.mapred.Counters current = EMPTY_COUNTERS;
            for (org.apache.hadoop.mapred.Counters c : this.mapCounters) {
                current = org.apache.hadoop.mapred.Counters.sum((org.apache.hadoop.mapred.Counters)current, (org.apache.hadoop.mapred.Counters)c);
            }
            current = org.apache.hadoop.mapred.Counters.sum((org.apache.hadoop.mapred.Counters)current, (org.apache.hadoop.mapred.Counters)this.reduceCounters);
            return current;
        }

        public void commitPending(org.apache.hadoop.mapred.TaskAttemptID taskid, TaskStatus taskStatus) throws IOException, InterruptedException {
            this.statusUpdate(taskid, taskStatus);
        }

        public void reportDiagnosticInfo(org.apache.hadoop.mapred.TaskAttemptID taskid, String trace) {
        }

        public void reportNextRecordRange(org.apache.hadoop.mapred.TaskAttemptID taskid, SortedRanges.Range range) throws IOException {
            LOG.info((Object)("Task " + taskid + " reportedNextRecordRange " + range));
        }

        public boolean ping(org.apache.hadoop.mapred.TaskAttemptID taskid) throws IOException {
            return true;
        }

        public boolean canCommit(org.apache.hadoop.mapred.TaskAttemptID taskid) throws IOException {
            return true;
        }

        public void done(org.apache.hadoop.mapred.TaskAttemptID taskId) throws IOException {
            int taskIndex = this.mapIds.indexOf(taskId);
            if (taskIndex >= 0) {
                this.status.setMapProgress(1.0f);
            } else {
                this.status.setReduceProgress(1.0f);
            }
        }

        public synchronized void fsError(org.apache.hadoop.mapred.TaskAttemptID taskId, String message) throws IOException {
            LOG.fatal((Object)("FSError: " + message + "from task: " + taskId));
        }

        public void shuffleError(org.apache.hadoop.mapred.TaskAttemptID taskId, String message) throws IOException {
            LOG.fatal((Object)("shuffleError: " + message + "from task: " + taskId));
        }

        public synchronized void fatalError(org.apache.hadoop.mapred.TaskAttemptID taskId, String msg) throws IOException {
            LOG.fatal((Object)("Fatal: " + msg + "from task: " + taskId));
        }

        public MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobId, int fromEventId, int maxLocs, org.apache.hadoop.mapred.TaskAttemptID id) throws IOException {
            return new MapTaskCompletionEventsUpdate(TaskCompletionEvent.EMPTY_ARRAY, false);
        }

        protected class MapTaskRunnable
        implements Runnable {
            private final int taskId;
            private final JobSplit.TaskSplitMetaInfo info;
            private final JobID jobId;
            private final JobConf localConf;
            private final Map<org.apache.hadoop.mapred.TaskAttemptID, MapOutputFile> mapOutputFiles;
            public volatile Throwable storedException;

            public MapTaskRunnable(JobSplit.TaskSplitMetaInfo info, int taskId, JobID jobId, Map<org.apache.hadoop.mapred.TaskAttemptID, MapOutputFile> mapOutputFiles) {
                this.info = info;
                this.taskId = taskId;
                this.mapOutputFiles = mapOutputFiles;
                this.jobId = jobId;
                this.localConf = new JobConf((Configuration)Job.this.job);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    org.apache.hadoop.mapred.TaskAttemptID mapId = new org.apache.hadoop.mapred.TaskAttemptID(new TaskID((org.apache.hadoop.mapreduce.JobID)this.jobId, TaskType.MAP, this.taskId), 0);
                    LOG.info((Object)("Starting task: " + mapId));
                    Job.this.mapIds.add(mapId);
                    MapTask map = new MapTask(Job.this.systemJobFile.toString(), mapId, this.taskId, this.info.getSplitIndex(), 1);
                    map.setUser(UserGroupInformation.getCurrentUser().getShortUserName());
                    LocalJobRunner.setupChildMapredLocalDirs((Task)map, this.localConf);
                    MROutputFiles mapOutput = new MROutputFiles();
                    mapOutput.setConf((Configuration)this.localConf);
                    this.mapOutputFiles.put(mapId, (MapOutputFile)mapOutput);
                    map.setJobFile(Job.this.localJobFile.toString());
                    this.localConf.setUser(map.getUser());
                    map.localizeConfiguration(this.localConf);
                    map.setConf((Configuration)this.localConf);
                    try {
                        LocalJobRunner.this.map_tasks.getAndIncrement();
                        LocalJobRunner.this.myMetrics.launchMap(mapId);
                        map.run(this.localConf, (TaskUmbilicalProtocol)Job.this);
                        LocalJobRunner.this.myMetrics.completeMap(mapId);
                    }
                    finally {
                        LocalJobRunner.this.map_tasks.getAndDecrement();
                    }
                    LOG.info((Object)("Finishing task: " + mapId));
                }
                catch (Throwable e) {
                    this.storedException = e;
                }
            }
        }
    }
}

