/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.junit.Assert;
import org.junit.Test;

public class TestHistoryFileManagerInitWithNonRunningDFS {
    private static final String CLUSTER_BASE_DIR = MiniDFSCluster.getBaseDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeepRetryingWhileNameNodeInSafeMode() throws Exception {
        Configuration conf = new Configuration();
        long maxJhsWaitTime = 500L;
        conf.setLong("mapreduce.jobhistory.maximum-start-wait-time-millis", 500L);
        conf.set("hdfs.minidfs.basedir", CLUSTER_BASE_DIR);
        MiniDFSCluster dfsCluster = new MiniDFSCluster.Builder(conf).build();
        try {
            dfsCluster.getFileSystem().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            Assert.assertTrue((boolean)dfsCluster.getFileSystem().isInSafeMode());
            HistoryFileManager hfm = new HistoryFileManager();
            hfm.serviceInit(conf);
            Assert.fail((String)"History File Manager did not retry to connect to name node");
        }
        catch (YarnRuntimeException yex) {
            String expectedExceptionMsg = "Timed out '500ms' waiting for FileSystem to become available";
            Assert.assertEquals((String)"Unexpected reconnect timeout exception message", (Object)expectedExceptionMsg, (Object)yex.getMessage());
        }
        finally {
            dfsCluster.shutdown(true);
        }
    }
}

