/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.v2.api.MRDelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.hs.HistoryServerMemStateStoreService;
import org.apache.hadoop.mapreduce.v2.hs.HistoryServerStateStoreService;
import org.apache.hadoop.mapreduce.v2.hs.TestJHSDelegationTokenSecretManager;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.junit.Assert;
import org.junit.Test;

public class TestJHSDelegationTokenSecretManager {
    @Test
    public void testRecovery() throws IOException {
        Configuration conf = new Configuration();
        HistoryServerMemStateStoreService store = new HistoryServerMemStateStoreService();
        store.init(conf);
        store.start();
        JHSDelegationTokenSecretManagerForTest mgr = new JHSDelegationTokenSecretManagerForTest((HistoryServerStateStoreService)store);
        mgr.startThreads();
        MRDelegationTokenIdentifier tokenId1 = new MRDelegationTokenIdentifier(new Text("tokenOwner"), new Text("tokenRenewer"), new Text("tokenUser"));
        Token token1 = new Token((TokenIdentifier)tokenId1, (SecretManager)mgr);
        MRDelegationTokenIdentifier tokenId2 = new MRDelegationTokenIdentifier(new Text("tokenOwner"), new Text("tokenRenewer"), new Text("tokenUser"));
        Token token2 = new Token((TokenIdentifier)tokenId2, (SecretManager)mgr);
        DelegationKey[] keys = mgr.getAllKeys();
        long tokenRenewDate1 = ((AbstractDelegationTokenSecretManager.DelegationTokenInformation)mgr.getAllTokens().get(tokenId1)).getRenewDate();
        long tokenRenewDate2 = ((AbstractDelegationTokenSecretManager.DelegationTokenInformation)mgr.getAllTokens().get(tokenId2)).getRenewDate();
        mgr.stopThreads();
        mgr = new JHSDelegationTokenSecretManagerForTest((HistoryServerStateStoreService)store);
        mgr.recover(store.loadState());
        List<DelegationKey> recoveredKeys = Arrays.asList(mgr.getAllKeys());
        for (DelegationKey key : keys) {
            Assert.assertTrue((String)"key missing after recovery", (boolean)recoveredKeys.contains(key));
        }
        Assert.assertTrue((String)"token1 missing", (boolean)mgr.getAllTokens().containsKey(tokenId1));
        Assert.assertEquals((String)"token1 renew date", (long)tokenRenewDate1, (long)((AbstractDelegationTokenSecretManager.DelegationTokenInformation)mgr.getAllTokens().get(tokenId1)).getRenewDate());
        Assert.assertTrue((String)"token2 missing", (boolean)mgr.getAllTokens().containsKey(tokenId2));
        Assert.assertEquals((String)"token2 renew date", (long)tokenRenewDate2, (long)((AbstractDelegationTokenSecretManager.DelegationTokenInformation)mgr.getAllTokens().get(tokenId2)).getRenewDate());
        mgr.startThreads();
        mgr.verifyToken((AbstractDelegationTokenIdentifier)tokenId1, token1.getPassword());
        mgr.verifyToken((AbstractDelegationTokenIdentifier)tokenId2, token2.getPassword());
        MRDelegationTokenIdentifier tokenId3 = new MRDelegationTokenIdentifier(new Text("tokenOwner"), new Text("tokenRenewer"), new Text("tokenUser"));
        Token token3 = new Token((TokenIdentifier)tokenId3, (SecretManager)mgr);
        Assert.assertEquals((String)"sequence number restore", (long)(tokenId2.getSequenceNumber() + 1), (long)tokenId3.getSequenceNumber());
        mgr.cancelToken(token1, "tokenOwner");
        MRDelegationTokenIdentifier tokenIdFull = new MRDelegationTokenIdentifier(new Text("tokenOwner/localhost@LOCALHOST"), new Text("tokenRenewer"), new Text("tokenUser"));
        KerberosName.setRules((String)"RULE:[1:$1]\nRULE:[2:$1]");
        Token tokenFull = new Token((TokenIdentifier)tokenIdFull, (SecretManager)mgr);
        try {
            mgr.cancelToken(tokenFull, "tokenOwner");
        }
        catch (AccessControlException ace) {
            Assert.assertTrue((boolean)ace.getMessage().contains("is not authorized to cancel the token"));
        }
        mgr.cancelToken(tokenFull, tokenIdFull.getOwner().toString());
        long tokenRenewDate3 = ((AbstractDelegationTokenSecretManager.DelegationTokenInformation)mgr.getAllTokens().get(tokenId3)).getRenewDate();
        mgr.stopThreads();
        mgr = new JHSDelegationTokenSecretManagerForTest((HistoryServerStateStoreService)store);
        mgr.recover(store.loadState());
        Assert.assertFalse((String)"token1 should be missing", (boolean)mgr.getAllTokens().containsKey(tokenId1));
        Assert.assertTrue((String)"token2 missing", (boolean)mgr.getAllTokens().containsKey(tokenId2));
        Assert.assertEquals((String)"token2 renew date", (long)tokenRenewDate2, (long)((AbstractDelegationTokenSecretManager.DelegationTokenInformation)mgr.getAllTokens().get(tokenId2)).getRenewDate());
        Assert.assertTrue((String)"token3 missing", (boolean)mgr.getAllTokens().containsKey(tokenId3));
        Assert.assertEquals((String)"token3 renew date", (long)tokenRenewDate3, (long)((AbstractDelegationTokenSecretManager.DelegationTokenInformation)mgr.getAllTokens().get(tokenId3)).getRenewDate());
        mgr.startThreads();
        mgr.verifyToken((AbstractDelegationTokenIdentifier)tokenId2, token2.getPassword());
        mgr.verifyToken((AbstractDelegationTokenIdentifier)tokenId3, token3.getPassword());
        mgr.stopThreads();
    }
}

