/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.util.Collection;
import java.util.NavigableSet;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestJobIdHistoryFileInfoMap {
    private boolean checkSize(HistoryFileManager.JobIdHistoryFileInfoMap map, int size) throws InterruptedException {
        for (int i = 0; i < 100; ++i) {
            if (map.size() == size) {
                return true;
            }
            Thread.sleep(20L);
        }
        return false;
    }

    @Test(timeout=2000L)
    public void testWithSingleElement() throws InterruptedException {
        HistoryFileManager.JobIdHistoryFileInfoMap mapWithSize = new HistoryFileManager.JobIdHistoryFileInfoMap();
        JobId jobId = MRBuilderUtils.newJobId((long)1L, (int)1, (int)1);
        HistoryFileManager.HistoryFileInfo fileInfo1 = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)fileInfo1.getJobId()).thenReturn((Object)jobId);
        Assert.assertEquals((String)"Incorrect return on putIfAbsent()", null, (Object)mapWithSize.putIfAbsent(jobId, fileInfo1));
        Assert.assertEquals((String)"Incorrect return on putIfAbsent()", (Object)fileInfo1, (Object)mapWithSize.putIfAbsent(jobId, fileInfo1));
        Assert.assertEquals((String)"Incorrect get()", (Object)fileInfo1, (Object)mapWithSize.get(jobId));
        Assert.assertTrue((String)"Incorrect size()", (boolean)this.checkSize(mapWithSize, 1));
        NavigableSet set = mapWithSize.navigableKeySet();
        Assert.assertEquals((String)"Incorrect navigableKeySet()", (long)1L, (long)set.size());
        Assert.assertTrue((String)"Incorrect navigableKeySet()", (boolean)set.contains(jobId));
        Collection values = mapWithSize.values();
        Assert.assertEquals((String)"Incorrect values()", (long)1L, (long)values.size());
        Assert.assertTrue((String)"Incorrect values()", (boolean)values.contains(fileInfo1));
    }
}

