/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.MockAppContext;
import org.apache.hadoop.mapreduce.v2.app.webapp.TestAMWebApp;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsAboutPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsAttemptsPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsConfPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsController;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsCountersPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsJobPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsSingleCounterPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsTaskPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsTasksPage;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.log.AggregatedLogsPage;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHSWebApp {
    private static final Log LOG = LogFactory.getLog(TestHSWebApp.class);

    @Test
    public void testAppControllerIndex() {
        MockAppContext ctx = new MockAppContext(0, 1, 1, 1);
        Injector injector = WebAppTests.createMockInjector(AppContext.class, (Object)ctx, (Module[])new Module[0]);
        HsController controller = (HsController)injector.getInstance(HsController.class);
        controller.index();
        Assert.assertEquals((Object)ctx.getApplicationID().toString(), (Object)controller.get("app.id", ""));
    }

    @Test
    public void testJobView() {
        LOG.info((Object)"HsJobPage");
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map params = TestAMWebApp.getJobParams((AppContext)appContext);
        WebAppTests.testPage(HsJobPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testTasksView() {
        LOG.info((Object)"HsTasksPage");
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map params = TestAMWebApp.getTaskParams((AppContext)appContext);
        WebAppTests.testPage(HsTasksPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testTasksViewNaturalSortType() {
        LOG.info((Object)"HsTasksPage");
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map params = TestAMWebApp.getTaskParams((AppContext)appContext);
        Injector testPage = WebAppTests.testPage(HsTasksPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
        View viewInstance = (View)testPage.getInstance(HsTasksPage.class);
        Map moreParams = viewInstance.context().requestContext().moreParams();
        String appTableColumnsMeta = (String)moreParams.get("ui.dataTables.selector.init");
        Assert.assertTrue((appTableColumnsMeta.indexOf("natural") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testTaskView() {
        LOG.info((Object)"HsTaskPage");
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map params = TestAMWebApp.getTaskParams((AppContext)appContext);
        WebAppTests.testPage(HsTaskPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testTaskViewNaturalSortType() {
        LOG.info((Object)"HsTaskPage");
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map params = TestAMWebApp.getTaskParams((AppContext)appContext);
        Injector testPage = WebAppTests.testPage(HsTaskPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
        View viewInstance = (View)testPage.getInstance(HsTaskPage.class);
        Map moreParams = viewInstance.context().requestContext().moreParams();
        String appTableColumnsMeta = (String)moreParams.get("ui.dataTables.attempts.init");
        Assert.assertTrue((appTableColumnsMeta.indexOf("natural") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAttemptsWithJobView() {
        LOG.info((Object)"HsAttemptsPage with data");
        MockAppContext ctx = new MockAppContext(0, 1, 1, 1);
        JobId id = (JobId)ctx.getAllJobs().keySet().iterator().next();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("job.id", id.toString());
        params.put("task.type", "m");
        params.put("attempt.state", "SUCCESSFUL");
        WebAppTests.testPage(HsAttemptsPage.class, AppContext.class, (Object)ctx, params, (Module[])new Module[0]);
    }

    @Test
    public void testAttemptsView() {
        LOG.info((Object)"HsAttemptsPage");
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map params = TestAMWebApp.getTaskParams((AppContext)appContext);
        WebAppTests.testPage(HsAttemptsPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testConfView() {
        LOG.info((Object)"HsConfPage");
        WebAppTests.testPage(HsConfPage.class, AppContext.class, (Object)new MockAppContext(0, 1, 1, 1), (Module[])new Module[0]);
    }

    @Test
    public void testAboutView() {
        LOG.info((Object)"HsAboutPage");
        WebAppTests.testPage(HsAboutPage.class, AppContext.class, (Object)new MockAppContext(0, 1, 1, 1), (Module[])new Module[0]);
    }

    @Test
    public void testJobCounterView() {
        LOG.info((Object)"JobCounterView");
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1);
        Map params = TestAMWebApp.getJobParams((AppContext)appContext);
        WebAppTests.testPage(HsCountersPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testJobCounterViewForKilledJob() {
        LOG.info((Object)"JobCounterViewForKilledJob");
        MockAppContext appContext = new MockAppContext(0, 1, 1, 1, true);
        Map params = TestAMWebApp.getJobParams((AppContext)appContext);
        WebAppTests.testPage(HsCountersPage.class, AppContext.class, (Object)appContext, (Map)params, (Module[])new Module[0]);
    }

    @Test
    public void testSingleCounterView() {
        LOG.info((Object)"HsSingleCounterPage");
        WebAppTests.testPage(HsSingleCounterPage.class, AppContext.class, (Object)new MockAppContext(0, 1, 1, 1), (Module[])new Module[0]);
    }

    @Test
    public void testLogsView1() throws IOException {
        LOG.info((Object)"HsLogsPage");
        Injector injector = WebAppTests.testPage(AggregatedLogsPage.class, AppContext.class, (Object)new MockAppContext(0, 1, 1, 1), (Module[])new Module[0]);
        PrintWriter spyPw = WebAppTests.getPrintWriter((Injector)injector);
        ((PrintWriter)Mockito.verify((Object)spyPw)).write("Cannot get container logs without a ContainerId");
        ((PrintWriter)Mockito.verify((Object)spyPw)).write("Cannot get container logs without a NodeId");
        ((PrintWriter)Mockito.verify((Object)spyPw)).write("Cannot get container logs without an app owner");
    }

    @Test
    public void testLogsView2() throws IOException {
        LOG.info((Object)"HsLogsPage with data");
        MockAppContext ctx = new MockAppContext(0, 1, 1, 1);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("container.id", MRApp.newContainerId((int)1, (int)1, (long)333L, (int)1).toString());
        params.put("nm.id", NodeId.newInstance((String)"localhost", (int)1234).toString());
        params.put("entity.string", "container_10_0001_01_000001");
        params.put("app.owner", "owner");
        Injector injector = WebAppTests.testPage(AggregatedLogsPage.class, AppContext.class, (Object)ctx, params, (Module[])new Module[0]);
        PrintWriter spyPw = WebAppTests.getPrintWriter((Injector)injector);
        ((PrintWriter)Mockito.verify((Object)spyPw)).write("Aggregation is not enabled. Try the nodemanager at localhost:1234");
    }

    @Test
    public void testLogsViewSingle() throws IOException {
        LOG.info((Object)"HsLogsPage with params for single log and data limits");
        MockAppContext ctx = new MockAppContext(0, 1, 1, 1);
        HashMap<String, String> params = new HashMap<String, String>();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.log-aggregation-enable", true);
        params.put("start", "-2048");
        params.put("end", "-1024");
        params.put("log.type", "syslog");
        params.put("container.id", MRApp.newContainerId((int)1, (int)1, (long)333L, (int)1).toString());
        params.put("nm.id", NodeId.newInstance((String)"localhost", (int)1234).toString());
        params.put("entity.string", "container_10_0001_01_000001");
        params.put("app.owner", "owner");
        Injector injector = WebAppTests.testPage(AggregatedLogsPage.class, AppContext.class, (Object)ctx, params, (Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});
        PrintWriter spyPw = WebAppTests.getPrintWriter((Injector)injector);
        ((PrintWriter)Mockito.verify((Object)spyPw)).write("Logs not available for container_10_0001_01_000001. Aggregation may not be complete, Check back later or try the nodemanager at localhost:1234");
    }

    @Test
    public void testLogsViewBadStartEnd() throws IOException {
        LOG.info((Object)"HsLogsPage with bad start/end params");
        MockAppContext ctx = new MockAppContext(0, 1, 1, 1);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("start", "foo");
        params.put("end", "bar");
        params.put("container.id", MRApp.newContainerId((int)1, (int)1, (long)333L, (int)1).toString());
        params.put("nm.id", NodeId.newInstance((String)"localhost", (int)1234).toString());
        params.put("entity.string", "container_10_0001_01_000001");
        params.put("app.owner", "owner");
        Injector injector = WebAppTests.testPage(AggregatedLogsPage.class, AppContext.class, (Object)ctx, params, (Module[])new Module[0]);
        PrintWriter spyPw = WebAppTests.getPrintWriter((Injector)injector);
        ((PrintWriter)Mockito.verify((Object)spyPw)).write("Invalid log start value: foo");
        ((PrintWriter)Mockito.verify((Object)spyPw)).write("Invalid log end value: bar");
    }
}

