/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.hs.webapp.TestHsJobBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlBlockForTest;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestHsJobBlock {
    @Test
    public void testHsJobBlockForOversizeJobShouldDisplayWarningMessage() {
        int maxAllowedTaskNum = 100;
        Configuration config = new Configuration();
        config.setInt("mapreduce.jobhistory.loadedjob.tasks.max", maxAllowedTaskNum);
        JobHistoryStubWithAllOversizeJobs jobHistory = new JobHistoryStubWithAllOversizeJobs(maxAllowedTaskNum);
        jobHistory.init(config);
        1 jobBlock = new /* Unavailable Anonymous Inner Class!! */;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        HtmlBlock.Block block = TestHsJobBlock.createBlockToCreateTo((OutputStream)outputStream);
        jobBlock.render(block);
        block.getWriter().flush();
        String out = outputStream.toString();
        Assert.assertTrue((String)"Should display warning message for jobs that have too many tasks", (boolean)out.contains("Any job larger than " + maxAllowedTaskNum + " will not be loaded"));
    }

    @Test
    public void testHsJobBlockForNormalSizeJobShouldNotDisplayWarningMessage() {
        Configuration config = new Configuration();
        config.setInt("mapreduce.jobhistory.loadedjob.tasks.max", -1);
        JobHitoryStubWithAllNormalSizeJobs jobHistory = new JobHitoryStubWithAllNormalSizeJobs();
        jobHistory.init(config);
        2 jobBlock = new /* Unavailable Anonymous Inner Class!! */;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        HtmlBlock.Block block = TestHsJobBlock.createBlockToCreateTo((OutputStream)outputStream);
        jobBlock.render(block);
        block.getWriter().flush();
        String out = outputStream.toString();
        Assert.assertTrue((String)"Should display job overview for the job.", (boolean)out.contains("ApplicationMaster"));
    }

    private static HtmlBlock.Block createBlockToCreateTo(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        HtmlBlockForTest html = new HtmlBlockForTest();
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

