/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.StringReader;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.hs.MockHistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsWebApp;
import org.apache.hadoop.mapreduce.v2.hs.webapp.TestHsWebServicesJobs;
import org.apache.hadoop.mapreduce.v2.hs.webapp.VerifyJobsUtils;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestHsWebServicesJobs
extends JerseyTestBase {
    private static Configuration conf = new Configuration();
    private static MockHistoryContext appContext;
    private static HsWebApp webApp;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestHsWebServicesJobs() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.mapreduce.v2.hs.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testJobs() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jobs = json.getJSONObject("jobs");
        JSONArray arr = jobs.getJSONArray("job");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)arr.length());
        JSONObject info = arr.getJSONObject(0);
        Job job = appContext.getPartialJob(MRApps.toJobID((String)info.getString("id")));
        VerifyJobsUtils.verifyHsJobPartial((JSONObject)info, (Job)job);
    }

    @Test
    public void testJobsSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jobs = json.getJSONObject("jobs");
        JSONArray arr = jobs.getJSONArray("job");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)arr.length());
        JSONObject info = arr.getJSONObject(0);
        Job job = appContext.getPartialJob(MRApps.toJobID((String)info.getString("id")));
        VerifyJobsUtils.verifyHsJobPartial((JSONObject)info, (Job)job);
    }

    @Test
    public void testJobsDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jobs = json.getJSONObject("jobs");
        JSONArray arr = jobs.getJSONArray("job");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)arr.length());
        JSONObject info = arr.getJSONObject(0);
        Job job = appContext.getPartialJob(MRApps.toJobID((String)info.getString("id")));
        VerifyJobsUtils.verifyHsJobPartial((JSONObject)info, (Job)job);
    }

    @Test
    public void testJobsXML() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList jobs = dom.getElementsByTagName("jobs");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)jobs.getLength());
        NodeList job = dom.getElementsByTagName("job");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)job.getLength());
        this.verifyHsJobPartialXML(job, appContext);
    }

    public void verifyHsJobPartialXML(NodeList nodes, MockHistoryContext appContext) {
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            Job job = appContext.getPartialJob(MRApps.toJobID((String)WebServicesTestUtils.getXmlString((Element)element, (String)"id")));
            Assert.assertNotNull((String)"Job not found - output incorrect", (Object)job);
            VerifyJobsUtils.verifyHsJobGeneric((Job)job, (String)WebServicesTestUtils.getXmlString((Element)element, (String)"id"), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"user"), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"name"), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"state"), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"queue"), (long)WebServicesTestUtils.getXmlLong((Element)element, (String)"startTime"), (long)WebServicesTestUtils.getXmlLong((Element)element, (String)"finishTime"), (int)WebServicesTestUtils.getXmlInt((Element)element, (String)"mapsTotal"), (int)WebServicesTestUtils.getXmlInt((Element)element, (String)"mapsCompleted"), (int)WebServicesTestUtils.getXmlInt((Element)element, (String)"reducesTotal"), (int)WebServicesTestUtils.getXmlInt((Element)element, (String)"reducesCompleted"));
        }
    }

    public void verifyHsJobXML(NodeList nodes, AppContext appContext) {
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            Job job = appContext.getJob(MRApps.toJobID((String)WebServicesTestUtils.getXmlString((Element)element, (String)"id")));
            Assert.assertNotNull((String)"Job not found - output incorrect", (Object)job);
            VerifyJobsUtils.verifyHsJobGeneric((Job)job, (String)WebServicesTestUtils.getXmlString((Element)element, (String)"id"), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"user"), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"name"), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"state"), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"queue"), (long)WebServicesTestUtils.getXmlLong((Element)element, (String)"startTime"), (long)WebServicesTestUtils.getXmlLong((Element)element, (String)"finishTime"), (int)WebServicesTestUtils.getXmlInt((Element)element, (String)"mapsTotal"), (int)WebServicesTestUtils.getXmlInt((Element)element, (String)"mapsCompleted"), (int)WebServicesTestUtils.getXmlInt((Element)element, (String)"reducesTotal"), (int)WebServicesTestUtils.getXmlInt((Element)element, (String)"reducesCompleted"));
            VerifyJobsUtils.verifyHsJobGenericSecure((Job)job, (Boolean)WebServicesTestUtils.getXmlBoolean((Element)element, (String)"uberized"), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"diagnostics"), (long)WebServicesTestUtils.getXmlLong((Element)element, (String)"avgMapTime"), (long)WebServicesTestUtils.getXmlLong((Element)element, (String)"avgReduceTime"), (long)WebServicesTestUtils.getXmlLong((Element)element, (String)"avgShuffleTime"), (long)WebServicesTestUtils.getXmlLong((Element)element, (String)"avgMergeTime"), (int)WebServicesTestUtils.getXmlInt((Element)element, (String)"failedReduceAttempts"), (int)WebServicesTestUtils.getXmlInt((Element)element, (String)"killedReduceAttempts"), (int)WebServicesTestUtils.getXmlInt((Element)element, (String)"successfulReduceAttempts"), (int)WebServicesTestUtils.getXmlInt((Element)element, (String)"failedMapAttempts"), (int)WebServicesTestUtils.getXmlInt((Element)element, (String)"killedMapAttempts"), (int)WebServicesTestUtils.getXmlInt((Element)element, (String)"successfulMapAttempts"));
        }
    }

    @Test
    public void testJobId() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("job");
            VerifyJobsUtils.verifyHsJob((JSONObject)info, (Job)appContext.getJob(id));
        }
    }

    @Test
    public void testJobIdSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId + "/").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("job");
            VerifyJobsUtils.verifyHsJob((JSONObject)info, (Job)appContext.getJob(id));
        }
    }

    @Test
    public void testJobIdDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("job");
            VerifyJobsUtils.verifyHsJob((JSONObject)info, (Job)appContext.getJob(id));
        }
    }

    @Test
    public void testJobIdNonExist() throws JSONException, Exception {
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path("job_0_1234").get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: job, job_0_1234, is not found", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
        }
    }

    @Test
    public void testJobIdInvalid() throws JSONException, Exception {
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path("job_foo").accept(new String[]{"application/json"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            this.verifyJobIdInvalid(message, type, classname);
        }
    }

    @Test
    public void testJobIdInvalidDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path("job_foo").get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            this.verifyJobIdInvalid(message, type, classname);
        }
    }

    @Test
    public void testJobIdInvalidXML() throws JSONException, Exception {
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path("job_foo").accept(new String[]{"application/xml"}).get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
            String msg = (String)response.getEntity(String.class);
            System.out.println(msg);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(msg));
            Document dom = db.parse(is);
            NodeList nodes = dom.getElementsByTagName("RemoteException");
            Element element = (Element)nodes.item(0);
            String message = WebServicesTestUtils.getXmlString((Element)element, (String)"message");
            String type = WebServicesTestUtils.getXmlString((Element)element, (String)"exception");
            String classname = WebServicesTestUtils.getXmlString((Element)element, (String)"javaClassName");
            this.verifyJobIdInvalid(message, type, classname);
        }
    }

    private void verifyJobIdInvalid(String message, String type, String classname) {
        WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: JobId string : job_foo is not properly formed", (String)message);
        WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
        WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
    }

    @Test
    public void testJobIdInvalidBogus() throws JSONException, Exception {
        WebResource r = this.resource();
        try {
            r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path("bogusfoo").get(JSONObject.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
            JSONObject exception = msg.getJSONObject("RemoteException");
            Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
            String message = exception.getString("message");
            String type = exception.getString("exception");
            String classname = exception.getString("javaClassName");
            WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: JobId string : bogusfoo is not properly formed", (String)message);
            WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"NotFoundException", (String)type);
            WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.NotFoundException", (String)classname);
        }
    }

    @Test
    public void testJobIdXML() throws Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).accept(new String[]{"application/xml"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
            String xml = (String)response.getEntity(String.class);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document dom = db.parse(is);
            NodeList job = dom.getElementsByTagName("job");
            this.verifyHsJobXML(job, (AppContext)appContext);
        }
    }

    @Test
    public void testJobCounters() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("counters").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("jobCounters");
            this.verifyHsJobCounters(info, appContext.getJob(id));
        }
    }

    @Test
    public void testJobCountersSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("counters/").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("jobCounters");
            this.verifyHsJobCounters(info, appContext.getJob(id));
        }
    }

    @Test
    public void testJobCountersForKilledJob() throws Exception {
        WebResource r = this.resource();
        appContext = new MockHistoryContext(0, 1, 1, 1, true);
        this.injector = Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("counters/").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("jobCounters");
            WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((JobId)id), (String)info.getString("id"));
            Assert.assertTrue((String)"Job shouldn't contain any counters", (info.length() == 1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testJobCountersDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("counters/").get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("jobCounters");
            this.verifyHsJobCounters(info, appContext.getJob(id));
        }
    }

    @Test
    public void testJobCountersXML() throws Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("counters").accept(new String[]{"application/xml"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
            String xml = (String)response.getEntity(String.class);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document dom = db.parse(is);
            NodeList info = dom.getElementsByTagName("jobCounters");
            this.verifyHsJobCountersXML(info, appContext.getJob(id));
        }
    }

    public void verifyHsJobCounters(JSONObject info, Job job) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)info.length());
        WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((JobId)job.getID()), (String)info.getString("id"));
        JSONArray counterGroups = info.getJSONArray("counterGroup");
        for (int i = 0; i < counterGroups.length(); ++i) {
            JSONObject counterGroup = counterGroups.getJSONObject(i);
            String name = counterGroup.getString("counterGroupName");
            Assert.assertTrue((String)"name not set", (name != null && !name.isEmpty() ? 1 : 0) != 0);
            JSONArray counters = counterGroup.getJSONArray("counter");
            for (int j = 0; j < counters.length(); ++j) {
                JSONObject counter = counters.getJSONObject(j);
                String counterName = counter.getString("name");
                Assert.assertTrue((String)"counter name not set", (counterName != null && !counterName.isEmpty() ? 1 : 0) != 0);
                long mapValue = counter.getLong("mapCounterValue");
                Assert.assertTrue((String)"mapCounterValue  >= 0", (mapValue >= 0L ? 1 : 0) != 0);
                long reduceValue = counter.getLong("reduceCounterValue");
                Assert.assertTrue((String)"reduceCounterValue  >= 0", (reduceValue >= 0L ? 1 : 0) != 0);
                long totalValue = counter.getLong("totalCounterValue");
                Assert.assertTrue((String)"totalCounterValue  >= 0", (totalValue >= 0L ? 1 : 0) != 0);
            }
        }
    }

    public void verifyHsJobCountersXML(NodeList nodes, Job job) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            Assert.assertNotNull((String)"Job not found - output incorrect", (Object)job);
            WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((JobId)job.getID()), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"id"));
            NodeList groups = element.getElementsByTagName("counterGroup");
            for (int j = 0; j < groups.getLength(); ++j) {
                Element counters = (Element)groups.item(j);
                Assert.assertNotNull((String)"should have counters in the web service info", (Object)counters);
                String name = WebServicesTestUtils.getXmlString((Element)counters, (String)"counterGroupName");
                Assert.assertTrue((String)"name not set", (name != null && !name.isEmpty() ? 1 : 0) != 0);
                NodeList counterArr = counters.getElementsByTagName("counter");
                for (int z = 0; z < counterArr.getLength(); ++z) {
                    Element counter = (Element)counterArr.item(z);
                    String counterName = WebServicesTestUtils.getXmlString((Element)counter, (String)"name");
                    Assert.assertTrue((String)"counter name not set", (counterName != null && !counterName.isEmpty() ? 1 : 0) != 0);
                    long mapValue = WebServicesTestUtils.getXmlLong((Element)counter, (String)"mapCounterValue");
                    Assert.assertTrue((String)"mapCounterValue not >= 0", (mapValue >= 0L ? 1 : 0) != 0);
                    long reduceValue = WebServicesTestUtils.getXmlLong((Element)counter, (String)"reduceCounterValue");
                    Assert.assertTrue((String)"reduceCounterValue  >= 0", (reduceValue >= 0L ? 1 : 0) != 0);
                    long totalValue = WebServicesTestUtils.getXmlLong((Element)counter, (String)"totalCounterValue");
                    Assert.assertTrue((String)"totalCounterValue  >= 0", (totalValue >= 0L ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testJobAttempts() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("jobattempts").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("jobAttempts");
            this.verifyHsJobAttempts(info, appContext.getJob(id));
        }
    }

    @Test
    public void testJobAttemptsSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("jobattempts/").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("jobAttempts");
            this.verifyHsJobAttempts(info, appContext.getJob(id));
        }
    }

    @Test
    public void testJobAttemptsDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("jobattempts").get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("jobAttempts");
            this.verifyHsJobAttempts(info, appContext.getJob(id));
        }
    }

    @Test
    public void testJobAttemptsXML() throws Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("jobattempts").accept(new String[]{"application/xml"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
            String xml = (String)response.getEntity(String.class);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document dom = db.parse(is);
            NodeList attempts = dom.getElementsByTagName("jobAttempts");
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)attempts.getLength());
            NodeList info = dom.getElementsByTagName("jobAttempt");
            this.verifyHsJobAttemptsXML(info, appContext.getJob(id));
        }
    }

    public void verifyHsJobAttempts(JSONObject info, Job job) throws JSONException {
        JSONArray attempts = info.getJSONArray("jobAttempt");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)attempts.length());
        for (int i = 0; i < attempts.length(); ++i) {
            JSONObject attempt = attempts.getJSONObject(i);
            this.verifyHsJobAttemptsGeneric(job, attempt.getString("nodeHttpAddress"), attempt.getString("nodeId"), attempt.getInt("id"), attempt.getLong("startTime"), attempt.getString("containerId"), attempt.getString("logsLink"));
        }
    }

    public void verifyHsJobAttemptsXML(NodeList nodes, Job job) {
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyHsJobAttemptsGeneric(job, WebServicesTestUtils.getXmlString((Element)element, (String)"nodeHttpAddress"), WebServicesTestUtils.getXmlString((Element)element, (String)"nodeId"), WebServicesTestUtils.getXmlInt((Element)element, (String)"id"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startTime"), WebServicesTestUtils.getXmlString((Element)element, (String)"containerId"), WebServicesTestUtils.getXmlString((Element)element, (String)"logsLink"));
        }
    }

    public void verifyHsJobAttemptsGeneric(Job job, String nodeHttpAddress, String nodeId, int id, long startTime, String containerId, String logsLink) {
        boolean attemptFound = false;
        for (AMInfo amInfo : job.getAMInfos()) {
            if (amInfo.getAppAttemptId().getAttemptId() != id) continue;
            attemptFound = true;
            String nmHost = amInfo.getNodeManagerHost();
            int nmHttpPort = amInfo.getNodeManagerHttpPort();
            int nmPort = amInfo.getNodeManagerPort();
            WebServicesTestUtils.checkStringMatch((String)"nodeHttpAddress", (String)(nmHost + ":" + nmHttpPort), (String)nodeHttpAddress);
            Assert.assertTrue((String)"startime not greater than 0", (startTime > 0L ? 1 : 0) != 0);
            WebServicesTestUtils.checkStringMatch((String)"containerId", (String)amInfo.getContainerId().toString(), (String)containerId);
            String localLogsLink = StringHelper.join((Object[])new Object[]{"hsmockwebapp", StringHelper.ujoin((String)"logs", (String[])new String[]{nodeId, containerId, MRApps.toString((JobId)job.getID()), job.getUserName()})});
            Assert.assertTrue((String)"logsLink", (boolean)logsLink.contains(localLogsLink));
        }
        Assert.assertTrue((String)("attempt: " + id + " was not found"), (boolean)attemptFound);
    }

    static /* synthetic */ MockHistoryContext access$002(MockHistoryContext x0) {
        appContext = x0;
        return appContext;
    }

    static /* synthetic */ HsWebApp access$102(HsWebApp x0) {
        webApp = x0;
        return webApp;
    }

    static /* synthetic */ HsWebApp access$100() {
        return webApp;
    }

    static /* synthetic */ MockHistoryContext access$000() {
        return appContext;
    }

    static /* synthetic */ Configuration access$200() {
        return conf;
    }

    static /* synthetic */ Injector access$300(TestHsWebServicesJobs x0) {
        return x0.injector;
    }
}

