/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.hs.CompletedJob;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.hs.TestHistoryFileManager;
import org.apache.hadoop.mapreduce.v2.hs.UnparsedJob;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobIndexInfo;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Mockito;

public class TestHistoryFileManager {
    private static MiniDFSCluster dfsCluster = null;
    private static MiniDFSCluster dfsCluster2 = null;
    private static String coreSitePath;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpClass() throws Exception {
        coreSitePath = "." + File.separator + "target" + File.separator + "test-classes" + File.separator + "core-site.xml";
        HdfsConfiguration conf = new HdfsConfiguration();
        HdfsConfiguration conf2 = new HdfsConfiguration();
        dfsCluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        conf2.set("hdfs.minidfs.basedir", conf.get("hdfs.minidfs.basedir", MiniDFSCluster.getBaseDirectory()) + "_2");
        dfsCluster2 = new MiniDFSCluster.Builder((Configuration)conf2).build();
    }

    @AfterClass
    public static void cleanUpClass() throws Exception {
        dfsCluster.shutdown();
        dfsCluster2.shutdown();
    }

    @After
    public void cleanTest() throws Exception {
        new File(coreSitePath).delete();
        dfsCluster.getFileSystem().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        dfsCluster2.getFileSystem().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
    }

    private String getDoneDirNameForTest() {
        return "/" + this.name.getMethodName();
    }

    private String getIntermediateDoneDirNameForTest() {
        return "/intermediate_" + this.name.getMethodName();
    }

    private void testTryCreateHistoryDirs(Configuration conf, boolean expected) throws Exception {
        conf.set("mapreduce.jobhistory.done-dir", this.getDoneDirNameForTest());
        conf.set("mapreduce.jobhistory.intermediate-done-dir", this.getIntermediateDoneDirNameForTest());
        HistoryFileManager hfm = new HistoryFileManager();
        hfm.conf = conf;
        Assert.assertEquals((Object)expected, (Object)hfm.tryCreatingHistoryDirs(false));
    }

    @Test
    public void testCreateDirsWithoutFileSystem() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("fs.defaultFS", "hdfs://localhost:1");
        this.testTryCreateHistoryDirs((Configuration)conf, false);
    }

    @Test
    public void testCreateDirsWithFileSystem() throws Exception {
        dfsCluster.getFileSystem().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        Assert.assertFalse((boolean)dfsCluster.getFileSystem().isInSafeMode());
        this.testTryCreateHistoryDirs(dfsCluster.getConfiguration(0), true);
    }

    @Test
    public void testCreateDirsWithAdditionalFileSystem() throws Exception {
        dfsCluster.getFileSystem().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        dfsCluster2.getFileSystem().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        Assert.assertFalse((boolean)dfsCluster.getFileSystem().isInSafeMode());
        Assert.assertFalse((boolean)dfsCluster2.getFileSystem().isInSafeMode());
        Configuration conf = new Configuration(false);
        conf.set("fs.defaultFS", dfsCluster.getURI().toString());
        FileOutputStream os = new FileOutputStream(coreSitePath);
        conf.writeXml((OutputStream)os);
        os.close();
        this.testTryCreateHistoryDirs(dfsCluster2.getConfiguration(0), true);
        Assert.assertTrue((boolean)dfsCluster.getFileSystem().exists(new Path(this.getDoneDirNameForTest())));
        Assert.assertTrue((boolean)dfsCluster.getFileSystem().exists(new Path(this.getIntermediateDoneDirNameForTest())));
        Assert.assertFalse((boolean)dfsCluster2.getFileSystem().exists(new Path(this.getDoneDirNameForTest())));
        Assert.assertFalse((boolean)dfsCluster2.getFileSystem().exists(new Path(this.getIntermediateDoneDirNameForTest())));
    }

    @Test
    public void testCreateDirsWithFileSystemInSafeMode() throws Exception {
        dfsCluster.getFileSystem().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        Assert.assertTrue((boolean)dfsCluster.getFileSystem().isInSafeMode());
        this.testTryCreateHistoryDirs(dfsCluster.getConfiguration(0), false);
    }

    private void testCreateHistoryDirs(Configuration conf, Clock clock) throws Exception {
        conf.set("mapreduce.jobhistory.done-dir", "/" + UUID.randomUUID());
        conf.set("mapreduce.jobhistory.intermediate-done-dir", "/" + UUID.randomUUID());
        HistoryFileManager hfm = new HistoryFileManager();
        hfm.conf = conf;
        hfm.createHistoryDirs(clock, 500L, 2000L);
    }

    @Test
    public void testCreateDirsWithFileSystemBecomingAvailBeforeTimeout() throws Exception {
        dfsCluster.getFileSystem().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        Assert.assertTrue((boolean)dfsCluster.getFileSystem().isInSafeMode());
        new /* Unavailable Anonymous Inner Class!! */.start();
        this.testCreateHistoryDirs(dfsCluster.getConfiguration(0), (Clock)SystemClock.getInstance());
    }

    @Test(expected=YarnRuntimeException.class)
    public void testCreateDirsWithFileSystemNotBecomingAvailBeforeTimeout() throws Exception {
        dfsCluster.getFileSystem().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        Assert.assertTrue((boolean)dfsCluster.getFileSystem().isInSafeMode());
        ControlledClock clock = new ControlledClock();
        clock.setTime(1L);
        new /* Unavailable Anonymous Inner Class!! */.start();
        this.testCreateHistoryDirs(dfsCluster.getConfiguration(0), (Clock)clock);
    }

    @Test
    public void testScanDirectory() throws Exception {
        Path p = new Path("any");
        FileContext fc = (FileContext)Mockito.mock(FileContext.class);
        Mockito.when((Object)fc.makeQualified(p)).thenReturn((Object)p);
        Mockito.when((Object)fc.listStatus(p)).thenThrow(new Throwable[]{new FileNotFoundException()});
        List lfs = HistoryFileManager.scanDirectory((Path)p, (FileContext)fc, null);
        Assert.assertNotNull((Object)lfs);
    }

    @Test
    public void testHistoryFileInfoSummaryFileNotExist() throws Exception {
        HistoryFileManagerTest hmTest = new HistoryFileManagerTest();
        String job = "job_1410889000000_123456";
        Path summaryFile = new Path(job + ".summary");
        JobIndexInfo jobIndexInfo = new JobIndexInfo();
        jobIndexInfo.setJobId(TypeConverter.toYarn((JobID)JobID.forName((String)job)));
        Configuration conf = dfsCluster.getConfiguration(0);
        conf.set("mapreduce.jobhistory.done-dir", "/" + UUID.randomUUID());
        conf.set("mapreduce.jobhistory.intermediate-done-dir", "/" + UUID.randomUUID());
        hmTest.serviceInit(conf);
        HistoryFileManager.HistoryFileInfo info = hmTest.getHistoryFileInfo(null, null, summaryFile, jobIndexInfo, false);
        info.moveToDone();
        Assert.assertFalse((boolean)info.didMoveFail());
    }

    @Test
    public void testHistoryFileInfoLoadOversizedJobShouldReturnUnParsedJob() throws Exception {
        HistoryFileManagerTest hmTest = new HistoryFileManagerTest();
        int allowedMaximumTasks = 5;
        Configuration conf = dfsCluster.getConfiguration(0);
        conf.setInt("mapreduce.jobhistory.loadedjob.tasks.max", allowedMaximumTasks);
        hmTest.init(conf);
        String jobId = "job_1410889000000_123456";
        JobIndexInfo jobIndexInfo = new JobIndexInfo();
        jobIndexInfo.setJobId(TypeConverter.toYarn((JobID)JobID.forName((String)jobId)));
        jobIndexInfo.setNumMaps(allowedMaximumTasks);
        jobIndexInfo.setNumReduces(allowedMaximumTasks);
        HistoryFileManager.HistoryFileInfo info = hmTest.getHistoryFileInfo(null, null, null, jobIndexInfo, false);
        Job job = info.loadJob();
        Assert.assertTrue((String)"Should return an instance of UnparsedJob to indicate the job history file is not parsed", (boolean)(job instanceof UnparsedJob));
    }

    @Test
    public void testHistoryFileInfoLoadNormalSizedJobShouldReturnCompletedJob() throws Exception {
        HistoryFileManagerTest hmTest = new HistoryFileManagerTest();
        int numOfTasks = 100;
        Configuration conf = dfsCluster.getConfiguration(0);
        conf.setInt("mapreduce.jobhistory.loadedjob.tasks.max", 201);
        hmTest.init(conf);
        String jobId = "job_1416424547277_0002";
        JobIndexInfo jobIndexInfo = new JobIndexInfo();
        jobIndexInfo.setJobId(TypeConverter.toYarn((JobID)JobID.forName((String)"job_1416424547277_0002")));
        jobIndexInfo.setNumMaps(100);
        jobIndexInfo.setNumReduces(100);
        String historyFile = this.getClass().getClassLoader().getResource("job_2.0.3-alpha-FAILED.jhist").getFile();
        Path historyFilePath = FileSystem.getLocal((Configuration)conf).makeQualified(new Path(historyFile));
        HistoryFileManager.HistoryFileInfo info = hmTest.getHistoryFileInfo(historyFilePath, null, null, jobIndexInfo, false);
        Job job = info.loadJob();
        Assert.assertTrue((String)"Should return an instance of CompletedJob as a result of parsing the job history file of the job", (boolean)(job instanceof CompletedJob));
    }

    @Test
    public void testHistoryFileInfoShouldReturnCompletedJobIfMaxNotConfiged() throws Exception {
        HistoryFileManagerTest hmTest = new HistoryFileManagerTest();
        Configuration conf = dfsCluster.getConfiguration(0);
        conf.setInt("mapreduce.jobhistory.loadedjob.tasks.max", -1);
        hmTest.init(conf);
        String jobId = "job_1416424547277_0002";
        JobIndexInfo jobIndexInfo = new JobIndexInfo();
        jobIndexInfo.setJobId(TypeConverter.toYarn((JobID)JobID.forName((String)"job_1416424547277_0002")));
        jobIndexInfo.setNumMaps(100);
        jobIndexInfo.setNumReduces(100);
        String historyFile = this.getClass().getClassLoader().getResource("job_2.0.3-alpha-FAILED.jhist").getFile();
        Path historyFilePath = FileSystem.getLocal((Configuration)conf).makeQualified(new Path(historyFile));
        HistoryFileManager.HistoryFileInfo info = hmTest.getHistoryFileInfo(historyFilePath, null, null, jobIndexInfo, false);
        Job job = info.loadJob();
        Assert.assertTrue((String)"Should return an instance of CompletedJob as a result of parsing the job history file of the job", (boolean)(job instanceof CompletedJob));
    }

    @Test
    public void testMoveToDoneAlreadyMovedSucceeds() throws Exception {
        HistoryFileManagerTest historyFileManager = new HistoryFileManagerTest();
        long jobTimestamp = 1535436603000L;
        String job = "job_" + jobTimestamp + "_123456789";
        String intermediateDirectory = "/" + UUID.randomUUID();
        String doneDirectory = "/" + UUID.randomUUID();
        Configuration conf = dfsCluster.getConfiguration(0);
        conf.set("mapreduce.jobhistory.intermediate-done-dir", intermediateDirectory);
        conf.set("mapreduce.jobhistory.done-dir", doneDirectory);
        Path intermediateHistoryFilePath = new Path(intermediateDirectory + "/" + job + ".jhist");
        Path intermediateConfFilePath = new Path(intermediateDirectory + "/" + job + "_conf.xml");
        Path doneHistoryFilePath = new Path(doneDirectory + "/" + JobHistoryUtils.timestampDirectoryComponent((long)jobTimestamp) + "/123456/" + job + ".jhist");
        Path doneConfFilePath = new Path(doneDirectory + "/" + JobHistoryUtils.timestampDirectoryComponent((long)jobTimestamp) + "/123456/" + job + "_conf.xml");
        dfsCluster.getFileSystem().createNewFile(doneHistoryFilePath);
        dfsCluster.getFileSystem().createNewFile(doneConfFilePath);
        historyFileManager.serviceInit(conf);
        JobIndexInfo jobIndexInfo = new JobIndexInfo();
        jobIndexInfo.setJobId(TypeConverter.toYarn((JobID)JobID.forName((String)job)));
        jobIndexInfo.setFinishTime(jobTimestamp);
        HistoryFileManager.HistoryFileInfo info = historyFileManager.getHistoryFileInfo(intermediateHistoryFilePath, intermediateConfFilePath, null, jobIndexInfo, false);
        info.moveToDone();
        Assert.assertFalse((boolean)info.isMovePending());
        Assert.assertEquals((Object)doneHistoryFilePath.toString(), (Object)info.getHistoryFile().toUri().getPath());
        Assert.assertEquals((Object)doneConfFilePath.toString(), (Object)info.getConfFile().toUri().getPath());
    }

    static /* synthetic */ MiniDFSCluster access$000() {
        return dfsCluster;
    }
}

