/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.hs.CompletedJob;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.hs.TestJobHistoryEntities;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestJobHistoryEntities {
    private final String historyFileName = "job_1329348432655_0001-1329348443227-user-Sleep+job-1329348468601-10-1-SUCCEEDED-default.jhist";
    private final String historyFileNameZeroReduceTasks = "job_1416424547277_0002-1416424775281-root-TeraGen-1416424785433-2-0-SUCCEEDED-default-1416424779349.jhist";
    private final String confFileName = "job_1329348432655_0001_conf.xml";
    private final Configuration conf = new Configuration();
    private final JobACLsManager jobAclsManager = new JobACLsManager(this.conf);
    private boolean loadTasks;
    private JobId jobId = MRBuilderUtils.newJobId((long)1329348432655L, (int)1, (int)1);
    Path fullHistoryPath = new Path(this.getClass().getClassLoader().getResource("job_1329348432655_0001-1329348443227-user-Sleep+job-1329348468601-10-1-SUCCEEDED-default.jhist").getFile());
    Path fullHistoryPathZeroReduces = new Path(this.getClass().getClassLoader().getResource("job_1416424547277_0002-1416424775281-root-TeraGen-1416424785433-2-0-SUCCEEDED-default-1416424779349.jhist").getFile());
    Path fullConfPath = new Path(this.getClass().getClassLoader().getResource("job_1329348432655_0001_conf.xml").getFile());
    private CompletedJob completedJob;

    public TestJobHistoryEntities(boolean loadTasks) throws Exception {
        this.loadTasks = loadTasks;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> list = new ArrayList<Object[]>(2);
        list.add(new Object[]{true});
        list.add(new Object[]{false});
        return list;
    }

    @Test(timeout=100000L)
    public void testCompletedJob() throws Exception {
        HistoryFileManager.HistoryFileInfo info = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)info.getConfFile()).thenReturn((Object)this.fullConfPath);
        Mockito.when((Object)info.getHistoryFile()).thenReturn((Object)this.fullHistoryPath);
        this.completedJob = new CompletedJob(this.conf, this.jobId, this.fullHistoryPath, this.loadTasks, "user", info, this.jobAclsManager);
        Assert.assertEquals((Object)this.loadTasks, (Object)this.completedJob.tasksLoaded.get());
        Assert.assertEquals((long)1L, (long)this.completedJob.getAMInfos().size());
        Assert.assertEquals((long)10L, (long)this.completedJob.getCompletedMaps());
        Assert.assertEquals((long)1L, (long)this.completedJob.getCompletedReduces());
        Assert.assertEquals((long)12L, (long)this.completedJob.getTasks().size());
        Assert.assertEquals((Object)true, (Object)this.completedJob.tasksLoaded.get());
        Assert.assertEquals((long)10L, (long)this.completedJob.getTasks(TaskType.MAP).size());
        Assert.assertEquals((long)2L, (long)this.completedJob.getTasks(TaskType.REDUCE).size());
        Assert.assertEquals((Object)"user", (Object)this.completedJob.getUserName());
        Assert.assertEquals((Object)JobState.SUCCEEDED, (Object)this.completedJob.getState());
        JobReport jobReport = this.completedJob.getReport();
        Assert.assertEquals((Object)"user", (Object)jobReport.getUser());
        Assert.assertEquals((Object)JobState.SUCCEEDED, (Object)jobReport.getJobState());
        Assert.assertEquals((Object)this.fullHistoryPath.toString(), (Object)jobReport.getHistoryFile());
    }

    @Test(timeout=100000L)
    public void testCopmletedJobReportWithZeroTasks() throws Exception {
        HistoryFileManager.HistoryFileInfo info = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)info.getConfFile()).thenReturn((Object)this.fullConfPath);
        Mockito.when((Object)info.getHistoryFile()).thenReturn((Object)this.fullHistoryPathZeroReduces);
        this.completedJob = new CompletedJob(this.conf, this.jobId, this.fullHistoryPathZeroReduces, this.loadTasks, "user", info, this.jobAclsManager);
        JobReport jobReport = this.completedJob.getReport();
        Assert.assertEquals((long)0L, (long)this.completedJob.getTotalReduces());
        Assert.assertEquals((long)0L, (long)this.completedJob.getCompletedReduces());
        Assert.assertEquals((double)1.0, (double)jobReport.getReduceProgress(), (double)0.001);
        Assert.assertEquals((Object)this.fullHistoryPathZeroReduces.toString(), (Object)jobReport.getHistoryFile());
    }

    @Test(timeout=10000L)
    public void testCompletedTask() throws Exception {
        HistoryFileManager.HistoryFileInfo info = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)info.getConfFile()).thenReturn((Object)this.fullConfPath);
        this.completedJob = new CompletedJob(this.conf, this.jobId, this.fullHistoryPath, this.loadTasks, "user", info, this.jobAclsManager);
        TaskId mt1Id = MRBuilderUtils.newTaskId((JobId)this.jobId, (int)0, (TaskType)TaskType.MAP);
        TaskId rt1Id = MRBuilderUtils.newTaskId((JobId)this.jobId, (int)0, (TaskType)TaskType.REDUCE);
        Map mapTasks = this.completedJob.getTasks(TaskType.MAP);
        Map reduceTasks = this.completedJob.getTasks(TaskType.REDUCE);
        Assert.assertEquals((long)10L, (long)mapTasks.size());
        Assert.assertEquals((long)2L, (long)reduceTasks.size());
        Task mt1 = (Task)mapTasks.get(mt1Id);
        Assert.assertEquals((long)1L, (long)mt1.getAttempts().size());
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)mt1.getState());
        TaskReport mt1Report = mt1.getReport();
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)mt1Report.getTaskState());
        Assert.assertEquals((Object)mt1Id, (Object)mt1Report.getTaskId());
        Task rt1 = (Task)reduceTasks.get(rt1Id);
        Assert.assertEquals((long)1L, (long)rt1.getAttempts().size());
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)rt1.getState());
        TaskReport rt1Report = rt1.getReport();
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)rt1Report.getTaskState());
        Assert.assertEquals((Object)rt1Id, (Object)rt1Report.getTaskId());
    }

    @Test(timeout=10000L)
    public void testCompletedTaskAttempt() throws Exception {
        HistoryFileManager.HistoryFileInfo info = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)info.getConfFile()).thenReturn((Object)this.fullConfPath);
        this.completedJob = new CompletedJob(this.conf, this.jobId, this.fullHistoryPath, this.loadTasks, "user", info, this.jobAclsManager);
        TaskId mt1Id = MRBuilderUtils.newTaskId((JobId)this.jobId, (int)0, (TaskType)TaskType.MAP);
        TaskId rt1Id = MRBuilderUtils.newTaskId((JobId)this.jobId, (int)0, (TaskType)TaskType.REDUCE);
        TaskAttemptId mta1Id = MRBuilderUtils.newTaskAttemptId((TaskId)mt1Id, (int)0);
        TaskAttemptId rta1Id = MRBuilderUtils.newTaskAttemptId((TaskId)rt1Id, (int)0);
        Task mt1 = this.completedJob.getTask(mt1Id);
        Task rt1 = this.completedJob.getTask(rt1Id);
        TaskAttempt mta1 = mt1.getAttempt(mta1Id);
        Assert.assertEquals((Object)TaskAttemptState.SUCCEEDED, (Object)mta1.getState());
        Assert.assertEquals((Object)"localhost:45454", (Object)mta1.getAssignedContainerMgrAddress());
        Assert.assertEquals((Object)"localhost:9999", (Object)mta1.getNodeHttpAddress());
        TaskAttemptReport mta1Report = mta1.getReport();
        Assert.assertEquals((Object)TaskAttemptState.SUCCEEDED, (Object)mta1Report.getTaskAttemptState());
        Assert.assertEquals((Object)"localhost", (Object)mta1Report.getNodeManagerHost());
        Assert.assertEquals((long)45454L, (long)mta1Report.getNodeManagerPort());
        Assert.assertEquals((long)9999L, (long)mta1Report.getNodeManagerHttpPort());
        TaskAttempt rta1 = rt1.getAttempt(rta1Id);
        Assert.assertEquals((Object)TaskAttemptState.SUCCEEDED, (Object)rta1.getState());
        Assert.assertEquals((Object)"localhost:45454", (Object)rta1.getAssignedContainerMgrAddress());
        Assert.assertEquals((Object)"localhost:9999", (Object)rta1.getNodeHttpAddress());
        TaskAttemptReport rta1Report = rta1.getReport();
        Assert.assertEquals((Object)TaskAttemptState.SUCCEEDED, (Object)rta1Report.getTaskAttemptState());
        Assert.assertEquals((Object)"localhost", (Object)rta1Report.getNodeManagerHost());
        Assert.assertEquals((long)45454L, (long)rta1Report.getNodeManagerPort());
        Assert.assertEquals((long)9999L, (long)rta1Report.getNodeManagerHttpPort());
    }

    @Test(timeout=30000L)
    public void testGetTaskAttemptCompletionEvent() throws Exception {
        HistoryFileManager.HistoryFileInfo info = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)info.getConfFile()).thenReturn((Object)this.fullConfPath);
        this.completedJob = new CompletedJob(this.conf, this.jobId, this.fullHistoryPath, this.loadTasks, "user", info, this.jobAclsManager);
        TaskCompletionEvent[] events = this.completedJob.getMapAttemptCompletionEvents(0, 1000);
        Assert.assertEquals((long)10L, (long)this.completedJob.getMapAttemptCompletionEvents(0, 10).length);
        int currentEventId = 0;
        for (TaskCompletionEvent taskAttemptCompletionEvent : events) {
            int eventId = taskAttemptCompletionEvent.getEventId();
            Assert.assertTrue((eventId >= currentEventId ? 1 : 0) != 0);
            currentEventId = eventId;
        }
        Assert.assertNull((Object)this.completedJob.loadConfFile());
        Assert.assertEquals((Object)"Sleep job", (Object)this.completedJob.getName());
        Assert.assertEquals((Object)"default", (Object)this.completedJob.getQueueName());
        Assert.assertEquals((double)1.0, (double)this.completedJob.getProgress(), (double)0.001);
        Assert.assertEquals((long)12L, (long)this.completedJob.getTaskAttemptCompletionEvents(0, 1000).length);
        Assert.assertEquals((long)10L, (long)this.completedJob.getTaskAttemptCompletionEvents(0, 10).length);
        Assert.assertEquals((long)7L, (long)this.completedJob.getTaskAttemptCompletionEvents(5, 10).length);
        Assert.assertEquals((long)1L, (long)this.completedJob.getDiagnostics().size());
        Assert.assertEquals((Object)"", this.completedJob.getDiagnostics().get(0));
        Assert.assertEquals((long)0L, (long)this.completedJob.getJobACLs().size());
    }

    @Test(timeout=30000L)
    public void testCompletedJobWithDiagnostics() throws Exception {
        String jobError = "Job Diagnostics";
        JobHistoryParser.JobInfo jobInfo = (JobHistoryParser.JobInfo)Mockito.spy((Object)new JobHistoryParser.JobInfo());
        Mockito.when((Object)jobInfo.getErrorInfo()).thenReturn((Object)"Job Diagnostics");
        Mockito.when((Object)jobInfo.getJobStatus()).thenReturn((Object)JobState.FAILED.toString());
        Mockito.when((Object)jobInfo.getAMInfos()).thenReturn(Collections.emptyList());
        JobHistoryParser mockParser = (JobHistoryParser)Mockito.mock(JobHistoryParser.class);
        Mockito.when((Object)mockParser.parse()).thenReturn((Object)jobInfo);
        HistoryFileManager.HistoryFileInfo info = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)info.getConfFile()).thenReturn((Object)this.fullConfPath);
        Mockito.when((Object)info.getHistoryFile()).thenReturn((Object)this.fullHistoryPath);
        1 job = new /* Unavailable Anonymous Inner Class!! */;
        Assert.assertEquals((Object)"Job Diagnostics", (Object)job.getReport().getDiagnostics());
    }
}

