/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.JobIdPBImpl;
import org.apache.hadoop.mapreduce.v2.hs.CachedHistoryStorage;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.hs.TestUnnecessaryBlockingOnHistoryFileInfo;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestUnnecessaryBlockingOnHistoryFileInfo {
    private static final File INTERMEDIATE_DIR = new File("target", TestUnnecessaryBlockingOnHistoryFileInfo.class.getName() + "/intermediate");
    private static final File USER_DIR = new File(INTERMEDIATE_DIR, "test");

    @BeforeClass
    public static void setUp() throws IOException {
        if (USER_DIR.exists()) {
            FileUtils.cleanDirectory((File)USER_DIR);
        }
        USER_DIR.mkdirs();
    }

    @AfterClass
    public static void cleanUp() throws IOException {
        FileUtils.deleteDirectory((File)INTERMEDIATE_DIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testTwoThreadsQueryingDifferentJobOfSameUser() throws InterruptedException, IOException {
        Configuration config = new Configuration();
        config.set("mapreduce.jobhistory.intermediate-done-dir", INTERMEDIATE_DIR.getPath());
        config.setLong("mapreduce.jobhistory.max-age-ms", Long.MAX_VALUE);
        JobId job1 = TestUnnecessaryBlockingOnHistoryFileInfo.createJobId((int)0);
        JobId job2 = TestUnnecessaryBlockingOnHistoryFileInfo.createJobId((int)1);
        HistoryFileManagerUnderContention historyFileManager = this.createHistoryFileManager(config, new JobId[]{job1, job2});
        Thread webRequest1 = null;
        Thread webRequest2 = null;
        try {
            TestUnnecessaryBlockingOnHistoryFileInfo.createJhistFile((JobId)job1);
            webRequest1 = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            webRequest1.start();
            historyFileManager.waitUntilIntermediateDirIsScanned(job1);
            TestUnnecessaryBlockingOnHistoryFileInfo.createJhistFile((JobId)job2);
            webRequest2 = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            webRequest2.start();
            historyFileManager.waitUntilIntermediateDirIsScanned(job2);
            Assert.assertTrue((String)"Thread 2 is blocked while it is trying to load job2 by Thread 1 which is loading job1.", (webRequest2.getState() != Thread.State.BLOCKED ? 1 : 0) != 0);
        }
        finally {
            if (webRequest1 != null) {
                webRequest1.interrupt();
            }
            if (webRequest2 != null) {
                webRequest2.interrupt();
            }
        }
    }

    private HistoryFileManagerUnderContention createHistoryFileManager(Configuration config, JobId ... jobIds) {
        HistoryFileManagerUnderContention historyFileManager = new HistoryFileManagerUnderContention(this, jobIds);
        historyFileManager.init(config);
        historyFileManager.start();
        return historyFileManager;
    }

    private static CachedHistoryStorage createHistoryStorage(Configuration config, HistoryFileManager historyFileManager) {
        CachedHistoryStorage historyStorage = new CachedHistoryStorage();
        historyStorage.setHistoryFileManager(historyFileManager);
        historyStorage.init(config);
        historyStorage.start();
        return historyStorage;
    }

    private static JobId createJobId(int id) {
        JobIdPBImpl jobId = new JobIdPBImpl();
        jobId.setId(id);
        jobId.setAppId(ApplicationIdPBImpl.newInstance((long)0L, (int)id));
        return jobId;
    }

    private static boolean createJhistFile(JobId jobId) throws IOException {
        StringBuilder fileName = new StringBuilder(jobId.toString());
        long finishTime = System.currentTimeMillis();
        fileName.append("-").append(finishTime - 1000L).append("-").append("test").append("-").append(jobId.getId()).append("-").append(finishTime).append(".jhist");
        File jhistFile = new File(USER_DIR, fileName.toString());
        return jhistFile.createNewFile();
    }
}

