/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp.dao;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.hs.CompletedJob;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.hs.TestJobHistoryEntities;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobInfo;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestJobInfo {
    @Test(timeout=10000L)
    public void testAverageMergeTime() throws IOException {
        String historyFileName = "job_1329348432655_0001-1329348443227-user-Sleep+job-1329348468601-10-1-SUCCEEDED-default.jhist";
        String confFileName = "job_1329348432655_0001_conf.xml";
        Configuration conf = new Configuration();
        JobACLsManager jobAclsMgr = new JobACLsManager(conf);
        Path fulleHistoryPath = new Path(TestJobHistoryEntities.class.getClassLoader().getResource(historyFileName).getFile());
        Path fullConfPath = new Path(TestJobHistoryEntities.class.getClassLoader().getResource(confFileName).getFile());
        HistoryFileManager.HistoryFileInfo info = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)info.getConfFile()).thenReturn((Object)fullConfPath);
        Mockito.when((Object)info.getHistoryFile()).thenReturn((Object)fulleHistoryPath);
        JobId jobId = MRBuilderUtils.newJobId((long)1329348432655L, (int)1, (int)1);
        CompletedJob completedJob = new CompletedJob(conf, jobId, fulleHistoryPath, true, "user", info, jobAclsMgr);
        JobInfo jobInfo = new JobInfo((Job)completedJob);
        Assert.assertEquals((long)50L, (long)jobInfo.getAvgMergeTime());
    }

    @Test
    public void testAverageReduceTime() {
        Job job = (Job)Mockito.mock(CompletedJob.class);
        Task task1 = (Task)Mockito.mock(Task.class);
        Task task2 = (Task)Mockito.mock(Task.class);
        JobId jobId = MRBuilderUtils.newJobId((long)1L, (int)1, (int)1);
        TaskId taskId1 = MRBuilderUtils.newTaskId((JobId)jobId, (int)1, (TaskType)TaskType.REDUCE);
        TaskId taskId2 = MRBuilderUtils.newTaskId((JobId)jobId, (int)2, (TaskType)TaskType.REDUCE);
        TaskAttemptId taskAttemptId1 = MRBuilderUtils.newTaskAttemptId((TaskId)taskId1, (int)1);
        TaskAttemptId taskAttemptId2 = MRBuilderUtils.newTaskAttemptId((TaskId)taskId2, (int)2);
        TaskAttempt taskAttempt1 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        TaskAttempt taskAttempt2 = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        JobReport jobReport = (JobReport)Mockito.mock(JobReport.class);
        Mockito.when((Object)taskAttempt1.getState()).thenReturn((Object)TaskAttemptState.SUCCEEDED);
        Mockito.when((Object)taskAttempt1.getLaunchTime()).thenReturn((Object)0L);
        Mockito.when((Object)taskAttempt1.getShuffleFinishTime()).thenReturn((Object)4L);
        Mockito.when((Object)taskAttempt1.getSortFinishTime()).thenReturn((Object)6L);
        Mockito.when((Object)taskAttempt1.getFinishTime()).thenReturn((Object)8L);
        Mockito.when((Object)taskAttempt2.getState()).thenReturn((Object)TaskAttemptState.SUCCEEDED);
        Mockito.when((Object)taskAttempt2.getLaunchTime()).thenReturn((Object)5L);
        Mockito.when((Object)taskAttempt2.getShuffleFinishTime()).thenReturn((Object)10L);
        Mockito.when((Object)taskAttempt2.getSortFinishTime()).thenReturn((Object)22L);
        Mockito.when((Object)taskAttempt2.getFinishTime()).thenReturn((Object)42L);
        Mockito.when((Object)task1.getType()).thenReturn((Object)TaskType.REDUCE);
        Mockito.when((Object)task2.getType()).thenReturn((Object)TaskType.REDUCE);
        Mockito.when((Object)task1.getAttempts()).thenReturn((Object)new /* Unavailable Anonymous Inner Class!! */);
        Mockito.when((Object)task2.getAttempts()).thenReturn((Object)new /* Unavailable Anonymous Inner Class!! */);
        Mockito.when((Object)job.getTasks()).thenReturn((Object)new /* Unavailable Anonymous Inner Class!! */);
        Mockito.when((Object)job.getID()).thenReturn((Object)jobId);
        Mockito.when((Object)job.getReport()).thenReturn((Object)jobReport);
        Mockito.when((Object)job.getName()).thenReturn((Object)"TestJobInfo");
        Mockito.when((Object)job.getState()).thenReturn((Object)JobState.SUCCEEDED);
        JobInfo jobInfo = new JobInfo(job);
        Assert.assertEquals((long)11L, (long)jobInfo.getAvgReduceTime());
    }

    @Test
    public void testGetStartTimeStr() {
        JobReport jobReport = (JobReport)Mockito.mock(JobReport.class);
        Mockito.when((Object)jobReport.getStartTime()).thenReturn((Object)-1L);
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)job.getReport()).thenReturn((Object)jobReport);
        Mockito.when((Object)job.getName()).thenReturn((Object)"TestJobInfo");
        Mockito.when((Object)job.getState()).thenReturn((Object)JobState.SUCCEEDED);
        JobId jobId = MRBuilderUtils.newJobId((long)1L, (int)1, (int)1);
        Mockito.when((Object)job.getID()).thenReturn((Object)jobId);
        JobInfo jobInfo = new JobInfo(job);
        Assert.assertEquals((Object)"N/A", (Object)jobInfo.getStartTimeStr());
        Date date = new Date();
        Mockito.when((Object)jobReport.getStartTime()).thenReturn((Object)date.getTime());
        jobInfo = new JobInfo(job);
        Assert.assertEquals((Object)date.toString(), (Object)jobInfo.getStartTimeStr());
    }

    @Test
    public void testGetFormattedStartTimeStr() {
        JobReport jobReport = (JobReport)Mockito.mock(JobReport.class);
        Mockito.when((Object)jobReport.getStartTime()).thenReturn((Object)-1L);
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)job.getReport()).thenReturn((Object)jobReport);
        Mockito.when((Object)job.getName()).thenReturn((Object)"TestJobInfo");
        Mockito.when((Object)job.getState()).thenReturn((Object)JobState.SUCCEEDED);
        JobId jobId = MRBuilderUtils.newJobId((long)1L, (int)1, (int)1);
        Mockito.when((Object)job.getID()).thenReturn((Object)jobId);
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        JobInfo jobInfo = new JobInfo(job);
        Assert.assertEquals((Object)"N/A", (Object)jobInfo.getFormattedStartTimeStr((DateFormat)dateFormat));
        Date date = new Date();
        Mockito.when((Object)jobReport.getStartTime()).thenReturn((Object)date.getTime());
        jobInfo = new JobInfo(job);
        Assert.assertEquals((Object)dateFormat.format(date), (Object)jobInfo.getFormattedStartTimeStr((DateFormat)dateFormat));
    }
}

