/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.v2.api.MRDelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.hs.HistoryServerStateStoreService;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.Shell;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HistoryServerFileSystemStateStoreService
extends HistoryServerStateStoreService {
    public static final Log LOG = LogFactory.getLog(HistoryServerFileSystemStateStoreService.class);
    private static final String ROOT_STATE_DIR_NAME = "HistoryServerState";
    private static final String TOKEN_STATE_DIR_NAME = "tokens";
    private static final String TOKEN_KEYS_DIR_NAME = "keys";
    private static final String TOKEN_BUCKET_DIR_PREFIX = "tb_";
    private static final String TOKEN_BUCKET_NAME_FORMAT = "tb_%03d";
    private static final String TOKEN_MASTER_KEY_FILE_PREFIX = "key_";
    private static final String TOKEN_FILE_PREFIX = "token_";
    private static final String TMP_FILE_PREFIX = "tmp-";
    private static final FsPermission DIR_PERMISSIONS = new FsPermission(448);
    private static final FsPermission FILE_PERMISSIONS = Shell.WINDOWS ? new FsPermission(448) : new FsPermission(256);
    private static final int NUM_TOKEN_BUCKETS = 1000;
    private FileSystem fs;
    private Path rootStatePath;
    private Path tokenStatePath;
    private Path tokenKeysStatePath;

    @Override
    protected void initStorage(Configuration conf) throws IOException {
        String storeUri = conf.get("mapreduce.jobhistory.recovery.store.fs.uri");
        if (storeUri == null) {
            throw new IOException("No store location URI configured in mapreduce.jobhistory.recovery.store.fs.uri");
        }
        LOG.info((Object)("Using " + storeUri + " for history server state storage"));
        this.rootStatePath = new Path(storeUri, ROOT_STATE_DIR_NAME);
    }

    @Override
    protected void startStorage() throws IOException {
        this.fs = this.rootStatePath.getFileSystem(this.getConfig());
        this.createDir(this.rootStatePath);
        this.tokenStatePath = new Path(this.rootStatePath, TOKEN_STATE_DIR_NAME);
        this.createDir(this.tokenStatePath);
        this.tokenKeysStatePath = new Path(this.tokenStatePath, TOKEN_KEYS_DIR_NAME);
        this.createDir(this.tokenKeysStatePath);
        for (int i = 0; i < 1000; ++i) {
            this.createDir(this.getTokenBucketPath(i));
        }
    }

    @Override
    protected void closeStorage() throws IOException {
    }

    @Override
    public HistoryServerStateStoreService.HistoryServerState loadState() throws IOException {
        LOG.info((Object)("Loading history server state from " + this.rootStatePath));
        HistoryServerStateStoreService.HistoryServerState state = new HistoryServerStateStoreService.HistoryServerState();
        this.loadTokenState(state);
        return state;
    }

    @Override
    public void storeToken(MRDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        Path tokenPath;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing token " + tokenId.getSequenceNumber()));
        }
        if (this.fs.exists(tokenPath = this.getTokenPath(tokenId))) {
            throw new IOException(tokenPath + " already exists");
        }
        this.createFile(tokenPath, this.buildTokenData(tokenId, renewDate));
    }

    @Override
    public void updateToken(MRDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating token " + tokenId.getSequenceNumber()));
        }
        this.createFile(this.getTokenPath(tokenId), this.buildTokenData(tokenId, renewDate));
    }

    @Override
    public void removeToken(MRDelegationTokenIdentifier tokenId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing token " + tokenId.getSequenceNumber()));
        }
        this.deleteFile(this.getTokenPath(tokenId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTokenMasterKey(DelegationKey key) throws IOException {
        Path keyPath;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing master key " + key.getKeyId()));
        }
        if (this.fs.exists(keyPath = new Path(this.tokenKeysStatePath, TOKEN_MASTER_KEY_FILE_PREFIX + key.getKeyId()))) {
            throw new IOException(keyPath + " already exists");
        }
        ByteArrayOutputStream memStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(memStream);
        try {
            key.write((DataOutput)dataStream);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{dataStream});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{dataStream});
        this.createFile(keyPath, memStream.toByteArray());
    }

    @Override
    public void removeTokenMasterKey(DelegationKey key) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing master key " + key.getKeyId()));
        }
        Path keyPath = new Path(this.tokenKeysStatePath, TOKEN_MASTER_KEY_FILE_PREFIX + key.getKeyId());
        this.deleteFile(keyPath);
    }

    private static int getBucketId(MRDelegationTokenIdentifier tokenId) {
        return tokenId.getSequenceNumber() % 1000;
    }

    private Path getTokenBucketPath(int bucketId) {
        return new Path(this.tokenStatePath, String.format(TOKEN_BUCKET_NAME_FORMAT, bucketId));
    }

    private Path getTokenPath(MRDelegationTokenIdentifier tokenId) {
        Path bucketPath = this.getTokenBucketPath(HistoryServerFileSystemStateStoreService.getBucketId(tokenId));
        return new Path(bucketPath, TOKEN_FILE_PREFIX + tokenId.getSequenceNumber());
    }

    private void createDir(Path dir) throws IOException {
        try {
            FileStatus status = this.fs.getFileStatus(dir);
            if (!status.isDirectory()) {
                throw new FileAlreadyExistsException("Unexpected file in store: " + dir);
            }
            if (!status.getPermission().equals((Object)DIR_PERMISSIONS)) {
                this.fs.setPermission(dir, DIR_PERMISSIONS);
            }
        }
        catch (FileNotFoundException e) {
            this.fs.mkdirs(dir, DIR_PERMISSIONS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(Path file, byte[] data) throws IOException {
        int WRITE_BUFFER_SIZE = 4096;
        Path tmp = new Path(file.getParent(), TMP_FILE_PREFIX + file.getName());
        FSDataOutputStream out = this.fs.create(tmp, FILE_PERMISSIONS, true, 4096, this.fs.getDefaultReplication(tmp), this.fs.getDefaultBlockSize(tmp), null);
        try {
            try {
                out.write(data);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
                throw throwable;
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{out});
            if (!this.fs.rename(tmp, file)) {
                throw new IOException("Could not rename " + tmp + " to " + file);
            }
        }
        catch (IOException e) {
            this.fs.delete(tmp, false);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(Path file, long numBytes) throws IOException {
        byte[] data = new byte[(int)numBytes];
        FSDataInputStream in = this.fs.open(file);
        try {
            in.readFully(data);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
        return data;
    }

    private void deleteFile(Path file) throws IOException {
        boolean deleted;
        try {
            deleted = this.fs.delete(file, false);
        }
        catch (FileNotFoundException e) {
            deleted = true;
        }
        if (!deleted) {
            throw new IOException("Unable to delete " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] buildTokenData(MRDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        ByteArrayOutputStream memStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(memStream);
        try {
            tokenId.write((DataOutput)dataStream);
            dataStream.writeLong(renewDate);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{dataStream});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{dataStream});
        return memStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTokenMasterKey(HistoryServerStateStoreService.HistoryServerState state, Path keyFile, long numKeyFileBytes) throws IOException {
        DelegationKey key = new DelegationKey();
        byte[] keyData = this.readFile(keyFile, numKeyFileBytes);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(keyData));
        try {
            key.readFields((DataInput)in);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
        state.tokenMasterKeyState.add(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MRDelegationTokenIdentifier loadToken(HistoryServerStateStoreService.HistoryServerState state, Path tokenFile, long numTokenFileBytes) throws IOException {
        long renewDate;
        MRDelegationTokenIdentifier tokenId = new MRDelegationTokenIdentifier();
        byte[] tokenData = this.readFile(tokenFile, numTokenFileBytes);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(tokenData));
        try {
            tokenId.readFields((DataInput)in);
            renewDate = in.readLong();
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
        state.tokenState.put(tokenId, renewDate);
        return tokenId;
    }

    private int loadTokensFromBucket(HistoryServerStateStoreService.HistoryServerState state, Path bucket) throws IOException {
        FileStatus[] tokenStats;
        String numStr = bucket.getName().substring(TOKEN_BUCKET_DIR_PREFIX.length());
        int bucketId = Integer.parseInt(numStr);
        int numTokens = 0;
        for (FileStatus stat : tokenStats = this.fs.listStatus(bucket)) {
            String name = stat.getPath().getName();
            if (name.startsWith(TOKEN_FILE_PREFIX)) {
                MRDelegationTokenIdentifier token = this.loadToken(state, stat.getPath(), stat.getLen());
                int tokenBucketId = HistoryServerFileSystemStateStoreService.getBucketId(token);
                if (tokenBucketId != bucketId) {
                    throw new IOException("Token " + stat.getPath() + " should be in bucket " + tokenBucketId + ", found in bucket " + bucketId);
                }
                ++numTokens;
                continue;
            }
            LOG.warn((Object)("Skipping unexpected file in history server token bucket: " + stat.getPath()));
        }
        return numTokens;
    }

    private int loadKeys(HistoryServerStateStoreService.HistoryServerState state) throws IOException {
        FileStatus[] stats = this.fs.listStatus(this.tokenKeysStatePath);
        int numKeys = 0;
        for (FileStatus stat : stats) {
            String name = stat.getPath().getName();
            if (name.startsWith(TOKEN_MASTER_KEY_FILE_PREFIX)) {
                this.loadTokenMasterKey(state, stat.getPath(), stat.getLen());
                ++numKeys;
                continue;
            }
            LOG.warn((Object)("Skipping unexpected file in history server token state: " + stat.getPath()));
        }
        return numKeys;
    }

    private int loadTokens(HistoryServerStateStoreService.HistoryServerState state) throws IOException {
        FileStatus[] stats = this.fs.listStatus(this.tokenStatePath);
        int numTokens = 0;
        for (FileStatus stat : stats) {
            String name = stat.getPath().getName();
            if (name.startsWith(TOKEN_BUCKET_DIR_PREFIX)) {
                numTokens += this.loadTokensFromBucket(state, stat.getPath());
                continue;
            }
            if (name.equals(TOKEN_KEYS_DIR_NAME)) continue;
            LOG.warn((Object)("Skipping unexpected file in history server token state: " + stat.getPath()));
        }
        return numTokens;
    }

    private void loadTokenState(HistoryServerStateStoreService.HistoryServerState state) throws IOException {
        int numKeys = this.loadKeys(state);
        int numTokens = this.loadTokens(state);
        LOG.info((Object)("Loaded " + numKeys + " master keys and " + numTokens + " tokens from " + this.tokenStatePath));
    }
}

