/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.hs.CachedHistoryStorage;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.hs.JobHistory;
import org.apache.hadoop.mapreduce.v2.hs.TestJobHistory;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestJobHistory {
    JobHistory jobHistory = null;

    @Test
    public void testRefreshLoadedJobCache() throws Exception {
        int i;
        HistoryFileManager historyManager = (HistoryFileManager)Mockito.mock(HistoryFileManager.class);
        this.jobHistory = (JobHistory)Mockito.spy((Object)new JobHistory());
        ((JobHistory)Mockito.doReturn((Object)historyManager).when((Object)this.jobHistory)).createHistoryFileManager();
        Configuration conf = new Configuration();
        conf.set("mapreduce.jobhistory.loadedjobs.cache.size", "2");
        this.jobHistory.init(conf);
        this.jobHistory.start();
        CachedHistoryStorage storage = (CachedHistoryStorage)Mockito.spy((Object)((CachedHistoryStorage)this.jobHistory.getHistoryStorage()));
        Job[] jobs = new Job[3];
        JobId[] jobIds = new JobId[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            jobs[i2] = (Job)Mockito.mock(Job.class);
            jobIds[i2] = (JobId)Mockito.mock(JobId.class);
            Mockito.when((Object)jobs[i2].getID()).thenReturn((Object)jobIds[i2]);
        }
        HistoryFileManager.HistoryFileInfo fileInfo = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)historyManager.getFileInfo((JobId)Mockito.any(JobId.class))).thenReturn((Object)fileInfo);
        Mockito.when((Object)fileInfo.loadJob()).thenReturn((Object)jobs[0]).thenReturn((Object)jobs[1]).thenReturn((Object)jobs[2]);
        for (int i3 = 0; i3 < 3; ++i3) {
            storage.getFullJob(jobs[i3].getID());
        }
        Map jobCache = storage.getLoadedJobCache();
        Assert.assertFalse((boolean)jobCache.containsKey(jobs[0].getID()));
        Assert.assertTrue((jobCache.containsKey(jobs[1].getID()) && jobCache.containsKey(jobs[2].getID()) ? 1 : 0) != 0);
        conf.set("mapreduce.jobhistory.loadedjobs.cache.size", "3");
        ((CachedHistoryStorage)Mockito.doReturn((Object)conf).when((Object)storage)).createConf();
        Mockito.when((Object)fileInfo.loadJob()).thenReturn((Object)jobs[0]).thenReturn((Object)jobs[1]).thenReturn((Object)jobs[2]);
        this.jobHistory.refreshLoadedJobCache();
        for (i = 0; i < 3; ++i) {
            storage.getFullJob(jobs[i].getID());
        }
        jobCache = storage.getLoadedJobCache();
        for (i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)jobCache.containsKey(jobs[i].getID()));
        }
    }

    @Test
    public void testRefreshJobRetentionSettings() throws IOException, InterruptedException {
        String root = "mockfs://foo/";
        String historyDoneDir = root + "mapred/history/done";
        long now = System.currentTimeMillis();
        long someTimeYesterday = now - 90000000L;
        long timeBefore200Secs = now - 200000L;
        String timestampComponent = JobHistoryUtils.timestampDirectoryComponent((long)someTimeYesterday);
        Path donePathYesterday = new Path(historyDoneDir, timestampComponent + "/" + "000000");
        FileStatus dirCreatedYesterdayStatus = new FileStatus(0L, true, 0, 0L, someTimeYesterday, donePathYesterday);
        timestampComponent = JobHistoryUtils.timestampDirectoryComponent((long)timeBefore200Secs);
        Path donePathToday = new Path(historyDoneDir, timestampComponent + "/" + "000000");
        FileStatus dirCreatedTodayStatus = new FileStatus(0L, true, 0, 0L, timeBefore200Secs, donePathToday);
        Path fileUnderYesterdayDir = new Path(donePathYesterday.toString(), "job_1372363578825_0015-" + someTimeYesterday + "-user-Sleep+job-" + someTimeYesterday + "-1-1-SUCCEEDED-default.jhist");
        FileStatus fileUnderYesterdayDirStatus = new FileStatus(10L, false, 0, 0L, someTimeYesterday, fileUnderYesterdayDir);
        Path fileUnderTodayDir = new Path(donePathYesterday.toString(), "job_1372363578825_0016-" + timeBefore200Secs + "-user-Sleep+job-" + timeBefore200Secs + "-1-1-SUCCEEDED-default.jhist");
        FileStatus fileUnderTodayDirStatus = new FileStatus(10L, false, 0, 0L, timeBefore200Secs, fileUnderTodayDir);
        HistoryFileManager historyManager = (HistoryFileManager)Mockito.spy((Object)new HistoryFileManager());
        this.jobHistory = (JobHistory)Mockito.spy((Object)new JobHistory());
        LinkedList<FileStatus> fileStatusList = new LinkedList<FileStatus>();
        fileStatusList.add(dirCreatedYesterdayStatus);
        fileStatusList.add(dirCreatedTodayStatus);
        ((JobHistory)Mockito.doReturn((Object)4).when((Object)this.jobHistory)).getInitDelaySecs();
        ((JobHistory)Mockito.doReturn((Object)historyManager).when((Object)this.jobHistory)).createHistoryFileManager();
        LinkedList<FileStatus> list1 = new LinkedList<FileStatus>();
        list1.add(fileUnderYesterdayDirStatus);
        ((HistoryFileManager)Mockito.doReturn(list1).when((Object)historyManager)).scanDirectoryForHistoryFiles((Path)Mockito.eq((Object)donePathYesterday), (FileContext)Mockito.any(FileContext.class));
        LinkedList<FileStatus> list2 = new LinkedList<FileStatus>();
        list2.add(fileUnderTodayDirStatus);
        ((HistoryFileManager)Mockito.doReturn(list2).when((Object)historyManager)).scanDirectoryForHistoryFiles((Path)Mockito.eq((Object)donePathToday), (FileContext)Mockito.any(FileContext.class));
        ((HistoryFileManager)Mockito.doReturn(fileStatusList).when((Object)historyManager)).getHistoryDirsForCleaning(Mockito.anyLong());
        ((HistoryFileManager)Mockito.doReturn((Object)true).when((Object)historyManager)).deleteDir((FileStatus)Mockito.any(FileStatus.class));
        HistoryFileManager.JobListCache jobListCache = (HistoryFileManager.JobListCache)Mockito.mock(HistoryFileManager.JobListCache.class);
        HistoryFileManager.HistoryFileInfo fileInfo = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        ((HistoryFileManager)Mockito.doReturn((Object)jobListCache).when((Object)historyManager)).createJobListCache();
        Mockito.when((Object)jobListCache.get((JobId)Mockito.any(JobId.class))).thenReturn((Object)fileInfo);
        ((HistoryFileManager.HistoryFileInfo)Mockito.doNothing().when((Object)fileInfo)).delete();
        Configuration conf = new Configuration();
        conf.setLong("mapreduce.jobhistory.max-age-ms", 86400000L);
        conf.setLong("mapreduce.jobhistory.cleaner.interval-ms", 2000L);
        this.jobHistory.init(conf);
        this.jobHistory.start();
        Assert.assertEquals((long)2000L, (long)this.jobHistory.getCleanerInterval());
        ((HistoryFileManager.HistoryFileInfo)Mockito.verify((Object)fileInfo, (VerificationMode)Mockito.timeout((int)20000).times(1))).delete();
        fileStatusList.remove(dirCreatedYesterdayStatus);
        conf.setLong("mapreduce.jobhistory.max-age-ms", 10000L);
        conf.setLong("mapreduce.jobhistory.cleaner.interval-ms", 1000L);
        ((JobHistory)Mockito.doReturn((Object)conf).when((Object)this.jobHistory)).createConf();
        this.jobHistory.refreshJobRetentionSettings();
        Assert.assertEquals((long)1000L, (long)this.jobHistory.getCleanerInterval());
        ((HistoryFileManager.HistoryFileInfo)Mockito.verify((Object)fileInfo, (VerificationMode)Mockito.timeout((int)20000).times(2))).delete();
    }

    @Test
    public void testRefreshLoadedJobCacheUnSupportedOperation() {
        this.jobHistory = (JobHistory)Mockito.spy((Object)new JobHistory());
        1 storage = new /* Unavailable Anonymous Inner Class!! */;
        ((JobHistory)Mockito.doReturn((Object)storage).when((Object)this.jobHistory)).createHistoryStorage();
        this.jobHistory.init(new Configuration());
        this.jobHistory.start();
        Exception th = null;
        try {
            this.jobHistory.refreshLoadedJobCache();
        }
        catch (Exception e) {
            th = e;
        }
        Assert.assertTrue((boolean)(th instanceof UnsupportedOperationException));
    }

    @After
    public void cleanUp() {
        if (this.jobHistory != null) {
            this.jobHistory.stop();
        }
    }
}

