/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.HistoryViewer;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.JobIdPBImpl;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.TaskIdPBImpl;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.hs.CompletedTask;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.hs.JobHistory;
import org.apache.hadoop.mapreduce.v2.hs.PartialJob;
import org.apache.hadoop.mapreduce.v2.hs.TestJobHistoryEvents;
import org.apache.hadoop.mapreduce.v2.hs.TestJobHistoryParsing;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobsInfo;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobIndexInfo;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.RackResolver;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestJobHistoryParsing {
    private static final Log LOG = LogFactory.getLog(TestJobHistoryParsing.class);
    private static final String RACK_NAME = "/MyRackName";
    private ByteArrayOutputStream outContent = new ByteArrayOutputStream();

    @Test(timeout=50000L)
    public void testJobInfo() throws Exception {
        JobHistoryParser.JobInfo info = new JobHistoryParser.JobInfo();
        Assert.assertEquals((Object)"NORMAL", (Object)info.getPriority());
        info.printAll();
    }

    @Test(timeout=300000L)
    public void testHistoryParsing() throws Exception {
        LOG.info((Object)"STARTING testHistoryParsing()");
        try {
            this.checkHistoryParsing(2, 1, 2);
        }
        finally {
            LOG.info((Object)"FINISHED testHistoryParsing()");
        }
    }

    @Test(timeout=50000L)
    public void testHistoryParsingWithParseErrors() throws Exception {
        LOG.info((Object)"STARTING testHistoryParsingWithParseErrors()");
        try {
            this.checkHistoryParsing(3, 0, 2);
        }
        finally {
            LOG.info((Object)"FINISHED testHistoryParsingWithParseErrors()");
        }
    }

    private static String getJobSummary(FileContext fc, Path path) throws IOException {
        Path qPath = fc.makeQualified(path);
        FSDataInputStream in = fc.open(qPath);
        String jobSummaryString = in.readUTF();
        in.close();
        return jobSummaryString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHistoryParsing(int numMaps, int numReduces, int numSuccessfulMaps) throws Exception {
        long numFinishedMaps;
        JobHistoryParser.JobInfo jobInfo;
        Object keypair;
        Configuration conf = new Configuration();
        conf.set("mapreduce.job.user.name", System.getProperty("user.name"));
        long amStartTimeEst = System.currentTimeMillis();
        conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
        RackResolver.init((Configuration)conf);
        TestJobHistoryEvents.MRAppWithHistory app = new TestJobHistoryEvents.MRAppWithHistory(numMaps, numReduces, true, this.getClass().getName(), true);
        app.submit(conf);
        Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
        JobId jobId = job.getID();
        LOG.info((Object)("JOBID is " + TypeConverter.fromYarn((JobId)jobId).toString()));
        app.waitForState(job, JobState.SUCCEEDED);
        app.waitForState(Service.STATE.STOPPED);
        String jobhistoryDir = JobHistoryUtils.getHistoryIntermediateDoneDirForUser((Configuration)conf);
        FileContext fc = null;
        try {
            fc = FileContext.getFileContext((Configuration)conf);
        }
        catch (IOException ioe) {
            LOG.info((Object)"Can not get FileContext", (Throwable)ioe);
            throw new Exception("Can not get File Context");
        }
        if (numMaps == numSuccessfulMaps) {
            String summaryFileName = JobHistoryUtils.getIntermediateSummaryFileName((JobId)jobId);
            Path summaryFile = new Path(jobhistoryDir, summaryFileName);
            String jobSummaryString = TestJobHistoryParsing.getJobSummary((FileContext)fc, (Path)summaryFile);
            Assert.assertNotNull((Object)jobSummaryString);
            Assert.assertTrue((boolean)jobSummaryString.contains("resourcesPerMap=100"));
            Assert.assertTrue((boolean)jobSummaryString.contains("resourcesPerReduce=100"));
            HashMap<String, String> jobSummaryElements = new HashMap<String, String>();
            StringTokenizer strToken = new StringTokenizer(jobSummaryString, ",");
            while (strToken.hasMoreTokens()) {
                keypair = strToken.nextToken();
                jobSummaryElements.put(((String)keypair).split("=")[0], ((String)keypair).split("=")[1]);
            }
            Assert.assertEquals((String)"JobId does not match", (Object)jobId.toString(), jobSummaryElements.get("jobId"));
            Assert.assertEquals((String)"JobName does not match", (Object)"test", jobSummaryElements.get("jobName"));
            Assert.assertTrue((String)"submitTime should not be 0", (Long.parseLong((String)jobSummaryElements.get("submitTime")) != 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)"launchTime should not be 0", (Long.parseLong((String)jobSummaryElements.get("launchTime")) != 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)"firstMapTaskLaunchTime should not be 0", (Long.parseLong((String)jobSummaryElements.get("firstMapTaskLaunchTime")) != 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)"firstReduceTaskLaunchTime should not be 0", (Long.parseLong((String)jobSummaryElements.get("firstReduceTaskLaunchTime")) != 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)"finishTime should not be 0", (Long.parseLong((String)jobSummaryElements.get("finishTime")) != 0L ? 1 : 0) != 0);
            Assert.assertEquals((String)"Mismatch in num map slots", (long)numSuccessfulMaps, (long)Integer.parseInt((String)jobSummaryElements.get("numMaps")));
            Assert.assertEquals((String)"Mismatch in num reduce slots", (long)numReduces, (long)Integer.parseInt((String)jobSummaryElements.get("numReduces")));
            Assert.assertEquals((String)"User does not match", (Object)System.getProperty("user.name"), jobSummaryElements.get("user"));
            Assert.assertEquals((String)"Queue does not match", (Object)"default", jobSummaryElements.get("queue"));
            Assert.assertEquals((String)"Status does not match", (Object)"SUCCEEDED", jobSummaryElements.get("status"));
        }
        JobHistory jobHistory = new JobHistory();
        jobHistory.init(conf);
        HistoryFileManager.HistoryFileInfo fileInfo = jobHistory.getJobFileInfo(jobId);
        keypair = fileInfo;
        synchronized (keypair) {
            Path historyFilePath = fileInfo.getHistoryFile();
            FSDataInputStream in = null;
            LOG.info((Object)("JobHistoryFile is: " + historyFilePath));
            try {
                in = fc.open(fc.makeQualified(historyFilePath));
            }
            catch (IOException ioe) {
                LOG.info((Object)("Can not open history file: " + historyFilePath), (Throwable)ioe);
                throw new Exception("Can not open History File");
            }
            JobHistoryParser parser = new JobHistoryParser(in);
            EventReader realReader = new EventReader((DataInputStream)in);
            EventReader reader = (EventReader)Mockito.mock(EventReader.class);
            if (numMaps == numSuccessfulMaps) {
                reader = realReader;
            } else {
                AtomicInteger numFinishedEvents = new AtomicInteger(0);
                Mockito.when((Object)reader.getNextEvent()).thenAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */);
            }
            jobInfo = parser.parse(reader);
            numFinishedMaps = this.computeFinishedMaps(jobInfo, numMaps, numSuccessfulMaps);
            if (numFinishedMaps != (long)numMaps) {
                IOException parseException = parser.getParseException();
                Assert.assertNotNull((String)"Didn't get expected parse exception", (Object)parseException);
            }
        }
        Assert.assertEquals((String)"Incorrect username ", (Object)System.getProperty("user.name"), (Object)jobInfo.getUsername());
        Assert.assertEquals((String)"Incorrect jobName ", (Object)"test", (Object)jobInfo.getJobname());
        Assert.assertEquals((String)"Incorrect queuename ", (Object)"default", (Object)jobInfo.getJobQueueName());
        Assert.assertEquals((String)"incorrect conf path", (Object)"test", (Object)jobInfo.getJobConfPath());
        Assert.assertEquals((String)"incorrect finishedMap ", (long)numSuccessfulMaps, (long)numFinishedMaps);
        Assert.assertEquals((String)"incorrect finishedReduces ", (long)numReduces, (long)jobInfo.getFinishedReduces());
        Assert.assertEquals((String)"incorrect uberized ", (Object)job.isUber(), (Object)jobInfo.getUberized());
        Map allTasks = jobInfo.getAllTasks();
        int totalTasks = allTasks.size();
        Assert.assertEquals((String)"total number of tasks is incorrect  ", (long)(numMaps + numReduces), (long)totalTasks);
        Assert.assertEquals((long)1L, (long)jobInfo.getAMInfos().size());
        Assert.assertEquals((Object)MRApp.NM_HOST, (Object)((JobHistoryParser.AMInfo)jobInfo.getAMInfos().get(0)).getNodeManagerHost());
        JobHistoryParser.AMInfo amInfo = (JobHistoryParser.AMInfo)jobInfo.getAMInfos().get(0);
        Assert.assertEquals((long)MRApp.NM_PORT, (long)amInfo.getNodeManagerPort());
        Assert.assertEquals((long)MRApp.NM_HTTP_PORT, (long)amInfo.getNodeManagerHttpPort());
        Assert.assertEquals((long)1L, (long)amInfo.getAppAttemptId().getAttemptId());
        Assert.assertEquals((Object)amInfo.getAppAttemptId(), (Object)amInfo.getContainerId().getApplicationAttemptId());
        Assert.assertTrue((amInfo.getStartTime() <= System.currentTimeMillis() && amInfo.getStartTime() >= amStartTimeEst ? 1 : 0) != 0);
        ContainerId fakeCid = MRApp.newContainerId((int)-1, (int)-1, (long)-1L, (int)-1);
        for (JobHistoryParser.TaskInfo taskInfo : allTasks.values()) {
            int taskAttemptCount = taskInfo.getAllTaskAttempts().size();
            Assert.assertEquals((String)"total number of task attempts ", (long)1L, (long)taskAttemptCount);
            JobHistoryParser.TaskAttemptInfo taInfo = (JobHistoryParser.TaskAttemptInfo)taskInfo.getAllTaskAttempts().values().iterator().next();
            Assert.assertNotNull((Object)taInfo.getContainerId());
            Assert.assertFalse((boolean)taInfo.getContainerId().equals((Object)fakeCid));
        }
        for (Task task : job.getTasks().values()) {
            JobHistoryParser.TaskInfo taskInfo = (JobHistoryParser.TaskInfo)allTasks.get(TypeConverter.fromYarn((TaskId)task.getID()));
            Assert.assertNotNull((String)"TaskInfo not found", (Object)taskInfo);
            for (TaskAttempt taskAttempt : task.getAttempts().values()) {
                JobHistoryParser.TaskAttemptInfo taskAttemptInfo = (JobHistoryParser.TaskAttemptInfo)taskInfo.getAllTaskAttempts().get(TypeConverter.fromYarn((TaskAttemptId)taskAttempt.getID()));
                Assert.assertNotNull((String)"TaskAttemptInfo not found", (Object)taskAttemptInfo);
                Assert.assertEquals((String)"Incorrect shuffle port for task attempt", (long)taskAttempt.getShufflePort(), (long)taskAttemptInfo.getShufflePort());
                if (numMaps != numSuccessfulMaps) continue;
                Assert.assertEquals((Object)MRApp.NM_HOST, (Object)taskAttemptInfo.getHostname());
                Assert.assertEquals((long)MRApp.NM_PORT, (long)taskAttemptInfo.getPort());
                Assert.assertEquals((String)"rack-name is incorrect", (Object)taskAttemptInfo.getRackname(), (Object)"/MyRackName");
            }
        }
        PrintStream stdps = System.out;
        try {
            HistoryViewer viewer;
            System.setOut(new PrintStream(this.outContent));
            HistoryFileManager.HistoryFileInfo historyFileInfo = fileInfo;
            synchronized (historyFileInfo) {
                viewer = new HistoryViewer(fc.makeQualified(fileInfo.getHistoryFile()).toString(), conf, true);
            }
            viewer.print();
            for (JobHistoryParser.TaskInfo taskInfo : allTasks.values()) {
                String test = (taskInfo.getTaskStatus() == null ? "" : taskInfo.getTaskStatus()) + " " + taskInfo.getTaskType() + " task list for " + taskInfo.getTaskId().getJobID();
                Assert.assertTrue((this.outContent.toString().indexOf(test) > 0 ? 1 : 0) != 0);
                Assert.assertTrue((this.outContent.toString().indexOf(taskInfo.getTaskId().toString()) > 0 ? 1 : 0) != 0);
            }
        }
        finally {
            System.setOut(stdps);
        }
    }

    private long computeFinishedMaps(JobHistoryParser.JobInfo jobInfo, int numMaps, int numSuccessfulMaps) {
        if (numMaps == numSuccessfulMaps) {
            return jobInfo.getFinishedMaps();
        }
        long numFinishedMaps = 0L;
        Map taskInfos = jobInfo.getAllTasks();
        for (JobHistoryParser.TaskInfo taskInfo : taskInfos.values()) {
            if (!TaskState.SUCCEEDED.toString().equals(taskInfo.getTaskStatus())) continue;
            ++numFinishedMaps;
        }
        return numFinishedMaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testHistoryParsingForFailedAttempts() throws Exception {
        LOG.info((Object)"STARTING testHistoryParsingForFailedAttempts");
        try {
            JobHistoryParser.JobInfo jobInfo;
            JobHistoryParser parser;
            HistoryFileManager.HistoryFileInfo fileInfo;
            Configuration conf = new Configuration();
            conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
            RackResolver.init((Configuration)conf);
            MRAppWithHistoryWithFailedAttempt app = new MRAppWithHistoryWithFailedAttempt(2, 1, true, this.getClass().getName(), true);
            app.submit(conf);
            Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
            JobId jobId = job.getID();
            app.waitForState(job, JobState.SUCCEEDED);
            app.waitForState(Service.STATE.STOPPED);
            JobHistory jobHistory = new JobHistory();
            jobHistory.init(conf);
            HistoryFileManager.HistoryFileInfo historyFileInfo = fileInfo = jobHistory.getJobFileInfo(jobId);
            synchronized (historyFileInfo) {
                Path historyFilePath = fileInfo.getHistoryFile();
                FSDataInputStream in = null;
                FileContext fc = null;
                try {
                    fc = FileContext.getFileContext((Configuration)conf);
                    in = fc.open(fc.makeQualified(historyFilePath));
                }
                catch (IOException ioe) {
                    LOG.info((Object)("Can not open history file: " + historyFilePath), (Throwable)ioe);
                    throw new Exception("Can not open History File");
                }
                parser = new JobHistoryParser(in);
                jobInfo = parser.parse();
            }
            IOException parseException = parser.getParseException();
            Assert.assertNull((String)("Caught an expected exception " + parseException), (Object)parseException);
            int noOffailedAttempts = 0;
            Map allTasks = jobInfo.getAllTasks();
            for (Task task : job.getTasks().values()) {
                JobHistoryParser.TaskInfo taskInfo = (JobHistoryParser.TaskInfo)allTasks.get(TypeConverter.fromYarn((TaskId)task.getID()));
                for (TaskAttempt taskAttempt : task.getAttempts().values()) {
                    JobHistoryParser.TaskAttemptInfo taskAttemptInfo = (JobHistoryParser.TaskAttemptInfo)taskInfo.getAllTaskAttempts().get(TypeConverter.fromYarn((TaskAttemptId)taskAttempt.getID()));
                    Assert.assertEquals((String)"rack-name is incorrect", (Object)taskAttemptInfo.getRackname(), (Object)"/MyRackName");
                    if (!taskAttemptInfo.getTaskStatus().equals("FAILED")) continue;
                    ++noOffailedAttempts;
                }
            }
            Assert.assertEquals((String)"No of Failed tasks doesn't match.", (long)2L, (long)noOffailedAttempts);
        }
        finally {
            LOG.info((Object)"FINISHED testHistoryParsingForFailedAttempts");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testCountersForFailedTask() throws Exception {
        LOG.info((Object)"STARTING testCountersForFailedTask");
        try {
            JobHistoryParser.JobInfo jobInfo;
            JobHistoryParser parser;
            HistoryFileManager.HistoryFileInfo fileInfo;
            Configuration conf = new Configuration();
            conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
            RackResolver.init((Configuration)conf);
            MRAppWithHistoryWithFailedTask app = new MRAppWithHistoryWithFailedTask(2, 1, true, this.getClass().getName(), true);
            app.submit(conf);
            Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
            JobId jobId = job.getID();
            app.waitForState(job, JobState.FAILED);
            app.waitForState(Service.STATE.STOPPED);
            JobHistory jobHistory = new JobHistory();
            jobHistory.init(conf);
            HistoryFileManager.HistoryFileInfo historyFileInfo = fileInfo = jobHistory.getJobFileInfo(jobId);
            synchronized (historyFileInfo) {
                FSDataInputStream fSDataInputStream;
                Path historyFilePath = fileInfo.getHistoryFile();
                Object var11_9 = null;
                FileContext fc = null;
                try {
                    fc = FileContext.getFileContext((Configuration)conf);
                    fSDataInputStream = fc.open(fc.makeQualified(historyFilePath));
                }
                catch (IOException ioe) {
                    LOG.info((Object)("Can not open history file: " + historyFilePath), (Throwable)ioe);
                    throw new Exception("Can not open History File");
                }
                parser = new JobHistoryParser(fSDataInputStream);
                jobInfo = parser.parse();
            }
            IOException parseException = parser.getParseException();
            Assert.assertNull((String)("Caught an expected exception " + parseException), (Object)parseException);
            for (Map.Entry entry : jobInfo.getAllTasks().entrySet()) {
                TaskId yarnTaskID = TypeConverter.toYarn((TaskID)((TaskID)entry.getKey()));
                CompletedTask ct = new CompletedTask(yarnTaskID, (JobHistoryParser.TaskInfo)entry.getValue());
                Assert.assertNotNull((String)"completed task report has null counters", (Object)ct.getReport().getCounters());
            }
            List originalDiagnostics = job.getDiagnostics();
            String string = jobInfo.getErrorInfo();
            Assert.assertTrue((String)"No original diagnostics for a failed job", (originalDiagnostics != null && !originalDiagnostics.isEmpty() ? 1 : 0) != 0);
            Assert.assertNotNull((String)"No history error info for a failed job ", (Object)string);
            for (String diagString : originalDiagnostics) {
                Assert.assertTrue((boolean)string.contains(diagString));
            }
        }
        finally {
            LOG.info((Object)"FINISHED testCountersForFailedTask");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDiagnosticsForKilledJob() throws Exception {
        LOG.info((Object)"STARTING testDiagnosticsForKilledJob");
        try {
            JobHistoryParser.JobInfo jobInfo;
            JobHistoryParser parser;
            HistoryFileManager.HistoryFileInfo fileInfo;
            Configuration conf = new Configuration();
            conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
            RackResolver.init((Configuration)conf);
            MRAppWithHistoryWithJobKilled app = new MRAppWithHistoryWithJobKilled(2, 1, true, this.getClass().getName(), true);
            app.submit(conf);
            Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
            JobId jobId = job.getID();
            app.waitForState(job, JobState.KILLED);
            app.waitForState(Service.STATE.STOPPED);
            JobHistory jobHistory = new JobHistory();
            jobHistory.init(conf);
            HistoryFileManager.HistoryFileInfo historyFileInfo = fileInfo = jobHistory.getJobFileInfo(jobId);
            synchronized (historyFileInfo) {
                Path historyFilePath = fileInfo.getHistoryFile();
                FSDataInputStream in = null;
                FileContext fc = null;
                try {
                    fc = FileContext.getFileContext((Configuration)conf);
                    in = fc.open(fc.makeQualified(historyFilePath));
                }
                catch (IOException ioe) {
                    LOG.info((Object)("Can not open history file: " + historyFilePath), (Throwable)ioe);
                    throw new Exception("Can not open History File");
                }
                parser = new JobHistoryParser(in);
                jobInfo = parser.parse();
            }
            IOException parseException = parser.getParseException();
            Assert.assertNull((String)("Caught an expected exception " + parseException), (Object)parseException);
            List originalDiagnostics = job.getDiagnostics();
            String historyError = jobInfo.getErrorInfo();
            Assert.assertTrue((String)"No original diagnostics for a failed job", (originalDiagnostics != null && !originalDiagnostics.isEmpty() ? 1 : 0) != 0);
            Assert.assertNotNull((String)"No history error info for a failed job ", (Object)historyError);
            for (String diagString : originalDiagnostics) {
                Assert.assertTrue((boolean)historyError.contains(diagString));
            }
            Assert.assertTrue((String)"No killed message in diagnostics", (boolean)historyError.contains("Job received Kill while in RUNNING state."));
        }
        finally {
            LOG.info((Object)"FINISHED testDiagnosticsForKilledJob");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testScanningOldDirs() throws Exception {
        LOG.info((Object)"STARTING testScanningOldDirs");
        try {
            int msecToSleep;
            Configuration conf = new Configuration();
            conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
            RackResolver.init((Configuration)conf);
            TestJobHistoryEvents.MRAppWithHistory app = new TestJobHistoryEvents.MRAppWithHistory(1, 1, true, this.getClass().getName(), true);
            app.submit(conf);
            Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
            JobId jobId = job.getID();
            LOG.info((Object)("JOBID is " + TypeConverter.fromYarn((JobId)jobId).toString()));
            app.waitForState(job, JobState.SUCCEEDED);
            app.waitForState(Service.STATE.STOPPED);
            HistoryFileManagerForTest hfm = new HistoryFileManagerForTest();
            hfm.init(conf);
            HistoryFileManager.HistoryFileInfo fileInfo = hfm.getFileInfo(jobId);
            Assert.assertNotNull((String)"Unable to locate job history", (Object)fileInfo);
            hfm.deleteJobFromJobListCache(fileInfo);
            int msecPerSleep = 10;
            for (msecToSleep = 10000; fileInfo.isMovePending() && msecToSleep > 0; msecToSleep -= 10) {
                Assert.assertTrue((!fileInfo.didMoveFail() ? 1 : 0) != 0);
                Thread.sleep(10L);
            }
            Assert.assertTrue((String)"Timeout waiting for history move", (msecToSleep > 0 ? 1 : 0) != 0);
            fileInfo = hfm.getFileInfo(jobId);
            hfm.stop();
            Assert.assertNotNull((String)"Unable to locate old job history", (Object)fileInfo);
            Assert.assertTrue((String)"HistoryFileManager not shutdown properly", (boolean)hfm.moveToDoneExecutor.isTerminated());
        }
        finally {
            LOG.info((Object)"FINISHED testScanningOldDirs");
        }
    }

    public static void main(String[] args) throws Exception {
        TestJobHistoryParsing t = new TestJobHistoryParsing();
        t.testHistoryParsing();
        t.testHistoryParsingForFailedAttempts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=15000L)
    public void testDeleteFileInfo() throws Exception {
        LOG.info((Object)"STARTING testDeleteFileInfo");
        try {
            Configuration conf = new Configuration();
            conf.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
            RackResolver.init((Configuration)conf);
            TestJobHistoryEvents.MRAppWithHistory app = new TestJobHistoryEvents.MRAppWithHistory(1, 1, true, this.getClass().getName(), true);
            app.submit(conf);
            Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
            JobId jobId = job.getID();
            app.waitForState(job, JobState.SUCCEEDED);
            app.waitForState(Service.STATE.STOPPED);
            HistoryFileManager hfm = new HistoryFileManager();
            hfm.init(conf);
            HistoryFileManager.HistoryFileInfo fileInfo = hfm.getFileInfo(jobId);
            hfm.initExisting();
            while (fileInfo.isMovePending()) {
                Thread.sleep(300L);
            }
            Assert.assertNotNull((Object)hfm.jobListCache.values());
            hfm.clean();
            Assert.assertFalse((boolean)fileInfo.isDeleted());
            hfm.setMaxHistoryAge(-1L);
            hfm.clean();
            hfm.stop();
            Assert.assertTrue((String)"Thread pool shutdown", (boolean)hfm.moveToDoneExecutor.isTerminated());
            Assert.assertTrue((String)"file should be deleted ", (boolean)fileInfo.isDeleted());
        }
        finally {
            LOG.info((Object)"FINISHED testDeleteFileInfo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testJobHistoryMethods() throws Exception {
        LOG.info((Object)"STARTING testJobHistoryMethods");
        try {
            Configuration configuration = new Configuration();
            configuration.setClass("net.topology.node.switch.mapping.impl", MyResolver.class, DNSToSwitchMapping.class);
            RackResolver.init((Configuration)configuration);
            TestJobHistoryEvents.MRAppWithHistory app = new TestJobHistoryEvents.MRAppWithHistory(1, 1, true, this.getClass().getName(), true);
            app.submit(configuration);
            Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
            app.waitForState(job, JobState.SUCCEEDED);
            JobHistory jobHistory = new JobHistory();
            jobHistory.init(configuration);
            Assert.assertEquals((long)1L, (long)jobHistory.getAllJobs().size());
            Assert.assertEquals((long)1L, (long)jobHistory.getAllJobs(app.getAppID()).size());
            JobsInfo jobsinfo = jobHistory.getPartialJobs(Long.valueOf(0L), Long.valueOf(10L), null, "default", Long.valueOf(0L), Long.valueOf(System.currentTimeMillis() + 1L), Long.valueOf(0L), Long.valueOf(System.currentTimeMillis() + 1L), JobState.SUCCEEDED);
            Assert.assertEquals((long)1L, (long)jobsinfo.getJobs().size());
            Assert.assertNotNull((Object)jobHistory.getApplicationAttemptId());
            Assert.assertEquals((Object)"application_0_0000", (Object)jobHistory.getApplicationID().toString());
            Assert.assertEquals((Object)"Job History Server", (Object)jobHistory.getApplicationName());
            Assert.assertNull((Object)jobHistory.getEventHandler());
            Assert.assertNull((Object)jobHistory.getClock());
            Assert.assertNull((Object)jobHistory.getClusterInfo());
        }
        finally {
            LOG.info((Object)"FINISHED testJobHistoryMethods");
        }
    }

    @Test(timeout=3000L)
    public void testPartialJob() throws Exception {
        JobIdPBImpl jobId = new JobIdPBImpl();
        jobId.setId(0);
        JobIndexInfo jii = new JobIndexInfo(0L, System.currentTimeMillis(), "user", "jobName", (JobId)jobId, 3, 2, "JobStatus");
        PartialJob test = new PartialJob(jii, (JobId)jobId);
        Assert.assertEquals((double)1.0, (double)test.getProgress(), (double)0.001);
        Assert.assertNull((Object)test.getAllCounters());
        Assert.assertNull((Object)test.getTasks());
        Assert.assertNull((Object)test.getTasks(org.apache.hadoop.mapreduce.v2.api.records.TaskType.MAP));
        Assert.assertNull((Object)test.getTask((TaskId)new TaskIdPBImpl()));
        Assert.assertNull((Object)test.getTaskAttemptCompletionEvents(0, 100));
        Assert.assertNull((Object)test.getMapAttemptCompletionEvents(0, 100));
        Assert.assertTrue((boolean)test.checkAccess(UserGroupInformation.getCurrentUser(), null));
        Assert.assertNull((Object)test.getAMInfos());
    }

    @Test
    public void testMultipleFailedTasks() throws Exception {
        JobHistoryParser parser = new JobHistoryParser((FSDataInputStream)Mockito.mock(FSDataInputStream.class));
        EventReader reader = (EventReader)Mockito.mock(EventReader.class);
        AtomicInteger numEventsRead = new AtomicInteger(0);
        TaskType taskType = TaskType.MAP;
        TaskID[] tids = new TaskID[2];
        JobID jid = new JobID("1", 1);
        tids[0] = new TaskID(jid, taskType, 0);
        tids[1] = new TaskID(jid, taskType, 1);
        Mockito.when((Object)reader.getNextEvent()).thenAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */);
        JobHistoryParser.JobInfo info = parser.parse(reader);
        Assert.assertTrue((String)"Task 0 not implicated", (boolean)info.getErrorInfo().contains(tids[0].toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedJobHistoryWithoutDiagnostics() throws Exception {
        Path histPath = new Path(this.getClass().getClassLoader().getResource("job_1393307629410_0001-1393307687476-user-Sleep+job-1393307723835-0-0-FAILED-default-1393307693920.jhist").getFile());
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)new Configuration());
        try (FSDataInputStream fsdis = lfs.open(histPath);){
            JobHistoryParser parser = new JobHistoryParser(fsdis);
            JobHistoryParser.JobInfo info = parser.parse();
            Assert.assertEquals((String)"History parsed jobId incorrectly", (Object)info.getJobId(), (Object)JobID.forName((String)"job_1393307629410_0001"));
            Assert.assertEquals((String)"Default diagnostics incorrect ", (Object)"", (Object)info.getErrorInfo());
        }
    }

    @Test
    public void testTaskAttemptUnsuccessfulCompletionWithoutCounters203() throws IOException {
        Path histPath = new Path(this.getClass().getClassLoader().getResource("job_2.0.3-alpha-FAILED.jhist").getFile());
        JobHistoryParser parser = new JobHistoryParser((FileSystem)FileSystem.getLocal((Configuration)new Configuration()), histPath);
        JobHistoryParser.JobInfo jobInfo = parser.parse();
        LOG.info((Object)(" job info: " + jobInfo.getJobname() + " " + jobInfo.getFinishedMaps() + " " + jobInfo.getTotalMaps() + " " + jobInfo.getJobId()));
    }

    @Test
    public void testTaskAttemptUnsuccessfulCompletionWithoutCounters240() throws IOException {
        Path histPath = new Path(this.getClass().getClassLoader().getResource("job_2.4.0-FAILED.jhist").getFile());
        JobHistoryParser parser = new JobHistoryParser((FileSystem)FileSystem.getLocal((Configuration)new Configuration()), histPath);
        JobHistoryParser.JobInfo jobInfo = parser.parse();
        LOG.info((Object)(" job info: " + jobInfo.getJobname() + " " + jobInfo.getFinishedMaps() + " " + jobInfo.getTotalMaps() + " " + jobInfo.getJobId()));
    }

    @Test
    public void testTaskAttemptUnsuccessfulCompletionWithoutCounters0239() throws IOException {
        Path histPath = new Path(this.getClass().getClassLoader().getResource("job_0.23.9-FAILED.jhist").getFile());
        JobHistoryParser parser = new JobHistoryParser((FileSystem)FileSystem.getLocal((Configuration)new Configuration()), histPath);
        JobHistoryParser.JobInfo jobInfo = parser.parse();
        LOG.info((Object)(" job info: " + jobInfo.getJobname() + " " + jobInfo.getFinishedMaps() + " " + jobInfo.getTotalMaps() + " " + jobInfo.getJobId()));
    }
}

