/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.File;
import java.io.StringReader;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.hs.HistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsWebApp;
import org.apache.hadoop.mapreduce.v2.hs.webapp.TestHsWebServicesJobConf;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestHsWebServicesJobConf
extends JerseyTest {
    private static Configuration conf = new Configuration();
    private static HistoryContext appContext;
    private static HsWebApp webApp;
    private static File testConfDir;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});

    @Before
    public void setUp() throws Exception {
        super.setUp();
        testConfDir.mkdir();
    }

    @AfterClass
    public static void stop() {
        FileUtil.fullyDelete((File)testConfDir);
    }

    public TestHsWebServicesJobConf() {
        super((AppDescriptor)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.mapreduce.v2.hs.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testJobConf() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("conf").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("conf");
            this.verifyHsJobConf(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobConfSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("conf/").accept(new String[]{"application/json"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("conf");
            this.verifyHsJobConf(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobConfDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("conf").get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
            JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
            JSONObject info = json.getJSONObject("conf");
            this.verifyHsJobConf(info, (Job)jobsMap.get(id));
        }
    }

    @Test
    public void testJobConfXML() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        for (JobId id : jobsMap.keySet()) {
            String jobId = MRApps.toString((JobId)id);
            ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").path(jobId).path("conf").accept(new String[]{"application/xml"}).get(ClientResponse.class);
            Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
            String xml = (String)response.getEntity(String.class);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            Document dom = db.parse(is);
            NodeList info = dom.getElementsByTagName("conf");
            this.verifyHsJobConfXML(info, (Job)jobsMap.get(id));
        }
    }

    public void verifyHsJobConf(JSONObject info, Job job) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)info.length());
        WebServicesTestUtils.checkStringMatch((String)"path", (String)job.getConfFile().toString(), (String)info.getString("path"));
        JSONArray properties = info.getJSONArray("property");
        for (int i = 0; i < properties.length(); ++i) {
            JSONObject prop = properties.getJSONObject(i);
            String name = prop.getString("name");
            String value = prop.getString("value");
            Assert.assertTrue((String)"name not set", (name != null && !name.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((String)"value not set", (value != null && !value.isEmpty() ? 1 : 0) != 0);
        }
    }

    public void verifyHsJobConfXML(NodeList nodes, Job job) {
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            WebServicesTestUtils.checkStringMatch((String)"path", (String)job.getConfFile().toString(), (String)WebServicesTestUtils.getXmlString((Element)element, (String)"path"));
            NodeList properties = element.getElementsByTagName("property");
            for (int j = 0; j < properties.getLength(); ++j) {
                Element property = (Element)properties.item(j);
                Assert.assertNotNull((String)"should have counters in the web service info", (Object)property);
                String name = WebServicesTestUtils.getXmlString((Element)property, (String)"name");
                String value = WebServicesTestUtils.getXmlString((Element)property, (String)"value");
                Assert.assertTrue((String)"name not set", (name != null && !name.isEmpty() ? 1 : 0) != 0);
                Assert.assertTrue((String)"name not set", (value != null && !value.isEmpty() ? 1 : 0) != 0);
            }
        }
    }

    static /* synthetic */ File access$000() {
        return testConfDir;
    }

    static /* synthetic */ Configuration access$100() {
        return conf;
    }

    static /* synthetic */ HistoryContext access$202(HistoryContext x0) {
        appContext = x0;
        return appContext;
    }

    static /* synthetic */ HsWebApp access$302(HsWebApp x0) {
        webApp = x0;
        return webApp;
    }

    static /* synthetic */ HsWebApp access$300() {
        return webApp;
    }

    static /* synthetic */ HistoryContext access$200() {
        return appContext;
    }

    static /* synthetic */ Injector access$400(TestHsWebServicesJobConf x0) {
        return x0.injector;
    }

    static {
        testConfDir = new File("target", TestHsWebServicesJobConf.class.getSimpleName() + "confDir");
    }
}

