/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.util.Records;

public class CompletedTaskAttempt
implements TaskAttempt {
    private final JobHistoryParser.TaskAttemptInfo attemptInfo;
    private final TaskAttemptId attemptId;
    private final TaskAttemptState state;
    private final List<String> diagnostics = new ArrayList();
    private TaskAttemptReport report;
    private String localDiagMessage;

    CompletedTaskAttempt(TaskId taskId, JobHistoryParser.TaskAttemptInfo attemptInfo) {
        this.attemptInfo = attemptInfo;
        this.attemptId = TypeConverter.toYarn((TaskAttemptID)attemptInfo.getAttemptId());
        if (attemptInfo.getTaskStatus() != null) {
            this.state = TaskAttemptState.valueOf((String)attemptInfo.getTaskStatus());
        } else {
            this.state = TaskAttemptState.KILLED;
            this.localDiagMessage = "Attmpt state missing from History : marked as KILLED";
            this.diagnostics.add(this.localDiagMessage);
        }
        if (attemptInfo.getError() != null) {
            this.diagnostics.add(attemptInfo.getError());
        }
    }

    public NodeId getNodeId() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public ContainerId getAssignedContainerID() {
        return this.attemptInfo.getContainerId();
    }

    public String getAssignedContainerMgrAddress() {
        return this.attemptInfo.getHostname() + ":" + this.attemptInfo.getPort();
    }

    public String getNodeHttpAddress() {
        return this.attemptInfo.getTrackerName() + ":" + this.attemptInfo.getHttpPort();
    }

    public String getNodeRackName() {
        return this.attemptInfo.getRackname();
    }

    public Counters getCounters() {
        return this.attemptInfo.getCounters();
    }

    public TaskAttemptId getID() {
        return this.attemptId;
    }

    public float getProgress() {
        return 1.0f;
    }

    public synchronized TaskAttemptReport getReport() {
        if (this.report == null) {
            this.constructTaskAttemptReport();
        }
        return this.report;
    }

    public Phase getPhase() {
        return Phase.CLEANUP;
    }

    public TaskAttemptState getState() {
        return this.state;
    }

    public boolean isFinished() {
        return true;
    }

    public List<String> getDiagnostics() {
        return this.diagnostics;
    }

    public long getLaunchTime() {
        return this.attemptInfo.getStartTime();
    }

    public long getFinishTime() {
        return this.attemptInfo.getFinishTime();
    }

    public long getShuffleFinishTime() {
        return this.attemptInfo.getShuffleFinishTime();
    }

    public long getSortFinishTime() {
        return this.attemptInfo.getSortFinishTime();
    }

    public int getShufflePort() {
        return this.attemptInfo.getShufflePort();
    }

    private void constructTaskAttemptReport() {
        this.report = (TaskAttemptReport)Records.newRecord(TaskAttemptReport.class);
        this.report.setTaskAttemptId(this.attemptId);
        this.report.setTaskAttemptState(this.state);
        this.report.setProgress(this.getProgress());
        this.report.setStartTime(this.attemptInfo.getStartTime());
        this.report.setFinishTime(this.attemptInfo.getFinishTime());
        this.report.setShuffleFinishTime(this.attemptInfo.getShuffleFinishTime());
        this.report.setSortFinishTime(this.attemptInfo.getSortFinishTime());
        if (this.localDiagMessage != null) {
            this.report.setDiagnosticInfo(this.attemptInfo.getError() + ", " + this.localDiagMessage);
        } else {
            this.report.setDiagnosticInfo(this.attemptInfo.getError());
        }
        this.report.setStateString(this.attemptInfo.getState());
        this.report.setCounters(TypeConverter.toYarn((Counters)this.getCounters()));
        this.report.setContainerId(this.attemptInfo.getContainerId());
        if (this.attemptInfo.getHostname() == null) {
            this.report.setNodeManagerHost("UNKNOWN");
        } else {
            this.report.setNodeManagerHost(this.attemptInfo.getHostname());
            this.report.setNodeManagerPort(this.attemptInfo.getPort());
        }
        this.report.setNodeManagerHttpPort(this.attemptInfo.getHttpPort());
    }
}

