/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import com.google.common.cache.Cache;
import java.io.IOException;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.hs.CachedHistoryStorage;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.hs.JobHistory;
import org.apache.hadoop.mapreduce.v2.hs.TestJobHistory;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestJobHistory {
    JobHistory jobHistory = null;

    @Test
    public void testRefreshLoadedJobCache() throws Exception {
        HistoryFileManager historyManager = (HistoryFileManager)Mockito.mock(HistoryFileManager.class);
        this.jobHistory = (JobHistory)Mockito.spy((Object)new JobHistory());
        ((JobHistory)Mockito.doReturn((Object)historyManager).when((Object)this.jobHistory)).createHistoryFileManager();
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.jobhistory.loadedjobs.cache.size", 2);
        this.jobHistory.init(conf);
        this.jobHistory.start();
        CachedHistoryStorage storage = (CachedHistoryStorage)Mockito.spy((Object)((CachedHistoryStorage)this.jobHistory.getHistoryStorage()));
        Assert.assertFalse((boolean)storage.getUseLoadedTasksCache());
        Job[] jobs = new Job[3];
        JobId[] jobIds = new JobId[3];
        for (int i = 0; i < 3; ++i) {
            jobs[i] = (Job)Mockito.mock(Job.class);
            jobIds[i] = (JobId)Mockito.mock(JobId.class);
            Mockito.when((Object)jobs[i].getID()).thenReturn((Object)jobIds[i]);
        }
        HistoryFileManager.HistoryFileInfo fileInfo = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)historyManager.getFileInfo((JobId)Matchers.any(JobId.class))).thenReturn((Object)fileInfo);
        Mockito.when((Object)fileInfo.loadJob()).thenReturn((Object)jobs[0]).thenReturn((Object)jobs[1]).thenReturn((Object)jobs[2]);
        for (int i = 0; i < 3; ++i) {
            storage.getFullJob(jobs[i].getID());
        }
        Cache jobCache = storage.getLoadedJobCache();
        Assert.assertTrue((jobCache.size() > 0L ? 1 : 0) != 0);
        conf.setInt("mapreduce.jobhistory.loadedjobs.cache.size", 3);
        ((CachedHistoryStorage)Mockito.doReturn((Object)conf).when((Object)storage)).createConf();
        Mockito.when((Object)fileInfo.loadJob()).thenReturn((Object)jobs[0]).thenReturn((Object)jobs[1]).thenReturn((Object)jobs[2]);
        this.jobHistory.refreshLoadedJobCache();
        for (int i = 0; i < 3; ++i) {
            storage.getFullJob(jobs[i].getID());
        }
        jobCache = storage.getLoadedJobCache();
        Assert.assertTrue((jobCache.size() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testTasksCacheLimit() throws Exception {
        HistoryFileManager historyManager = (HistoryFileManager)Mockito.mock(HistoryFileManager.class);
        this.jobHistory = (JobHistory)Mockito.spy((Object)new JobHistory());
        ((JobHistory)Mockito.doReturn((Object)historyManager).when((Object)this.jobHistory)).createHistoryFileManager();
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.jobhistory.loadedtasks.cache.size", 50);
        this.jobHistory.init(conf);
        this.jobHistory.start();
        CachedHistoryStorage storage = (CachedHistoryStorage)Mockito.spy((Object)((CachedHistoryStorage)this.jobHistory.getHistoryStorage()));
        Assert.assertTrue((boolean)storage.getUseLoadedTasksCache());
        TestCase.assertEquals((int)storage.getLoadedTasksCacheSize(), (int)50);
        Job[] jobs = new Job[10];
        JobId[] jobIds = new JobId[10];
        for (int i = 0; i < jobs.length; ++i) {
            jobs[i] = (Job)Mockito.mock(Job.class);
            jobIds[i] = (JobId)Mockito.mock(JobId.class);
            Mockito.when((Object)jobs[i].getID()).thenReturn((Object)jobIds[i]);
            Mockito.when((Object)jobs[i].getTotalMaps()).thenReturn((Object)10);
            Mockito.when((Object)jobs[i].getTotalReduces()).thenReturn((Object)2);
        }
        Job[] lgJobs = new Job[3];
        JobId[] lgJobIds = new JobId[3];
        for (int i = 0; i < lgJobs.length; ++i) {
            lgJobs[i] = (Job)Mockito.mock(Job.class);
            lgJobIds[i] = (JobId)Mockito.mock(JobId.class);
            Mockito.when((Object)lgJobs[i].getID()).thenReturn((Object)lgJobIds[i]);
            Mockito.when((Object)lgJobs[i].getTotalMaps()).thenReturn((Object)2000);
            Mockito.when((Object)lgJobs[i].getTotalReduces()).thenReturn((Object)10);
        }
        HistoryFileManager.HistoryFileInfo fileInfo = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)historyManager.getFileInfo((JobId)Matchers.any(JobId.class))).thenReturn((Object)fileInfo);
        Mockito.when((Object)fileInfo.loadJob()).thenReturn((Object)jobs[0]).thenReturn((Object)jobs[1]).thenReturn((Object)jobs[2]).thenReturn((Object)jobs[3]).thenReturn((Object)jobs[4]).thenReturn((Object)jobs[5]).thenReturn((Object)jobs[6]).thenReturn((Object)jobs[7]).thenReturn((Object)jobs[8]).thenReturn((Object)jobs[9]).thenReturn((Object)lgJobs[0]).thenReturn((Object)lgJobs[1]).thenReturn((Object)lgJobs[2]);
        Cache jobCache = storage.getLoadedJobCache();
        for (int i = 0; i < jobs.length; ++i) {
            storage.getFullJob(jobs[i].getID());
        }
        long prevSize = jobCache.size();
        for (int i = 0; i < lgJobs.length; ++i) {
            storage.getFullJob(lgJobs[i].getID());
        }
        Assert.assertTrue((jobCache.size() < prevSize ? 1 : 0) != 0);
    }

    @Test
    public void testJobCacheLimitLargerThanMax() throws Exception {
        HistoryFileManager historyManager = (HistoryFileManager)Mockito.mock(HistoryFileManager.class);
        JobHistory jobHistory = (JobHistory)Mockito.spy((Object)new JobHistory());
        ((JobHistory)Mockito.doReturn((Object)historyManager).when((Object)jobHistory)).createHistoryFileManager();
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.jobhistory.loadedtasks.cache.size", 500);
        jobHistory.init(conf);
        jobHistory.start();
        CachedHistoryStorage storage = (CachedHistoryStorage)Mockito.spy((Object)((CachedHistoryStorage)jobHistory.getHistoryStorage()));
        Assert.assertTrue((boolean)storage.getUseLoadedTasksCache());
        TestCase.assertEquals((int)storage.getLoadedTasksCacheSize(), (int)500);
        Job[] lgJobs = new Job[10];
        JobId[] lgJobIds = new JobId[10];
        for (int i = 0; i < lgJobs.length; ++i) {
            lgJobs[i] = (Job)Mockito.mock(Job.class);
            lgJobIds[i] = (JobId)Mockito.mock(JobId.class);
            Mockito.when((Object)lgJobs[i].getID()).thenReturn((Object)lgJobIds[i]);
            Mockito.when((Object)lgJobs[i].getTotalMaps()).thenReturn((Object)700);
            Mockito.when((Object)lgJobs[i].getTotalReduces()).thenReturn((Object)50);
        }
        HistoryFileManager.HistoryFileInfo fileInfo = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)historyManager.getFileInfo((JobId)Matchers.any(JobId.class))).thenReturn((Object)fileInfo);
        Mockito.when((Object)fileInfo.loadJob()).thenReturn((Object)lgJobs[0]).thenReturn((Object)lgJobs[1]).thenReturn((Object)lgJobs[2]).thenReturn((Object)lgJobs[3]).thenReturn((Object)lgJobs[4]).thenReturn((Object)lgJobs[5]).thenReturn((Object)lgJobs[6]).thenReturn((Object)lgJobs[7]).thenReturn((Object)lgJobs[8]).thenReturn((Object)lgJobs[9]);
        Cache jobCache = storage.getLoadedJobCache();
        long[] cacheSize = new long[10];
        for (int i = 0; i < lgJobs.length; ++i) {
            storage.getFullJob(lgJobs[i].getID());
            Assert.assertTrue((jobCache.size() > 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLoadedTasksEmptyConfiguration() {
        Configuration conf = new Configuration();
        conf.set("mapreduce.jobhistory.loadedtasks.cache.size", "");
        HistoryFileManager historyManager = (HistoryFileManager)Mockito.mock(HistoryFileManager.class);
        JobHistory jobHistory = (JobHistory)Mockito.spy((Object)new JobHistory());
        ((JobHistory)Mockito.doReturn((Object)historyManager).when((Object)jobHistory)).createHistoryFileManager();
        jobHistory.init(conf);
        jobHistory.start();
        CachedHistoryStorage storage = (CachedHistoryStorage)Mockito.spy((Object)((CachedHistoryStorage)jobHistory.getHistoryStorage()));
        Assert.assertFalse((boolean)storage.getUseLoadedTasksCache());
    }

    @Test
    public void testLoadedTasksZeroConfiguration() {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.jobhistory.loadedtasks.cache.size", 0);
        HistoryFileManager historyManager = (HistoryFileManager)Mockito.mock(HistoryFileManager.class);
        JobHistory jobHistory = (JobHistory)Mockito.spy((Object)new JobHistory());
        ((JobHistory)Mockito.doReturn((Object)historyManager).when((Object)jobHistory)).createHistoryFileManager();
        jobHistory.init(conf);
        jobHistory.start();
        CachedHistoryStorage storage = (CachedHistoryStorage)Mockito.spy((Object)((CachedHistoryStorage)jobHistory.getHistoryStorage()));
        Assert.assertTrue((boolean)storage.getUseLoadedTasksCache());
        TestCase.assertEquals((int)storage.getLoadedTasksCacheSize(), (int)1);
    }

    @Test
    public void testLoadedTasksNegativeConfiguration() {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.jobhistory.loadedtasks.cache.size", -1);
        HistoryFileManager historyManager = (HistoryFileManager)Mockito.mock(HistoryFileManager.class);
        JobHistory jobHistory = (JobHistory)Mockito.spy((Object)new JobHistory());
        ((JobHistory)Mockito.doReturn((Object)historyManager).when((Object)jobHistory)).createHistoryFileManager();
        jobHistory.init(conf);
        jobHistory.start();
        CachedHistoryStorage storage = (CachedHistoryStorage)Mockito.spy((Object)((CachedHistoryStorage)jobHistory.getHistoryStorage()));
        Assert.assertTrue((boolean)storage.getUseLoadedTasksCache());
        TestCase.assertEquals((int)storage.getLoadedTasksCacheSize(), (int)1);
    }

    @Test
    public void testLoadJobErrorCases() throws IOException {
        HistoryFileManager historyManager = (HistoryFileManager)Mockito.mock(HistoryFileManager.class);
        this.jobHistory = (JobHistory)Mockito.spy((Object)new JobHistory());
        ((JobHistory)Mockito.doReturn((Object)historyManager).when((Object)this.jobHistory)).createHistoryFileManager();
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.jobhistory.loadedtasks.cache.size", 50);
        this.jobHistory.init(conf);
        this.jobHistory.start();
        CachedHistoryStorage storage = (CachedHistoryStorage)Mockito.spy((Object)((CachedHistoryStorage)this.jobHistory.getHistoryStorage()));
        Assert.assertTrue((boolean)storage.getUseLoadedTasksCache());
        TestCase.assertEquals((int)storage.getLoadedTasksCacheSize(), (int)50);
        Job[] jobs = new Job[4];
        JobId[] jobIds = new JobId[4];
        for (int i = 0; i < jobs.length; ++i) {
            jobs[i] = (Job)Mockito.mock(Job.class);
            jobIds[i] = (JobId)Mockito.mock(JobId.class);
            Mockito.when((Object)jobs[i].getID()).thenReturn((Object)jobIds[i]);
            Mockito.when((Object)jobs[i].getTotalMaps()).thenReturn((Object)10);
            Mockito.when((Object)jobs[i].getTotalReduces()).thenReturn((Object)2);
        }
        HistoryFileManager.HistoryFileInfo loadJobException = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)loadJobException.loadJob()).thenThrow(new Throwable[]{new IOException("History file not found")});
        Mockito.when((Object)historyManager.getFileInfo(jobIds[0])).thenThrow(new Throwable[]{new IOException("")});
        Mockito.when((Object)historyManager.getFileInfo(jobIds[1])).thenReturn(null);
        Mockito.when((Object)historyManager.getFileInfo(jobIds[2])).thenReturn((Object)loadJobException);
        try {
            storage.getFullJob(jobIds[0]);
            Assert.fail((String)"Did not get expected YarnRuntimeException for getFileInfo() throwing IOException");
        }
        catch (YarnRuntimeException yarnRuntimeException) {
            // empty catch block
        }
        Job job = storage.getFullJob(jobIds[1]);
        Assert.assertNull((Object)job);
        try {
            storage.getFullJob(jobIds[2]);
            Assert.fail((String)"Did not get expected YarnRuntimeException for fileInfo.loadJob() throwing IOException");
        }
        catch (YarnRuntimeException yarnRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testRefreshJobRetentionSettings() throws IOException, InterruptedException {
        String root = "mockfs://foo/";
        String historyDoneDir = root + "mapred/history/done";
        long now = System.currentTimeMillis();
        long someTimeYesterday = now - 90000000L;
        long timeBefore200Secs = now - 200000L;
        String timestampComponent = JobHistoryUtils.timestampDirectoryComponent((long)someTimeYesterday);
        Path donePathYesterday = new Path(historyDoneDir, timestampComponent + "/" + "000000");
        FileStatus dirCreatedYesterdayStatus = new FileStatus(0L, true, 0, 0L, someTimeYesterday, donePathYesterday);
        timestampComponent = JobHistoryUtils.timestampDirectoryComponent((long)timeBefore200Secs);
        Path donePathToday = new Path(historyDoneDir, timestampComponent + "/" + "000000");
        FileStatus dirCreatedTodayStatus = new FileStatus(0L, true, 0, 0L, timeBefore200Secs, donePathToday);
        Path fileUnderYesterdayDir = new Path(donePathYesterday.toString(), "job_1372363578825_0015-" + someTimeYesterday + "-user-Sleep+job-" + someTimeYesterday + "-1-1-SUCCEEDED-default.jhist");
        FileStatus fileUnderYesterdayDirStatus = new FileStatus(10L, false, 0, 0L, someTimeYesterday, fileUnderYesterdayDir);
        Path fileUnderTodayDir = new Path(donePathYesterday.toString(), "job_1372363578825_0016-" + timeBefore200Secs + "-user-Sleep+job-" + timeBefore200Secs + "-1-1-SUCCEEDED-default.jhist");
        FileStatus fileUnderTodayDirStatus = new FileStatus(10L, false, 0, 0L, timeBefore200Secs, fileUnderTodayDir);
        HistoryFileManager historyManager = (HistoryFileManager)Mockito.spy((Object)new HistoryFileManager());
        this.jobHistory = (JobHistory)Mockito.spy((Object)new JobHistory());
        LinkedList<FileStatus> fileStatusList = new LinkedList<FileStatus>();
        fileStatusList.add(dirCreatedYesterdayStatus);
        fileStatusList.add(dirCreatedTodayStatus);
        ((JobHistory)Mockito.doReturn((Object)4).when((Object)this.jobHistory)).getInitDelaySecs();
        ((JobHistory)Mockito.doReturn((Object)historyManager).when((Object)this.jobHistory)).createHistoryFileManager();
        LinkedList<FileStatus> list1 = new LinkedList<FileStatus>();
        list1.add(fileUnderYesterdayDirStatus);
        ((HistoryFileManager)Mockito.doReturn(list1).when((Object)historyManager)).scanDirectoryForHistoryFiles((Path)Matchers.eq((Object)donePathYesterday), (FileContext)Matchers.any(FileContext.class));
        LinkedList<FileStatus> list2 = new LinkedList<FileStatus>();
        list2.add(fileUnderTodayDirStatus);
        ((HistoryFileManager)Mockito.doReturn(list2).when((Object)historyManager)).scanDirectoryForHistoryFiles((Path)Matchers.eq((Object)donePathToday), (FileContext)Matchers.any(FileContext.class));
        ((HistoryFileManager)Mockito.doReturn(fileStatusList).when((Object)historyManager)).getHistoryDirsForCleaning(Mockito.anyLong());
        ((HistoryFileManager)Mockito.doReturn((Object)true).when((Object)historyManager)).deleteDir((FileStatus)Matchers.any(FileStatus.class));
        HistoryFileManager.JobListCache jobListCache = (HistoryFileManager.JobListCache)Mockito.mock(HistoryFileManager.JobListCache.class);
        HistoryFileManager.HistoryFileInfo fileInfo = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        ((HistoryFileManager)Mockito.doReturn((Object)jobListCache).when((Object)historyManager)).createJobListCache();
        Mockito.when((Object)jobListCache.get((JobId)Matchers.any(JobId.class))).thenReturn((Object)fileInfo);
        ((HistoryFileManager.HistoryFileInfo)Mockito.doNothing().when((Object)fileInfo)).delete();
        Configuration conf = new Configuration();
        conf.setLong("mapreduce.jobhistory.max-age-ms", 86400000L);
        conf.setLong("mapreduce.jobhistory.cleaner.interval-ms", 2000L);
        this.jobHistory.init(conf);
        this.jobHistory.start();
        TestCase.assertEquals((long)2000L, (long)this.jobHistory.getCleanerInterval());
        ((HistoryFileManager.HistoryFileInfo)Mockito.verify((Object)fileInfo, (VerificationMode)Mockito.timeout((int)20000).times(1))).delete();
        fileStatusList.remove(dirCreatedYesterdayStatus);
        conf.setLong("mapreduce.jobhistory.max-age-ms", 10000L);
        conf.setLong("mapreduce.jobhistory.cleaner.interval-ms", 1000L);
        ((JobHistory)Mockito.doReturn((Object)conf).when((Object)this.jobHistory)).createConf();
        this.jobHistory.refreshJobRetentionSettings();
        TestCase.assertEquals((long)1000L, (long)this.jobHistory.getCleanerInterval());
        ((HistoryFileManager.HistoryFileInfo)Mockito.verify((Object)fileInfo, (VerificationMode)Mockito.timeout((int)20000).times(2))).delete();
    }

    @Test
    public void testRefreshLoadedJobCacheUnSupportedOperation() {
        this.jobHistory = (JobHistory)Mockito.spy((Object)new JobHistory());
        1 storage = new /* Unavailable Anonymous Inner Class!! */;
        ((JobHistory)Mockito.doReturn((Object)storage).when((Object)this.jobHistory)).createHistoryStorage();
        this.jobHistory.init(new Configuration());
        this.jobHistory.start();
        Exception th = null;
        try {
            this.jobHistory.refreshLoadedJobCache();
        }
        catch (Exception e) {
            th = e;
        }
        Assert.assertTrue((boolean)(th instanceof UnsupportedOperationException));
    }

    @After
    public void cleanUp() {
        if (this.jobHistory != null) {
            this.jobHistory.stop();
        }
    }
}

