/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsTaskPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsView;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

public class HsTaskPage
extends HsView {
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        this.commonPreHead(html);
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:2}");
        this.set("ui.dataTables.id", "attempts");
        this.set(JQueryUI.initID((String)"ui.dataTables", (String)"attempts"), this.attemptsTableInit());
        this.set(JQueryUI.postInitID((String)"ui.dataTables", (String)"attempts"), this.attemptsPostTableInit());
        this.setTableStyles(html, "attempts", new String[0]);
    }

    protected Class<? extends SubView> content() {
        return AttemptsBlock.class;
    }

    private String attemptsTableInit() {
        TaskType type = null;
        String symbol = this.$("task.type");
        if (!symbol.isEmpty()) {
            type = MRApps.taskType((String)symbol);
        } else {
            TaskId taskID = MRApps.toTaskID((String)this.$("task.id"));
            type = taskID.getTaskType();
        }
        StringBuilder b = JQueryUI.tableInit().append(", 'aaData': attemptsTableData").append(", bDeferRender: true").append(", bProcessing: true").append("\n,aoColumnDefs:[\n").append("\n{'aTargets': [ 4 ]").append(", 'bSearchable': false }").append("\n, {'sType':'numeric', 'aTargets': [ 0 ]").append(", 'mRender': parseHadoopAttemptID }").append("\n, {'sType':'numeric', 'aTargets': [ 5, 6").append(type == TaskType.REDUCE ? ", 7, 8" : "").append(" ], 'mRender': renderHadoopDate }").append("\n, {'sType':'numeric', 'aTargets': [").append(type == TaskType.REDUCE ? "9, 10, 11, 12" : "7").append(" ], 'mRender': renderHadoopElapsedTime }]").append("\n, aaSorting: [[0, 'asc']]").append("}");
        return b.toString();
    }

    private String attemptsPostTableInit() {
        return "var asInitVals = new Array();\n$('tfoot input').keyup( function () \n{  attemptsDataTable.fnFilter( this.value, $('tfoot input').index(this) );\n} );\n$('tfoot input').each( function (i) {\n  asInitVals[i] = this.value;\n} );\n$('tfoot input').focus( function () {\n  if ( this.className == 'search_init' )\n  {\n    this.className = '';\n    this.value = '';\n  }\n} );\n$('tfoot input').blur( function (i) {\n  if ( this.value == '' )\n  {\n    this.className = 'search_init';\n    this.value = asInitVals[$('tfoot input').index(this)];\n  }\n} );\n";
    }
}

