/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.JobIdPBImpl;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.TaskAttemptIdPBImpl;
import org.apache.hadoop.mapreduce.v2.api.records.impl.pb.TaskIdPBImpl;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.AppForTest;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsAboutPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsAttemptsPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsConfPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsCountersPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsJobPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsLogsPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsSingleCounterPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsTaskPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsTasksPage;
import org.apache.hadoop.mapreduce.v2.hs.webapp.TestBlocks;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.log.AggregatedLogsPage;
import org.apache.hadoop.yarn.webapp.view.BlockForTest;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestBlocks {
    private ByteArrayOutputStream data = new ByteArrayOutputStream();

    @Test
    public void testHsTasksBlock() {
        Task task = this.getTask(0L);
        HashMap<TaskId, Task> tasks = new HashMap<TaskId, Task>();
        tasks.put(task.getID(), task);
        AppContext ctx = (AppContext)Mockito.mock(AppContext.class);
        AppForTest app = new AppForTest(ctx);
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)job.getTasks()).thenReturn(tasks);
        app.setJob(job);
        HsTasksBlockForTest block = new HsTasksBlockForTest(this, (App)app);
        block.addParameter("task.type", "r");
        PrintWriter pWriter = new PrintWriter(this.data);
        BlockForTest html = new BlockForTest((HtmlBlock)new HtmlBlockForTest(this, null), pWriter, 0, false);
        block.render((HtmlBlock.Block)html);
        pWriter.flush();
        Assert.assertTrue((boolean)this.data.toString().contains("task_0_0001_r_000000"));
        Assert.assertTrue((boolean)this.data.toString().contains("SUCCEEDED"));
        Assert.assertTrue((boolean)this.data.toString().contains("100001"));
        Assert.assertTrue((boolean)this.data.toString().contains("100011"));
        Assert.assertTrue((boolean)this.data.toString().contains(""));
    }

    @Test
    public void testAttemptsBlock() {
        AppContext ctx = (AppContext)Mockito.mock(AppContext.class);
        AppForTest app = new AppForTest(ctx);
        Task task = this.getTask(0L);
        HashMap<TaskAttemptIdPBImpl, TaskAttempt> attempts = new HashMap<TaskAttemptIdPBImpl, TaskAttempt>();
        TaskAttempt attempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        TaskAttemptIdPBImpl taId = new TaskAttemptIdPBImpl();
        taId.setId(0);
        taId.setTaskId(task.getID());
        Mockito.when((Object)attempt.getID()).thenReturn((Object)taId);
        Mockito.when((Object)attempt.getNodeHttpAddress()).thenReturn((Object)"Node address");
        ApplicationId appId = ApplicationIdPBImpl.newInstance((long)0L, (int)5);
        ApplicationAttemptId appAttemptId = ApplicationAttemptIdPBImpl.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerIdPBImpl.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        Mockito.when((Object)attempt.getAssignedContainerID()).thenReturn((Object)containerId);
        Mockito.when((Object)attempt.getAssignedContainerMgrAddress()).thenReturn((Object)"assignedContainerMgrAddress");
        Mockito.when((Object)attempt.getNodeRackName()).thenReturn((Object)"nodeRackName");
        long taStartTime = 100002L;
        long taFinishTime = 100012L;
        long taShuffleFinishTime = 100010L;
        long taSortFinishTime = 100011L;
        TaskAttemptState taState = TaskAttemptState.SUCCEEDED;
        Mockito.when((Object)attempt.getLaunchTime()).thenReturn((Object)100002L);
        Mockito.when((Object)attempt.getFinishTime()).thenReturn((Object)100012L);
        Mockito.when((Object)attempt.getShuffleFinishTime()).thenReturn((Object)100010L);
        Mockito.when((Object)attempt.getSortFinishTime()).thenReturn((Object)100011L);
        Mockito.when((Object)attempt.getState()).thenReturn((Object)taState);
        TaskAttemptReport taReport = (TaskAttemptReport)Mockito.mock(TaskAttemptReport.class);
        Mockito.when((Object)taReport.getStartTime()).thenReturn((Object)100002L);
        Mockito.when((Object)taReport.getFinishTime()).thenReturn((Object)100012L);
        Mockito.when((Object)taReport.getShuffleFinishTime()).thenReturn((Object)100010L);
        Mockito.when((Object)taReport.getSortFinishTime()).thenReturn((Object)100011L);
        Mockito.when((Object)taReport.getContainerId()).thenReturn((Object)containerId);
        Mockito.when((Object)Float.valueOf(taReport.getProgress())).thenReturn((Object)Float.valueOf(1.0f));
        Mockito.when((Object)taReport.getStateString()).thenReturn((Object)"Processed 128/128 records <p> \n");
        Mockito.when((Object)taReport.getTaskAttemptState()).thenReturn((Object)taState);
        Mockito.when((Object)taReport.getDiagnosticInfo()).thenReturn((Object)"");
        Mockito.when((Object)attempt.getReport()).thenReturn((Object)taReport);
        attempts.put(taId, attempt);
        Mockito.when((Object)task.getAttempts()).thenReturn(attempts);
        app.setTask(task);
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)job.getUserName()).thenReturn((Object)"User");
        app.setJob(job);
        AttemptsBlockForTest block = new AttemptsBlockForTest(this, (App)app);
        block.addParameter("task.type", "r");
        PrintWriter pWriter = new PrintWriter(this.data);
        BlockForTest html = new BlockForTest((HtmlBlock)new HtmlBlockForTest(this, null), pWriter, 0, false);
        block.render((HtmlBlock.Block)html);
        pWriter.flush();
        Assert.assertTrue((boolean)this.data.toString().contains("0 attempt_0_0001_r_000000_0"));
        Assert.assertTrue((boolean)this.data.toString().contains("SUCCEEDED"));
        Assert.assertFalse((boolean)this.data.toString().contains("Processed 128/128 records <p> \n"));
        Assert.assertTrue((boolean)this.data.toString().contains("Processed 128\\/128 records &lt;p&gt; \\n"));
        Assert.assertTrue((boolean)this.data.toString().contains("_0005_01_000001:attempt_0_0001_r_000000_0:User:"));
        Assert.assertTrue((boolean)this.data.toString().contains("100002"));
        Assert.assertTrue((boolean)this.data.toString().contains("100010"));
        Assert.assertTrue((boolean)this.data.toString().contains("100011"));
        Assert.assertTrue((boolean)this.data.toString().contains("100012"));
    }

    @Test
    public void testHsJobsBlock() {
        AppContext ctx = (AppContext)Mockito.mock(AppContext.class);
        HashMap<JobId, Job> jobs = new HashMap<JobId, Job>();
        Job job = this.getJob();
        jobs.put(job.getID(), job);
        Mockito.when((Object)ctx.getAllJobs()).thenReturn(jobs);
        HsJobsBlockForTest block = new HsJobsBlockForTest(this, ctx);
        PrintWriter pWriter = new PrintWriter(this.data);
        BlockForTest html = new BlockForTest((HtmlBlock)new HtmlBlockForTest(this, null), pWriter, 0, false);
        block.render((HtmlBlock.Block)html);
        pWriter.flush();
        Assert.assertTrue((boolean)this.data.toString().contains("JobName"));
        Assert.assertTrue((boolean)this.data.toString().contains("UserName"));
        Assert.assertTrue((boolean)this.data.toString().contains("QueueName"));
        Assert.assertTrue((boolean)this.data.toString().contains("SUCCEEDED"));
    }

    @Test
    public void testHsController() throws Exception {
        AppContext ctx = (AppContext)Mockito.mock(AppContext.class);
        ApplicationId appId = ApplicationIdPBImpl.newInstance((long)0L, (int)5);
        Mockito.when((Object)ctx.getApplicationID()).thenReturn((Object)appId);
        AppForTest app = new AppForTest(ctx);
        Configuration config = new Configuration();
        Controller.RequestContext requestCtx = (Controller.RequestContext)Mockito.mock(Controller.RequestContext.class);
        HsControllerForTest controller = new HsControllerForTest((App)app, config, requestCtx);
        controller.index();
        Assert.assertEquals((Object)"JobHistory", (Object)controller.get("title", ""));
        Assert.assertEquals(HsJobPage.class, (Object)controller.jobPage());
        Assert.assertEquals(HsCountersPage.class, (Object)controller.countersPage());
        Assert.assertEquals(HsTasksPage.class, (Object)controller.tasksPage());
        Assert.assertEquals(HsTaskPage.class, (Object)controller.taskPage());
        Assert.assertEquals(HsAttemptsPage.class, (Object)controller.attemptsPage());
        controller.set("job.id", "job_01_01");
        controller.set("task.id", "task_01_01_m01_01");
        controller.set("task.type", "m");
        controller.set("attempt.state", "State");
        Job job = (Job)Mockito.mock(Job.class);
        Task task = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)job.getTask((TaskId)Matchers.any(TaskId.class))).thenReturn((Object)task);
        JobId jobID = MRApps.toJobID((String)"job_01_01");
        Mockito.when((Object)ctx.getJob(jobID)).thenReturn((Object)job);
        Mockito.when((Object)job.checkAccess((UserGroupInformation)Matchers.any(UserGroupInformation.class), (JobACL)Matchers.any(JobACL.class))).thenReturn((Object)true);
        controller.job();
        Assert.assertEquals(HsJobPage.class, (Object)controller.getClazz());
        controller.jobCounters();
        Assert.assertEquals(HsCountersPage.class, (Object)controller.getClazz());
        controller.taskCounters();
        Assert.assertEquals(HsCountersPage.class, (Object)controller.getClazz());
        controller.tasks();
        Assert.assertEquals(HsTasksPage.class, (Object)controller.getClazz());
        controller.task();
        Assert.assertEquals(HsTaskPage.class, (Object)controller.getClazz());
        controller.attempts();
        Assert.assertEquals(HsAttemptsPage.class, (Object)controller.getClazz());
        Assert.assertEquals(HsConfPage.class, (Object)controller.confPage());
        Assert.assertEquals(HsAboutPage.class, (Object)controller.aboutPage());
        controller.about();
        Assert.assertEquals(HsAboutPage.class, (Object)controller.getClazz());
        controller.logs();
        Assert.assertEquals(HsLogsPage.class, (Object)controller.getClazz());
        controller.nmlogs();
        Assert.assertEquals(AggregatedLogsPage.class, (Object)controller.getClazz());
        Assert.assertEquals(HsSingleCounterPage.class, (Object)controller.singleCounterPage());
        controller.singleJobCounter();
        Assert.assertEquals(HsSingleCounterPage.class, (Object)controller.getClazz());
        controller.singleTaskCounter();
        Assert.assertEquals(HsSingleCounterPage.class, (Object)controller.getClazz());
    }

    private Job getJob() {
        Job job = (Job)Mockito.mock(Job.class);
        JobIdPBImpl jobId = new JobIdPBImpl();
        ApplicationId appId = ApplicationIdPBImpl.newInstance((long)System.currentTimeMillis(), (int)4);
        jobId.setAppId(appId);
        jobId.setId(1);
        Mockito.when((Object)job.getID()).thenReturn((Object)jobId);
        JobReport report = (JobReport)Mockito.mock(JobReport.class);
        Mockito.when((Object)report.getStartTime()).thenReturn((Object)100010L);
        Mockito.when((Object)report.getFinishTime()).thenReturn((Object)100015L);
        Mockito.when((Object)job.getReport()).thenReturn((Object)report);
        Mockito.when((Object)job.getName()).thenReturn((Object)"JobName");
        Mockito.when((Object)job.getUserName()).thenReturn((Object)"UserName");
        Mockito.when((Object)job.getQueueName()).thenReturn((Object)"QueueName");
        Mockito.when((Object)job.getState()).thenReturn((Object)JobState.SUCCEEDED);
        Mockito.when((Object)job.getTotalMaps()).thenReturn((Object)3);
        Mockito.when((Object)job.getCompletedMaps()).thenReturn((Object)2);
        Mockito.when((Object)job.getTotalReduces()).thenReturn((Object)2);
        Mockito.when((Object)job.getCompletedReduces()).thenReturn((Object)1);
        Mockito.when((Object)job.getCompletedReduces()).thenReturn((Object)1);
        return job;
    }

    private Task getTask(long timestamp) {
        JobIdPBImpl jobId = new JobIdPBImpl();
        jobId.setId(0);
        jobId.setAppId(ApplicationIdPBImpl.newInstance((long)timestamp, (int)1));
        TaskIdPBImpl taskId = new TaskIdPBImpl();
        taskId.setId(0);
        taskId.setTaskType(TaskType.REDUCE);
        taskId.setJobId((JobId)jobId);
        Task task = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)task.getID()).thenReturn((Object)taskId);
        TaskReport report = (TaskReport)Mockito.mock(TaskReport.class);
        Mockito.when((Object)Float.valueOf(report.getProgress())).thenReturn((Object)Float.valueOf(0.7f));
        Mockito.when((Object)report.getTaskState()).thenReturn((Object)TaskState.SUCCEEDED);
        Mockito.when((Object)report.getStartTime()).thenReturn((Object)100001L);
        Mockito.when((Object)report.getFinishTime()).thenReturn((Object)100011L);
        Mockito.when((Object)task.getReport()).thenReturn((Object)report);
        Mockito.when((Object)task.getType()).thenReturn((Object)TaskType.REDUCE);
        return task;
    }
}

