/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetDiagnosticsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptCompletionEventsResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskAttemptReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetTaskReportsRequest;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.hs.HistoryClientService;
import org.apache.hadoop.mapreduce.v2.hs.JobHistory;
import org.apache.hadoop.mapreduce.v2.hs.JobHistoryServer;
import org.apache.hadoop.mapreduce.v2.hs.TestJobHistoryEvents;
import org.apache.hadoop.mapreduce.v2.hs.TestJobHistoryParsing;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.util.RackResolver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestJobHistoryServer {
    private static RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    JobHistoryServer historyServer = null;

    @Test(timeout=50000L)
    public void testStartStopServer() throws Exception {
        this.historyServer = new JobHistoryServer();
        Configuration config = new Configuration();
        this.historyServer.init(config);
        Assert.assertEquals((Object)Service.STATE.INITED, (Object)this.historyServer.getServiceState());
        Assert.assertEquals((long)6L, (long)this.historyServer.getServices().size());
        HistoryClientService historyService = this.historyServer.getClientService();
        Assert.assertNotNull((Object)this.historyServer.getClientService());
        Assert.assertEquals((Object)Service.STATE.INITED, (Object)historyService.getServiceState());
        this.historyServer.start();
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)this.historyServer.getServiceState());
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)historyService.getServiceState());
        this.historyServer.stop();
        Assert.assertEquals((Object)Service.STATE.STOPPED, (Object)this.historyServer.getServiceState());
        Assert.assertNotNull((Object)historyService.getClientHandler().getConnectAddress());
    }

    @Test(timeout=50000L)
    public void testReports() throws Exception {
        Configuration config = new Configuration();
        config.setClass("net.topology.node.switch.mapping.impl", TestJobHistoryParsing.MyResolver.class, DNSToSwitchMapping.class);
        RackResolver.init((Configuration)config);
        TestJobHistoryEvents.MRAppWithHistory app = new TestJobHistoryEvents.MRAppWithHistory(1, 1, true, this.getClass().getName(), true);
        app.submit(config);
        Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
        app.waitForState(job, JobState.SUCCEEDED);
        this.historyServer = new JobHistoryServer();
        this.historyServer.init(config);
        this.historyServer.start();
        JobHistory jobHistory = null;
        for (Service service : this.historyServer.getServices()) {
            if (!(service instanceof JobHistory)) continue;
            jobHistory = (JobHistory)service;
        }
        Map jobs = jobHistory.getAllJobs();
        Assert.assertEquals((long)1L, (long)jobs.size());
        Assert.assertEquals((Object)"job_0_0000", (Object)((JobId)jobs.keySet().iterator().next()).toString());
        Task task = (Task)job.getTasks().values().iterator().next();
        TaskAttempt attempt = (TaskAttempt)task.getAttempts().values().iterator().next();
        HistoryClientService historyService = this.historyServer.getClientService();
        MRClientProtocol protocol = historyService.getClientHandler();
        GetTaskAttemptReportRequest gtarRequest = (GetTaskAttemptReportRequest)recordFactory.newRecordInstance(GetTaskAttemptReportRequest.class);
        TaskAttemptId taId = attempt.getID();
        taId.setTaskId(task.getID());
        taId.getTaskId().setJobId(job.getID());
        gtarRequest.setTaskAttemptId(taId);
        GetTaskAttemptReportResponse response = protocol.getTaskAttemptReport(gtarRequest);
        Assert.assertEquals((Object)"container_0_0000_01_000000", (Object)response.getTaskAttemptReport().getContainerId().toString());
        Assert.assertTrue((boolean)response.getTaskAttemptReport().getDiagnosticInfo().isEmpty());
        Assert.assertNotNull((Object)response.getTaskAttemptReport().getCounters().getCounter((Enum)TaskCounter.PHYSICAL_MEMORY_BYTES));
        Assert.assertEquals((Object)taId.toString(), (Object)response.getTaskAttemptReport().getTaskAttemptId().toString());
        GetTaskReportRequest request = (GetTaskReportRequest)recordFactory.newRecordInstance(GetTaskReportRequest.class);
        TaskId taskId = task.getID();
        taskId.setJobId(job.getID());
        request.setTaskId(taskId);
        GetTaskReportResponse reportResponse = protocol.getTaskReport(request);
        Assert.assertEquals((Object)"", reportResponse.getTaskReport().getDiagnosticsList().iterator().next());
        Assert.assertEquals((double)1.0, (double)reportResponse.getTaskReport().getProgress(), (double)0.01);
        Assert.assertEquals((Object)taskId.toString(), (Object)reportResponse.getTaskReport().getTaskId().toString());
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)reportResponse.getTaskReport().getTaskState());
        GetTaskReportsRequest gtreportsRequest = (GetTaskReportsRequest)recordFactory.newRecordInstance(GetTaskReportsRequest.class);
        gtreportsRequest.setJobId(TypeConverter.toYarn((JobID)JobID.forName((String)"job_1415730144495_0001")));
        gtreportsRequest.setTaskType(TaskType.REDUCE);
        try {
            protocol.getTaskReports(gtreportsRequest);
            Assert.fail((String)"IOException not thrown for invalid job id");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        GetTaskAttemptCompletionEventsRequest taskAttemptRequest = (GetTaskAttemptCompletionEventsRequest)recordFactory.newRecordInstance(GetTaskAttemptCompletionEventsRequest.class);
        taskAttemptRequest.setJobId(job.getID());
        GetTaskAttemptCompletionEventsResponse taskAttemptCompletionEventsResponse = protocol.getTaskAttemptCompletionEvents(taskAttemptRequest);
        Assert.assertEquals((long)0L, (long)taskAttemptCompletionEventsResponse.getCompletionEventCount());
        GetDiagnosticsRequest diagnosticRequest = (GetDiagnosticsRequest)recordFactory.newRecordInstance(GetDiagnosticsRequest.class);
        diagnosticRequest.setTaskAttemptId(taId);
        GetDiagnosticsResponse diagnosticResponse = protocol.getDiagnostics(diagnosticRequest);
        Assert.assertEquals((long)1L, (long)diagnosticResponse.getDiagnosticsCount());
        Assert.assertEquals((Object)"", (Object)diagnosticResponse.getDiagnostics(0));
    }

    @Test(timeout=60000L)
    public void testLaunch() throws Exception {
        ExitUtil.disableSystemExit();
        try {
            this.historyServer = JobHistoryServer.launchJobHistoryServer((String[])new String[0]);
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((long)0L, (long)e.status);
            ExitUtil.resetFirstExitException();
            Assert.fail();
        }
    }

    @After
    public void stop() {
        if (this.historyServer != null) {
            this.historyServer.stop();
        }
    }
}

