/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.hs.MockHistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsWebApp;
import org.apache.hadoop.mapreduce.v2.hs.webapp.TestHsWebServicesJobsQuery;
import org.apache.hadoop.mapreduce.v2.hs.webapp.VerifyJobsUtils;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHsWebServicesJobsQuery
extends JerseyTest {
    private static Configuration conf = new Configuration();
    private static MockHistoryContext appContext;
    private static HsWebApp webApp;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestHsWebServicesJobsQuery() {
        super((AppDescriptor)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.mapreduce.v2.hs.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testJobsQueryStateNone() throws JSONException, Exception {
        WebResource r = this.resource();
        ArrayList<JobState> JOB_STATES = new ArrayList<JobState>(Arrays.asList(JobState.values()));
        Map jobsMap = appContext.getAllJobs();
        for (Map.Entry entry : jobsMap.entrySet()) {
            JOB_STATES.remove(((Job)entry.getValue()).getState());
        }
        Assert.assertTrue((String)"No unused job states", (JOB_STATES.size() > 0 ? 1 : 0) != 0);
        JobState notInUse = JOB_STATES.get(0);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("state", notInUse.toString()).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        Assert.assertEquals((String)"jobs is not null", (Object)JSONObject.NULL, (Object)json.get("jobs"));
    }

    @Test
    public void testJobsQueryState() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        String queryState = "BOGUS";
        JobId jid = null;
        Iterator iterator = jobsMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            jid = ((Job)entry.getValue()).getID();
            queryState = ((Job)entry.getValue()).getState().toString();
        }
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("state", queryState).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jobs = json.getJSONObject("jobs");
        JSONArray arr = jobs.getJSONArray("job");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)arr.length());
        JSONObject info = arr.getJSONObject(0);
        Job job = appContext.getPartialJob(jid);
        VerifyJobsUtils.verifyHsJobPartial((JSONObject)info, (Job)job);
    }

    @Test
    public void testJobsQueryStateInvalid() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("state", "InvalidState").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject exception = msg.getJSONObject("RemoteException");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
        String message = exception.getString("message");
        String type = exception.getString("exception");
        String classname = exception.getString("javaClassName");
        WebServicesTestUtils.checkStringContains((String)"exception message", (String)"org.apache.hadoop.mapreduce.v2.api.records.JobState.InvalidState", (String)message);
        WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"IllegalArgumentException", (String)type);
        WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"java.lang.IllegalArgumentException", (String)classname);
    }

    @Test
    public void testJobsQueryUserNone() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("user", "bogus").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        Assert.assertEquals((String)"jobs is not null", (Object)JSONObject.NULL, (Object)json.get("jobs"));
    }

    @Test
    public void testJobsQueryUser() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("user", "mock").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        System.out.println(json.toString());
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jobs = json.getJSONObject("jobs");
        JSONArray arr = jobs.getJSONArray("job");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)arr.length());
        JSONObject info = arr.getJSONObject(0);
        Job job = appContext.getPartialJob(MRApps.toJobID((String)info.getString("id")));
        VerifyJobsUtils.verifyHsJobPartial((JSONObject)info, (Job)job);
    }

    @Test
    public void testJobsQueryLimit() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("limit", "2").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jobs = json.getJSONObject("jobs");
        JSONArray arr = jobs.getJSONArray("job");
        Assert.assertEquals((String)"incorrect number of elements", (long)2L, (long)arr.length());
    }

    @Test
    public void testJobsQueryLimitInvalid() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("limit", "-1").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject exception = msg.getJSONObject("RemoteException");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
        String message = exception.getString("message");
        String type = exception.getString("exception");
        String classname = exception.getString("javaClassName");
        WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: limit value must be greater then 0", (String)message);
        WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
        WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
    }

    @Test
    public void testJobsQueryQueue() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("queue", "mockqueue").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jobs = json.getJSONObject("jobs");
        JSONArray arr = jobs.getJSONArray("job");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)arr.length());
    }

    @Test
    public void testJobsQueryQueueNonExist() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("queue", "bogus").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        Assert.assertEquals((String)"jobs is not null", (Object)JSONObject.NULL, (Object)json.get("jobs"));
    }

    @Test
    public void testJobsQueryStartTimeEnd() throws JSONException, Exception {
        WebResource r = this.resource();
        Long now = System.currentTimeMillis();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("startedTimeEnd", String.valueOf(now)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jobs = json.getJSONObject("jobs");
        JSONArray arr = jobs.getJSONArray("job");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)arr.length());
    }

    @Test
    public void testJobsQueryStartTimeBegin() throws JSONException, Exception {
        WebResource r = this.resource();
        Long now = System.currentTimeMillis();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("startedTimeBegin", String.valueOf(now)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        Assert.assertEquals((String)"jobs is not null", (Object)JSONObject.NULL, (Object)json.get("jobs"));
    }

    @Test
    public void testJobsQueryStartTimeBeginEnd() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        int size = jobsMap.size();
        ArrayList<Long> startTime = new ArrayList<Long>(size);
        for (Map.Entry entry : jobsMap.entrySet()) {
            startTime.add(((Job)entry.getValue()).getReport().getStartTime());
        }
        Collections.sort(startTime);
        Assert.assertTrue((String)"Error we must have atleast 3 jobs", (size >= 3 ? 1 : 0) != 0);
        long midStartTime = (Long)startTime.get(size - 2);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("startedTimeBegin", String.valueOf(40000)).queryParam("startedTimeEnd", String.valueOf(midStartTime)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jobs = json.getJSONObject("jobs");
        JSONArray arr = jobs.getJSONArray("job");
        Assert.assertEquals((String)"incorrect number of elements", (long)(size - 1), (long)arr.length());
    }

    @Test
    public void testJobsQueryStartTimeBeginEndInvalid() throws JSONException, Exception {
        WebResource r = this.resource();
        Long now = System.currentTimeMillis();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("startedTimeBegin", String.valueOf(now)).queryParam("startedTimeEnd", String.valueOf(40000)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject exception = msg.getJSONObject("RemoteException");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
        String message = exception.getString("message");
        String type = exception.getString("exception");
        String classname = exception.getString("javaClassName");
        WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: startedTimeEnd must be greater than startTimeBegin", (String)message);
        WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
        WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
    }

    @Test
    public void testJobsQueryStartTimeInvalidformat() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("startedTimeBegin", "efsd").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject exception = msg.getJSONObject("RemoteException");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
        String message = exception.getString("message");
        String type = exception.getString("exception");
        String classname = exception.getString("javaClassName");
        WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: Invalid number format: For input string: \"efsd\"", (String)message);
        WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
        WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
    }

    @Test
    public void testJobsQueryStartTimeEndInvalidformat() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("startedTimeEnd", "efsd").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject exception = msg.getJSONObject("RemoteException");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
        String message = exception.getString("message");
        String type = exception.getString("exception");
        String classname = exception.getString("javaClassName");
        WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: Invalid number format: For input string: \"efsd\"", (String)message);
        WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
        WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
    }

    @Test
    public void testJobsQueryStartTimeNegative() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("startedTimeBegin", String.valueOf(-1000)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject exception = msg.getJSONObject("RemoteException");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
        String message = exception.getString("message");
        String type = exception.getString("exception");
        String classname = exception.getString("javaClassName");
        WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: startedTimeBegin must be greater than 0", (String)message);
        WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
        WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
    }

    @Test
    public void testJobsQueryStartTimeEndNegative() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("startedTimeEnd", String.valueOf(-1000)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject exception = msg.getJSONObject("RemoteException");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
        String message = exception.getString("message");
        String type = exception.getString("exception");
        String classname = exception.getString("javaClassName");
        WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: startedTimeEnd must be greater than 0", (String)message);
        WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
        WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
    }

    @Test
    public void testJobsQueryFinishTimeEndNegative() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("finishedTimeEnd", String.valueOf(-1000)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject exception = msg.getJSONObject("RemoteException");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
        String message = exception.getString("message");
        String type = exception.getString("exception");
        String classname = exception.getString("javaClassName");
        WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: finishedTimeEnd must be greater than 0", (String)message);
        WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
        WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
    }

    @Test
    public void testJobsQueryFinishTimeBeginNegative() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("finishedTimeBegin", String.valueOf(-1000)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject exception = msg.getJSONObject("RemoteException");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
        String message = exception.getString("message");
        String type = exception.getString("exception");
        String classname = exception.getString("javaClassName");
        WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: finishedTimeBegin must be greater than 0", (String)message);
        WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
        WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
    }

    @Test
    public void testJobsQueryFinishTimeBeginEndInvalid() throws JSONException, Exception {
        WebResource r = this.resource();
        Long now = System.currentTimeMillis();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("finishedTimeBegin", String.valueOf(now)).queryParam("finishedTimeEnd", String.valueOf(40000)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject exception = msg.getJSONObject("RemoteException");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
        String message = exception.getString("message");
        String type = exception.getString("exception");
        String classname = exception.getString("javaClassName");
        WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: finishedTimeEnd must be greater than finishedTimeBegin", (String)message);
        WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
        WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
    }

    @Test
    public void testJobsQueryFinishTimeInvalidformat() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("finishedTimeBegin", "efsd").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject exception = msg.getJSONObject("RemoteException");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
        String message = exception.getString("message");
        String type = exception.getString("exception");
        String classname = exception.getString("javaClassName");
        WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: Invalid number format: For input string: \"efsd\"", (String)message);
        WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
        WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
    }

    @Test
    public void testJobsQueryFinishTimeEndInvalidformat() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("finishedTimeEnd", "efsd").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject msg = (JSONObject)response.getEntity(JSONObject.class);
        JSONObject exception = msg.getJSONObject("RemoteException");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)exception.length());
        String message = exception.getString("message");
        String type = exception.getString("exception");
        String classname = exception.getString("javaClassName");
        WebServicesTestUtils.checkStringMatch((String)"exception message", (String)"java.lang.Exception: Invalid number format: For input string: \"efsd\"", (String)message);
        WebServicesTestUtils.checkStringMatch((String)"exception type", (String)"BadRequestException", (String)type);
        WebServicesTestUtils.checkStringMatch((String)"exception classname", (String)"org.apache.hadoop.yarn.webapp.BadRequestException", (String)classname);
    }

    @Test
    public void testJobsQueryFinishTimeBegin() throws JSONException, Exception {
        WebResource r = this.resource();
        Long now = System.currentTimeMillis();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("finishedTimeBegin", String.valueOf(now)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jobs = json.getJSONObject("jobs");
        JSONArray arr = jobs.getJSONArray("job");
        Assert.assertEquals((String)"incorrect number of elements", (long)3L, (long)arr.length());
    }

    @Test
    public void testJobsQueryFinishTimeEnd() throws JSONException, Exception {
        WebResource r = this.resource();
        Long now = System.currentTimeMillis();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("finishedTimeEnd", String.valueOf(now)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        Assert.assertEquals((String)"jobs is not null", (Object)JSONObject.NULL, (Object)json.get("jobs"));
    }

    @Test
    public void testJobsQueryFinishTimeBeginEnd() throws JSONException, Exception {
        WebResource r = this.resource();
        Map jobsMap = appContext.getAllJobs();
        int size = jobsMap.size();
        ArrayList<Long> finishTime = new ArrayList<Long>(size);
        for (Map.Entry entry : jobsMap.entrySet()) {
            finishTime.add(((Job)entry.getValue()).getReport().getFinishTime());
        }
        Collections.sort(finishTime);
        Assert.assertTrue((String)"Error we must have atleast 3 jobs", (size >= 3 ? 1 : 0) != 0);
        long midFinishTime = (Long)finishTime.get(size - 2);
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("mapreduce").path("jobs").queryParam("finishedTimeBegin", String.valueOf(40000)).queryParam("finishedTimeEnd", String.valueOf(midFinishTime)).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject jobs = json.getJSONObject("jobs");
        JSONArray arr = jobs.getJSONArray("job");
        Assert.assertEquals((String)"incorrect number of elements", (long)(size - 1), (long)arr.length());
    }

    static /* synthetic */ MockHistoryContext access$002(MockHistoryContext x0) {
        appContext = x0;
        return appContext;
    }

    static /* synthetic */ HsWebApp access$102(HsWebApp x0) {
        webApp = x0;
        return webApp;
    }

    static /* synthetic */ HsWebApp access$100() {
        return webApp;
    }

    static /* synthetic */ MockHistoryContext access$000() {
        return appContext;
    }

    static /* synthetic */ Configuration access$200() {
        return conf;
    }

    static /* synthetic */ Injector access$300(TestHsWebServicesJobsQuery x0) {
        return x0.injector;
    }
}

