/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.hs.CachedHistoryStorage;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.hs.HistoryStorage;
import org.apache.hadoop.mapreduce.v2.hs.PartialJob;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobInfo;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobsInfo;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

/*
 * Exception performing whole class analysis ignored.
 */
public class CachedHistoryStorage
extends AbstractService
implements HistoryStorage {
    private static final Log LOG = LogFactory.getLog(CachedHistoryStorage.class);
    private LoadingCache<JobId, Job> loadedJobCache = null;
    private int loadedJobCacheSize;
    private int loadedTasksCacheSize;
    private boolean useLoadedTasksCache;
    private HistoryFileManager hsManager;

    public void setHistoryFileManager(HistoryFileManager hsManager) {
        this.hsManager = hsManager;
    }

    public void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        LOG.info((Object)"CachedHistoryStorage Init");
        this.createLoadedJobCache(conf);
    }

    private void createLoadedJobCache(Configuration conf) {
        this.loadedJobCacheSize = conf.getInt("mapreduce.jobhistory.loadedjobs.cache.size", 5);
        this.useLoadedTasksCache = false;
        try {
            String taskSizeString = conf.get("mapreduce.jobhistory.loadedtasks.cache.size");
            if (taskSizeString != null) {
                this.loadedTasksCacheSize = Math.max(Integer.parseInt(taskSizeString), 1);
                this.useLoadedTasksCache = true;
            }
        }
        catch (NumberFormatException nfe) {
            LOG.error((Object)"The property mapreduce.jobhistory.loadedtasks.cache.size is not an integer value.  Please set it to a positive integer value.");
        }
        1 loader = new /* Unavailable Anonymous Inner Class!! */;
        if (!this.useLoadedTasksCache) {
            this.loadedJobCache = CacheBuilder.newBuilder().maximumSize((long)this.loadedJobCacheSize).initialCapacity(this.loadedJobCacheSize).concurrencyLevel(1).build((CacheLoader)loader);
        } else {
            2 weightByTasks = new /* Unavailable Anonymous Inner Class!! */;
            this.loadedJobCache = CacheBuilder.newBuilder().maximumWeight((long)this.loadedTasksCacheSize).weigher((Weigher)weightByTasks).concurrencyLevel(1).build((CacheLoader)loader);
        }
    }

    public void refreshLoadedJobCache() {
        if (this.getServiceState() == Service.STATE.STARTED) {
            this.setConfig(this.createConf());
            this.createLoadedJobCache(this.getConfig());
        } else {
            LOG.warn((Object)"Failed to execute refreshLoadedJobCache: CachedHistoryStorage is not started");
        }
    }

    @VisibleForTesting
    Configuration createConf() {
        return new Configuration();
    }

    public CachedHistoryStorage() {
        super(CachedHistoryStorage.class.getName());
    }

    private Job loadJob(JobId jobId) throws RuntimeException, IOException {
        HistoryFileManager.HistoryFileInfo fileInfo;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking for Job " + jobId));
        }
        if ((fileInfo = this.hsManager.getFileInfo(jobId)) == null) {
            throw new HSFileRuntimeException("Unable to find job " + jobId);
        }
        if (fileInfo.isDeleted()) {
            throw new HSFileRuntimeException("Cannot load deleted job " + jobId);
        }
        return fileInfo.loadJob();
    }

    @VisibleForTesting
    Cache<JobId, Job> getLoadedJobCache() {
        return this.loadedJobCache;
    }

    public Job getFullJob(JobId jobId) {
        Job retVal = null;
        try {
            retVal = (Job)this.loadedJobCache.getUnchecked((Object)jobId);
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof HSFileRuntimeException) {
                LOG.error((Object)e.getCause().getMessage());
                return null;
            }
            throw new YarnRuntimeException(e.getCause());
        }
        return retVal;
    }

    public Map<JobId, Job> getAllPartialJobs() {
        LOG.debug((Object)"Called getAllPartialJobs()");
        TreeMap<JobId, Job> result = new TreeMap<JobId, Job>();
        try {
            for (HistoryFileManager.HistoryFileInfo mi : this.hsManager.getAllFileInfo()) {
                if (mi == null) continue;
                JobId id = mi.getJobId();
                result.put(id, (Job)new PartialJob(mi.getJobIndexInfo(), id));
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Error trying to scan for all FileInfos", (Throwable)e);
            throw new YarnRuntimeException((Throwable)e);
        }
        return result;
    }

    public JobsInfo getPartialJobs(Long offset, Long count, String user, String queue, Long sBegin, Long sEnd, Long fBegin, Long fEnd, JobState jobState) {
        return CachedHistoryStorage.getPartialJobs(this.getAllPartialJobs().values(), (Long)offset, (Long)count, (String)user, (String)queue, (Long)sBegin, (Long)sEnd, (Long)fBegin, (Long)fEnd, (JobState)jobState);
    }

    public static JobsInfo getPartialJobs(Collection<Job> jobs, Long offset, Long count, String user, String queue, Long sBegin, Long sEnd, Long fBegin, Long fEnd, JobState jobState) {
        JobsInfo allJobs = new JobsInfo();
        if (sBegin == null || sBegin < 0L) {
            sBegin = 0L;
        }
        if (sEnd == null) {
            sEnd = Long.MAX_VALUE;
        }
        if (fBegin == null || fBegin < 0L) {
            fBegin = 0L;
        }
        if (fEnd == null) {
            fEnd = Long.MAX_VALUE;
        }
        if (offset == null || offset < 0L) {
            offset = 0L;
        }
        if (count == null) {
            count = Long.MAX_VALUE;
        }
        if (offset > (long)jobs.size()) {
            return allJobs;
        }
        long at = 0L;
        long end = offset + count - 1L;
        if (end < 0L) {
            end = Long.MAX_VALUE;
        }
        for (Job job : jobs) {
            JobReport report;
            if (at > end) break;
            if (queue != null && !queue.isEmpty() && !job.getQueueName().equals(queue) || user != null && !user.isEmpty() && !job.getUserName().equals(user) || (report = job.getReport()).getStartTime() < sBegin || report.getStartTime() > sEnd || report.getFinishTime() < fBegin || report.getFinishTime() > fEnd || jobState != null && jobState != report.getJobState() || ++at - 1L < offset) continue;
            JobInfo jobInfo = new JobInfo(job);
            allJobs.add(jobInfo);
        }
        return allJobs;
    }

    @VisibleForTesting
    public boolean getUseLoadedTasksCache() {
        return this.useLoadedTasksCache;
    }

    @VisibleForTesting
    public int getLoadedTasksCacheSize() {
        return this.loadedTasksCacheSize;
    }

    static /* synthetic */ Job access$000(CachedHistoryStorage x0, JobId x1) throws RuntimeException, IOException {
        return x0.loadJob(x1);
    }

    static /* synthetic */ int access$100(CachedHistoryStorage x0) {
        return x0.loadedTasksCacheSize;
    }
}

