/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.MockAppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.hs.CachedHistoryStorage;
import org.apache.hadoop.mapreduce.v2.hs.HistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.MockHistoryJobs;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobsInfo;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

public class MockHistoryContext
extends MockAppContext
implements HistoryContext {
    private final Map<JobId, Job> partialJobs;
    private final Map<JobId, Job> fullJobs;

    public MockHistoryContext(int numJobs, int numTasks, int numAttempts) {
        super(0);
        MockHistoryJobs.JobsPair jobs;
        try {
            jobs = MockHistoryJobs.newHistoryJobs((int)numJobs, (int)numTasks, (int)numAttempts);
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        this.partialJobs = jobs.partial;
        this.fullJobs = jobs.full;
    }

    public MockHistoryContext(int appid, int numJobs, int numTasks, int numAttempts) {
        super(appid);
        MockHistoryJobs.JobsPair jobs;
        try {
            jobs = MockHistoryJobs.newHistoryJobs((ApplicationId)this.getApplicationID(), (int)numJobs, (int)numTasks, (int)numAttempts);
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        this.partialJobs = jobs.partial;
        this.fullJobs = jobs.full;
    }

    public MockHistoryContext(int appid, int numTasks, int numAttempts, Path confPath) {
        super(appid, numTasks, numAttempts, confPath);
        this.fullJobs = super.getAllJobs();
        this.partialJobs = null;
    }

    public MockHistoryContext(int appid, int numJobs, int numTasks, int numAttempts, boolean hasFailedTasks) {
        super(appid);
        MockHistoryJobs.JobsPair jobs;
        try {
            jobs = MockHistoryJobs.newHistoryJobs((ApplicationId)this.getApplicationID(), (int)numJobs, (int)numTasks, (int)numAttempts, (boolean)hasFailedTasks);
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        this.partialJobs = jobs.partial;
        this.fullJobs = jobs.full;
    }

    public Job getJob(JobId jobID) {
        return (Job)this.fullJobs.get(jobID);
    }

    public Job getPartialJob(JobId jobID) {
        return (Job)this.partialJobs.get(jobID);
    }

    public Map<JobId, Job> getAllJobs() {
        return this.fullJobs;
    }

    public Map<JobId, Job> getAllJobs(ApplicationId appID) {
        return null;
    }

    public JobsInfo getPartialJobs(Long offset, Long count, String user, String queue, Long sBegin, Long sEnd, Long fBegin, Long fEnd, JobState jobState) {
        return CachedHistoryStorage.getPartialJobs(this.partialJobs.values(), (Long)offset, (Long)count, (String)user, (String)queue, (Long)sBegin, (Long)sEnd, (Long)fBegin, (Long)fEnd, (JobState)jobState);
    }
}

