/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.hs.JobHistory;
import org.apache.hadoop.mapreduce.v2.hs.TestJobHistoryEvents;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.junit.Assert;
import org.junit.Test;

public class TestJobHistoryEvents {
    private static final Log LOG = LogFactory.getLog(TestJobHistoryEvents.class);

    @Test
    public void testHistoryEvents() throws Exception {
        Configuration conf = new Configuration();
        MRAppWithHistory app = new MRAppWithHistory(2, 1, true, this.getClass().getName(), true);
        app.submit(conf);
        Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
        JobId jobId = job.getID();
        LOG.info((Object)("JOBID is " + TypeConverter.fromYarn((JobId)jobId).toString()));
        app.waitForState(job, JobState.SUCCEEDED);
        app.waitForState(Service.STATE.STOPPED);
        JobHistory context = new JobHistory();
        context.init(conf);
        context.start();
        Assert.assertTrue((context.getStartTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)context.getServiceState(), (Object)Service.STATE.STARTED);
        Job parsedJob = context.getJob(jobId);
        context.stop();
        Assert.assertEquals((Object)context.getServiceState(), (Object)Service.STATE.STOPPED);
        Assert.assertEquals((String)"CompletedMaps not correct", (long)2L, (long)parsedJob.getCompletedMaps());
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)parsedJob.getUserName());
        Map tasks = parsedJob.getTasks();
        Assert.assertEquals((String)"No of tasks not correct", (long)3L, (long)tasks.size());
        for (Task task : tasks.values()) {
            this.verifyTask(task);
        }
        Map maps = parsedJob.getTasks(TaskType.MAP);
        Assert.assertEquals((String)"No of maps not correct", (long)2L, (long)maps.size());
        Map reduces = parsedJob.getTasks(TaskType.REDUCE);
        Assert.assertEquals((String)"No of reduces not correct", (long)1L, (long)reduces.size());
        Assert.assertEquals((String)"CompletedReduce not correct", (long)1L, (long)parsedJob.getCompletedReduces());
        Assert.assertEquals((String)"Job state not currect", (Object)JobState.SUCCEEDED, (Object)parsedJob.getState());
    }

    @Test
    public void testEventsFlushOnStop() throws Exception {
        Configuration conf = new Configuration();
        MRAppWithSpecialHistoryHandler app = new MRAppWithSpecialHistoryHandler(1, 0, true, this.getClass().getName(), true);
        app.submit(conf);
        Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
        JobId jobId = job.getID();
        LOG.info((Object)("JOBID is " + TypeConverter.fromYarn((JobId)jobId).toString()));
        app.waitForState(job, JobState.SUCCEEDED);
        app.waitForState(Service.STATE.STOPPED);
        JobHistory context = new JobHistory();
        context.init(conf);
        Job parsedJob = context.getJob(jobId);
        Assert.assertEquals((String)"CompletedMaps not correct", (long)1L, (long)parsedJob.getCompletedMaps());
        Map tasks = parsedJob.getTasks();
        Assert.assertEquals((String)"No of tasks not correct", (long)1L, (long)tasks.size());
        this.verifyTask((Task)tasks.values().iterator().next());
        Map maps = parsedJob.getTasks(TaskType.MAP);
        Assert.assertEquals((String)"No of maps not correct", (long)1L, (long)maps.size());
        Assert.assertEquals((String)"Job state not currect", (Object)JobState.SUCCEEDED, (Object)parsedJob.getState());
    }

    @Test
    public void testJobHistoryEventHandlerIsFirstServiceToStop() {
        MRAppWithSpecialHistoryHandler app = new MRAppWithSpecialHistoryHandler(1, 0, true, this.getClass().getName(), true);
        Configuration conf = new Configuration();
        app.init(conf);
        Service[] services = app.getServices().toArray(new Service[0]);
        Assert.assertEquals((Object)"JobHistoryEventHandler", (Object)services[services.length - 1].getName());
    }

    @Test
    public void testAssignedQueue() throws Exception {
        Configuration conf = new Configuration();
        MRAppWithHistory app = new MRAppWithHistory(2, 1, true, this.getClass().getName(), true, "assignedQueue");
        app.submit(conf);
        Job job = (Job)app.getContext().getAllJobs().values().iterator().next();
        JobId jobId = job.getID();
        LOG.info((Object)("JOBID is " + TypeConverter.fromYarn((JobId)jobId).toString()));
        app.waitForState(job, JobState.SUCCEEDED);
        app.waitForState(Service.STATE.STOPPED);
        JobHistory context = new JobHistory();
        context.init(conf);
        context.start();
        Assert.assertTrue((context.getStartTime() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)context.getServiceState(), (Object)Service.STATE.STARTED);
        Job parsedJob = context.getJob(jobId);
        context.stop();
        Assert.assertEquals((Object)context.getServiceState(), (Object)Service.STATE.STOPPED);
        Assert.assertEquals((String)"QueueName not correct", (Object)"assignedQueue", (Object)parsedJob.getQueueName());
    }

    private void verifyTask(Task task) {
        Assert.assertEquals((String)"Task state not currect", (Object)TaskState.SUCCEEDED, (Object)task.getState());
        Map attempts = task.getAttempts();
        Assert.assertEquals((String)"No of attempts not correct", (long)1L, (long)attempts.size());
        for (TaskAttempt attempt : attempts.values()) {
            this.verifyAttempt(attempt);
        }
    }

    private void verifyAttempt(TaskAttempt attempt) {
        Assert.assertEquals((String)"TaskAttempt state not currect", (Object)TaskAttemptState.SUCCEEDED, (Object)attempt.getState());
        Assert.assertNotNull((Object)attempt.getAssignedContainerID());
        ContainerId fakeCid = MRApp.newContainerId((int)-1, (int)-1, (long)-1L, (int)-1);
        Assert.assertFalse((boolean)attempt.getAssignedContainerID().equals((Object)fakeCid));
        Assert.assertEquals((Object)(MRApp.NM_HOST + ":" + MRApp.NM_PORT), (Object)attempt.getAssignedContainerMgrAddress());
    }

    public static void main(String[] args) throws Exception {
        TestJobHistoryEvents t = new TestJobHistoryEvents();
        t.testHistoryEvents();
        t.testEventsFlushOnStop();
        t.testJobHistoryEventHandlerIsFirstServiceToStop();
    }
}

