/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.v2.api.MRDelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.hs.HistoryServerFileSystemStateStoreService;
import org.apache.hadoop.mapreduce.v2.hs.HistoryServerStateStoreService;
import org.apache.hadoop.mapreduce.v2.hs.HistoryServerStateStoreServiceFactory;
import org.apache.hadoop.mapreduce.v2.hs.TestHistoryServerFileSystemStateStoreService;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHistoryServerFileSystemStateStoreService {
    private static final File testDir = new File(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")), "TestHistoryServerFileSystemStateStoreService");
    private Configuration conf;

    @Before
    public void setup() {
        FileUtil.fullyDelete((File)testDir);
        testDir.mkdirs();
        this.conf = new Configuration();
        this.conf.setBoolean("mapreduce.jobhistory.recovery.enable", true);
        this.conf.setClass("mapreduce.jobhistory.recovery.store.class", HistoryServerFileSystemStateStoreService.class, HistoryServerStateStoreService.class);
        this.conf.set("mapreduce.jobhistory.recovery.store.fs.uri", testDir.getAbsoluteFile().toURI().toString());
    }

    @After
    public void cleanup() {
        FileUtil.fullyDelete((File)testDir);
    }

    private HistoryServerStateStoreService createAndStartStore() throws IOException {
        HistoryServerStateStoreService store = HistoryServerStateStoreServiceFactory.getStore((Configuration)this.conf);
        Assert.assertTrue((String)"Factory did not create a filesystem store", (boolean)(store instanceof HistoryServerFileSystemStateStoreService));
        store.init(this.conf);
        store.start();
        return store;
    }

    private void testTokenStore(String stateStoreUri) throws IOException {
        this.conf.set("mapreduce.jobhistory.recovery.store.fs.uri", stateStoreUri);
        HistoryServerStateStoreService store = this.createAndStartStore();
        HistoryServerStateStoreService.HistoryServerState state = store.loadState();
        Assert.assertTrue((String)"token state not empty", (boolean)state.tokenState.isEmpty());
        Assert.assertTrue((String)"key state not empty", (boolean)state.tokenMasterKeyState.isEmpty());
        DelegationKey key1 = new DelegationKey(1, 2L, "keyData1".getBytes());
        MRDelegationTokenIdentifier token1 = new MRDelegationTokenIdentifier(new Text("tokenOwner1"), new Text("tokenRenewer1"), new Text("tokenUser1"));
        token1.setSequenceNumber(1);
        Long tokenDate1 = 1L;
        MRDelegationTokenIdentifier token2 = new MRDelegationTokenIdentifier(new Text("tokenOwner2"), new Text("tokenRenewer2"), new Text("tokenUser2"));
        token2.setSequenceNumber(12345678);
        Long tokenDate2 = 87654321L;
        store.storeTokenMasterKey(key1);
        try {
            store.storeTokenMasterKey(key1);
            Assert.fail((String)"redundant store of key undetected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        store.storeToken(token1, tokenDate1);
        store.storeToken(token2, tokenDate2);
        try {
            store.storeToken(token1, tokenDate1);
            Assert.fail((String)"redundant store of token undetected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        store.close();
        store = this.createAndStartStore();
        state = store.loadState();
        Assert.assertEquals((String)"incorrect loaded token count", (long)2L, (long)state.tokenState.size());
        Assert.assertTrue((String)"missing token 1", (boolean)state.tokenState.containsKey(token1));
        Assert.assertEquals((String)"incorrect token 1 date", (Object)tokenDate1, state.tokenState.get(token1));
        Assert.assertTrue((String)"missing token 2", (boolean)state.tokenState.containsKey(token2));
        Assert.assertEquals((String)"incorrect token 2 date", (Object)tokenDate2, state.tokenState.get(token2));
        Assert.assertEquals((String)"incorrect master key count", (long)1L, (long)state.tokenMasterKeyState.size());
        Assert.assertTrue((String)"missing master key 1", (boolean)state.tokenMasterKeyState.contains(key1));
        DelegationKey key2 = new DelegationKey(3, 4L, "keyData2".getBytes());
        DelegationKey key3 = new DelegationKey(5, 6L, "keyData3".getBytes());
        MRDelegationTokenIdentifier token3 = new MRDelegationTokenIdentifier(new Text("tokenOwner3"), new Text("tokenRenewer3"), new Text("tokenUser3"));
        token3.setSequenceNumber(12345679);
        Long tokenDate3 = 87654321L;
        store.removeToken(token1);
        store.storeTokenMasterKey(key2);
        Long newTokenDate2 = 975318642L;
        store.updateToken(token2, newTokenDate2);
        store.removeTokenMasterKey(key1);
        store.storeTokenMasterKey(key3);
        store.storeToken(token3, tokenDate3);
        store.close();
        store = this.createAndStartStore();
        state = store.loadState();
        Assert.assertEquals((String)"incorrect loaded token count", (long)2L, (long)state.tokenState.size());
        Assert.assertFalse((String)"token 1 not removed", (boolean)state.tokenState.containsKey(token1));
        Assert.assertTrue((String)"missing token 2", (boolean)state.tokenState.containsKey(token2));
        Assert.assertEquals((String)"incorrect token 2 date", (Object)newTokenDate2, state.tokenState.get(token2));
        Assert.assertTrue((String)"missing token 3", (boolean)state.tokenState.containsKey(token3));
        Assert.assertEquals((String)"incorrect token 3 date", (Object)tokenDate3, state.tokenState.get(token3));
        Assert.assertEquals((String)"incorrect master key count", (long)2L, (long)state.tokenMasterKeyState.size());
        Assert.assertFalse((String)"master key 1 not removed", (boolean)state.tokenMasterKeyState.contains(key1));
        Assert.assertTrue((String)"missing master key 2", (boolean)state.tokenMasterKeyState.contains(key2));
        Assert.assertTrue((String)"missing master key 3", (boolean)state.tokenMasterKeyState.contains(key3));
    }

    @Test
    public void testTokenStore() throws IOException {
        this.testTokenStore(testDir.getAbsoluteFile().toURI().toString());
    }

    @Test
    public void testTokenStoreHdfs() throws IOException {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).build();
        this.conf = cluster.getConfiguration(0);
        try {
            this.testTokenStore("/tmp/historystore");
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testUpdatedTokenRecovery() throws IOException {
        IOException intentionalErr = new IOException("intentional error");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        FileSystem spyfs = (FileSystem)Mockito.spy((Object)fs);
        1 updateTmpMatcher = new /* Unavailable Anonymous Inner Class!! */;
        ((FileSystem)Mockito.doThrow((Throwable)intentionalErr).when((Object)spyfs)).rename((Path)Mockito.argThat((Matcher)updateTmpMatcher), (Path)Mockito.isA(Path.class));
        this.conf.set("mapreduce.jobhistory.recovery.store.fs.uri", testDir.getAbsoluteFile().toURI().toString());
        2 store = new /* Unavailable Anonymous Inner Class!! */;
        store.init(this.conf);
        store.start();
        MRDelegationTokenIdentifier token1 = new MRDelegationTokenIdentifier(new Text("tokenOwner1"), new Text("tokenRenewer1"), new Text("tokenUser1"));
        token1.setSequenceNumber(1);
        Long tokenDate1 = 1L;
        store.storeToken(token1, tokenDate1);
        Long newTokenDate1 = 975318642L;
        try {
            store.updateToken(token1, newTokenDate1);
            Assert.fail((String)"intentional error not thrown");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)intentionalErr, (Object)e);
        }
        store.close();
        store = this.createAndStartStore();
        HistoryServerStateStoreService.HistoryServerState state = store.loadState();
        Assert.assertEquals((String)"incorrect loaded token count", (long)1L, (long)state.tokenState.size());
        Assert.assertTrue((String)"missing token 1", (boolean)state.tokenState.containsKey(token1));
        Assert.assertEquals((String)"incorrect token 1 date", (Object)newTokenDate1, state.tokenState.get(token1));
        store.close();
    }
}

