/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ClientRMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.DelegationToken;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.ProtoUtils;

public class ResourceMgrDelegate {
    private static final Log LOG = LogFactory.getLog(ResourceMgrDelegate.class);
    private final InetSocketAddress rmAddress;
    private YarnConfiguration conf;
    ClientRMProtocol applicationsManager;
    private ApplicationId applicationId;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private static final String ROOT = "root";

    public ResourceMgrDelegate(YarnConfiguration conf) {
        this.conf = conf;
        YarnRPC rpc = YarnRPC.create((Configuration)this.conf);
        this.rmAddress = ResourceMgrDelegate.getRmAddress(conf);
        LOG.debug((Object)("Connecting to ResourceManager at " + this.rmAddress));
        this.applicationsManager = (ClientRMProtocol)rpc.getProxy(ClientRMProtocol.class, this.rmAddress, (Configuration)this.conf);
        LOG.debug((Object)("Connected to ResourceManager at " + this.rmAddress));
    }

    public ResourceMgrDelegate(YarnConfiguration conf, ClientRMProtocol applicationsManager) {
        this.conf = conf;
        this.applicationsManager = applicationsManager;
        this.rmAddress = ResourceMgrDelegate.getRmAddress(conf);
    }

    private static InetSocketAddress getRmAddress(YarnConfiguration conf) {
        return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    public TaskTrackerInfo[] getActiveTrackers() throws IOException, InterruptedException {
        GetClusterNodesRequest request = (GetClusterNodesRequest)this.recordFactory.newRecordInstance(GetClusterNodesRequest.class);
        GetClusterNodesResponse response = this.applicationsManager.getClusterNodes(request);
        return TypeConverter.fromYarnNodes((List)response.getNodeReports());
    }

    public JobStatus[] getAllJobs() throws IOException, InterruptedException {
        GetAllApplicationsRequest request = (GetAllApplicationsRequest)this.recordFactory.newRecordInstance(GetAllApplicationsRequest.class);
        GetAllApplicationsResponse response = this.applicationsManager.getAllApplications(request);
        return TypeConverter.fromYarnApps((List)response.getApplicationList(), (Configuration)this.conf);
    }

    public TaskTrackerInfo[] getBlacklistedTrackers() throws IOException, InterruptedException {
        LOG.warn((Object)"getBlacklistedTrackers - Not implemented yet");
        return new TaskTrackerInfo[0];
    }

    public ClusterMetrics getClusterMetrics() throws IOException, InterruptedException {
        GetClusterMetricsRequest request = (GetClusterMetricsRequest)this.recordFactory.newRecordInstance(GetClusterMetricsRequest.class);
        GetClusterMetricsResponse response = this.applicationsManager.getClusterMetrics(request);
        YarnClusterMetrics metrics = response.getClusterMetrics();
        ClusterMetrics oldMetrics = new ClusterMetrics(1, 1, 1, 1, 1, 1, metrics.getNumNodeManagers() * 10, metrics.getNumNodeManagers() * 2, 1, metrics.getNumNodeManagers(), 0, 0);
        return oldMetrics;
    }

    public Token getDelegationToken(Text renewer) throws IOException, InterruptedException {
        GetDelegationTokenRequest rmDTRequest = (GetDelegationTokenRequest)this.recordFactory.newRecordInstance(GetDelegationTokenRequest.class);
        rmDTRequest.setRenewer(renewer.toString());
        GetDelegationTokenResponse response = this.applicationsManager.getDelegationToken(rmDTRequest);
        DelegationToken yarnToken = response.getRMDelegationToken();
        return ProtoUtils.convertFromProtoFormat((DelegationToken)yarnToken, (InetSocketAddress)this.rmAddress);
    }

    public String getFilesystemName() throws IOException, InterruptedException {
        return FileSystem.get((Configuration)this.conf).getUri().toString();
    }

    public JobID getNewJobID() throws IOException, InterruptedException {
        GetNewApplicationRequest request = (GetNewApplicationRequest)this.recordFactory.newRecordInstance(GetNewApplicationRequest.class);
        this.applicationId = this.applicationsManager.getNewApplication(request).getApplicationId();
        return TypeConverter.fromYarn((ApplicationId)this.applicationId);
    }

    private GetQueueInfoRequest getQueueInfoRequest(String queueName, boolean includeApplications, boolean includeChildQueues, boolean recursive) {
        GetQueueInfoRequest request = (GetQueueInfoRequest)this.recordFactory.newRecordInstance(GetQueueInfoRequest.class);
        request.setQueueName(queueName);
        request.setIncludeApplications(includeApplications);
        request.setIncludeChildQueues(includeChildQueues);
        request.setRecursive(recursive);
        return request;
    }

    public QueueInfo getQueue(String queueName) throws IOException, InterruptedException {
        GetQueueInfoRequest request = this.getQueueInfoRequest(queueName, true, false, false);
        this.recordFactory.newRecordInstance(GetQueueInfoRequest.class);
        return TypeConverter.fromYarn((org.apache.hadoop.yarn.api.records.QueueInfo)this.applicationsManager.getQueueInfo(request).getQueueInfo(), (Configuration)this.conf);
    }

    private void getChildQueues(org.apache.hadoop.yarn.api.records.QueueInfo parent, List<org.apache.hadoop.yarn.api.records.QueueInfo> queues, boolean recursive) {
        List childQueues = parent.getChildQueues();
        for (org.apache.hadoop.yarn.api.records.QueueInfo child : childQueues) {
            queues.add(child);
            if (!recursive) continue;
            this.getChildQueues(child, queues, recursive);
        }
    }

    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException, InterruptedException {
        GetQueueUserAclsInfoRequest request = (GetQueueUserAclsInfoRequest)this.recordFactory.newRecordInstance(GetQueueUserAclsInfoRequest.class);
        List userAcls = this.applicationsManager.getQueueUserAcls(request).getUserAclsInfoList();
        return TypeConverter.fromYarnQueueUserAclsInfo((List)userAcls);
    }

    public QueueInfo[] getQueues() throws IOException, InterruptedException {
        ArrayList<org.apache.hadoop.yarn.api.records.QueueInfo> queues = new ArrayList<org.apache.hadoop.yarn.api.records.QueueInfo>();
        org.apache.hadoop.yarn.api.records.QueueInfo rootQueue = this.applicationsManager.getQueueInfo(this.getQueueInfoRequest(ROOT, false, true, true)).getQueueInfo();
        this.getChildQueues(rootQueue, queues, true);
        return TypeConverter.fromYarnQueueInfo(queues, (Configuration)this.conf);
    }

    public QueueInfo[] getRootQueues() throws IOException, InterruptedException {
        ArrayList<org.apache.hadoop.yarn.api.records.QueueInfo> queues = new ArrayList<org.apache.hadoop.yarn.api.records.QueueInfo>();
        org.apache.hadoop.yarn.api.records.QueueInfo rootQueue = this.applicationsManager.getQueueInfo(this.getQueueInfoRequest(ROOT, false, true, true)).getQueueInfo();
        this.getChildQueues(rootQueue, queues, false);
        return TypeConverter.fromYarnQueueInfo(queues, (Configuration)this.conf);
    }

    public QueueInfo[] getChildQueues(String parent) throws IOException, InterruptedException {
        ArrayList<org.apache.hadoop.yarn.api.records.QueueInfo> queues = new ArrayList<org.apache.hadoop.yarn.api.records.QueueInfo>();
        org.apache.hadoop.yarn.api.records.QueueInfo parentQueue = this.applicationsManager.getQueueInfo(this.getQueueInfoRequest(parent, false, true, false)).getQueueInfo();
        this.getChildQueues(parentQueue, queues, true);
        return TypeConverter.fromYarnQueueInfo(queues, (Configuration)this.conf);
    }

    public String getStagingAreaDir() throws IOException, InterruptedException {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path path = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        LOG.debug((Object)("getStagingAreaDir: dir=" + path));
        return path.toString();
    }

    public String getSystemDir() throws IOException, InterruptedException {
        Path sysDir = new Path("jobSubmitDir");
        return sysDir.toString();
    }

    public long getTaskTrackerExpiryInterval() throws IOException, InterruptedException {
        return 0L;
    }

    public void setJobPriority(JobID arg0, String arg1) throws IOException, InterruptedException {
    }

    public long getProtocolVersion(String arg0, long arg1) throws IOException {
        return 0L;
    }

    public ApplicationId submitApplication(ApplicationSubmissionContext appContext) throws IOException {
        appContext.setApplicationId(this.applicationId);
        SubmitApplicationRequest request = (SubmitApplicationRequest)this.recordFactory.newRecordInstance(SubmitApplicationRequest.class);
        request.setApplicationSubmissionContext(appContext);
        this.applicationsManager.submitApplication(request);
        LOG.info((Object)("Submitted application " + this.applicationId + " to ResourceManager" + " at " + this.rmAddress));
        return this.applicationId;
    }

    public void killApplication(ApplicationId applicationId) throws IOException {
        KillApplicationRequest request = (KillApplicationRequest)this.recordFactory.newRecordInstance(KillApplicationRequest.class);
        request.setApplicationId(applicationId);
        this.applicationsManager.forceKillApplication(request);
        LOG.info((Object)("Killing application " + applicationId));
    }

    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnRemoteException {
        GetApplicationReportRequest request = (GetApplicationReportRequest)this.recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        request.setApplicationId(appId);
        GetApplicationReportResponse response = this.applicationsManager.getApplicationReport(request);
        ApplicationReport applicationReport = response.getApplicationReport();
        return applicationReport;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }
}

