/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TestCombineFileInputFormat;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestCombineFileInputFormat {
    private static final Log LOG = LogFactory.getLog((String)TestCombineFileInputFormat.class.getName());
    private static JobConf defaultConf = new JobConf();
    private static FileSystem localFs = null;
    private static Path workDir;

    private static void writeFile(FileSystem fs, Path name, String contents) throws IOException {
        FSDataOutputStream stm = fs.create(name);
        stm.write(contents.getBytes());
        stm.close();
    }

    @Test
    public void testSplits() throws IOException {
        JobConf job = new JobConf((Configuration)defaultConf);
        localFs.delete(workDir, true);
        TestCombineFileInputFormat.writeFile((FileSystem)localFs, (Path)new Path(workDir, "test.txt"), (String)"the quick\nbrown\nfox jumped\nover\n the lazy\n dog\n");
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        1 format = new /* Unavailable Anonymous Inner Class!! */;
        boolean SIZE_SPLITS = true;
        LOG.info((Object)"Trying to getSplits with splits = 1");
        InputSplit[] splits = format.getSplits(job, 1);
        LOG.info((Object)("Got getSplits = " + splits.length));
        Assert.assertEquals((String)"splits == 1", (int)1, (int)splits.length);
    }

    static {
        try {
            defaultConf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), "TestCombineFileInputFormat").makeQualified(localFs);
    }
}

