/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.TestLazyOutput;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapred.lib.LazyOutputFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestLazyOutput
extends TestCase {
    private static final int NUM_HADOOP_SLAVES = 3;
    private static final int NUM_MAPS_PER_NODE = 2;
    private static final Path INPUT = new Path("/testlazy/input");
    private static final List<String> input = Arrays.asList("All", "Roads", "Lead", "To", "Hadoop");

    private static void runTestLazyOutput(JobConf job, Path output, int numReducers, boolean createLazily) throws Exception {
        job.setJobName("test-lazy-output");
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{INPUT});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)output);
        job.setInputFormat(TextInputFormat.class);
        job.setMapOutputKeyClass(LongWritable.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(Text.class);
        job.setMapperClass(TestMapper.class);
        job.setReducerClass(TestReducer.class);
        JobClient client = new JobClient(job);
        job.setNumReduceTasks(numReducers);
        if (createLazily) {
            LazyOutputFormat.setOutputFormatClass((JobConf)job, TextOutputFormat.class);
        } else {
            job.setOutputFormat(TextOutputFormat.class);
        }
        JobClient.runJob((JobConf)job);
    }

    public void createInput(FileSystem fs, int numMappers) throws Exception {
        for (int i = 0; i < numMappers; ++i) {
            FSDataOutputStream os = fs.create(new Path(INPUT, "text" + i + ".txt"));
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
            for (String inp : input) {
                wr.write(inp + "\n");
            }
            ((Writer)wr).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazyOutput() throws Exception {
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        FileSystem fileSys = null;
        try {
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster(conf, 3, true, null);
            fileSys = dfs.getFileSystem();
            mr = new MiniMRCluster(3, fileSys.getUri().toString(), 1);
            int numReducers = 2;
            int numMappers = 6;
            this.createInput(fileSys, numMappers);
            Path output1 = new Path("/testlazy/output1");
            TestLazyOutput.runTestLazyOutput((JobConf)mr.createJobConf(), (Path)output1, (int)numReducers, (boolean)true);
            Path[] fileList = FileUtil.stat2Paths((FileStatus[])fileSys.listStatus(output1, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
            for (int i = 0; i < fileList.length; ++i) {
                System.out.println("Test1 File list[" + i + "]" + ": " + fileList[i]);
            }
            TestLazyOutput.assertTrue((fileList.length == numReducers - 1 ? 1 : 0) != 0);
            Path output2 = new Path("/testlazy/output2");
            TestLazyOutput.runTestLazyOutput((JobConf)mr.createJobConf(), (Path)output2, (int)0, (boolean)true);
            fileList = FileUtil.stat2Paths((FileStatus[])fileSys.listStatus(output2, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
            for (int i = 0; i < fileList.length; ++i) {
                System.out.println("Test2 File list[" + i + "]" + ": " + fileList[i]);
            }
            TestLazyOutput.assertTrue((fileList.length == numMappers - 1 ? 1 : 0) != 0);
            Path output3 = new Path("/testlazy/output3");
            TestLazyOutput.runTestLazyOutput((JobConf)mr.createJobConf(), (Path)output3, (int)0, (boolean)false);
            fileList = FileUtil.stat2Paths((FileStatus[])fileSys.listStatus(output3, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
            for (int i = 0; i < fileList.length; ++i) {
                System.out.println("Test3 File list[" + i + "]" + ": " + fileList[i]);
            }
            TestLazyOutput.assertTrue((fileList.length == numMappers ? 1 : 0) != 0);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }
}

