/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobQueueClient;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.YarnException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestNetworkedJob {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');
    private static Path testDir = new Path(TEST_ROOT_DIR + "/test_mini_mr_local");
    private static Path inFile = new Path(testDir, "in");
    private static Path outDir = new Path(testDir, "out");

    @Test(timeout=10000L)
    public void testGetNullCounters() throws Exception {
        Job mockJob = (Job)Mockito.mock(Job.class);
        JobClient.NetworkedJob underTest = new JobClient.NetworkedJob(mockJob);
        Mockito.when((Object)mockJob.getCounters()).thenReturn(null);
        Assert.assertNull((Object)underTest.getCounters());
        ((Job)Mockito.verify((Object)mockJob)).getCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testGetJobStatus() throws IOException, InterruptedException, ClassNotFoundException {
        MiniMRClientCluster mr = null;
        FileSystem fileSys = null;
        try {
            mr = MiniMRClientClusterFactory.create(this.getClass(), (int)2, (Configuration)new Configuration());
            JobConf job = new JobConf(mr.getConfig());
            fileSys = FileSystem.get((Configuration)job);
            fileSys.delete(testDir, true);
            FSDataOutputStream out = fileSys.create(inFile, true);
            out.writeBytes("This is a test file");
            out.close();
            FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{inFile});
            FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
            job.setInputFormat(TextInputFormat.class);
            job.setOutputFormat(TextOutputFormat.class);
            job.setMapperClass(IdentityMapper.class);
            job.setReducerClass(IdentityReducer.class);
            job.setNumReduceTasks(0);
        }
        finally {
            if (fileSys != null) {
                fileSys.delete(testDir, true);
            }
            if (mr != null) {
                mr.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=100000L)
    public void testNetworkedJob() throws Exception {
        MiniMRClientCluster mr = null;
        FileSystem fileSys = null;
        try {
            Configuration conf = new Configuration();
            mr = MiniMRClientClusterFactory.create(this.getClass(), (int)2, (Configuration)conf);
            JobConf job = new JobConf(mr.getConfig());
            fileSys = FileSystem.get((Configuration)job);
            fileSys.delete(testDir, true);
            FSDataOutputStream out = fileSys.create(inFile, true);
            out.writeBytes("This is a test file");
            out.close();
            FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{inFile});
            FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
            job.setInputFormat(TextInputFormat.class);
            job.setOutputFormat(TextOutputFormat.class);
            job.setMapperClass(IdentityMapper.class);
            job.setReducerClass(IdentityReducer.class);
            job.setNumReduceTasks(0);
            JobClient client = new JobClient(mr.getConfig());
            RunningJob rj = client.submitJob(job);
            JobID jobId = rj.getID();
            JobClient.NetworkedJob runningJob = (JobClient.NetworkedJob)client.getJob(jobId);
            runningJob.setJobPriority(JobPriority.HIGH.name());
            Assert.assertTrue((boolean)runningJob.getConfiguration().toString().endsWith("0001/job.xml"));
            Assert.assertEquals((Object)runningJob.getID(), (Object)jobId);
            Assert.assertEquals((Object)runningJob.getJobID(), (Object)jobId.toString());
            Assert.assertTrue((boolean)runningJob.getJobName().contains("hadoop-"));
            Assert.assertTrue((boolean)runningJob.getJobFile().endsWith(".staging/" + runningJob.getJobID() + "/job.xml"));
            Assert.assertTrue((runningJob.getTrackingURL().length() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((runningJob.mapProgress() == 0.0f ? 1 : 0) != 0);
            Assert.assertTrue((runningJob.reduceProgress() == 0.0f ? 1 : 0) != 0);
            Assert.assertTrue((runningJob.cleanupProgress() == 0.0f ? 1 : 0) != 0);
            Assert.assertTrue((runningJob.setupProgress() == 0.0f ? 1 : 0) != 0);
            TaskCompletionEvent[] tce = runningJob.getTaskCompletionEvents(0);
            Assert.assertEquals((long)tce.length, (long)0L);
            Assert.assertEquals((Object)runningJob.getHistoryUrl(), (Object)"");
            Assert.assertFalse((boolean)runningJob.isRetired());
            Assert.assertEquals((Object)runningJob.getFailureInfo(), (Object)"");
            Assert.assertEquals((long)client.getMapTaskReports(jobId).length, (long)0L);
            try {
                client.getSetupTaskReports(jobId);
            }
            catch (YarnException e) {
                Assert.assertEquals((Object)e.getMessage(), (Object)"Unrecognized task type: JOB_SETUP");
            }
            try {
                client.getCleanupTaskReports(jobId);
            }
            catch (YarnException e) {
                Assert.assertEquals((Object)e.getMessage(), (Object)"Unrecognized task type: JOB_CLEANUP");
            }
            Assert.assertEquals((long)client.getReduceTaskReports(jobId).length, (long)0L);
            ClusterStatus status = client.getClusterStatus(true);
            Assert.assertEquals((long)status.getActiveTrackerNames().size(), (long)2L);
            Assert.assertEquals((long)status.getBlacklistedTrackers(), (long)0L);
            Assert.assertEquals((long)status.getBlacklistedTrackerNames().size(), (long)0L);
            Assert.assertEquals((long)status.getBlackListedTrackersInfo().size(), (long)0L);
            Assert.assertEquals((Object)status.getJobTrackerStatus(), (Object)Cluster.JobTrackerStatus.RUNNING);
            Assert.assertEquals((long)status.getMapTasks(), (long)1L);
            Assert.assertEquals((long)status.getMaxMapTasks(), (long)20L);
            Assert.assertEquals((long)status.getMaxReduceTasks(), (long)4L);
            Assert.assertEquals((long)status.getNumExcludedNodes(), (long)0L);
            Assert.assertEquals((long)status.getReduceTasks(), (long)1L);
            Assert.assertEquals((long)status.getTaskTrackers(), (long)2L);
            Assert.assertEquals((long)status.getTTExpiryInterval(), (long)0L);
            Assert.assertEquals((Object)status.getJobTrackerStatus(), (Object)Cluster.JobTrackerStatus.RUNNING);
            ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
            status.write((DataOutput)new DataOutputStream(dataOut));
            ClusterStatus status2 = new ClusterStatus();
            status2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(dataOut.toByteArray())));
            Assert.assertEquals((Object)status.getActiveTrackerNames(), (Object)status2.getActiveTrackerNames());
            Assert.assertEquals((Object)status.getBlackListedTrackersInfo(), (Object)status2.getBlackListedTrackersInfo());
            Assert.assertEquals((long)status.getMapTasks(), (long)status2.getMapTasks());
            JobClient.setTaskOutputFilter((JobConf)job, (JobClient.TaskStatusFilter)JobClient.TaskStatusFilter.ALL);
            Assert.assertEquals((Object)JobClient.getTaskOutputFilter((JobConf)job), (Object)JobClient.TaskStatusFilter.ALL);
            Assert.assertEquals((long)client.getDefaultMaps(), (long)20L);
            Assert.assertEquals((long)client.getDefaultReduces(), (long)4L);
            Assert.assertEquals((Object)client.getSystemDir().getName(), (Object)"jobSubmitDir");
            JobQueueInfo[] rootQueueInfo = client.getRootQueues();
            Assert.assertEquals((long)rootQueueInfo.length, (long)1L);
            Assert.assertEquals((Object)rootQueueInfo[0].getQueueName(), (Object)"default");
            JobQueueInfo[] qinfo = client.getQueues();
            Assert.assertEquals((long)qinfo.length, (long)1L);
            Assert.assertEquals((Object)qinfo[0].getQueueName(), (Object)"default");
            Assert.assertEquals((long)client.getChildQueues("default").length, (long)0L);
            Assert.assertEquals((long)client.getJobsFromQueue("default").length, (long)1L);
            Assert.assertTrue((boolean)client.getJobsFromQueue("default")[0].getJobFile().endsWith("/job.xml"));
            JobQueueInfo qi = client.getQueueInfo("default");
            Assert.assertEquals((Object)qi.getQueueName(), (Object)"default");
            Assert.assertEquals((Object)qi.getQueueState(), (Object)"running");
            QueueAclsInfo[] aai = client.getQueueAclsForCurrentUser();
            Assert.assertEquals((long)aai.length, (long)2L);
            Assert.assertEquals((Object)aai[0].getQueueName(), (Object)"root");
            Assert.assertEquals((Object)aai[1].getQueueName(), (Object)"default");
            Token token = client.getDelegationToken(new Text(UserGroupInformation.getCurrentUser().getShortUserName()));
            Assert.assertEquals((Object)token.getKind().toString(), (Object)"RM_DELEGATION_TOKEN");
            try {
                long l = client.renewDelegationToken(token);
            }
            catch (UnsupportedOperationException e) {
                Assert.assertTrue((boolean)e.getMessage().endsWith("is not supported  for RM_DELEGATION_TOKEN tokens"));
            }
            try {
                client.cancelDelegationToken(token);
            }
            catch (UnsupportedOperationException e) {
                Assert.assertTrue((boolean)e.getMessage().endsWith("is not supported  for RM_DELEGATION_TOKEN tokens"));
            }
        }
        finally {
            if (fileSys != null) {
                fileSys.delete(testDir, true);
            }
            if (mr != null) {
                mr.stop();
            }
        }
    }

    @Test(timeout=10000L)
    public void testBlackListInfo() throws IOException {
        ClusterStatus.BlackListInfo info = new ClusterStatus.BlackListInfo();
        info.setBlackListReport("blackListInfo");
        info.setReasonForBlackListing("reasonForBlackListing");
        info.setTrackerName("trackerName");
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        info.write((DataOutput)out);
        ClusterStatus.BlackListInfo info2 = new ClusterStatus.BlackListInfo();
        info2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(byteOut.toByteArray())));
        Assert.assertEquals((Object)info, (Object)info);
        Assert.assertEquals((Object)info.toString(), (Object)info.toString());
        Assert.assertEquals((Object)info.getTrackerName(), (Object)"trackerName");
        Assert.assertEquals((Object)info.getReasonForBlackListing(), (Object)"reasonForBlackListing");
        Assert.assertEquals((Object)info.getBlackListReport(), (Object)"blackListInfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testJobQueueClient() throws Exception {
        MiniMRClientCluster mr = null;
        FileSystem fileSys = null;
        PrintStream oldOut = System.out;
        try {
            Configuration conf = new Configuration();
            mr = MiniMRClientClusterFactory.create(this.getClass(), (int)2, (Configuration)conf);
            JobConf job = new JobConf(mr.getConfig());
            fileSys = FileSystem.get((Configuration)job);
            fileSys.delete(testDir, true);
            FSDataOutputStream out = fileSys.create(inFile, true);
            out.writeBytes("This is a test file");
            out.close();
            FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{inFile});
            FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
            job.setInputFormat(TextInputFormat.class);
            job.setOutputFormat(TextOutputFormat.class);
            job.setMapperClass(IdentityMapper.class);
            job.setReducerClass(IdentityReducer.class);
            job.setNumReduceTasks(0);
            JobClient client = new JobClient(mr.getConfig());
            client.submitJob(job);
            JobQueueClient jobClient = new JobQueueClient(job);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            System.setOut(new PrintStream(bytes));
            String[] arg = new String[]{"-list"};
            jobClient.run(arg);
            Assert.assertTrue((boolean)bytes.toString().contains("Queue Name : default"));
            Assert.assertTrue((boolean)bytes.toString().contains("Queue State : running"));
            bytes = new ByteArrayOutputStream();
            System.setOut(new PrintStream(bytes));
            String[] arg1 = new String[]{"-showacls"};
            jobClient.run(arg1);
            Assert.assertTrue((boolean)bytes.toString().contains("Queue acls for user :"));
            Assert.assertTrue((boolean)bytes.toString().contains("root  ADMINISTER_QUEUE,SUBMIT_APPLICATIONS"));
            Assert.assertTrue((boolean)bytes.toString().contains("default  ADMINISTER_QUEUE,SUBMIT_APPLICATIONS"));
            bytes = new ByteArrayOutputStream();
            System.setOut(new PrintStream(bytes));
            String[] arg2 = new String[]{"-info", "default"};
            jobClient.run(arg2);
            Assert.assertTrue((boolean)bytes.toString().contains("Queue Name : default"));
            Assert.assertTrue((boolean)bytes.toString().contains("Queue State : running"));
            Assert.assertTrue((boolean)bytes.toString().contains("Scheduling Info"));
            bytes = new ByteArrayOutputStream();
            System.setOut(new PrintStream(bytes));
            String[] arg3 = new String[]{"-info", "default", "-showJobs"};
            jobClient.run(arg3);
            Assert.assertTrue((boolean)bytes.toString().contains("Queue Name : default"));
            Assert.assertTrue((boolean)bytes.toString().contains("Queue State : running"));
            Assert.assertTrue((boolean)bytes.toString().contains("Scheduling Info"));
            Assert.assertTrue((boolean)bytes.toString().contains("job_1"));
            String[] arg4 = new String[]{};
            jobClient.run(arg4);
        }
        finally {
            System.setOut(oldOut);
            if (fileSys != null) {
                fileSys.delete(testDir, true);
            }
            if (mr != null) {
                mr.stop();
            }
        }
    }
}

