/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TestReduceFetchFromPartialMem;
import org.apache.hadoop.mapreduce.TaskCounter;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestReduceFetchFromPartialMem
extends TestCase {
    protected static MiniMRCluster mrCluster = null;
    protected static MiniDFSCluster dfsCluster = null;
    protected static TestSuite mySuite;
    private static final String tagfmt = "%04d";
    private static final String keyfmt = "KEYKEYKEYKEYKEYKEYKE";
    private static final int keylen;

    protected static void setSuite(Class<? extends TestCase> klass) {
        mySuite = new TestSuite(klass);
    }

    public static Test suite() {
        1 setup = new /* Unavailable Anonymous Inner Class!! */;
        return setup;
    }

    private static int getValLen(int id, int nMaps) {
        return 4096 / nMaps * (id + 1);
    }

    public void testReduceFromPartialMem() throws Exception {
        int MAP_TASKS = 7;
        JobConf job = mrCluster.createJobConf();
        job.setNumMapTasks(7);
        job.setInt("mapreduce.reduce.merge.inmem.threshold", 0);
        job.set("mapreduce.reduce.input.buffer.percent", "1.0");
        job.setInt("mapreduce.reduce.shuffle.parallelcopies", 1);
        job.setInt("mapreduce.task.io.sort.mb", 10);
        job.set("mapreduce.reduce.java.opts", "-Xmx128m");
        job.setLong("mapreduce.reduce.memory.totalbytes", 0x8000000L);
        job.set("mapreduce.reduce.shuffle.input.buffer.percent", "0.14");
        job.set("mapreduce.reduce.shuffle.merge.percent", "1.0");
        Counters c = TestReduceFetchFromPartialMem.runJob((JobConf)job);
        long out = ((Counters.Counter)c.findCounter((Enum)TaskCounter.MAP_OUTPUT_RECORDS)).getCounter();
        long spill = ((Counters.Counter)c.findCounter((Enum)TaskCounter.SPILLED_RECORDS)).getCounter();
        TestReduceFetchFromPartialMem.assertTrue((String)("Expected some records not spilled during reduce" + spill + ")"), (spill < 2L * out ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counters runJob(JobConf conf) throws Exception {
        conf.setMapperClass(MapMB.class);
        conf.setReducerClass(MBValidate.class);
        conf.setOutputKeyClass(Text.class);
        conf.setOutputValueClass(Text.class);
        conf.setNumReduceTasks(1);
        conf.setInputFormat(FakeIF.class);
        conf.setNumTasksToExecutePerJvm(1);
        conf.setInt("mapreduce.map.maxattempts", 0);
        conf.setInt("mapreduce.reduce.maxattempts", 0);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{new Path("/in")});
        Path outp = new Path("/out");
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outp);
        RunningJob job = null;
        try {
            job = JobClient.runJob((JobConf)conf);
            TestReduceFetchFromPartialMem.assertTrue((boolean)job.isSuccessful());
        }
        finally {
            FileSystem fs = dfsCluster.getFileSystem();
            if (fs.exists(outp)) {
                fs.delete(outp, true);
            }
        }
        return job.getCounters();
    }

    static /* synthetic */ int access$000() {
        return keylen;
    }

    static /* synthetic */ int access$100(int x0, int x1) {
        return TestReduceFetchFromPartialMem.getValLen((int)x0, (int)x1);
    }

    static {
        TestReduceFetchFromPartialMem.setSuite(TestReduceFetchFromPartialMem.class);
        keylen = "KEYKEYKEYKEYKEYKEYKE".length();
    }
}

